/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.workspace;

import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class BaseNCodec {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    @Deprecated
    protected final byte PAD = (byte)61;
    protected final byte pad;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;
    private final CodecPolicy decodingPolicy;

    private static int compareUnsigned(int n, int n2) {
        int n3 = n + Integer.MIN_VALUE;
        int n4 = n2 + Integer.MIN_VALUE;
        return n3 < n4 ? -1 : (n3 == n4 ? 0 : 1);
    }

    private static int createPositiveCapacity(int n) {
        if (n < 0) {
            throw new OutOfMemoryError("Unable to allocate array size: " + ((long)n & 0xFFFFFFFFL));
        }
        return n > 0x7FFFFFF7 ? n : 0x7FFFFFF7;
    }

    public static byte[] getChunkSeparator() {
        return (byte[])CHUNK_SEPARATOR.clone();
    }

    protected static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static byte[] resizeBuffer(Context context, int n) {
        int n2 = context.buffer.length;
        int n3 = n2 * 2;
        if (BaseNCodec.compareUnsigned(n3, n) < 0) {
            n3 = n;
        }
        if (BaseNCodec.compareUnsigned(n3, 0x7FFFFFF7) > 0) {
            n3 = BaseNCodec.createPositiveCapacity(n);
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(context.buffer, 0, byArray, 0, context.buffer.length);
        context.buffer = byArray;
        return byArray;
    }

    protected BaseNCodec(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 61);
    }

    protected BaseNCodec(int n, int n2, int n3, int n4, byte by) {
        this(n, n2, n3, n4, by, CodecPolicy.LENIANT);
    }

    protected BaseNCodec(int n, int n2, int n3, int n4, byte by, CodecPolicy codecPolicy) {
        this.unencodedBlockSize = n;
        this.encodedBlockSize = n2;
        boolean bl = n3 > 0 && n4 > 0;
        this.lineLength = bl ? n3 / n2 * n2 : 0;
        this.chunkSeparatorLength = n4;
        this.pad = by;
        this.decodingPolicy = codecPolicy;
    }

    int available(Context context) {
        return context.buffer != null ? context.pos - context.readPos : 0;
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            if (this.pad == by || this.isInAlphabet(by)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public byte[] decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Context context = new Context();
        this.decode(byArray, 0, byArray.length, context);
        this.decode(byArray, 0, -1, context);
        byte[] byArray2 = new byte[context.pos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    public Object decode(Object object) {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        return null;
    }

    public byte[] decode(String string) {
        return this.decode(string.getBytes(Charset.forName("UTF-8")));
    }

    public byte[] encode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        return this.encode(byArray, 0, byArray.length);
    }

    public byte[] encode(byte[] byArray, int n, int n2) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Context context = new Context();
        this.encode(byArray, n, n2, context);
        this.encode(byArray, n, -1, context);
        byte[] byArray2 = new byte[context.pos - context.readPos];
        this.readResults(byArray2, 0, byArray2.length, context);
        return byArray2;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    public Object encode(Object object) {
        return this.encode((byte[])object);
    }

    public String encodeAsString(byte[] byArray) {
        return new String(this.encode(byArray), Charset.forName("UTF-8"));
    }

    public String encodeToString(byte[] byArray) {
        return new String(this.encode(byArray), Charset.forName("UTF-8"));
    }

    protected byte[] ensureBufferSize(int n, Context context) {
        if (context.buffer == null) {
            context.buffer = new byte[Math.max(n, this.getDefaultBufferSize())];
            context.pos = 0;
            context.readPos = 0;
        } else if (context.pos + n - context.buffer.length > 0) {
            return BaseNCodec.resizeBuffer(context, context.pos + n);
        }
        return context.buffer;
    }

    public CodecPolicy getCodecPolicy() {
        return this.decodingPolicy;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    public long getEncodedLength(byte[] byArray) {
        long l = (long)((byArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            l += (l + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return l;
    }

    boolean hasData(Context context) {
        return context.buffer != null;
    }

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl) {
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            if (!(this.isInAlphabet(by) || bl && (by == this.pad || BaseNCodec.isWhiteSpace(by)))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(string.getBytes(Charset.forName("UTF-8")), true);
    }

    public boolean isStrictDecoding() {
        return this.decodingPolicy == CodecPolicy.STRICT;
    }

    int readResults(byte[] byArray, int n, int n2, Context context) {
        if (context.buffer != null) {
            int n3 = Math.min(this.available(context), n2);
            System.arraycopy(context.buffer, context.readPos, byArray, n, n3);
            context.readPos += n3;
            if (context.readPos >= context.pos) {
                context.buffer = null;
            }
            return n3;
        }
        return context.eof ? -1 : 0;
    }

    static enum CodecPolicy {
        STRICT,
        LENIANT;

    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

