/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.workspace;

import java.math.BigInteger;
import java.nio.charset.Charset;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.BaseNCodec;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE;
    private static final int MASK_6BITS = 63;
    private static final int MASK_4BITS = 15;
    private static final int MASK_2BITS = 3;
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;

    static {
        byte[] byArray = new byte[123];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = 62;
        byArray[44] = -1;
        byArray[45] = 62;
        byArray[46] = -1;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = 63;
        byArray[96] = -1;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        DECODE_TABLE = byArray;
    }

    public static byte[] decodeBase64(byte[] byArray) {
        return new Base64().decode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return new Base64().decode(string);
    }

    public static BigInteger decodeInteger(byte[] byArray) {
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        return Base64.encodeBase64(byArray, bl, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) {
        return Base64.encodeBase64(byArray, bl, bl2, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2, int n) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = bl ? new Base64(bl2) : new Base64(0, CHUNK_SEPARATOR, bl2);
        long l = base64.getEncodedLength(byArray);
        if (l > (long)n) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l + ") than the specified maximum size of " + n);
        }
        return base64.encode(byArray);
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public static String encodeBase64String(byte[] byArray) {
        return new String(Base64.encodeBase64(byArray, false), Charset.forName("UTF-8"));
    }

    public static byte[] encodeBase64URLSafe(byte[] byArray) {
        return Base64.encodeBase64(byArray, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] byArray) {
        return new String(Base64.encodeBase64(byArray, false, true), Charset.forName("UTF-8"));
    }

    public static byte[] encodeInteger(BigInteger bigInteger) {
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    @Deprecated
    public static boolean isArrayByteBase64(byte[] byArray) {
        return Base64.isBase64(byArray);
    }

    public static boolean isBase64(byte by) {
        return by == 61 || by >= 0 && by < DECODE_TABLE.length && DECODE_TABLE[by] != -1;
    }

    public static boolean isBase64(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (!Base64.isBase64(byArray[n]) && !Base64.isWhiteSpace(byArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isBase64(String string) {
        return Base64.isBase64(string.getBytes(Charset.forName("UTF-8")));
    }

    static byte[] toIntegerBytes(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        n = n + 7 >> 3 << 3;
        byte[] byArray = bigInteger.toByteArray();
        if (bigInteger.bitLength() % 8 != 0 && bigInteger.bitLength() / 8 + 1 == n / 8) {
            return byArray;
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (bigInteger.bitLength() % 8 == 0) {
            n2 = 1;
            --n3;
        }
        int n4 = n / 8 - n3;
        byte[] byArray2 = new byte[n / 8];
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        return byArray2;
    }

    public Base64() {
        this(0);
    }

    public Base64(boolean bl) {
        this(76, CHUNK_SEPARATOR, bl);
    }

    public Base64(int n) {
        this(n, CHUNK_SEPARATOR);
    }

    public Base64(int n, byte[] byArray) {
        this(n, byArray, false);
    }

    public Base64(int n, byte[] byArray, boolean bl) {
        this(n, byArray, bl, BaseNCodec.CodecPolicy.LENIANT);
    }

    public Base64(int n, byte[] byArray, boolean bl, BaseNCodec.CodecPolicy codecPolicy) {
        super(3, 4, n, byArray == null ? 0 : byArray.length, (byte)61, codecPolicy);
        if (byArray != null) {
            if (this.containsAlphabetOrPad(byArray)) {
                String string = new String(byArray, Charset.forName("UTF-8"));
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
            }
            if (n > 0) {
                this.encodeSize = 4 + byArray.length;
                this.lineSeparator = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.lineSeparator, 0, byArray.length);
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = bl ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    @Override
    void decode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
        }
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            byte by2;
            byte[] byArray2 = this.ensureBufferSize(this.decodeSize, context);
            if ((by2 = byArray[n++]) == this.pad) {
                context.eof = true;
                break;
            }
            if (by2 >= 0 && by2 < DECODE_TABLE.length && (by = DECODE_TABLE[by2]) >= 0) {
                context.modulus = (context.modulus + 1) % 4;
                context.ibitWorkArea = (context.ibitWorkArea << 6) + by;
                if (context.modulus == 0) {
                    byArray2[context.pos++] = (byte)(context.ibitWorkArea >> 16 & 0xFF);
                    byArray2[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                    byArray2[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                }
            }
            ++n3;
        }
        if (context.eof && context.modulus != 0) {
            byte[] byArray3 = this.ensureBufferSize(this.decodeSize, context);
            switch (context.modulus) {
                case 1: {
                    this.validateTrailingCharacter();
                    break;
                }
                case 2: {
                    this.validateCharacter(15, context);
                    context.ibitWorkArea >>= 4;
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    this.validateCharacter(3, context);
                    context.ibitWorkArea >>= 2;
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea >> 8 & 0xFF);
                    byArray3[context.pos++] = (byte)(context.ibitWorkArea & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
        }
    }

    @Override
    void encode(byte[] byArray, int n, int n2, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (n2 < 0) {
            context.eof = true;
            if (context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            byte[] byArray2 = this.ensureBufferSize(this.encodeSize, context);
            int n3 = context.pos;
            switch (context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 2 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[context.pos++] = this.pad;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                case 2: {
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 10 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea >> 4 & 0x3F];
                    byArray2[context.pos++] = this.encodeTable[context.ibitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    byArray2[context.pos++] = this.pad;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
            context.currentLinePos += context.pos - n3;
            if (this.lineLength > 0 && context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, byArray2, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                int n5;
                byte[] byArray3 = this.ensureBufferSize(this.encodeSize, context);
                context.modulus = (context.modulus + 1) % 3;
                if ((n5 = byArray[n++]) < 0) {
                    n5 += 256;
                }
                context.ibitWorkArea = (context.ibitWorkArea << 8) + n5;
                if (context.modulus == 0) {
                    byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 18 & 0x3F];
                    byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 12 & 0x3F];
                    byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea >> 6 & 0x3F];
                    byArray3[context.pos++] = this.encodeTable[context.ibitWorkArea & 0x3F];
                    context.currentLinePos += 4;
                    if (this.lineLength > 0 && this.lineLength <= context.currentLinePos) {
                        System.arraycopy(this.lineSeparator, 0, byArray3, context.pos, this.lineSeparator.length);
                        context.pos += this.lineSeparator.length;
                        context.currentLinePos = 0;
                    }
                }
                ++n4;
            }
        }
    }

    @Override
    protected boolean isInAlphabet(byte by) {
        return by >= 0 && by < this.decodeTable.length && this.decodeTable[by] != -1;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    private void validateCharacter(int n, BaseNCodec.Context context) {
        if (this.isStrictDecoding() && (context.ibitWorkArea & n) != 0) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Expected the discarded bits from the character to be zero.");
        }
    }

    private void validateTrailingCharacter() {
        if (this.isStrictDecoding()) {
            throw new IllegalArgumentException("Strict decoding: Last encoded character (before the paddings if any) is a valid base 64 alphabet but not a possible encoding. Decoding requires at least two trailing 6-bit characters to create bytes.");
        }
    }
}

