/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceRulesList {
    private final List<ResourceRule> list;
    private static final ResourceRule defaultRule = new ResourceRule("", true, Action.EXCLUDE, 16000, 48, false);

    public static ResourceRulesList loadResourceRules(File conf) throws IOException {
        ArrayList<ResourceRule> list = new ArrayList<ResourceRule>();
        try {
            JSONArray rulesArray = new JSONObject(FileUtils.readFileToString(conf, StandardCharsets.UTF_8)).getJSONArray("rules");
            int i = 0;
            int l = rulesArray.length();
            while (i < l) {
                JSONObject obj = rulesArray.getJSONObject(i);
                Iterator<String> itr = obj.keys();
                while (itr.hasNext()) {
                    JSONObject ffmpegObj;
                    String name = itr.next();
                    JSONObject a = obj.getJSONObject(name);
                    boolean wildcard = name.endsWith("*");
                    if (wildcard) {
                        name = name.substring(0, name.length() - 1);
                    }
                    Action action = Action.valueOf(a.getString("action").toUpperCase());
                    int ffmpegSamples = 16000;
                    int ffmpegBitrate = 48;
                    boolean ffmpegStereo = false;
                    if (action == Action.ENCODE && (ffmpegObj = a.optJSONObject("ffmpeg", null)) != null) {
                        ffmpegSamples = ffmpegObj.optInt("samples", ffmpegSamples);
                        ffmpegBitrate = ffmpegObj.optInt("bitrate", ffmpegBitrate);
                        ffmpegStereo = ffmpegObj.optBoolean("stereo", ffmpegStereo);
                    }
                    list.add(new ResourceRule(name, wildcard, action, ffmpegSamples, ffmpegBitrate, ffmpegStereo));
                }
                ++i;
            }
        }
        catch (JSONException ex) {
            throw new IOException("Invalid JSON file: " + conf.getAbsolutePath(), ex);
        }
        return new ResourceRulesList(list);
    }

    private ResourceRulesList(List<ResourceRule> list) {
        this.list = list;
    }

    public ResourceRule get(String str) {
        int i = 0;
        int l = this.list.size();
        while (i < l) {
            ResourceRule r = this.list.get(i);
            if (r.wildcard ? str.startsWith(r.path) : str.equals(r.path)) {
                return r;
            }
            ++i;
        }
        return defaultRule;
    }

    public static enum Action {
        INCLUDE,
        EXCLUDE,
        ENCODE,
        LANGUAGES_ZIP;

    }

    public static class ResourceRule {
        private final String path;
        private final boolean wildcard;
        public final Action action;
        public final int ffmpegSamples;
        public final int ffmpegBitrate;
        public final boolean ffmpegStereo;

        protected ResourceRule(String path, boolean wildcard, Action action, int ffmpegSamples, int ffmpegBitrate, boolean ffmpegStereo) {
            this.path = path;
            this.wildcard = wildcard;
            this.action = action;
            this.ffmpegSamples = ffmpegSamples;
            this.ffmpegBitrate = ffmpegBitrate;
            this.ffmpegStereo = ffmpegStereo;
        }
    }
}

