/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.Lines;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.CSVMappings;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.OpenGLEnumManager;
import net.lax1dude.eaglercraft.v1_8.buildtools.util.FileReaderUTF;
import org.apache.commons.io.IOUtils;

public class InsertJavaDoc {
    public static final String enumImport = "import static net.lax1dude.eaglercraft.v1_8.opengl.RealOpenGLEnums.*;";
    private static final String[] typeModifiersFields = new String[]{"public", "private", "protected", "static", "final", "volatile", "transient"};
    private static final String[] typeModifiersMethods = new String[]{"public", "private", "protected", "static", "final", "synchronized", "abstract", "default"};
    private static final Pattern illegalCharactersNotATypeName = Pattern.compile("[^a-zA-Z0-9_\\-\\$\\[\\]<>\\.]");

    private static boolean isTypeModifierField(String tk) {
        int i = 0;
        while (i < typeModifiersFields.length) {
            if (typeModifiersFields[i].equals(tk)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isTypeModifierMethod(String tk) {
        int i = 0;
        while (i < typeModifiersMethods.length) {
            if (typeModifiersMethods[i].equals(tk)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean processSource(File fileIn, File fileOut, File mcpDataTMP, CSVMappings csv) throws Throwable {
        return InsertJavaDoc.processSource(fileIn, fileOut, mcpDataTMP, csv, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean processSource(File fileIn, File fileOut, File mcpDataTMP, CSVMappings csv, boolean compress) throws Throwable {
        int[] enums;
        int modf;
        int modm;
        block90: {
            Object s;
            Object ln;
            System.out.println("Adding javadoc...");
            if (csv == null) {
                System.out.println("(writing enums only, skipping field/method annotations)");
            }
            ArrayList<String> copyrightComment = null;
            Throwable throwable = null;
            Object var7_8 = null;
            try (BufferedReader is = new BufferedReader(new FileReaderUTF(new File(EaglerBuildTools.repositoryRoot, "patches/minecraft/output_license.txt")));){
                copyrightComment = new ArrayList<String>();
                copyrightComment.add("/**+");
                while (true) {
                    if ((ln = is.readLine()) == null) {
                        copyrightComment.add(" * ");
                        copyrightComment.add(" */");
                        break;
                    }
                    copyrightComment.add(" * " + (String)ln);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            HashMap<String, ArrayList<CSVMappings.Symbol>> methodsInClasses = new HashMap<String, ArrayList<CSVMappings.Symbol>>();
            HashMap<String, ArrayList<CSVMappings.Symbol>> fieldsInClasses = new HashMap<String, ArrayList<CSVMappings.Symbol>>();
            if (csv != null) {
                FileReaderUTF fr32;
                Throwable throwable3;
                File methodsCSV = new File(mcpDataTMP, "methods.csv");
                try {
                    ln = null;
                    throwable3 = null;
                    try {
                        fr32 = new FileReaderUTF(methodsCSV);
                        try {
                            csv.loadMethodsFile(fr32);
                        }
                        finally {
                            if (fr32 != null) {
                                fr32.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (ln == null) {
                            ln = throwable4;
                            throw ln;
                        }
                        if (ln == throwable4) throw ln;
                        ((Throwable)ln).addSuppressed(throwable4);
                        throw ln;
                    }
                }
                catch (IOException ex) {
                    System.err.println("ERROR: failed to read \"" + methodsCSV.getAbsolutePath() + "\"!");
                    ex.printStackTrace();
                    return false;
                }
                File fieldsCSV = new File(mcpDataTMP, "fields.csv");
                try {
                    throwable3 = null;
                    fr32 = null;
                    try (FileReaderUTF fr = new FileReaderUTF(fieldsCSV);){
                        csv.loadFieldsFile(fr);
                    }
                    catch (Throwable fr32) {
                        if (throwable3 == null) {
                            throwable3 = fr32;
                            throw throwable3;
                        }
                        if (throwable3 == fr32) throw throwable3;
                        throwable3.addSuppressed(fr32);
                        throw throwable3;
                    }
                }
                catch (IOException ex) {
                    System.err.println("ERROR: failed to read \"" + fieldsCSV.getAbsolutePath() + "\"!");
                    ex.printStackTrace();
                    return false;
                }
                Throwable ex = null;
                fr32 = null;
                try (BufferedReader is = new BufferedReader(new FileReaderUTF(new File(mcpDataTMP, "joined.srg")));){
                    while ((s = is.readLine()) != null) {
                        int idxx;
                        if (((String)s).startsWith("MD:")) {
                            s = ((String)s).trim();
                            idxx = ((String)s).lastIndexOf(32);
                            int idxx2 = ((String)s).lastIndexOf(32, idxx - 1);
                            s = ((String)s).substring(idxx2 + 1, idxx);
                            idxx = ((String)s).lastIndexOf(47);
                            String s1 = ((String)s).substring(0, idxx);
                            String s2 = ((String)s).substring(idxx + 1);
                            CSVMappings.Symbol sm = csv.csvMethodsMappings.get(s2);
                            if (sm == null || sm.comment == null || sm.comment.length() <= 0) continue;
                            ArrayList<CSVMappings.Symbol> sbls = (ArrayList<CSVMappings.Symbol>)methodsInClasses.get(s1);
                            if (sbls == null) {
                                sbls = new ArrayList<CSVMappings.Symbol>();
                                methodsInClasses.put(s1, sbls);
                            }
                            sbls.add(sm);
                            continue;
                        }
                        if (!((String)s).startsWith("FD:")) continue;
                        s = ((String)s).trim();
                        idxx = ((String)s).lastIndexOf(32);
                        s = ((String)s).substring(idxx + 1);
                        idxx = ((String)s).lastIndexOf(47);
                        String s1 = ((String)s).substring(0, idxx);
                        String s2 = ((String)s).substring(idxx + 1);
                        CSVMappings.Symbol sm = csv.csvFieldsMappings.get(s2);
                        if (sm == null || sm.comment == null || sm.comment.length() <= 0) continue;
                        ArrayList<CSVMappings.Symbol> sbls = (ArrayList<CSVMappings.Symbol>)fieldsInClasses.get(s1);
                        if (sbls == null) {
                            sbls = new ArrayList<CSVMappings.Symbol>();
                            fieldsInClasses.put(s1, sbls);
                        }
                        sbls.add(sm);
                    }
                }
                catch (Throwable fr32) {
                    if (ex == null) {
                        ex = fr32;
                        throw ex;
                    }
                    if (ex == fr32) throw ex;
                    ex.addSuppressed(fr32);
                    throw ex;
                }
            }
            OpenGLEnumManager.loadEnumMap();
            System.out.print("   ");
            int xt = 0;
            modm = 0;
            modf = 0;
            enums = new int[1];
            Consumer<Integer> enumCounter = new Consumer<Integer>(){

                @Override
                public void accept(Integer t) {
                    enums[0] = enums[0] + t;
                }
            };
            try {
                s = null;
                Object var14_30 = null;
                try {
                    ZipInputStream jarIn = new ZipInputStream(new FileInputStream(fileIn));
                    try {
                        try (ZipOutputStream jarOut = new ZipOutputStream(new FileOutputStream(fileOut));){
                            ZipEntry et;
                            jarOut.setLevel(compress ? 5 : 0);
                            jarOut.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                            jarOut.write("Manifest-Version: 1.0\nCreated-By: Eaglercraft BuildTools\n".getBytes(StandardCharsets.UTF_8));
                            while ((et = jarIn.getNextEntry()) != null) {
                                if (et.isDirectory()) continue;
                                String nm = et.getName();
                                if (nm.endsWith(".java")) {
                                    ArrayList<String> linesLst;
                                    block88: {
                                        List fields;
                                        String fs = IOUtils.toString((InputStream)jarIn, "UTF-8");
                                        linesLst = new ArrayList<String>();
                                        linesLst.addAll(Lines.linesList(fs));
                                        if (copyrightComment != null) {
                                            int i = 0;
                                            while (i < linesLst.size()) {
                                                String ln2 = (String)linesLst.get(i);
                                                if (!ln2.startsWith("import")) {
                                                    if (ln2.startsWith("public")) {
                                                        ln2 = ln2.substring(6).trim();
                                                    }
                                                    if (ln2.startsWith("class") || ln2.startsWith("enum") || ln2.startsWith("interface") || ln2.startsWith("@interface")) {
                                                        linesLst.addAll(i, copyrightComment);
                                                        i += copyrightComment.size();
                                                        break;
                                                    }
                                                }
                                                ++i;
                                            }
                                        }
                                        String cnm = nm.substring(0, nm.length() - 5);
                                        List meths = csv == null ? null : (List)methodsInClasses.get(cnm);
                                        List list = fields = csv == null ? null : (List)fieldsInClasses.get(cnm);
                                        if (meths != null || fields != null) {
                                            int i = 0;
                                            while (i < linesLst.size()) {
                                                int j;
                                                boolean hasType;
                                                boolean hasMethodDecl;
                                                boolean hasTypeDecl;
                                                String[] tokens;
                                                String ln2 = (String)linesLst.get(i);
                                                boolean notMethod = ln2.endsWith(";");
                                                String ln3 = ln2;
                                                String indent = "";
                                                while (true) {
                                                    if (ln3.length() <= 0 || !Character.isWhitespace(ln3.charAt(0))) {
                                                        tokens = ln3.split("\\s+");
                                                        hasTypeDecl = false;
                                                        hasMethodDecl = false;
                                                        hasType = false;
                                                        j = 0;
                                                        break;
                                                    }
                                                    indent = String.valueOf(indent) + ln3.charAt(0);
                                                    ln3 = ln3.substring(1);
                                                }
                                                block39: while (j < tokens.length) {
                                                    if (tokens[j].length() > 0) {
                                                        boolean b1 = false;
                                                        boolean b2 = false;
                                                        if (InsertJavaDoc.isTypeModifierField(tokens[j])) {
                                                            b1 = true;
                                                            hasTypeDecl = true;
                                                        }
                                                        if (!notMethod && InsertJavaDoc.isTypeModifierMethod(tokens[j])) {
                                                            b2 = true;
                                                            hasMethodDecl = true;
                                                        }
                                                        if (!b1 && !b2) {
                                                            if (!hasType) {
                                                                if (illegalCharactersNotATypeName.matcher(tokens[j]).find()) break;
                                                                hasType = true;
                                                            } else {
                                                                int idx = 0;
                                                                if (hasTypeDecl && j < tokens.length - 1 && tokens[j + 1].equals("=")) {
                                                                    if (fields == null) break;
                                                                    int k = 0;
                                                                    int l = fields.size();
                                                                    while (k < l) {
                                                                        CSVMappings.Symbol ss = (CSVMappings.Symbol)fields.get(k);
                                                                        if (ss.name.equals(tokens[j])) {
                                                                            List<String> lines = InsertJavaDoc.wordWrapComment(ss.comment, indent);
                                                                            linesLst.addAll(i, lines);
                                                                            i += lines.size();
                                                                            ++modf;
                                                                            break block39;
                                                                        }
                                                                        ++k;
                                                                    }
                                                                } else {
                                                                    idx = tokens[j].indexOf(40);
                                                                    if ((idx == -1 || j <= 0) && !hasMethodDecl || meths == null || idx <= 0) break;
                                                                    String sss = tokens[j].substring(0, idx);
                                                                    int k = 0;
                                                                    int l = meths.size();
                                                                    while (k < l) {
                                                                        CSVMappings.Symbol ss = (CSVMappings.Symbol)meths.get(k);
                                                                        if (ss.name.equals(sss)) {
                                                                            List<String> lines = InsertJavaDoc.wordWrapComment(ss.comment, indent);
                                                                            linesLst.addAll(i, lines);
                                                                            i += lines.size();
                                                                            ++modm;
                                                                            break block39;
                                                                        }
                                                                        ++k;
                                                                    }
                                                                }
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    ++j;
                                                }
                                                ++i;
                                            }
                                        }
                                        int cnt0 = enums[0];
                                        int i = 0;
                                        int l = linesLst.size();
                                        while (true) {
                                            if (i >= l) {
                                                if (cnt0 != enums[0]) {
                                                    i = 0;
                                                    l = linesLst.size();
                                                    break;
                                                }
                                                break block88;
                                            }
                                            linesLst.set(i, OpenGLEnumManager.insertIntoLine((String)linesLst.get(i), enumCounter));
                                            ++i;
                                        }
                                        while (i < l) {
                                            String line = (String)linesLst.get(i);
                                            if (line.startsWith("package")) {
                                                linesLst.addAll(i + 1, Arrays.asList("", enumImport));
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    ZipEntry z2 = new ZipEntry(nm);
                                    jarOut.putNextEntry(z2);
                                    IOUtils.write(String.join((CharSequence)System.lineSeparator(), linesLst), (OutputStream)jarOut, "UTF-8");
                                    if (++xt % 75 != 74) continue;
                                    System.out.print(".");
                                    continue;
                                }
                                if (nm.startsWith("META-INF")) continue;
                                ZipEntry z2 = new ZipEntry(nm);
                                jarOut.putNextEntry(z2);
                                IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut, 4096);
                            }
                        }
                        if (jarIn == null) break block90;
                    }
                    catch (Throwable throwable5) {
                        if (s == null) {
                            s = throwable5;
                        } else if (s != throwable5) {
                            ((Throwable)s).addSuppressed(throwable5);
                        }
                        if (jarIn == null) throw s;
                        jarIn.close();
                        throw s;
                    }
                    jarIn.close();
                }
                catch (Throwable throwable6) {
                    if (s == null) {
                        s = throwable6;
                        throw s;
                    }
                    if (s == throwable6) throw s;
                    ((Throwable)s).addSuppressed(throwable6);
                    throw s;
                }
            }
            catch (IOException ex) {
                System.err.println("Failed to process jar '" + fileIn.getName() + "' and write it to '" + fileOut.getName() + "!");
                ex.printStackTrace();
                return false;
            }
        }
        System.out.println();
        System.out.println("Added " + enums[0] + " OpenGL enums");
        if (csv != null) {
            System.out.println("Added " + modm + " comments to methods");
            System.out.println("Added " + modf + " comments to fields");
        }
        System.out.println();
        return true;
    }

    private static List<String> wordWrapComment(String strIn, String indent) {
        String[] wds = strIn.split("\\s+");
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(String.valueOf(indent) + "/**+");
        String ln = "";
        int i = 0;
        while (i < wds.length) {
            if (ln.length() > 0 && wds[i].length() + ln.length() > 60) {
                ret.add(String.valueOf(indent) + " * " + ln);
                ln = "";
            }
            ln = String.valueOf(ln) + (ln.length() > 0 ? " " + wds[i] : wds[i]);
            ++i;
        }
        if (ln.length() > 0) {
            ret.add(String.valueOf(indent) + " * " + ln);
        }
        ret.add(String.valueOf(indent) + " */");
        return ret;
    }

    public static String stripDocForDiff(String fileIn) {
        int idx;
        List<String> linesIn = Lines.linesList(fileIn);
        OpenGLEnumManager.loadEnumMap();
        ArrayList<String> linesOut = new ArrayList<String>();
        boolean addOpenGLImport = false;
        int i = 0;
        int l = linesIn.size();
        while (i < l) {
            String line = linesIn.get(i);
            if (line.trim().startsWith("/**+")) {
                while (i < l) {
                    if (!linesIn.get(i).endsWith("*/")) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                String line2 = OpenGLEnumManager.stripFromLine(line);
                if (line2 != null) {
                    linesOut.add(line2);
                    addOpenGLImport = true;
                } else {
                    linesOut.add(line);
                }
            }
            ++i;
        }
        if (addOpenGLImport && (idx = linesOut.indexOf(enumImport)) != -1) {
            if (idx - 1 >= 0 && ((String)linesOut.get(idx - 1)).trim().length() == 0 && linesOut.size() > 1) {
                linesOut.remove(--idx);
                linesOut.remove(idx);
            } else {
                linesOut.remove(idx);
            }
        }
        return String.join((CharSequence)System.lineSeparator(), linesOut);
    }
}

