/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EaglerContextRedacted {
    public static void writeContextRedacted(Patch<String> patch, PrintWriter output) {
        Date theDate = new Date();
        output.println();
        output.println("# Eagler Context Redacted Diff");
        output.println("# Copyright (c) " + new SimpleDateFormat("yyyy").format(theDate) + " lax1dude. All rights reserved.");
        output.println();
        output.println("# Version: 1.0");
        output.println("# Author: lax1dude");
        output.println();
        int lastSourcePos = 0;
        int lastTargetPos = 0;
        List<AbstractDelta<String>> deltas = patch.getDeltas();
        int i = 0;
        int l = deltas.size();
        while (i < l) {
            block9: {
                String blockPrefix;
                String blockType;
                AbstractDelta<String> delta = deltas.get(i);
                DeltaType type = delta.getType();
                switch (type) {
                    case CHANGE: {
                        blockType = "> CHANGE";
                        blockPrefix = "~ ";
                        break;
                    }
                    case DELETE: {
                        blockType = "> DELETE";
                        blockPrefix = "- ";
                        break;
                    }
                    case EQUAL: {
                        break block9;
                    }
                    case INSERT: {
                        blockType = "> INSERT";
                        blockPrefix = "+ ";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type " + (Object)((Object)type) + " for delta " + i);
                    }
                }
                Chunk<String> source = delta.getSource();
                int sourcePos = source.getPosition();
                int sourceLen = source.getLines().size();
                int sourcePosRelative = sourcePos - lastSourcePos;
                Chunk<String> target = delta.getTarget();
                int targetPos = target.getPosition();
                List<String> linesToWrite = target.getLines();
                int targetLen = linesToWrite.size();
                int targetPosRelative = targetPos - lastTargetPos;
                output.println(String.valueOf(blockType) + "  " + targetPosRelative + (targetLen > 0 ? " : " + (targetPosRelative + targetLen) : "") + "  @  " + sourcePosRelative + (sourceLen > 0 ? " : " + (sourcePosRelative + sourceLen) : ""));
                output.println();
                if (targetLen > 0) {
                    int j = 0;
                    int ll = linesToWrite.size();
                    while (j < ll) {
                        output.println(String.valueOf(blockPrefix) + linesToWrite.get(j));
                        ++j;
                    }
                    output.println();
                }
                lastSourcePos = sourcePos + sourceLen;
                lastTargetPos = targetPos + targetLen;
            }
            ++i;
        }
        output.println("> EOF");
    }

    public static Patch<String> readContextRestricted(List<String> context, BufferedReader reader) throws IOException {
        String line;
        Patch<String> newPatch = new Patch<String>();
        DeltaType currentDeltaType = null;
        int sourceStart = 0;
        int sourceLen = 0;
        int targetStart = 0;
        int targetLen = 0;
        ArrayList<String> targetLines = null;
        int lastSourcePos = 0;
        int lastTargetPos = 0;
        block17: while ((line = reader.readLine()) != null) {
            if (line.length() < 2) continue;
            if (line.charAt(1) != ' ') {
                throw new IOException("Unknown line type: " + line.substring(0, 2));
            }
            char lineType = line.charAt(0);
            String value = line.substring(2);
            switch (lineType) {
                case '#': {
                    String v;
                    String k;
                    int idx = value.indexOf(58);
                    if (idx <= 0 || !(k = value.substring(0, idx).trim().toLowerCase()).equals("version") || (v = value.substring(idx + 1).trim()).equals("1.0")) continue block17;
                    throw new IOException("Unsupported format version: " + v);
                }
                case '>': {
                    CharSequence[] split = value.trim().split("[\\s]+");
                    if (split.length == 1 && split[0].equals("EOF")) break block17;
                    if (!(split.length >= 4 && (split[2].equals("@") && (split.length == 4 || split.length == 6 && ((String)split[4]).equals(":")) || split[2].equals(":") && (split.length == 6 && ((String)split[4]).equals("@") || split.length == 8 && ((String)split[4]).equals("@") && ((String)split[6]).equals(":"))))) {
                        throw new IOException("Invalid block: [ " + String.join((CharSequence)" ", split) + " ]");
                    }
                    if (currentDeltaType != null) {
                        newPatch.addDelta(EaglerContextRedacted.makeDelta(currentDeltaType, lastSourcePos += sourceStart, sourceLen, lastTargetPos += targetStart, targetLen, context, targetLines));
                        lastSourcePos += sourceLen;
                        lastTargetPos += targetLen;
                    }
                    switch (split[0]) {
                        case "CHANGE": {
                            currentDeltaType = DeltaType.CHANGE;
                            break;
                        }
                        case "DELETE": {
                            currentDeltaType = DeltaType.DELETE;
                            break;
                        }
                        case "INSERT": {
                            currentDeltaType = DeltaType.INSERT;
                            break;
                        }
                        default: {
                            throw new IOException("Unknown line block: " + (String)split[0]);
                        }
                    }
                    targetLines = null;
                    targetStart = EaglerContextRedacted.parseInt((String)split[1]);
                    if (((String)split[2]).equals(":")) {
                        targetLen = EaglerContextRedacted.parseInt((String)split[3]) - targetStart;
                        sourceStart = EaglerContextRedacted.parseInt((String)split[5]);
                        if (split.length == 8) {
                            sourceLen = EaglerContextRedacted.parseInt((String)split[7]) - sourceStart;
                            break;
                        }
                        sourceLen = 0;
                        break;
                    }
                    targetLen = 0;
                    sourceStart = EaglerContextRedacted.parseInt((String)split[3]);
                    if (split.length == 6) {
                        sourceLen = EaglerContextRedacted.parseInt((String)split[5]) - sourceStart;
                        break;
                    }
                    sourceLen = 0;
                    break;
                }
                case '~': {
                    if (currentDeltaType != DeltaType.CHANGE) {
                        throw new IOException("Read an unexpected CHANGE line in a " + currentDeltaType + " block: " + line);
                    }
                    if (targetLines == null) {
                        targetLines = new ArrayList<String>();
                    }
                    targetLines.add(value);
                    break;
                }
                case '-': {
                    if (currentDeltaType != DeltaType.DELETE) {
                        throw new IOException("Read an unexpected DELETE line in a " + currentDeltaType + " block: " + line);
                    }
                    if (targetLines == null) {
                        targetLines = new ArrayList();
                    }
                    targetLines.add(value);
                    break;
                }
                case '+': {
                    if (currentDeltaType != DeltaType.INSERT) {
                        throw new IOException("Read an unexpected INSERT line in a " + currentDeltaType + " block: " + line);
                    }
                    if (targetLines == null) {
                        targetLines = new ArrayList();
                    }
                    targetLines.add(value);
                    break;
                }
                default: {
                    throw new IOException("Unknown line type: " + lineType);
                }
            }
        }
        if (currentDeltaType != null) {
            newPatch.addDelta(EaglerContextRedacted.makeDelta(currentDeltaType, lastSourcePos += sourceStart, sourceLen, lastTargetPos += targetStart, targetLen, context, targetLines));
            lastSourcePos += sourceLen;
            lastTargetPos += targetLen;
        }
        return newPatch;
    }

    private static int parseInt(String str) throws IOException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Value is not a valid integer: \"" + str + "\"");
        }
    }

    private static AbstractDelta<String> makeDelta(DeltaType deltaType, int sourceStart, int sourceLen, int targetStart, int targetLen, List<String> context, List<String> targetLines) throws IOException {
        ArrayList<String> sourceLines = new ArrayList<String>(sourceLen);
        int i = 0;
        while (i < sourceLen) {
            sourceLines.add(context.get(sourceStart + i));
            ++i;
        }
        if (targetLines == null) {
            targetLines = new ArrayList<String>(0);
        }
        if (targetLen != targetLines.size()) {
            throw new IOException((Object)((Object)deltaType) + " block at sourceStart " + sourceStart + " is " + targetLen + " lines long but only " + targetLines.size() + " lines were read!");
        }
        switch (deltaType) {
            case CHANGE: {
                return new ChangeDelta<String>(new Chunk(sourceStart, sourceLines), new Chunk<String>(targetStart, targetLines));
            }
            case DELETE: {
                return new DeleteDelta<String>(new Chunk(sourceStart, sourceLines), new Chunk<String>(targetStart, targetLines));
            }
            case INSERT: {
                return new InsertDelta<String>(new Chunk(sourceStart, sourceLines), new Chunk<String>(targetStart, targetLines));
            }
        }
        throw new IllegalArgumentException("Invalid delta type: " + (Object)((Object)deltaType));
    }
}

