/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JavaC {
    public static final boolean windows;
    public static File jdkHome;
    public static final List<String> compilerFlags;
    private static int debugSourceFileCount;

    static {
        compilerFlags = Arrays.asList("-Xlint:-unchecked", "-Xlint:-options", "-Xlint:-deprecation", "-source", "1.8", "-target", "1.8");
        debugSourceFileCount = 0;
        windows = System.getProperty("os.name").toLowerCase().contains("windows");
        String javac = windows ? "javac.exe" : "javac";
        File jdkHomeProp = new File(System.getProperty("java.home"));
        jdkHome = new File(jdkHomeProp, "bin/" + javac).isFile() ? jdkHomeProp : (new File(jdkHomeProp, "../bin/" + javac).isFile() ? jdkHomeProp.getParentFile() : null);
    }

    public static int runJavaC(File mcSourceJar, File outputDirectory, File tmpDirectory, String[] teavmClasspath, File ... eaglerSourceDirs) throws IOException {
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new IOException("Could not create output directory: " + outputDirectory.getAbsolutePath());
        }
        if (!tmpDirectory.exists() && !tmpDirectory.mkdirs()) {
            throw new IOException("Could not create temporary directory: " + outputDirectory.getAbsolutePath());
        }
        File minecraftSrcTmp = new File(tmpDirectory, "MinecraftSrc/src_javadoc_tmp");
        if (!minecraftSrcTmp.exists() && !minecraftSrcTmp.mkdirs()) {
            throw new IOException("Could not create temporary directory: " + minecraftSrcTmp.getAbsolutePath());
        }
        debugSourceFileCount = 0;
        File argFile = new File(tmpDirectory, "sourceFiles.txt");
        Throwable throwable = null;
        Object var8_9 = null;
        try (PrintWriter writer = new PrintWriter(new FileWriter(argFile));){
            System.out.println("Extracting decompiled source...");
            byte[] copyBuffer = new byte[16384];
            Throwable throwable2 = null;
            Object var13_20 = null;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(mcSourceJar));){
                ZipEntry etr;
                while ((etr = zis.getNextEntry()) != null && !etr.isDirectory()) {
                    String n = etr.getName();
                    if (!n.endsWith(".java")) continue;
                    File writeTo = new File(minecraftSrcTmp, n);
                    File parent = writeTo.getParentFile();
                    if (!parent.exists() && !parent.mkdirs()) {
                        throw new IOException("Could not create temporary directory: " + parent.getAbsolutePath());
                    }
                    Throwable throwable3 = null;
                    Object var20_33 = null;
                    try (FileOutputStream os = new FileOutputStream(writeTo);){
                        int copyBufferLen;
                        while ((copyBufferLen = zis.read(copyBuffer)) != -1) {
                            ((OutputStream)os).write(copyBuffer, 0, copyBufferLen);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    writer.println("\"" + writeTo.getAbsolutePath().replace('\\', '/') + "\"");
                    ++debugSourceFileCount;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            System.out.println("Scanning source folder paths...");
            int i = 0;
            while (i < eaglerSourceDirs.length) {
                JavaC.discoverSourceFiles(eaglerSourceDirs[i], writer);
                ++i;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        ArrayList<String> commandBuilder = new ArrayList<String>();
        if (windows) {
            commandBuilder.add(new File(jdkHome, "bin/javac.exe").getAbsolutePath());
        } else {
            commandBuilder.add(new File(jdkHome, "bin/javac").getAbsolutePath());
        }
        commandBuilder.addAll(compilerFlags);
        String pathSeparator = System.getProperty("path.separator");
        commandBuilder.add("-classpath");
        commandBuilder.add(String.join((CharSequence)pathSeparator, teavmClasspath));
        commandBuilder.add("-sourcepath");
        StringBuilder sourcePathBuilder = new StringBuilder();
        sourcePathBuilder.append(mcSourceJar.getAbsolutePath());
        int i = 0;
        while (i < eaglerSourceDirs.length) {
            sourcePathBuilder.append(pathSeparator).append(eaglerSourceDirs[i].getAbsolutePath());
            ++i;
        }
        commandBuilder.add(sourcePathBuilder.toString());
        commandBuilder.add("-d");
        commandBuilder.add(outputDirectory.getAbsolutePath());
        commandBuilder.add("@" + argFile.getAbsolutePath());
        System.out.println();
        i = 0;
        int l = commandBuilder.size();
        while (i < l) {
            String e = (String)commandBuilder.get(i);
            if (e.indexOf(32) != -1) {
                System.out.print("\"" + e + "\"");
            } else {
                System.out.print(e);
            }
            System.out.print(' ');
            ++i;
        }
        System.out.println();
        System.out.println();
        System.out.println("Compiling " + debugSourceFileCount + " source files...");
        ProcessBuilder procBuilder = new ProcessBuilder(commandBuilder);
        procBuilder.directory(tmpDirectory);
        Process javacProcess = procBuilder.start();
        InputStream stdout = javacProcess.getInputStream();
        InputStream stderr = javacProcess.getErrorStream();
        byte[] readBuffer = new byte[128];
        do {
            boolean tick = false;
            int j = stdout.available();
            if (j > 0) {
                if (j > 128) {
                    j = 128;
                }
                stdout.read(readBuffer, 0, j);
                System.out.write(readBuffer, 0, j);
                tick = true;
            }
            if ((j = stderr.available()) > 0) {
                if (j > 128) {
                    j = 128;
                }
                stderr.read(readBuffer, 0, j);
                System.err.write(readBuffer, 0, j);
                tick = true;
            }
            if (tick) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } while (javacProcess.isAlive());
        while (true) {
            try {
                return javacProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void discoverSourceFiles(File folder, PrintWriter printWriter) throws IOException {
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            String name = f.getAbsolutePath();
            if (f.isDirectory()) {
                JavaC.discoverSourceFiles(f, printWriter);
            } else if (name.endsWith(".java")) {
                printWriter.println("\"" + name.replace('\\', '/') + "\"");
                ++debugSourceFileCount;
            }
            ++i;
        }
    }
}

