/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.md_5.bungee.UserConnection;

public class SkinServiceOffline
implements ISkinService {
    public static final int masterRateLimitPerPlayer = 250;
    private final Map<UUID, CachedSkin> skinCache = new HashMap<UUID, CachedSkin>();
    private final Multimap<UUID, UUID> onlinePlayersFromTexturesMap = MultimapBuilder.hashKeys().hashSetValues().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID uUID, UserConnection userConnection) {
        if (((EaglerInitialHandler)userConnection.getPendingConnection()).skinLookupRateLimiter.rateLimit(250)) {
            CachedSkin cachedSkin;
            Map<UUID, CachedSkin> map = this.skinCache;
            synchronized (map) {
                cachedSkin = this.skinCache.get(uUID);
            }
            if (cachedSkin != null) {
                userConnection.sendData("EAG|Skins-1.8", cachedSkin.packet);
            } else {
                userConnection.sendData("EAG|Skins-1.8", SkinPackets.makePresetResponse(uUID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID uUID, String string, UserConnection userConnection) {
        Collection collection;
        Object object = this.onlinePlayersFromTexturesMap;
        synchronized (object) {
            collection = this.onlinePlayersFromTexturesMap.get((Object)uUID);
        }
        if (collection.size() > 0) {
            Map<UUID, CachedSkin> map = this.skinCache;
            synchronized (map) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    object = this.skinCache.get(iterator.next());
                    if (object == null) continue;
                    userConnection.sendData("EAG|Skins-1.8", SkinPackets.rewriteUUID(uUID, object.packet));
                }
            }
        }
        userConnection.sendData("EAG|Skins-1.8", SkinPackets.makePresetResponse(uUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEaglercraftPlayer(UUID uUID, byte[] byArray, int n) throws IOException {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.put(uUID, new CachedSkin(uUID, byArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPlayer(UUID uUID) {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.remove(uUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTextureToPlayerAssociation(UUID uUID, UUID uUID2) {
        Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
        synchronized (multimap) {
            this.onlinePlayersFromTexturesMap.put((Object)uUID, (Object)uUID2);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.clear();
        }
    }

    private static class CachedSkin {
        protected final UUID uuid;
        protected final byte[] packet;

        protected CachedSkin(UUID uUID, byte[] byArray) {
            this.uuid = uUID;
            this.packet = byArray;
        }
    }
}

