/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.UserConnection;

public class SkinPackets {
    public static final int PACKET_MY_SKIN_PRESET = 1;
    public static final int PACKET_MY_SKIN_CUSTOM = 2;
    public static final int PACKET_GET_OTHER_SKIN = 3;
    public static final int PACKET_OTHER_SKIN_PRESET = 4;
    public static final int PACKET_OTHER_SKIN_CUSTOM = 5;
    public static final int PACKET_GET_SKIN_BY_URL = 6;
    private static final String hex = "0123456789abcdef";

    public static void processPacket(byte[] byArray, UserConnection userConnection, ISkinService iSkinService) throws IOException {
        if (byArray.length == 0) {
            throw new IOException("Zero-length packet recieved");
        }
        int n = byArray[0] & 0xFF;
        try {
            switch (n) {
                case 3: {
                    SkinPackets.processGetOtherSkin(byArray, userConnection, iSkinService);
                    break;
                }
                case 6: {
                    SkinPackets.processGetOtherSkinByURL(byArray, userConnection, iSkinService);
                    break;
                }
                default: {
                    throw new IOException("Unknown packet type " + n);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException("Unhandled exception handling packet type " + n, throwable);
        }
    }

    private static void processGetOtherSkin(byte[] byArray, UserConnection userConnection, ISkinService iSkinService) throws IOException {
        if (byArray.length != 17) {
            throw new IOException("Invalid length " + byArray.length + " for skin request packet");
        }
        UUID uUID = SkinPackets.bytesToUUID(byArray, 1);
        iSkinService.processGetOtherSkin(uUID, userConnection);
    }

    private static void processGetOtherSkinByURL(byte[] byArray, UserConnection userConnection, ISkinService iSkinService) throws IOException {
        URL uRL;
        if (byArray.length < 20) {
            throw new IOException("Invalid length " + byArray.length + " for skin request packet");
        }
        UUID uUID = SkinPackets.bytesToUUID(byArray, 1);
        int n = byArray[17] << 8 | byArray[18];
        if (byArray.length < 19 + n) {
            throw new IOException("Invalid length " + byArray.length + " for skin request packet with " + n + " length URL");
        }
        String string = SkinPackets.bytesToAscii(byArray, 19, n);
        if ((string = SkinService.sanitizeTextureURL(string)) == null) {
            throw new IOException("Invalid URL for skin request packet");
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Invalid URL for skin request packet", malformedURLException);
        }
        String string2 = uRL.getHost();
        if (EaglerXBungee.getEagler().getConfig().isValidSkinHost(string2)) {
            UUID uUID2 = SkinPackets.createEaglerURLSkinUUID(string);
            if (!uUID.equals(uUID2)) {
                throw new IOException("Invalid generated UUID from skin URL");
            }
        } else {
            throw new IOException("Invalid host in skin packet: " + string2);
        }
        iSkinService.processGetOtherSkin(uUID, string, userConnection);
    }

    public static void registerEaglerPlayer(UUID uUID, byte[] byArray, ISkinService iSkinService) throws IOException {
        byte[] byArray2;
        if (byArray.length == 0) {
            throw new IOException("Zero-length packet recieved");
        }
        int n = -1;
        int n2 = byArray[0] & 0xFF;
        switch (n2) {
            case 1: {
                if (byArray.length != 5) {
                    throw new IOException("Invalid length " + byArray.length + " for preset skin packet");
                }
                byArray2 = SkinPackets.makePresetResponse(uUID, byArray[1] << 24 | byArray[2] << 16 | byArray[3] << 8 | byArray[4] & 0xFF);
                break;
            }
            case 2: {
                byte[] byArray3 = new byte[16384];
                if (byArray.length != 2 + byArray3.length) {
                    throw new IOException("Invalid length " + byArray.length + " for custom skin packet");
                }
                SkinPackets.setAlphaForChest(byArray3, (byte)-1);
                System.arraycopy(byArray, 2, byArray3, 0, byArray3.length);
                n = byArray[1] & 0xFF;
                byArray2 = SkinPackets.makeCustomResponse(uUID, n, byArray3);
                break;
            }
            default: {
                throw new IOException("Unknown skin packet type: " + n2);
            }
        }
        iSkinService.registerEaglercraftPlayer(uUID, byArray2, n);
    }

    public static void registerEaglerPlayerFallback(UUID uUID, ISkinService iSkinService) throws IOException {
        int n = (uUID.hashCode() & 1) != 0 ? 1 : 0;
        byte[] byArray = SkinPackets.makePresetResponse(uUID, n);
        iSkinService.registerEaglercraftPlayer(uUID, byArray, n);
    }

    public static void setAlphaForChest(byte[] byArray, byte by) {
        if (byArray.length != 16384) {
            throw new IllegalArgumentException("Skin is not 64x64!");
        }
        int n = 20;
        while (n < 32) {
            int n2 = 16;
            while (n2 < 40) {
                byArray[n << 8 | n2 << 2] = by;
                ++n2;
            }
            ++n;
        }
    }

    public static byte[] makePresetResponse(UUID uUID) {
        return SkinPackets.makePresetResponse(uUID, (uUID.hashCode() & 1) != 0 ? 1 : 0);
    }

    public static byte[] makePresetResponse(UUID uUID, int n) {
        byte[] byArray = new byte[21];
        byArray[0] = 4;
        SkinPackets.UUIDToBytes(uUID, byArray, 1);
        byArray[17] = (byte)(n >> 24);
        byArray[18] = (byte)(n >> 16);
        byArray[19] = (byte)(n >> 8);
        byArray[20] = (byte)(n & 0xFF);
        return byArray;
    }

    public static byte[] makeCustomResponse(UUID uUID, int n, byte[] byArray) {
        byte[] byArray2 = new byte[18 + byArray.length];
        byArray2[0] = 5;
        SkinPackets.UUIDToBytes(uUID, byArray2, 1);
        byArray2[17] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 18, byArray.length);
        return byArray2;
    }

    public static UUID bytesToUUID(byte[] byArray, int n) {
        long l = ((long)byArray[n] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
        long l2 = ((long)byArray[n + 8] & 0xFFL) << 56 | ((long)byArray[n + 9] & 0xFFL) << 48 | ((long)byArray[n + 10] & 0xFFL) << 40 | ((long)byArray[n + 11] & 0xFFL) << 32 | ((long)byArray[n + 12] & 0xFFL) << 24 | ((long)byArray[n + 13] & 0xFFL) << 16 | ((long)byArray[n + 14] & 0xFFL) << 8 | (long)byArray[n + 15] & 0xFFL;
        return new UUID(l, l2);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3 * 2] = hex.charAt(byArray[n + n3] >> 4 & 0xF);
            cArray[n3 * 2 + 1] = hex.charAt(byArray[n + n3] & 0xF);
            ++n3;
        }
        return new String(cArray);
    }

    public static String bytesToAscii(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)(byArray[n + n3] & 0xFF);
            ++n3;
        }
        return new String(cArray);
    }

    public static String bytesToAscii(byte[] byArray) {
        return SkinPackets.bytesToAscii(byArray, 0, byArray.length);
    }

    public static void UUIDToBytes(UUID uUID, byte[] byArray, int n) {
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        byArray[n] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)(l & 0xFFL);
        byArray[n + 8] = (byte)(l2 >> 56);
        byArray[n + 9] = (byte)(l2 >> 48);
        byArray[n + 10] = (byte)(l2 >> 40);
        byArray[n + 11] = (byte)(l2 >> 32);
        byArray[n + 12] = (byte)(l2 >> 24);
        byArray[n + 13] = (byte)(l2 >> 16);
        byArray[n + 14] = (byte)(l2 >> 8);
        byArray[n + 15] = (byte)(l2 & 0xFFL);
    }

    public static byte[] asciiString(String string) {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        return byArray;
    }

    public static UUID createEaglerURLSkinUUID(String string) {
        return UUID.nameUUIDFromBytes(SkinPackets.asciiString("EaglercraftSkinURL:" + string));
    }

    public static int getModelId(String string) {
        return "slim".equalsIgnoreCase(string) ? 1 : 0;
    }

    public static byte[] rewriteUUID(UUID uUID, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        SkinPackets.UUIDToBytes(uUID, byArray2, 1);
        return byArray2;
    }

    public static byte[] rewriteUUIDModel(UUID uUID, byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        SkinPackets.UUIDToBytes(uUID, byArray2, 1);
        if (byArray2[0] == 5) {
            byArray2[17] = (byte)n;
        }
        return byArray2;
    }
}

