/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.query.EaglerQuerySimpleHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.query.MOTDConnection;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.MOTDCacheConfiguration;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class MOTDQueryHandler
extends EaglerQuerySimpleHandler
implements MOTDConnection {
    private long creationTime = 0L;
    private String line1;
    private String line2;
    private List<String> players;
    private int[] bitmap;
    private int onlinePlayers;
    private int maxPlayers;
    private boolean hasIcon;
    private boolean iconDirty;
    private String subType;
    private String returnType;

    @Override
    protected void begin(String string) {
        this.creationTime = System.currentTimeMillis();
        this.subType = string;
        this.returnType = "MOTD";
        EaglerListenerConfig eaglerListenerConfig = this.getListener();
        String[] stringArray = eaglerListenerConfig.getMotd().split("\n");
        if (stringArray.length >= 1) {
            this.line1 = stringArray[0];
        }
        if (stringArray.length >= 2) {
            this.line2 = stringArray[1];
        }
        this.maxPlayers = eaglerListenerConfig.getMaxPlayers();
        this.onlinePlayers = ProxyServer.getInstance().getOnlineCount();
        this.players = new ArrayList<String>();
        for (ProxiedPlayer proxiedPlayer : ProxyServer.getInstance().getPlayers()) {
            this.players.add(proxiedPlayer.getDisplayName());
            if (this.players.size() < 9) continue;
            this.players.add(ChatColor.GRAY + ChatColor.ITALIC + "(" + (this.onlinePlayers - this.players.size()) + " more)");
            break;
        }
        this.bitmap = new int[4096];
        int n = string.indexOf(46);
        if (n > 0) {
            this.subType = string.substring(n + 1);
            if (this.subType.length() == 0) {
                this.subType = "motd";
            }
        } else {
            this.subType = "motd";
        }
        if (!this.subType.startsWith("noicon") && !this.subType.startsWith("cache.noicon")) {
            Object object = eaglerListenerConfig.getServerIconPixels();
            this.hasIcon = object != null;
            this.iconDirty = this.hasIcon;
            if (this.hasIcon) {
                System.arraycopy(object, 0, this.bitmap, 0, 4096);
            }
        }
    }

    @Override
    public long getConnectionTimestamp() {
        return this.creationTime;
    }

    @Override
    public void sendToUser() {
        if (!this.isClosed()) {
            MOTDCacheConfiguration mOTDCacheConfiguration;
            Object object;
            JsonObject jsonObject = new JsonObject();
            if (this.subType.startsWith("cache.anim")) {
                jsonObject.addProperty("unsupported", Boolean.valueOf(true));
                this.sendJsonResponseAndClose(this.returnType, jsonObject);
                return;
            }
            if (this.subType.startsWith("cache")) {
                object = new JsonArray();
                mOTDCacheConfiguration = this.getListener().getMOTDCacheConfig();
                if (mOTDCacheConfiguration.cacheServerListAnimation) {
                    object.add("animation");
                }
                if (mOTDCacheConfiguration.cacheServerListResults) {
                    object.add("results");
                }
                if (mOTDCacheConfiguration.cacheServerListTrending) {
                    object.add("trending");
                }
                if (mOTDCacheConfiguration.cacheServerListPortfolios) {
                    object.add("portfolio");
                }
                jsonObject.add("cache", (JsonElement)object);
                jsonObject.addProperty("ttl", (Number)mOTDCacheConfiguration.cacheTTL);
            } else {
                object = this.getListener().getMOTDCacheConfig();
                jsonObject.addProperty("cache", Boolean.valueOf(object.cacheServerListAnimation || object.cacheServerListResults || object.cacheServerListTrending || object.cacheServerListPortfolios));
            }
            boolean bl = this.subType.startsWith("noicon") || this.subType.startsWith("cache.noicon");
            mOTDCacheConfiguration = new JsonArray();
            if (this.line1 != null && this.line1.length() > 0) {
                mOTDCacheConfiguration.add(this.line1);
            }
            if (this.line2 != null && this.line2.length() > 0) {
                mOTDCacheConfiguration.add(this.line2);
            }
            jsonObject.add("motd", (JsonElement)mOTDCacheConfiguration);
            jsonObject.addProperty("icon", Boolean.valueOf(this.hasIcon && !bl));
            jsonObject.addProperty("online", (Number)this.onlinePlayers);
            jsonObject.addProperty("max", (Number)this.maxPlayers);
            JsonArray jsonArray = new JsonArray();
            for (String object2 : this.players) {
                jsonArray.add(object2);
            }
            jsonObject.add("players", (JsonElement)jsonArray);
            this.sendJsonResponse(this.returnType, jsonObject);
            if (this.hasIcon && !bl && this.iconDirty && this.bitmap != null) {
                byte[] byArray = new byte[16384];
                int n = 0;
                while (n < 4096) {
                    int n2 = n << 2;
                    byArray[n2] = (byte)(this.bitmap[n] >> 16 & 0xFF);
                    byArray[n2 + 1] = (byte)(this.bitmap[n] >> 8 & 0xFF);
                    byArray[n2 + 2] = (byte)(this.bitmap[n] & 0xFF);
                    byArray[n2 + 3] = (byte)(this.bitmap[n] >> 24 & 0xFF);
                    ++n;
                }
                this.sendBinaryResponse(byArray);
                this.iconDirty = false;
            }
            if (this.subType.startsWith("cache")) {
                this.close();
            }
        }
    }

    @Override
    public String getLine1() {
        return this.line1;
    }

    @Override
    public String getLine2() {
        return this.line2;
    }

    @Override
    public List<String> getPlayerList() {
        return this.players;
    }

    @Override
    public int[] getBitmap() {
        return this.bitmap;
    }

    @Override
    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public void setLine1(String string) {
        this.line1 = string;
    }

    @Override
    public void setLine2(String string) {
        this.line2 = string;
    }

    @Override
    public void setPlayerList(List<String> list) {
        this.players = list;
    }

    @Override
    public void setPlayerList(String ... stringArray) {
        this.players = Arrays.asList(stringArray);
    }

    @Override
    public void setBitmap(int[] nArray) {
        this.hasIcon = true;
        this.iconDirty = true;
        this.bitmap = nArray;
    }

    @Override
    public void setOnlinePlayers(int n) {
        this.onlinePlayers = n;
    }

    @Override
    public void setMaxPlayers(int n) {
        this.maxPlayers = n;
    }
}

