/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpWebSocketHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpMemoryCache;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;

public class HttpHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final byte[] error429Bytes = "<h3>429 Too Many Requests<br /><small>(Try again later)</small></h3>".getBytes(StandardCharsets.UTF_8);
    private final EaglerListenerConfig conf;

    public HttpHandshakeHandler(EaglerListenerConfig eaglerListenerConfig) {
        this.conf = eaglerListenerConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(final ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        HttpMemoryCache httpMemoryCache;
        int n;
        Object object2;
        if (!(object instanceof HttpRequest)) {
            channelHandlerContext.close();
            return;
        }
        EaglerConnectionInstance eaglerConnectionInstance = (EaglerConnectionInstance)channelHandlerContext.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
        HttpRequest httpRequest = (HttpRequest)object;
        HttpHeaders httpHeaders = httpRequest.headers();
        String string = null;
        if (this.conf.isForwardIp()) {
            object2 = httpHeaders.get(this.conf.getForwardIpHeader());
            if (object2 == null) {
                EaglerXBungee.logger().warning("[" + channelHandlerContext.channel().remoteAddress() + "]: Connected without a '" + this.conf.getForwardIpHeader() + "' header, disconnecting...");
                channelHandlerContext.close();
                return;
            }
            string = ((String)object2).split(",", 2)[0];
            try {
                channelHandlerContext.channel().attr(EaglerPipeline.REAL_ADDRESS).set((Object)InetAddress.getByName(string));
            }
            catch (UnknownHostException unknownHostException) {
                EaglerXBungee.logger().warning("[" + channelHandlerContext.channel().remoteAddress() + "]: Connected with an invalid '" + this.conf.getForwardIpHeader() + "' header, disconnecting...");
                channelHandlerContext.close();
                return;
            }
        } else {
            object2 = channelHandlerContext.channel().remoteAddress();
            if (object2 instanceof InetSocketAddress) {
                string = ((InetSocketAddress)object2).getAddress().getHostAddress();
            }
        }
        object2 = this.conf.getRatelimitIp();
        RateLimitStatus rateLimitStatus = RateLimitStatus.OK;
        if (object2 != null && string != null) {
            rateLimitStatus = ((EaglerRateLimiter)object2).rateLimit(string);
        }
        if (rateLimitStatus == RateLimitStatus.LOCKED_OUT) {
            channelHandlerContext.close();
            return;
        }
        if (httpHeaders.get((CharSequence)HttpHeaderNames.CONNECTION) != null && httpHeaders.get((CharSequence)HttpHeaderNames.CONNECTION).toLowerCase().contains("upgrade") && "websocket".equalsIgnoreCase(httpHeaders.get((CharSequence)HttpHeaderNames.UPGRADE))) {
            WebSocketServerHandshakerFactory webSocketServerHandshakerFactory;
            WebSocketServerHandshaker webSocketServerHandshaker;
            String string2 = httpHeaders.get((CharSequence)HttpHeaderNames.ORIGIN);
            if (string2 != null) {
                channelHandlerContext.channel().attr(EaglerPipeline.ORIGIN).set((Object)string2);
            }
            if (rateLimitStatus == RateLimitStatus.OK) {
                channelHandlerContext.channel().attr(EaglerPipeline.HOST).set((Object)httpHeaders.get((CharSequence)HttpHeaderNames.HOST));
                channelHandlerContext.pipeline().replace((ChannelHandler)this, "HttpWebSocketHandler", (ChannelHandler)new HttpWebSocketHandler(this.conf));
            }
            if ((webSocketServerHandshaker = (webSocketServerHandshakerFactory = new WebSocketServerHandshakerFactory("ws://" + httpHeaders.get((CharSequence)HttpHeaderNames.HOST) + httpRequest.uri(), null, true, 1048575)).newHandshaker(httpRequest)) != null) {
                eaglerConnectionInstance.isWebSocket = true;
                ChannelFuture channelFuture = webSocketServerHandshaker.handshake(channelHandlerContext.channel(), httpRequest);
                if (rateLimitStatus == RateLimitStatus.OK) return;
                final RateLimitStatus rateLimitStatus2 = rateLimitStatus;
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        channelHandlerContext.writeAndFlush((Object)new TextWebSocketFrame(rateLimitStatus2 == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? "LOCKED" : "BLOCKED")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                });
                return;
            }
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channelHandlerContext.channel()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (rateLimitStatus != RateLimitStatus.OK) {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(error429Bytes.length, error429Bytes.length);
            byteBuf.writeBytes(error429Bytes);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TOO_MANY_REQUESTS, byteBuf);
            channelHandlerContext.writeAndFlush((Object)defaultFullHttpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        eaglerConnectionInstance.isRegularHttp = true;
        HttpWebServer httpWebServer = this.conf.getWebServer();
        if (httpWebServer == null) {
            channelHandlerContext.writeAndFlush((Object)HttpWebServer.getWebSocket404().createHTTPResponse(HttpResponseStatus.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        String string3 = httpRequest.uri();
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        if ((n = string3.indexOf(63)) != -1) {
            string3 = string3.substring(0, n);
        }
        if ((httpMemoryCache = httpWebServer.retrieveFile(string3)) != null) {
            channelHandlerContext.writeAndFlush((Object)httpMemoryCache.createHTTPResponse()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        channelHandlerContext.writeAndFlush((Object)HttpWebServer.getWebSocket404().createHTTPResponse(HttpResponseStatus.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (channelHandlerContext.channel().isActive()) {
            EaglerXBungee.logger().log(Level.WARNING, "[Pre][" + channelHandlerContext.channel().remoteAddress() + "]: Exception Caught: " + throwable.toString(), throwable);
            channelHandlerContext.close();
        }
    }

    private static String formatAddressFor404(String string) {
        return "<span style=\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\">" + string.replace("<", "&lt;").replace(">", "&gt;") + "</span>";
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        EaglerPipeline.closeChannel(channelHandlerContext.channel());
    }
}

