/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.md_5.bungee.config.Configuration;

public class EaglerRateLimiter {
    private final int period;
    private final int limit;
    private final int limitLockout;
    private int effectiveLimit;
    private int effectiveLimitLockout;
    private final int lockoutDuration;
    private final List<String> exceptions;
    private final Map<String, RateLimiter> ratelimiters = new HashMap<String, RateLimiter>();

    private EaglerRateLimiter(int n, int n2, int n3, int n4, List<String> list) {
        this.period = n * 1000 / n2;
        this.limit = this.effectiveLimit = n2;
        this.limitLockout = this.effectiveLimitLockout = n3;
        this.lockoutDuration = n4 * 1000;
        this.exceptions = list;
    }

    public void setDivisor(int n) {
        this.effectiveLimit = this.limit * n;
        this.effectiveLimitLockout = this.limitLockout * n;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getLimit() {
        return this.effectiveLimit;
    }

    public int getLimitLockout() {
        return this.effectiveLimitLockout;
    }

    public int getLockoutDuration() {
        return this.lockoutDuration;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public boolean isException(String string) {
        int n = 0;
        int n2 = this.exceptions.size();
        while (n < n2) {
            String string2 = this.exceptions.get(n);
            int n3 = string2.length() - 1;
            if (string2.indexOf(42) == 0 ? string.endsWith(string2.substring(1)) : (string2.lastIndexOf(42) == n3 ? string.startsWith(string2.substring(n3)) : string.equals(string2))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimitStatus rateLimit(String string) {
        RateLimiter rateLimiter;
        if (this.isException(string = string.toLowerCase())) {
            return RateLimitStatus.OK;
        }
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            rateLimiter = this.ratelimiters.get(string);
            if (rateLimiter == null) {
                rateLimiter = new RateLimiter();
                this.ratelimiters.put(string, rateLimiter);
            }
        }
        return rateLimiter.rateLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long l = System.currentTimeMillis();
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            Iterator<RateLimiter> iterator = this.ratelimiters.values().iterator();
            while (iterator.hasNext()) {
                RateLimiter rateLimiter = iterator.next();
                rateLimiter.tick(l);
                if (rateLimiter.requestCounter > 0 || rateLimiter.lockoutTimestamp > 0L) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            this.ratelimiters.clear();
        }
    }

    static EaglerRateLimiter loadConfig(Configuration configuration) {
        int n = configuration.getInt("period", -1);
        int n2 = configuration.getInt("limit", -1);
        int n3 = configuration.getInt("limit_lockout", -1);
        int n4 = configuration.getInt("lockout_duration", -1);
        List list = configuration.getList("exceptions");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            arrayList.add(string.toLowerCase());
        }
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1) {
            return new EaglerRateLimiter(n, n2, n3, n4, arrayList);
        }
        return null;
    }

    protected class RateLimiter {
        protected int requestCounter = 0;
        protected long lockoutTimestamp = 0L;
        protected long cooldownTimestamp = 0L;

        protected RateLimiter() {
        }

        protected RateLimitStatus rateLimit() {
            long l = System.currentTimeMillis();
            this.tick(l);
            if (this.lockoutTimestamp != 0L) {
                return RateLimitStatus.LOCKED_OUT;
            }
            if (++this.requestCounter > EaglerRateLimiter.this.effectiveLimitLockout) {
                this.lockoutTimestamp = l;
                this.requestCounter = 0;
                return RateLimitStatus.LIMITED_NOW_LOCKED_OUT;
            }
            if (this.requestCounter > EaglerRateLimiter.this.effectiveLimit) {
                return RateLimitStatus.LIMITED;
            }
            return RateLimitStatus.OK;
        }

        protected void tick(long l) {
            if (this.lockoutTimestamp != 0L) {
                if (l - this.lockoutTimestamp > (long)EaglerRateLimiter.this.lockoutDuration) {
                    this.requestCounter = 0;
                    this.lockoutTimestamp = 0L;
                    this.cooldownTimestamp = l;
                }
            } else {
                long l2 = l - this.cooldownTimestamp;
                long l3 = l2 / (long)EaglerRateLimiter.this.period;
                if (l3 >= (long)this.requestCounter) {
                    this.requestCounter = 0;
                    this.cooldownTimestamp = l;
                } else {
                    this.requestCounter = (int)((long)this.requestCounter - l3);
                    this.cooldownTimestamp += l3 * (long)EaglerRateLimiter.this.period;
                    if (this.requestCounter < 0) {
                        this.requestCounter = 0;
                    }
                }
            }
        }
    }
}

