/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event;

import java.net.InetAddress;
import java.util.function.Consumer;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.md_5.bungee.api.plugin.Event;

public class EaglercraftIsAuthRequiredEvent
extends Event {
    private final EaglerListenerConfig listener;
    private AuthResponse authResponse;
    private final InetAddress authRemoteAddress;
    private final String authOrigin;
    private final boolean wantsAuth;
    private final byte[] authUsername;
    private byte[] authSaltingData;
    private AuthMethod eventAuthMethod = null;
    private String eventAuthMessage = "enter the code:";
    private String kickUserMessage = "Login Denied";
    private Object authAttachment;
    private Consumer<EaglercraftIsAuthRequiredEvent> continueThread;
    private Runnable continueRunnable;
    private volatile boolean hasContinue = false;

    public EaglercraftIsAuthRequiredEvent(EaglerListenerConfig eaglerListenerConfig, InetAddress inetAddress, String string, boolean bl, byte[] byArray, Consumer<EaglercraftIsAuthRequiredEvent> consumer) {
        this.listener = eaglerListenerConfig;
        this.authRemoteAddress = inetAddress;
        this.authOrigin = string;
        this.wantsAuth = bl;
        this.authUsername = byArray;
        this.continueThread = consumer;
    }

    public EaglerListenerConfig getListener() {
        return this.listener;
    }

    public InetAddress getRemoteAddress() {
        return this.authRemoteAddress;
    }

    public String getOriginHeader() {
        return this.authOrigin;
    }

    public boolean isClientSolicitingPasscode() {
        return this.wantsAuth;
    }

    public byte[] getAuthUsername() {
        return this.authUsername;
    }

    public byte[] getSaltingData() {
        return this.authSaltingData;
    }

    public void setSaltingData(byte[] byArray) {
        this.authSaltingData = byArray;
    }

    public AuthMethod getUseAuthType() {
        return this.eventAuthMethod;
    }

    public void setUseAuthMethod(AuthMethod authMethod) {
        this.eventAuthMethod = authMethod;
    }

    public AuthResponse getAuthRequired() {
        return this.authResponse;
    }

    public void setAuthRequired(AuthResponse authResponse) {
        this.authResponse = authResponse;
    }

    public String getAuthMessage() {
        return this.eventAuthMessage;
    }

    public void setAuthMessage(String string) {
        this.eventAuthMessage = string;
    }

    public <T> T getAuthAttachment() {
        return (T)this.authAttachment;
    }

    public void setAuthAttachment(Object object) {
        this.authAttachment = object;
    }

    public boolean shouldKickUser() {
        return this.authResponse == null || this.authResponse == AuthResponse.DENY;
    }

    public String getKickMessage() {
        return this.kickUserMessage;
    }

    public void kickUser(String string) {
        this.authResponse = AuthResponse.DENY;
        this.kickUserMessage = string;
    }

    public Runnable makeAsyncContinue() {
        if (this.continueRunnable == null) {
            this.continueRunnable = new Runnable(){

                @Override
                public void run() {
                    if (EaglercraftIsAuthRequiredEvent.this.hasContinue) {
                        throw new IllegalStateException("Thread was already continued from a different function! Auth plugin conflict?");
                    }
                    EaglercraftIsAuthRequiredEvent.this.hasContinue = true;
                    EaglercraftIsAuthRequiredEvent.this.continueThread.accept(EaglercraftIsAuthRequiredEvent.this);
                }
            };
        }
        return this.continueRunnable;
    }

    public boolean isAsyncContinue() {
        return this.continueRunnable != null;
    }

    public void doDirectContinue() {
        this.continueThread.accept(this);
    }

    public static enum AuthMethod {
        PLAINTEXT,
        EAGLER_SHA256,
        AUTHME_SHA256;

    }

    public static enum AuthResponse {
        SKIP,
        REQUIRE,
        DENY;

    }
}

