/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite.EaglerDrivers;

public class JDBCCacheProvider
implements ICacheProvider {
    protected final Connection connection;
    protected final String uri;
    protected final PreparedStatement discardExpiredObjects;
    protected final PreparedStatement discardExpiredProfiles;
    protected final PreparedStatement getTotalObjects;
    protected final PreparedStatement getTotalProfiles;
    protected final PreparedStatement deleteSomeOldestObjects;
    protected final PreparedStatement deleteSomeOldestProfiles;
    protected final PreparedStatement querySkinByUUID;
    protected final PreparedStatement queryProfileByUUID;
    protected final PreparedStatement queryProfileByUsername;
    protected final PreparedStatement cacheNewSkin;
    protected final PreparedStatement cacheNewProfile;
    protected final PreparedStatement cacheHasSkin;
    protected final PreparedStatement cacheHasProfile;
    protected final PreparedStatement cacheUpdateSkin;
    protected final PreparedStatement cacheUpdateProfile;
    protected long lastFlush;
    protected int keepObjectsDays;
    protected int keepProfilesDays;
    protected int maxObjects;
    protected int maxProfiles;

    public static JDBCCacheProvider initialize(String string, String string2, String string3, int n, int n2, int n3, int n4) throws ICacheProvider.CacheException {
        Connection connection;
        try {
            connection = EaglerDrivers.connectToDatabase(string, string2, string3, new Properties());
            if (connection == null) {
                throw new IllegalStateException("Connection is null");
            }
        }
        catch (Throwable throwable) {
            throw new ICacheProvider.CacheException("Could not initialize '" + string + "'!", throwable);
        }
        EaglerXBungee.logger().info("Connected to database: " + string);
        try {
            Object object = null;
            Object var9_13 = null;
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_skins_objects\" (\"TextureUUID\" TEXT(32) NOT NULL,\"TextureURL\" VARCHAR(256) NOT NULL,\"TextureTime\" DATETIME NOT NULL,\"TextureData\" BLOB,\"TextureLength\" INT(24) NOT NULL,PRIMARY KEY(\"TextureUUID\"))");
                statement.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_skins_profiles\" (\"ProfileUUID\" TEXT(32) NOT NULL,\"ProfileName\" TEXT(16) NOT NULL,\"ProfileTime\" DATETIME NOT NULL,\"ProfileTexture\" VARCHAR(256),\"ProfileModel\" VARCHAR(16) NOT NULL,PRIMARY KEY(\"ProfileUUID\"))");
                statement.execute("CREATE INDEX IF NOT EXISTS \"profile_name_index\" ON \"eaglercraft_skins_profiles\" (\"ProfileName\")");
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            object = new JDBCCacheProvider(connection, string, n, n2, n3, n4);
            ((JDBCCacheProvider)object).flush();
            return object;
        }
        catch (ICacheProvider.CacheException cacheException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            throw cacheException;
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            throw new ICacheProvider.CacheException("Could not initialize '" + string + "'!", throwable);
        }
    }

    protected JDBCCacheProvider(Connection connection, String string, int n, int n2, int n3, int n4) throws SQLException {
        this.connection = connection;
        this.uri = string;
        this.lastFlush = 0L;
        this.keepObjectsDays = n;
        this.keepProfilesDays = n2;
        this.maxObjects = n3;
        this.maxProfiles = n4;
        this.discardExpiredObjects = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_objects WHERE textureTime < ?");
        this.discardExpiredProfiles = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_profiles WHERE profileTime < ?");
        this.getTotalObjects = this.connection.prepareStatement("SELECT COUNT(*) AS total_objects FROM eaglercraft_skins_objects");
        this.getTotalProfiles = this.connection.prepareStatement("SELECT COUNT(*) AS total_profiles FROM eaglercraft_skins_profiles");
        this.deleteSomeOldestObjects = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_objects WHERE TextureUUID IN (SELECT TextureUUID FROM eaglercraft_skins_objects ORDER BY TextureTime ASC LIMIT ?)");
        this.deleteSomeOldestProfiles = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_profiles WHERE ProfileUUID IN (SELECT ProfileUUID FROM eaglercraft_skins_profiles ORDER BY ProfileTime ASC LIMIT ?)");
        this.querySkinByUUID = this.connection.prepareStatement("SELECT TextureURL,TextureData,TextureLength FROM eaglercraft_skins_objects WHERE TextureUUID = ? LIMIT 1");
        this.queryProfileByUUID = this.connection.prepareStatement("SELECT ProfileName,ProfileTexture,ProfileModel FROM eaglercraft_skins_profiles WHERE ProfileUUID = ? LIMIT 1");
        this.queryProfileByUsername = this.connection.prepareStatement("SELECT ProfileUUID,ProfileTexture,ProfileModel FROM eaglercraft_skins_profiles WHERE ProfileName = ? LIMIT 1");
        this.cacheNewSkin = this.connection.prepareStatement("INSERT INTO eaglercraft_skins_objects (TextureUUID, TextureURL, TextureTime, TextureData, TextureLength) VALUES(?, ?, ?, ?, ?)");
        this.cacheNewProfile = this.connection.prepareStatement("INSERT INTO eaglercraft_skins_profiles (ProfileUUID, ProfileName, ProfileTime, ProfileTexture, ProfileModel) VALUES(?, ?, ?, ?, ?)");
        this.cacheHasSkin = this.connection.prepareStatement("SELECT COUNT(TextureUUID) AS has_object FROM eaglercraft_skins_objects WHERE TextureUUID = ? LIMIT 1");
        this.cacheHasProfile = this.connection.prepareStatement("SELECT COUNT(ProfileUUID) AS has_profile FROM eaglercraft_skins_profiles WHERE ProfileUUID = ? LIMIT 1");
        this.cacheUpdateSkin = this.connection.prepareStatement("UPDATE eaglercraft_skins_objects SET TextureURL = ?, TextureTime = ?, TextureData = ?, TextureLength = ? WHERE TextureUUID = ?");
        this.cacheUpdateProfile = this.connection.prepareStatement("UPDATE eaglercraft_skins_profiles SET ProfileName = ?, ProfileTime = ?, ProfileTexture = ?, ProfileModel = ? WHERE ProfileUUID = ?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICacheProvider.CacheLoadedSkin loadSkinByUUID(UUID uUID) throws ICacheProvider.CacheException {
        int n;
        byte[] byArray;
        String string;
        Object object;
        Object object2;
        String string2 = SkinService.getMojangUUID(uUID);
        try {
            object2 = this.querySkinByUUID;
            synchronized (object2) {
                this.querySkinByUUID.setString(1, string2);
                object = null;
                Object var8_7 = null;
                try (ResultSet resultSet = this.querySkinByUUID.executeQuery();){
                    if (!resultSet.next()) return null;
                    string = resultSet.getString(1);
                    byArray = resultSet.getBytes(2);
                    n = resultSet.getInt(3);
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                        throw object;
                    }
                    if (object == throwable) throw object;
                    ((Throwable)object).addSuppressed(throwable);
                    throw object;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ICacheProvider.CacheException("SQL query failure while loading cached skin", sQLException);
        }
        if (n == 0) {
            return new ICacheProvider.CacheLoadedSkin(uUID, string, new byte[0]);
        }
        object2 = new byte[n];
        try {
            object = new GZIPInputStream(new ByteArrayInputStream(byArray));
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 = ((GZIPInputStream)object).read((byte[])object2, n3, n - n3);
                if (n2 == -1) {
                    return new ICacheProvider.CacheLoadedSkin(uUID, string, (byte[])object2);
                }
                n3 += n2;
            }
            return new ICacheProvider.CacheLoadedSkin(uUID, string, (byte[])object2);
        }
        catch (IOException iOException) {
            throw new ICacheProvider.CacheException("SQL query failure while loading cached skin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheSkinByUUID(UUID uUID, String string, byte[] byArray) throws ICacheProvider.CacheException {
        byte[] byArray2;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ICacheProvider.CacheException("Skin compression error", iOException);
        }
        if (byArray == null || byArray.length == 0) {
            n = 0;
            byArray2 = null;
        } else {
            n = byArray.length;
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        try {
            String string2 = SkinService.getMojangUUID(uUID);
            PreparedStatement preparedStatement = this.cacheNewSkin;
            synchronized (preparedStatement) {
                boolean bl;
                this.cacheHasSkin.setString(1, string2);
                Throwable throwable = null;
                Object var11_14 = null;
                try (ResultSet resultSet = this.cacheHasSkin.executeQuery();){
                    bl = resultSet.next() ? resultSet.getInt(1) > 0 : false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (bl) {
                    this.cacheUpdateSkin.setString(1, string);
                    this.cacheUpdateSkin.setDate(2, new Date(System.currentTimeMillis()));
                    this.cacheUpdateSkin.setBytes(3, byArray2);
                    this.cacheUpdateSkin.setInt(4, n);
                    this.cacheUpdateSkin.setString(5, string2);
                    this.cacheUpdateSkin.executeUpdate();
                } else {
                    this.cacheNewSkin.setString(1, string2);
                    this.cacheNewSkin.setString(2, string);
                    this.cacheNewSkin.setDate(3, new Date(System.currentTimeMillis()));
                    this.cacheNewSkin.setBytes(4, byArray2);
                    this.cacheNewSkin.setInt(5, n);
                    this.cacheNewSkin.executeUpdate();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ICacheProvider.CacheException("SQL query failure while caching new skin", sQLException);
        }
    }

    @Override
    public ICacheProvider.CacheLoadedProfile loadProfileByUUID(UUID uUID) throws ICacheProvider.CacheException {
        String string = SkinService.getMojangUUID(uUID);
        PreparedStatement preparedStatement = this.queryProfileByUUID;
        synchronized (preparedStatement) {
            ResultSet resultSet;
            block17: {
                ICacheProvider.CacheLoadedProfile cacheLoadedProfile;
                block18: {
                    this.queryProfileByUUID.setString(1, string);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    resultSet = this.queryProfileByUUID.executeQuery();
                    try {
                        if (!resultSet.next()) break block17;
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        String string4 = resultSet.getString(3);
                        cacheLoadedProfile = new ICacheProvider.CacheLoadedProfile(uUID, string2, string3, string4);
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new ICacheProvider.CacheException("SQL query failure while loading profile by uuid", sQLException);
                        }
                    }
                    resultSet.close();
                }
                return cacheLoadedProfile;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            return null;
        }
    }

    @Override
    public ICacheProvider.CacheLoadedProfile loadProfileByUsername(String string) throws ICacheProvider.CacheException {
        PreparedStatement preparedStatement = this.queryProfileByUsername;
        synchronized (preparedStatement) {
            ResultSet resultSet;
            block17: {
                ICacheProvider.CacheLoadedProfile cacheLoadedProfile;
                block18: {
                    this.queryProfileByUsername.setString(1, string);
                    Throwable throwable = null;
                    Object var4_6 = null;
                    resultSet = this.queryProfileByUsername.executeQuery();
                    try {
                        if (!resultSet.next()) break block17;
                        UUID uUID = SkinService.parseMojangUUID(resultSet.getString(1));
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        cacheLoadedProfile = new ICacheProvider.CacheLoadedProfile(uUID, string, string2, string3);
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (SQLException sQLException) {
                            throw new ICacheProvider.CacheException("SQL query failure while loading profile by username", sQLException);
                        }
                    }
                    resultSet.close();
                }
                return cacheLoadedProfile;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheProfileByUUID(UUID uUID, String string, String string2, String string3) throws ICacheProvider.CacheException {
        try {
            String string4 = SkinService.getMojangUUID(uUID);
            PreparedStatement preparedStatement = this.cacheNewProfile;
            synchronized (preparedStatement) {
                boolean bl;
                this.cacheHasProfile.setString(1, string4);
                Throwable throwable = null;
                Object var9_10 = null;
                try (ResultSet resultSet = this.cacheHasProfile.executeQuery();){
                    bl = resultSet.next() ? resultSet.getInt(1) > 0 : false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (bl) {
                    this.cacheUpdateProfile.setString(1, string);
                    this.cacheUpdateProfile.setDate(2, new Date(System.currentTimeMillis()));
                    this.cacheUpdateProfile.setString(3, string2);
                    this.cacheUpdateProfile.setString(4, string3);
                    this.cacheUpdateProfile.setString(5, string4);
                    this.cacheUpdateProfile.executeUpdate();
                } else {
                    this.cacheNewProfile.setString(1, string4);
                    this.cacheNewProfile.setString(2, string);
                    this.cacheNewProfile.setDate(3, new Date(System.currentTimeMillis()));
                    this.cacheNewProfile.setString(4, string2);
                    this.cacheNewProfile.setString(5, string3);
                    this.cacheNewProfile.executeUpdate();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ICacheProvider.CacheException("SQL query failure while caching new profile", sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        block44: {
            long l = System.currentTimeMillis();
            if (l - this.lastFlush > 1200000L) {
                this.lastFlush = l;
                try {
                    int n;
                    int n2;
                    ResultSet resultSet;
                    Object var9_13;
                    Object object;
                    Date date = new Date(l - (long)this.keepObjectsDays * 86400000L);
                    Date date2 = new Date(l - (long)this.keepProfilesDays * 86400000L);
                    PreparedStatement preparedStatement = this.discardExpiredObjects;
                    synchronized (preparedStatement) {
                        this.discardExpiredObjects.setDate(1, date);
                        this.discardExpiredObjects.execute();
                    }
                    preparedStatement = this.discardExpiredProfiles;
                    synchronized (preparedStatement) {
                        this.discardExpiredProfiles.setDate(1, date2);
                        this.discardExpiredProfiles.execute();
                    }
                    PreparedStatement preparedStatement2 = this.getTotalObjects;
                    synchronized (preparedStatement2) {
                        block42: {
                            object = null;
                            var9_13 = null;
                            try {
                                resultSet = this.getTotalObjects.executeQuery();
                                try {
                                    if (resultSet.next()) {
                                        n2 = resultSet.getInt(1);
                                        break block42;
                                    }
                                    throw new SQLException("Empty ResultSet recieved when checking \"eaglercraft_skins_objects\" row count");
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                    }
                    preparedStatement2 = this.getTotalProfiles;
                    synchronized (preparedStatement2) {
                        block43: {
                            object = null;
                            var9_13 = null;
                            try {
                                resultSet = this.getTotalProfiles.executeQuery();
                                try {
                                    if (resultSet.next()) {
                                        n = resultSet.getInt(1);
                                        break block43;
                                    }
                                    throw new SQLException("Empty ResultSet recieved when checking \"eaglercraft_skins_profiles\" row count");
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                    }
                    if (n2 > this.maxObjects) {
                        int n3 = n2 - this.maxObjects + (this.maxObjects >> 3);
                        EaglerXBungee.logger().warning("Skin object cache has passed " + this.maxObjects + " skins in size (" + n2 + "), deleting " + n3 + " skins from the cache to free space");
                        object = this.deleteSomeOldestObjects;
                        synchronized (object) {
                            this.deleteSomeOldestObjects.setInt(1, n3);
                            this.deleteSomeOldestObjects.executeUpdate();
                        }
                    }
                    if (n <= this.maxProfiles) break block44;
                    int n4 = n - this.maxProfiles + (this.maxProfiles >> 3);
                    EaglerXBungee.logger().warning("Skin profile cache has passed " + this.maxProfiles + " profiles in size (" + n + "), deleting " + n4 + " profiles from the cache to free space");
                    object = this.deleteSomeOldestProfiles;
                    synchronized (object) {
                        this.deleteSomeOldestProfiles.setInt(1, n4);
                        this.deleteSomeOldestProfiles.executeUpdate();
                    }
                }
                catch (SQLException sQLException) {
                    throw new ICacheProvider.CacheException("SQL query failure while flushing cache!", sQLException);
                }
            }
        }
    }

    private void destroyStatement(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException sQLException) {}
    }

    @Override
    public void destroy() {
        this.destroyStatement(this.discardExpiredObjects);
        this.destroyStatement(this.discardExpiredProfiles);
        this.destroyStatement(this.getTotalObjects);
        this.destroyStatement(this.getTotalProfiles);
        this.destroyStatement(this.deleteSomeOldestObjects);
        this.destroyStatement(this.deleteSomeOldestProfiles);
        this.destroyStatement(this.querySkinByUUID);
        this.destroyStatement(this.queryProfileByUUID);
        this.destroyStatement(this.queryProfileByUsername);
        this.destroyStatement(this.cacheNewSkin);
        this.destroyStatement(this.cacheNewProfile);
        this.destroyStatement(this.cacheHasSkin);
        this.destroyStatement(this.cacheHasProfile);
        this.destroyStatement(this.cacheUpdateSkin);
        this.destroyStatement(this.cacheUpdateProfile);
        try {
            this.connection.close();
            EaglerXBungee.logger().info("Successfully disconnected from database '" + this.uri + "'");
        }
        catch (SQLException sQLException) {
            EaglerXBungee.logger().log(Level.WARNING, "Exception disconnecting from database '" + this.uri + "'!", sQLException);
        }
    }
}

