/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;

public interface ICacheProvider {
    public CacheLoadedSkin loadSkinByUUID(UUID var1) throws CacheException;

    public void cacheSkinByUUID(UUID var1, String var2, byte[] var3) throws CacheException;

    public CacheLoadedProfile loadProfileByUUID(UUID var1) throws CacheException;

    public CacheLoadedProfile loadProfileByUsername(String var1) throws CacheException;

    public void cacheProfileByUUID(UUID var1, String var2, String var3, String var4) throws CacheException;

    public void flush() throws CacheException;

    public void destroy();

    public static class CacheException
    extends RuntimeException {
        public CacheException() {
        }

        public CacheException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public CacheException(String string) {
            super(string);
        }

        public CacheException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class CacheLoadedProfile {
        public final UUID uuid;
        public final String username;
        public final String texture;
        public final String model;

        public CacheLoadedProfile(UUID uUID, String string, String string2, String string3) {
            this.uuid = uUID;
            this.username = string;
            this.texture = string2;
            this.model = string3;
        }

        public UUID getSkinUUID() {
            return SkinPackets.createEaglerURLSkinUUID(this.texture);
        }
    }

    public static class CacheLoadedSkin {
        public final UUID uuid;
        public final String url;
        public final byte[] texture;

        public CacheLoadedSkin(UUID uUID, String string, byte[] byArray) {
            this.uuid = uUID;
            this.url = string;
            this.texture = byArray;
        }
    }
}

