/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.md_5.bungee.netty.PipelineUtils;

public class BinaryHttpClient {
    private static final Cache<String, InetAddress> addressCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static EventLoopGroup eventLoop = null;

    public static void asyncRequest(String string, URI uRI, Consumer<Response> consumer) {
        String string2;
        InetAddress inetAddress;
        String string3;
        EventLoopGroup eventLoopGroup = BinaryHttpClient.getEventLoopGroup();
        int n = uRI.getPort();
        boolean bl = false;
        switch (string3 = uRI.getScheme()) {
            case "http": {
                if (n != -1) break;
                n = 80;
                break;
            }
            case "https": {
                if (n == -1) {
                    n = 443;
                }
                bl = true;
                break;
            }
            default: {
                consumer.accept(new Response(new UnsupportedOperationException("Unsupported scheme: " + string3)));
                return;
            }
        }
        if ((inetAddress = (InetAddress)addressCache.getIfPresent((Object)(string2 = uRI.getHost()))) == null) {
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                consumer.accept(new Response(unknownHostException));
                return;
            }
            addressCache.put((Object)string2, (Object)inetAddress);
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel(null))).group(eventLoopGroup)).handler((ChannelHandler)new NettyHttpChannelInitializer(consumer, bl, string2, n))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(inetAddress, n).connect().addListener((GenericFutureListener)new NettyHttpChannelFutureListener(string, uRI, consumer));
    }

    private static EventLoopGroup getEventLoopGroup() {
        if (eventLoop == null) {
            eventLoop = PipelineUtils.newEventLoopGroup((int)0, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("Skin Download Thread #%1$d").build());
        }
        return eventLoop;
    }

    public static void killEventLoop() {
        if (eventLoop != null) {
            EaglerXBungee.logger().info("Stopping skin cache HTTP client...");
            eventLoop.shutdownGracefully();
            try {
                eventLoop.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
            eventLoop = null;
        }
    }

    private static class NettyHttpChannelFutureListener
    implements ChannelFutureListener {
        protected final String method;
        protected final URI requestURI;
        protected final Consumer<Response> responseCallback;

        protected NettyHttpChannelFutureListener(String string, URI uRI, Consumer<Response> consumer) {
            this.method = string;
            this.requestURI = uRI;
            this.responseCallback = consumer;
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (channelFuture.isSuccess()) {
                String string = String.valueOf(this.requestURI.getRawPath()) + (this.requestURI.getRawQuery() == null ? "" : "?" + this.requestURI.getRawQuery());
                DefaultHttpRequest defaultHttpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.method), string);
                defaultHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.requestURI.getHost());
                defaultHttpRequest.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)("Mozilla/5.0 EaglerXBungee/" + EaglerXBungee.getEagler().getDescription().getVersion()));
                channelFuture.channel().writeAndFlush((Object)defaultHttpRequest);
            } else {
                addressCache.invalidate((Object)this.requestURI.getHost());
                this.responseCallback.accept(new Response(new IOException("Connection failed")));
            }
        }
    }

    private static class NettyHttpChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final Consumer<Response> responseCallback;
        protected final boolean ssl;
        protected final String host;
        protected final int port;

        protected NettyHttpChannelInitializer(Consumer<Response> consumer, boolean bl, String string, int n) {
            this.responseCallback = consumer;
            this.ssl = bl;
            this.host = string;
            this.port = n;
        }

        protected void initChannel(Channel channel) throws Exception {
            channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(5L, TimeUnit.SECONDS));
            if (this.ssl) {
                SSLEngine sSLEngine = SslContextBuilder.forClient().build().newEngine(channel.alloc(), this.host, this.port);
                channel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sSLEngine));
            }
            channel.pipeline().addLast("http", (ChannelHandler)new HttpClientCodec());
            channel.pipeline().addLast("handler", (ChannelHandler)new NettyHttpResponseHandler(this.responseCallback));
        }
    }

    private static class NettyHttpResponseHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        protected final Consumer<Response> responseCallback;
        protected int responseCode = -1;
        protected ByteBuf buffer = null;

        protected NettyHttpResponseHandler(Consumer<Response> consumer) {
            this.responseCallback = consumer;
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) throws Exception {
            HttpResponse httpResponse;
            if (httpObject instanceof HttpResponse) {
                httpResponse = (HttpResponse)httpObject;
                this.responseCode = httpResponse.status().code();
                if (this.responseCode == HttpResponseStatus.NO_CONTENT.code()) {
                    this.done(channelHandlerContext);
                    return;
                }
            }
            if (httpObject instanceof HttpContent) {
                httpResponse = (HttpContent)httpObject;
                if (this.buffer == null) {
                    this.buffer = channelHandlerContext.alloc().buffer();
                }
                this.buffer.writeBytes(httpResponse.content());
                if (httpObject instanceof LastHttpContent) {
                    this.done(channelHandlerContext);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            this.responseCallback.accept(new Response(throwable));
        }

        private void done(ChannelHandlerContext channelHandlerContext) {
            try {
                byte[] byArray;
                if (this.buffer != null) {
                    byArray = new byte[this.buffer.readableBytes()];
                    this.buffer.readBytes(byArray);
                    this.buffer.release();
                } else {
                    byArray = new byte[]{};
                }
                this.responseCallback.accept(new Response(this.responseCode, byArray));
            }
            finally {
                channelHandlerContext.channel().pipeline().remove((ChannelHandler)this);
                channelHandlerContext.channel().close();
            }
        }
    }

    public static class Response {
        public final int code;
        public final byte[] data;
        public final Throwable exception;

        public Response(int n, byte[] byArray) {
            this.code = n;
            this.data = byArray;
            this.exception = null;
        }

        public Response(Throwable throwable) {
            this.code = -1;
            this.data = null;
            this.exception = throwable;
        }
    }
}

