/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpMemoryCache;

public class HttpWebServer {
    public final File directory;
    public final Map<String, HttpContentType> contentTypes;
    private final Map<String, HttpMemoryCache> filesCache;
    private final List<String> index;
    private final String page404;
    private static HttpMemoryCache default404Page;
    private static HttpMemoryCache default404UpgradePage;
    private static final Object cacheClearLock;

    static {
        cacheClearLock = new Object();
    }

    public HttpWebServer(File file, Map<String, HttpContentType> map, List<String> list, String string) {
        this.directory = file;
        this.contentTypes = map;
        this.filesCache = new HashMap<String, HttpMemoryCache>();
        this.index = list;
        this.page404 = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        long l = System.currentTimeMillis();
        Object object = cacheClearLock;
        synchronized (object) {
            Map<String, HttpMemoryCache> map = this.filesCache;
            synchronized (map) {
                Iterator<HttpMemoryCache> iterator = this.filesCache.values().iterator();
                while (iterator.hasNext()) {
                    HttpMemoryCache httpMemoryCache = iterator.next();
                    if (httpMemoryCache.contentType.fileBrowserCacheTTL == Long.MAX_VALUE || l - httpMemoryCache.lastCacheHit <= 900000L) continue;
                    httpMemoryCache.fileData.release();
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     */
    public HttpMemoryCache retrieveFile(String string) {
        ArrayList<String> arrayList;
        block45: {
            String[] stringArray = string.split("(\\\\|\\/)+");
            arrayList = stringArray.length == 0 ? null : new ArrayList<String>();
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = stringArray[n].trim();
                if (stringArray[n].length() > 0 && !stringArray[n].equals(".") && !stringArray[n].startsWith("..")) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
            if (arrayList != null && arrayList.size() != 0) break block45;
            int n2 = 0;
            int n3 = this.index.size();
            while (n2 < n3) {
                HttpMemoryCache httpMemoryCache = this.retrieveFile(this.index.get(n2));
                if (httpMemoryCache != null) {
                    return httpMemoryCache;
                }
                ++n2;
            }
            return null;
        }
        try {
            String string2 = String.join((CharSequence)"/", arrayList);
            Object object = cacheClearLock;
            synchronized (object) {
                HttpMemoryCache httpMemoryCache;
                Map<String, HttpMemoryCache> map = this.filesCache;
                synchronized (map) {
                    httpMemoryCache = this.filesCache.get(string2);
                }
                if (httpMemoryCache != null) {
                    if ((httpMemoryCache = this.validateCache(httpMemoryCache)) != null) {
                        return httpMemoryCache;
                    }
                    map = this.filesCache;
                    synchronized (map) {
                        this.filesCache.remove(string2);
                    }
                }
                if (!((File)((Object)(map = new File(this.directory, string2)))).exists()) {
                    if (this.page404 == null || string.equals(this.page404)) {
                        return default404Page;
                    }
                    return this.retrieveFile(this.page404);
                }
                if (((File)((Object)map)).isDirectory()) {
                    Object object2;
                    String string3;
                    int n = 0;
                    int n4 = this.index.size();
                    while (n < n4) {
                        string3 = String.valueOf(string2) + "/" + this.index.get(n);
                        object2 = this.filesCache;
                        synchronized (object2) {
                            httpMemoryCache = this.filesCache.get(string3);
                        }
                        if (httpMemoryCache != null) {
                            if ((httpMemoryCache = this.validateCache(httpMemoryCache)) != null) {
                                object2 = this.filesCache;
                                synchronized (object2) {
                                    this.filesCache.put(string2, httpMemoryCache);
                                }
                            }
                            object2 = this.filesCache;
                            synchronized (object2) {
                                this.filesCache.remove(string3);
                            }
                            if (this.page404 == null || string.equals(this.page404)) {
                                return default404Page;
                            }
                            return this.retrieveFile(this.page404);
                            return httpMemoryCache;
                        }
                        ++n;
                    }
                    n = 0;
                    n4 = this.index.size();
                    while (n < n4) {
                        HttpMemoryCache httpMemoryCache2;
                        string3 = String.valueOf(string2) + "/" + this.index.get(n);
                        object2 = new File(this.directory, string3);
                        if (((File)object2).isFile() && (httpMemoryCache2 = this.retrieveFile((File)object2, string3)) != null) {
                            Map<String, HttpMemoryCache> map2 = this.filesCache;
                            synchronized (map2) {
                                this.filesCache.put(string2, httpMemoryCache2);
                            }
                            return httpMemoryCache2;
                        }
                        ++n;
                    }
                    if (this.page404 == null || string.equals(this.page404)) {
                        return default404Page;
                    }
                    return this.retrieveFile(this.page404);
                }
                HttpMemoryCache httpMemoryCache3 = this.retrieveFile((File)((Object)map), string2);
                if (httpMemoryCache3 != null) {
                    Map<String, HttpMemoryCache> map3 = this.filesCache;
                    synchronized (map3) {
                        this.filesCache.put(string2, httpMemoryCache3);
                    }
                    return httpMemoryCache3;
                }
                if (this.page404 == null || string.equals(this.page404)) {
                    return default404Page;
                }
                return this.retrieveFile(this.page404);
            }
        }
        catch (Throwable throwable) {
            return default404Page;
        }
    }

    private HttpMemoryCache retrieveFile(File file, String string) {
        int n = (int)file.length();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ByteBuf byteBuf = Unpooled.buffer((int)n, (int)n);
                byteBuf.writeBytes((InputStream)fileInputStream, n);
                String string2 = file.getName();
                HttpContentType httpContentType = null;
                int n2 = string2.lastIndexOf(46);
                if (n2 != -1) {
                    httpContentType = this.contentTypes.get(string2.substring(n2 + 1));
                }
                if (httpContentType == null) {
                    httpContentType = HttpContentType.defaultType;
                }
                long l = System.currentTimeMillis();
                return new HttpMemoryCache(file, string, byteBuf, httpContentType, l, l, file.lastModified());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private HttpMemoryCache validateCache(HttpMemoryCache httpMemoryCache) {
        long l;
        if (httpMemoryCache.fileObject == null) {
            return httpMemoryCache;
        }
        httpMemoryCache.lastCacheHit = l = System.currentTimeMillis();
        if (l - httpMemoryCache.lastDiskReload > 4000L) {
            File file = httpMemoryCache.fileObject;
            if (!file.isFile()) {
                return null;
            }
            long l2 = file.lastModified();
            if (l2 != httpMemoryCache.lastDiskModified) {
                int n = (int)file.length();
                try {
                    Throwable throwable = null;
                    Object var9_8 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        httpMemoryCache.fileData = Unpooled.buffer((int)n, (int)n);
                        httpMemoryCache.fileData.writeBytes((InputStream)fileInputStream, n);
                        httpMemoryCache.lastDiskReload = l;
                        httpMemoryCache.lastDiskModified = l2;
                        return httpMemoryCache;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return httpMemoryCache;
        }
        return httpMemoryCache;
    }

    public static void regenerate404Pages() {
        if (default404Page != null) {
            HttpWebServer.default404Page.fileData.release();
        }
        default404Page = HttpWebServer.regenerateDefault404();
        if (default404UpgradePage != null) {
            HttpWebServer.default404UpgradePage.fileData.release();
        }
        default404UpgradePage = HttpWebServer.regenerateDefaultUpgrade404();
    }

    public static HttpMemoryCache getHTTP404() {
        return default404Page;
    }

    public static HttpMemoryCache getWebSocket404() {
        return default404UpgradePage;
    }

    private static HttpMemoryCache regenerateDefault404() {
        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
        byte[] byArray = ("<!DOCTYPE html><html><head><title>" + HttpWebServer.htmlEntities(eaglerXBungee.getConfig().getServerName()) + "</title><script type=\"text/javascript\">" + "window.addEventListener(\"load\",()=>document.getElementById(\"addr\").innerText=window.location.href);</script></head>" + "<body style=\"font-family:sans-serif;text-align:center;\"><h1>404 Not Found</h1><hr /><p style=\"font-size:1.2em;\">" + "The requested resource <span id=\"addr\" style=\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\">" + "</span> could not be found on this server!</p><p>" + HttpWebServer.htmlEntities(eaglerXBungee.getDescription().getName()) + "/" + HttpWebServer.htmlEntities(eaglerXBungee.getDescription().getVersion()) + "</p></body></html>").getBytes(StandardCharsets.UTF_8);
        HttpContentType httpContentType = new HttpContentType(new HashSet<String>(Arrays.asList("html")), "text/html", "utf-8", 120000L);
        long l = System.currentTimeMillis();
        return new HttpMemoryCache(null, "~404", Unpooled.wrappedBuffer((byte[])byArray), httpContentType, l, l, l);
    }

    private static HttpMemoryCache regenerateDefaultUpgrade404() {
        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
        String string = HttpWebServer.htmlEntities(eaglerXBungee.getConfig().getServerName());
        byte[] byArray = ("<!DOCTYPE html><html><head><meta charset=\"UTF-8\" /><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" /><title>" + string + "</title><script type=\"text/javascript\">window.addEventListener(\"load\",()=>{var src=window.location.href;const gEI=(i)=>document.getElementById(i);" + "if(src.startsWith(\"http:\")){src=\"ws:\"+src.substring(5);}else if(src.startsWith(\"https:\")){src=\"wss:\"+src.substring(6);}else{return;}" + "gEI(\"wsUri\").innerHTML=\"<span id=\\\"wsField\\\" style=\\\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\\\">" + "</span>\";gEI(\"wsField\").innerText=src;});</script></head><body style=\"font-family:sans-serif;margin:0px;padding:12px;\"><h1 style=\"margin-block-start:0px;\">" + "404 'Websocket Upgrade Failure' (rip)</h1><h3>The URL you have requested is the physical WebSocket address of '" + string + "'</h3><p style=\"font-size:1.2em;" + "line-height:1.3em;\">To correctly join this server, load the latest EaglercraftX 1.8 client, click the 'Direct Connect' button<br />on the 'Multiplayer' screen, " + "and enter <span id=\"wsUri\">this URL</span> as the server address</p></body></html>").getBytes(StandardCharsets.UTF_8);
        HttpContentType httpContentType = new HttpContentType(new HashSet<String>(Arrays.asList("html")), "text/html", "utf-8", 14400000L);
        long l = System.currentTimeMillis();
        return new HttpMemoryCache(null, "~404", Unpooled.wrappedBuffer((byte[])byArray), httpContentType, l, l, l);
    }

    public static String htmlEntities(String string) {
        return string.replace("<", "&lt;").replace(">", "&gt;");
    }
}

