/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;

public class HttpMemoryCache {
    public File fileObject;
    public String filePath;
    public ByteBuf fileData;
    public HttpContentType contentType;
    public long lastCacheHit;
    public long lastDiskReload;
    public long lastDiskModified;
    private final String server;
    private static final SimpleDateFormat gmt = new SimpleDateFormat();

    static {
        gmt.setTimeZone(new SimpleTimeZone(0, "GMT"));
        gmt.applyPattern("dd MMM yyyy HH:mm:ss z");
    }

    public HttpMemoryCache(File file, String string, ByteBuf byteBuf, HttpContentType httpContentType, long l, long l2, long l3) {
        this.fileObject = file;
        this.filePath = string;
        this.fileData = byteBuf;
        this.contentType = httpContentType;
        this.lastCacheHit = l;
        this.lastDiskReload = l2;
        this.lastDiskModified = l3;
        this.server = "EaglerXBungee/" + EaglerXBungee.getEagler().getDescription().getVersion();
    }

    public DefaultFullHttpResponse createHTTPResponse() {
        return this.createHTTPResponse(HttpResponseStatus.OK);
    }

    public DefaultFullHttpResponse createHTTPResponse(HttpResponseStatus httpResponseStatus) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, Unpooled.copiedBuffer((ByteBuf)this.fileData));
        HttpHeaders httpHeaders = defaultFullHttpResponse.headers();
        Date date = new Date();
        httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType.httpHeader);
        httpHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.fileData.readableBytes());
        httpHeaders.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)this.contentType.cacheControlHeader);
        httpHeaders.add((CharSequence)HttpHeaderNames.DATE, (Object)gmt.format(date));
        long l = this.contentType.fileBrowserCacheTTL;
        if (l > 0L && l != Long.MAX_VALUE) {
            date.setTime(date.getTime() + l);
            httpHeaders.add((CharSequence)HttpHeaderNames.EXPIRES, (Object)gmt.format(date));
        }
        date.setTime(this.lastDiskModified);
        httpHeaders.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)gmt.format(date));
        httpHeaders.add((CharSequence)HttpHeaderNames.SERVER, (Object)this.server);
        return defaultFullHttpResponse;
    }
}

