/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Supplier;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ServerData;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.protocol.packet.TitleTimes;
import net.md_5.bungee.protocol.packet.ViewDistance;

public enum EaglerBungeeProtocol {
    HANDSHAKE(0){
        {
            this.TO_SERVER.registerPacket(Handshake.class, Handshake::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
        }
    }
    ,
    GAME(1){
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0), EaglerBungeeProtocol.map(107, 31), EaglerBungeeProtocol.map(393, 33), EaglerBungeeProtocol.map(477, 32), EaglerBungeeProtocol.map(573, 33), EaglerBungeeProtocol.map(735, 32), EaglerBungeeProtocol.map(751, 31), EaglerBungeeProtocol.map(755, 33), EaglerBungeeProtocol.map(759, 30), EaglerBungeeProtocol.map(760, 32)});
            this.TO_CLIENT.registerPacket(Login.class, Login::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1), EaglerBungeeProtocol.map(107, 35), EaglerBungeeProtocol.map(393, 37), EaglerBungeeProtocol.map(573, 38), EaglerBungeeProtocol.map(735, 37), EaglerBungeeProtocol.map(751, 36), EaglerBungeeProtocol.map(755, 38), EaglerBungeeProtocol.map(759, 35), EaglerBungeeProtocol.map(760, 37)});
            this.TO_CLIENT.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 2), EaglerBungeeProtocol.map(107, 15), EaglerBungeeProtocol.map(393, 14), EaglerBungeeProtocol.map(573, 15), EaglerBungeeProtocol.map(735, 14), EaglerBungeeProtocol.map(755, 15), EaglerBungeeProtocol.map(759, -1)});
            this.TO_CLIENT.registerPacket(Respawn.class, Respawn::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 7), EaglerBungeeProtocol.map(107, 51), EaglerBungeeProtocol.map(335, 52), EaglerBungeeProtocol.map(338, 53), EaglerBungeeProtocol.map(393, 56), EaglerBungeeProtocol.map(477, 58), EaglerBungeeProtocol.map(573, 59), EaglerBungeeProtocol.map(735, 58), EaglerBungeeProtocol.map(751, 57), EaglerBungeeProtocol.map(755, 61), EaglerBungeeProtocol.map(759, 59), EaglerBungeeProtocol.map(760, 62)});
            this.TO_CLIENT.registerPacket(BossBar.class, BossBar::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(107, 12), EaglerBungeeProtocol.map(573, 13), EaglerBungeeProtocol.map(735, 12), EaglerBungeeProtocol.map(755, 13), EaglerBungeeProtocol.map(759, 10)});
            this.TO_CLIENT.registerPacket(PlayerListItem.class, PlayerListItem::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 56), EaglerBungeeProtocol.map(107, 45), EaglerBungeeProtocol.map(338, 46), EaglerBungeeProtocol.map(393, 48), EaglerBungeeProtocol.map(477, 51), EaglerBungeeProtocol.map(573, 52), EaglerBungeeProtocol.map(735, 51), EaglerBungeeProtocol.map(751, 50), EaglerBungeeProtocol.map(755, 54), EaglerBungeeProtocol.map(759, 52), EaglerBungeeProtocol.map(760, 55)});
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, TabCompleteResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 58), EaglerBungeeProtocol.map(107, 14), EaglerBungeeProtocol.map(393, 16), EaglerBungeeProtocol.map(573, 17), EaglerBungeeProtocol.map(735, 16), EaglerBungeeProtocol.map(751, 15), EaglerBungeeProtocol.map(755, 17), EaglerBungeeProtocol.map(759, 14)});
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, ScoreboardObjective::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 59), EaglerBungeeProtocol.map(107, 63), EaglerBungeeProtocol.map(335, 65), EaglerBungeeProtocol.map(338, 66), EaglerBungeeProtocol.map(393, 69), EaglerBungeeProtocol.map(477, 73), EaglerBungeeProtocol.map(573, 74), EaglerBungeeProtocol.map(755, 83), EaglerBungeeProtocol.map(760, 86)});
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, ScoreboardScore::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 60), EaglerBungeeProtocol.map(107, 66), EaglerBungeeProtocol.map(335, 68), EaglerBungeeProtocol.map(338, 69), EaglerBungeeProtocol.map(393, 72), EaglerBungeeProtocol.map(477, 76), EaglerBungeeProtocol.map(573, 77), EaglerBungeeProtocol.map(755, 86), EaglerBungeeProtocol.map(760, 89)});
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, ScoreboardDisplay::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 61), EaglerBungeeProtocol.map(107, 56), EaglerBungeeProtocol.map(335, 58), EaglerBungeeProtocol.map(338, 59), EaglerBungeeProtocol.map(393, 62), EaglerBungeeProtocol.map(477, 66), EaglerBungeeProtocol.map(573, 67), EaglerBungeeProtocol.map(755, 76), EaglerBungeeProtocol.map(760, 79)});
            this.TO_CLIENT.registerPacket(Team.class, Team::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 62), EaglerBungeeProtocol.map(107, 65), EaglerBungeeProtocol.map(335, 67), EaglerBungeeProtocol.map(338, 68), EaglerBungeeProtocol.map(393, 71), EaglerBungeeProtocol.map(477, 75), EaglerBungeeProtocol.map(573, 76), EaglerBungeeProtocol.map(755, 85), EaglerBungeeProtocol.map(760, 88)});
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 63), EaglerBungeeProtocol.map(107, 24), EaglerBungeeProtocol.map(393, 25), EaglerBungeeProtocol.map(477, 24), EaglerBungeeProtocol.map(573, 25), EaglerBungeeProtocol.map(735, 24), EaglerBungeeProtocol.map(751, 23), EaglerBungeeProtocol.map(755, 24), EaglerBungeeProtocol.map(759, 21), EaglerBungeeProtocol.map(760, 22)});
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 64), EaglerBungeeProtocol.map(107, 26), EaglerBungeeProtocol.map(393, 27), EaglerBungeeProtocol.map(477, 26), EaglerBungeeProtocol.map(573, 27), EaglerBungeeProtocol.map(735, 26), EaglerBungeeProtocol.map(751, 25), EaglerBungeeProtocol.map(755, 26), EaglerBungeeProtocol.map(759, 23), EaglerBungeeProtocol.map(760, 25)});
            this.TO_CLIENT.registerPacket(Title.class, Title::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 69), EaglerBungeeProtocol.map(335, 71), EaglerBungeeProtocol.map(338, 72), EaglerBungeeProtocol.map(393, 75), EaglerBungeeProtocol.map(477, 79), EaglerBungeeProtocol.map(573, 80), EaglerBungeeProtocol.map(735, 79), EaglerBungeeProtocol.map(755, 89), EaglerBungeeProtocol.map(757, 90), EaglerBungeeProtocol.map(760, 93)});
            this.TO_CLIENT.registerPacket(ClearTitles.class, ClearTitles::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(755, 16), EaglerBungeeProtocol.map(759, 13)});
            this.TO_CLIENT.registerPacket(Subtitle.class, Subtitle::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(755, 87), EaglerBungeeProtocol.map(757, 88), EaglerBungeeProtocol.map(760, 91)});
            this.TO_CLIENT.registerPacket(TitleTimes.class, TitleTimes::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(755, 90), EaglerBungeeProtocol.map(757, 91), EaglerBungeeProtocol.map(760, 94)});
            this.TO_CLIENT.registerPacket(SystemChat.class, SystemChat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(759, 95), EaglerBungeeProtocol.map(760, 98)});
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, PlayerListHeaderFooter::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 71), EaglerBungeeProtocol.map(107, 72), EaglerBungeeProtocol.map(110, 71), EaglerBungeeProtocol.map(335, 73), EaglerBungeeProtocol.map(338, 74), EaglerBungeeProtocol.map(393, 78), EaglerBungeeProtocol.map(477, 83), EaglerBungeeProtocol.map(573, 84), EaglerBungeeProtocol.map(735, 83), EaglerBungeeProtocol.map(755, 94), EaglerBungeeProtocol.map(757, 95), EaglerBungeeProtocol.map(759, 96), EaglerBungeeProtocol.map(760, 99)});
            this.TO_CLIENT.registerPacket(EntityStatus.class, EntityStatus::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 26), EaglerBungeeProtocol.map(107, 27), EaglerBungeeProtocol.map(393, 28), EaglerBungeeProtocol.map(477, 27), EaglerBungeeProtocol.map(573, 28), EaglerBungeeProtocol.map(735, 27), EaglerBungeeProtocol.map(751, 26), EaglerBungeeProtocol.map(755, 27), EaglerBungeeProtocol.map(759, 24), EaglerBungeeProtocol.map(760, 26)});
            this.TO_CLIENT.registerPacket(Commands.class, Commands::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(393, 17), EaglerBungeeProtocol.map(573, 18), EaglerBungeeProtocol.map(735, 17), EaglerBungeeProtocol.map(751, 16), EaglerBungeeProtocol.map(755, 18), EaglerBungeeProtocol.map(759, 15)});
            this.TO_CLIENT.registerPacket(GameState.class, GameState::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(573, 31), EaglerBungeeProtocol.map(735, 30), EaglerBungeeProtocol.map(751, 29), EaglerBungeeProtocol.map(755, 30), EaglerBungeeProtocol.map(759, 27), EaglerBungeeProtocol.map(760, 29)});
            this.TO_CLIENT.registerPacket(ViewDistance.class, ViewDistance::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(477, 65), EaglerBungeeProtocol.map(573, 66), EaglerBungeeProtocol.map(735, 65), EaglerBungeeProtocol.map(755, 74), EaglerBungeeProtocol.map(759, 73), EaglerBungeeProtocol.map(760, 76)});
            this.TO_CLIENT.registerPacket(ServerData.class, ServerData::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(759, 63), EaglerBungeeProtocol.map(760, 66)});
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0), EaglerBungeeProtocol.map(107, 11), EaglerBungeeProtocol.map(335, 12), EaglerBungeeProtocol.map(338, 11), EaglerBungeeProtocol.map(393, 14), EaglerBungeeProtocol.map(477, 15), EaglerBungeeProtocol.map(735, 16), EaglerBungeeProtocol.map(755, 15), EaglerBungeeProtocol.map(759, 17), EaglerBungeeProtocol.map(760, 18)});
            this.TO_SERVER.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1), EaglerBungeeProtocol.map(107, 2), EaglerBungeeProtocol.map(335, 3), EaglerBungeeProtocol.map(338, 2), EaglerBungeeProtocol.map(477, 3), EaglerBungeeProtocol.map(759, -1)});
            this.TO_SERVER.registerPacket(ClientCommand.class, ClientCommand::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(759, 3), EaglerBungeeProtocol.map(760, 4)});
            this.TO_SERVER.registerPacket(ClientChat.class, ClientChat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(759, 4), EaglerBungeeProtocol.map(760, 5)});
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, TabCompleteRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 20), EaglerBungeeProtocol.map(107, 1), EaglerBungeeProtocol.map(335, 2), EaglerBungeeProtocol.map(338, 1), EaglerBungeeProtocol.map(393, 5), EaglerBungeeProtocol.map(477, 6), EaglerBungeeProtocol.map(759, 8), EaglerBungeeProtocol.map(760, 9)});
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 21), EaglerBungeeProtocol.map(107, 4), EaglerBungeeProtocol.map(335, 5), EaglerBungeeProtocol.map(338, 4), EaglerBungeeProtocol.map(477, 5), EaglerBungeeProtocol.map(759, 7), EaglerBungeeProtocol.map(760, 8)});
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 23), EaglerBungeeProtocol.map(107, 9), EaglerBungeeProtocol.map(335, 10), EaglerBungeeProtocol.map(338, 9), EaglerBungeeProtocol.map(393, 10), EaglerBungeeProtocol.map(477, 11), EaglerBungeeProtocol.map(755, 10), EaglerBungeeProtocol.map(759, 12), EaglerBungeeProtocol.map(760, 13)});
        }
    }
    ,
    STATUS(2){
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, StatusResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_SERVER.registerPacket(StatusRequest.class, StatusRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_SERVER.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
        }
    }
    ,
    LOGIN(3){
        {
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, EncryptionRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_CLIENT.registerPacket(LoginSuccess.class, LoginSuccess::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 2)});
            this.TO_CLIENT.registerPacket(SetCompression.class, SetCompression::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 3)});
            this.TO_CLIENT.registerPacket(LoginPayloadRequest.class, LoginPayloadRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(393, 4)});
            this.TO_SERVER.registerPacket(LoginRequest.class, LoginRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_SERVER.registerPacket(EncryptionResponse.class, EncryptionResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_SERVER.registerPacket(LoginPayloadResponse.class, LoginPayloadResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(393, 2)});
        }
    };

    public static final int MAX_PACKET_ID = 255;
    final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    private EaglerBungeeProtocol(int n2) {
    }

    private static ProtocolMapping map(int n, int n2) {
        return new ProtocolMapping(n, n2);
    }

    /* synthetic */ EaglerBungeeProtocol(String string, int n, int n2, EaglerBungeeProtocol eaglerBungeeProtocol) {
        this(n2);
    }

    public static final class DirectionData {
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap();
        private final EaglerBungeeProtocol protocolPhase;
        private final ProtocolConstants.Direction direction;

        public DirectionData(EaglerBungeeProtocol eaglerBungeeProtocol, ProtocolConstants.Direction direction) {
            this.protocolPhase = eaglerBungeeProtocol;
            this.direction = direction;
            Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.protocols.put(n, (Object)new ProtocolData(n));
            }
        }

        private ProtocolData getProtocolData(int n) {
            ProtocolData protocolData = (ProtocolData)this.protocols.get(n);
            if (protocolData == null && this.protocolPhase != GAME) {
                protocolData = (ProtocolData)Iterables.getFirst((Iterable)this.protocols.valueCollection(), null);
            }
            return protocolData;
        }

        public final DefinedPacket createPacket(int n, int n2) {
            ProtocolData protocolData = this.getProtocolData(n2);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version " + n2);
            }
            if (n > 255 || n < 0) {
                throw new BadPacketException("Packet with id " + n + " outside of range");
            }
            Supplier supplier = protocolData.packetConstructors[n];
            return supplier == null ? null : (DefinedPacket)supplier.get();
        }

        private void registerPacket(Class<? extends DefinedPacket> clazz, Supplier<? extends DefinedPacket> supplier, ProtocolMapping ... protocolMappingArray) {
            int n = 0;
            Object object = protocolMappingArray[n];
            Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
            while (iterator.hasNext()) {
                Object object2;
                int n2 = (Integer)iterator.next();
                if (n2 < ((ProtocolMapping)object).protocolVersion) continue;
                if (((ProtocolMapping)object).protocolVersion < n2 && n + 1 < protocolMappingArray.length && ((ProtocolMapping)(object2 = protocolMappingArray[n + 1])).protocolVersion == n2) {
                    Preconditions.checkState((((ProtocolMapping)object2).packetID != ((ProtocolMapping)object).packetID ? 1 : 0) != 0, (String)"Duplicate packet mapping (%s, %s)", (int)((ProtocolMapping)object).protocolVersion, (int)((ProtocolMapping)object2).protocolVersion);
                    object = object2;
                    ++n;
                }
                if (((ProtocolMapping)object).packetID < 0) break;
                object2 = (ProtocolData)this.protocols.get(n2);
                ((ProtocolData)object2).packetMap.put(clazz, ((ProtocolMapping)object).packetID);
                ((ProtocolData)object2).packetConstructors[((ProtocolMapping)object).packetID] = supplier;
            }
        }

        final int getId(Class<? extends DefinedPacket> clazz, int n) {
            ProtocolData protocolData = this.getProtocolData(n);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            Preconditions.checkArgument((boolean)protocolData.packetMap.containsKey(clazz), (String)"Cannot get ID for packet %s in phase %s with direction %s", clazz, (Object)((Object)this.protocolPhase), (Object)this.direction);
            return protocolData.packetMap.get(clazz);
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    public static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap(255);
        private final Supplier<? extends DefinedPacket>[] packetConstructors = new Supplier[255];

        public ProtocolData(int n) {
            this.protocolVersion = n;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public TObjectIntMap<Class<? extends DefinedPacket>> getPacketMap() {
            return this.packetMap;
        }

        public Supplier<? extends DefinedPacket>[] getPacketConstructors() {
            return this.packetConstructors;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ProtocolData)) {
                return false;
            }
            ProtocolData protocolData = (ProtocolData)object;
            if (!protocolData.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != protocolData.getProtocolVersion()) {
                return false;
            }
            TObjectIntMap<Class<? extends DefinedPacket>> tObjectIntMap = this.getPacketMap();
            TObjectIntMap<Class<? extends DefinedPacket>> tObjectIntMap2 = protocolData.getPacketMap();
            if (tObjectIntMap == null ? tObjectIntMap2 == null : tObjectIntMap.equals(tObjectIntMap2)) {
                return Arrays.deepEquals(this.getPacketConstructors(), protocolData.getPacketConstructors());
            }
            return false;
        }

        protected boolean canEqual(Object object) {
            return object instanceof ProtocolData;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getProtocolVersion();
            TObjectIntMap<Class<? extends DefinedPacket>> tObjectIntMap = this.getPacketMap();
            n = n * 59 + (tObjectIntMap == null ? 43 : tObjectIntMap.hashCode());
            n = n * 59 + Arrays.deepHashCode(this.getPacketConstructors());
            return n;
        }

        public String toString() {
            return "Protocol.ProtocolData(protocolVersion=" + this.getProtocolVersion() + ", packetMap=" + this.getPacketMap() + ", packetConstructors=" + Arrays.deepToString(this.getPacketConstructors()) + ")";
        }
    }

    public static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        public ProtocolMapping(int n, int n2) {
            this.protocolVersion = n;
            this.packetID = n2;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public int getPacketID() {
            return this.packetID;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ProtocolMapping)) {
                return false;
            }
            ProtocolMapping protocolMapping = (ProtocolMapping)object;
            return protocolMapping.canEqual(this) && this.getProtocolVersion() == protocolMapping.getProtocolVersion() && this.getPacketID() == protocolMapping.getPacketID();
        }

        protected boolean canEqual(Object object) {
            return object instanceof ProtocolMapping;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getProtocolVersion();
            n = n * 59 + this.getPacketID();
            return n;
        }

        public String toString() {
            return "Protocol.ProtocolMapping(protocolVersion=" + this.getProtocolVersion() + ", packetID=" + this.getPacketID() + ")";
        }
    }
}

