/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftHandleAuthPasswordEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftIsAuthRequiredEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftMOTDEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftRegisterSkinEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandConfirmCode;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerChannelWrapper;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftByteBufEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftDecoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftWrappedEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpServerQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerBungeeProtocol;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.MOTDQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.QueryManager;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class HttpWebSocketHandler
extends ChannelInboundHandlerAdapter {
    private final EaglerListenerConfig conf;
    private int clientLoginState = 0;
    private int clientProtocolVersion = -1;
    private boolean isProtocolExchanged = false;
    private int gameProtocolVersion = -1;
    private CharSequence clientBrandString;
    private CharSequence clientVersionString;
    private CharSequence clientUsername;
    private UUID clientUUID;
    private CharSequence clientRequestedServer;
    private boolean clientAuth;
    private byte[] clientAuthUsername;
    private byte[] clientAuthPassword;
    private EaglercraftIsAuthRequiredEvent authRequireEvent;
    private final Map<String, byte[]> profileData = new HashMap<String, byte[]>();
    private boolean hasFirstPacket = false;
    private boolean hasBinaryConnection = false;
    private boolean connectionClosed = false;
    private InetAddress remoteAddress;
    private String localAddrString;
    private Property texturesOverrideProperty;
    private boolean overrideEaglerToVanillaSkins;
    private static final byte[] legacyRedirectHeader;

    static {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(255);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(250);
            String string = "EAG|Reconnect";
            int n = string.length();
            dataOutputStream.writeShort(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeChar(string.charAt(n2));
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
        legacyRedirectHeader = byteArrayOutputStream.toByteArray();
    }

    public HttpWebSocketHandler(EaglerListenerConfig eaglerListenerConfig) {
        this.conf = eaglerListenerConfig;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof WebSocketFrame) {
            if (object instanceof BinaryWebSocketFrame) {
                this.handleBinary(channelHandlerContext, ((BinaryWebSocketFrame)object).content());
            } else if (object instanceof TextWebSocketFrame) {
                this.handleText(channelHandlerContext, ((TextWebSocketFrame)object).text());
            } else if (object instanceof PingWebSocketFrame) {
                channelHandlerContext.writeAndFlush((Object)new PongWebSocketFrame());
            } else if (object instanceof CloseWebSocketFrame) {
                channelHandlerContext.close();
            }
        } else {
            EaglerXBungee.logger().severe("Unexpected Packet: " + object.getClass().getSimpleName());
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (channelHandlerContext.channel().isActive()) {
            EaglerXBungee.logger().warning("[Yee][" + channelHandlerContext.channel().remoteAddress() + "]: Exception Caught: " + throwable.toString());
        }
    }

    private void handleBinary(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        int n;
        if (this.connectionClosed) {
            return;
        }
        if (!this.hasFirstPacket) {
            if (byteBuf.readableBytes() >= 2 && byteBuf.getByte(0) == 2 && byteBuf.getByte(1) == 69) {
                this.handleLegacyClient(channelHandlerContext, byteBuf);
                return;
            }
            this.hasFirstPacket = true;
            this.hasBinaryConnection = true;
            BungeeCord bungeeCord = BungeeCord.getInstance();
            n = bungeeCord.config.getPlayerLimit();
            if (n > 0 && bungeeCord.getOnlineCount() >= n) {
                this.sendErrorCode(channelHandlerContext, 8, bungeeCord.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            if (this.conf.getMaxPlayer() > 0) {
                int n2 = 0;
                for (Object object62 : bungeeCord.getPlayers()) {
                    if (object62.getPendingConnection().getListener() != this.conf) continue;
                    ++n2;
                }
                if (n2 >= this.conf.getMaxPlayer()) {
                    this.sendErrorCode(channelHandlerContext, 8, bungeeCord.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.connectionClosed = true;
                    return;
                }
            }
            object5 = channelHandlerContext.channel().remoteAddress();
            object62 = (InetAddress)channelHandlerContext.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
            object4 = null;
            object3 = RateLimitStatus.OK;
            if (object62 != null) {
                this.remoteAddress = object62;
                object4 = ((InetAddress)object62).getHostAddress();
            } else if (object5 instanceof InetSocketAddress) {
                this.remoteAddress = ((InetSocketAddress)object5).getAddress();
                object4 = this.remoteAddress.getHostAddress();
            } else {
                this.remoteAddress = InetAddress.getLoopbackAddress();
            }
            object2 = this.conf.getRatelimitLogin();
            if (object4 != null && object2 != null) {
                object3 = object2.rateLimit((String)object4);
            }
            if (object3 == RateLimitStatus.LOCKED_OUT) {
                channelHandlerContext.close();
                this.connectionClosed = true;
                return;
            }
            if (object3 != RateLimitStatus.OK) {
                this.sendErrorCode(channelHandlerContext, object3 == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? 7 : 6, "Too many logins!").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            this.localAddrString = object5.toString();
            EaglerXBungee.logger().info("[" + this.localAddrString + "]: Connected via websocket");
            if (object62 != null) {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: Real address is " + ((InetAddress)object62).getHostAddress());
            }
            if ((object = (String)channelHandlerContext.channel().attr(EaglerPipeline.ORIGIN).get()) != null) {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: Origin header is " + (String)object);
            } else {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: No origin header is present!");
            }
        } else if (!this.hasBinaryConnection) {
            this.connectionClosed = true;
            channelHandlerContext.close();
            return;
        }
        int n3 = -1;
        try {
            n3 = byteBuf.readUnsignedByte();
            switch (n3) {
                case 1: {
                    if (this.clientLoginState == 0) {
                        InetAddress inetAddress;
                        this.clientLoginState = 255;
                        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
                        object5 = eaglerXBungee.getConfig().getAuthConfig();
                        short s = byteBuf.readUnsignedByte();
                        if (s == 1) {
                            if (((EaglerAuthConfig)object5).isEnableAuthentication()) {
                                this.sendErrorCode(channelHandlerContext, 8, "Please update your client to register on this server!").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            if (byteBuf.readUnsignedByte() != 47) {
                                this.clientLoginState = 3;
                                object4 = Unpooled.buffer();
                                object4.writeByte(3);
                                object4.writeByte(1);
                                object4.writeByte(1);
                                object4.writeByte((int)s);
                                object3 = "Outdated Client";
                                object4.writeByte(((String)object3).length());
                                object4.writeCharSequence((CharSequence)object3, StandardCharsets.US_ASCII);
                                channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(object4)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                        } else if (s == 2) {
                            int n4;
                            int n5 = Integer.MAX_VALUE;
                            int n6 = -1;
                            boolean bl = false;
                            boolean bl2 = false;
                            int n7 = Integer.MAX_VALUE;
                            int n8 = -1;
                            boolean bl3 = false;
                            int n9 = byteBuf.readUnsignedShort();
                            int n10 = 0;
                            while (n10 < n9) {
                                n4 = byteBuf.readUnsignedShort();
                                if (n4 == 2) {
                                    bl = true;
                                }
                                if (n4 == 3) {
                                    bl2 = true;
                                }
                                if (n4 > n6) {
                                    n6 = n4;
                                }
                                if (n4 < n5) {
                                    n5 = n4;
                                }
                                ++n10;
                            }
                            n9 = byteBuf.readUnsignedShort();
                            n10 = 0;
                            while (n10 < n9) {
                                n4 = byteBuf.readUnsignedShort();
                                if (n4 == 47) {
                                    bl3 = true;
                                }
                                if (n4 > n8) {
                                    n8 = n4;
                                }
                                if (n4 < n7) {
                                    n7 = n4;
                                }
                                ++n10;
                            }
                            if (n5 == Integer.MAX_VALUE || n7 == Integer.MAX_VALUE) {
                                throw new IOException();
                            }
                            n10 = 0;
                            n4 = 0;
                            boolean bl4 = false;
                            if (!bl && !bl2) {
                                n10 = 1;
                                n4 = n5 > 3 && n6 > 3 ? 1 : 0;
                                bl4 = n5 < 2 && n6 < 2;
                            } else if (!bl3) {
                                n10 = 1;
                                n4 = n7 > 47 && n8 > 47 ? 1 : 0;
                                bl4 = n7 < 47 && n8 < 47;
                            }
                            int n11 = this.clientProtocolVersion = bl2 ? 3 : 2;
                            if (n10 != 0) {
                                this.clientLoginState = 3;
                                ByteBuf byteBuf2 = Unpooled.buffer();
                                byteBuf2.writeByte(3);
                                byteBuf2.writeShort(2);
                                byteBuf2.writeShort(2);
                                byteBuf2.writeShort(3);
                                byteBuf2.writeShort(1);
                                byteBuf2.writeShort(47);
                                String string = bl4 ? "Outdated Client" : (n4 != 0 ? "Outdated Server" : "Unsupported Client Version");
                                byteBuf2.writeByte(string.length());
                                byteBuf2.writeCharSequence((CharSequence)string, StandardCharsets.US_ASCII);
                                channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf2)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                        } else {
                            this.sendErrorCode(channelHandlerContext, 8, "Legacy protocol version should always be '2' on post-snapshot clients").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        short s2 = byteBuf.readUnsignedByte();
                        CharSequence charSequence = byteBuf.readCharSequence((int)s2, StandardCharsets.US_ASCII);
                        s2 = byteBuf.readUnsignedByte();
                        CharSequence charSequence2 = byteBuf.readCharSequence((int)s2, StandardCharsets.US_ASCII);
                        if (s >= 2) {
                            this.clientAuth = byteBuf.readBoolean();
                            s2 = byteBuf.readUnsignedByte();
                            this.clientAuthUsername = new byte[s2];
                            byteBuf.readBytes(this.clientAuthUsername);
                        }
                        if (byteBuf.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        boolean bl = false;
                        if (s == 1 && !((EaglerAuthConfig)object5).isEnableAuthentication()) {
                            this.clientProtocolVersion = 2;
                            bl = true;
                            this.clientAuth = false;
                            this.clientAuthUsername = null;
                        }
                        if ((inetAddress = (InetAddress)channelHandlerContext.channel().attr(EaglerPipeline.REAL_ADDRESS).get()) == null) {
                            SocketAddress socketAddress = channelHandlerContext.channel().remoteAddress();
                            inetAddress = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress() : InetAddress.getLoopbackAddress();
                        }
                        boolean bl5 = bl;
                        Runnable runnable = () -> this.lambda$0(charSequence, charSequence2, bl5, eaglerXBungee, (EaglerAuthConfig)object5, channelHandlerContext);
                        this.authRequireEvent = null;
                        if (((EaglerAuthConfig)object5).isEnableAuthentication()) {
                            String string = (String)channelHandlerContext.channel().attr(EaglerPipeline.ORIGIN).get();
                            try {
                                this.authRequireEvent = new EaglercraftIsAuthRequiredEvent(this.conf, this.remoteAddress, string, this.clientAuth, this.clientAuthUsername, eaglercraftIsAuthRequiredEvent -> {
                                    if (this.authRequireEvent.shouldKickUser()) {
                                        this.sendErrorCode(channelHandlerContext, 8, this.authRequireEvent.getKickMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        return;
                                    }
                                    EaglercraftIsAuthRequiredEvent.AuthResponse authResponse = this.authRequireEvent.getAuthRequired();
                                    if (authResponse == null) {
                                        this.sendErrorCode(channelHandlerContext, 8, "IsAuthRequiredEvent was not handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no installed authentication system handled: " + ((Object)((Object)this.authRequireEvent)).toString());
                                        return;
                                    }
                                    if (authResponse == EaglercraftIsAuthRequiredEvent.AuthResponse.DENY) {
                                        this.sendErrorCode(channelHandlerContext, 8, this.authRequireEvent.getKickMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        return;
                                    }
                                    EaglercraftIsAuthRequiredEvent.AuthMethod authMethod = this.authRequireEvent.getUseAuthType();
                                    if (authMethod == null) {
                                        this.sendErrorCode(channelHandlerContext, 8, "IsAuthRequiredEvent was not fully handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no authentication method provided by handler");
                                        return;
                                    }
                                    int n = this.getAuthMethodId(authMethod);
                                    if (n == -1) {
                                        this.sendErrorCode(channelHandlerContext, 8, "Unsupported authentication method resolved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, unsupported AuthMethod: " + (Object)((Object)authMethod));
                                        return;
                                    }
                                    if (!this.clientAuth && authResponse == EaglercraftIsAuthRequiredEvent.AuthResponse.REQUIRE) {
                                        this.sendErrorCode(channelHandlerContext, 9, "Authentication Required: [" + n + "] " + this.authRequireEvent.getAuthMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().info("[" + this.localAddrString + "]: Displaying authentication screen");
                                        return;
                                    }
                                    if (this.authRequireEvent.getUseAuthType() == null) {
                                        this.sendErrorCode(channelHandlerContext, 8, "IsAuthRequiredEvent was not fully handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no authentication method provided by handler");
                                        return;
                                    }
                                    runnable.run();
                                });
                                if (((EaglerAuthConfig)object5).isUseBuiltInAuthentication()) {
                                    DefaultAuthSystem defaultAuthSystem = eaglerXBungee.getAuthService();
                                    if (defaultAuthSystem != null) {
                                        defaultAuthSystem.handleIsAuthRequiredEvent(this.authRequireEvent);
                                    }
                                } else {
                                    eaglerXBungee.getProxy().getPluginManager().callEvent((Event)this.authRequireEvent);
                                }
                                if (!this.authRequireEvent.isAsyncContinue()) {
                                    this.authRequireEvent.doDirectContinue();
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                throw new EventException(throwable);
                            }
                        }
                        runnable.run();
                        break;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(channelHandlerContext, n3, "STATE_OPENED").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 4: {
                    if (this.clientLoginState == 1) {
                        this.clientLoginState = 255;
                        n = byteBuf.readUnsignedByte();
                        this.clientUsername = byteBuf.readCharSequence(n, StandardCharsets.US_ASCII);
                        object5 = this.clientUsername.toString();
                        if (!((String)object5).equals(((String)object5).replaceAll("[^A-Za-z0-9_]", "_").trim())) {
                            this.sendLoginDenied(channelHandlerContext, "Invalid characters in username").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientUsername.length() < 3) {
                            this.sendLoginDenied(channelHandlerContext, "Username must be at least 3 characters").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientUsername.length() > 16) {
                            this.sendLoginDenied(channelHandlerContext, "Username must be under 16 characters").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientAuthUsername == null) {
                            this.clientAuthUsername = new byte[n];
                            int n12 = 0;
                            while (n12 < n) {
                                this.clientAuthUsername[n12] = (byte)this.clientUsername.charAt(n12);
                                ++n12;
                            }
                        }
                        String string = "OfflinePlayer:";
                        object4 = new byte[string.length() + this.clientAuthUsername.length];
                        System.arraycopy(string.getBytes(StandardCharsets.US_ASCII), 0, object4, 0, string.length());
                        System.arraycopy(this.clientAuthUsername, 0, object4, string.length(), this.clientAuthUsername.length);
                        this.clientUUID = UUID.nameUUIDFromBytes((byte[])object4);
                        n = byteBuf.readUnsignedByte();
                        this.clientRequestedServer = byteBuf.readCharSequence(n, StandardCharsets.US_ASCII);
                        n = byteBuf.readUnsignedByte();
                        this.clientAuthPassword = new byte[n];
                        byteBuf.readBytes(this.clientAuthPassword);
                        if (byteBuf.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        object3 = () -> {
                            String string;
                            BungeeCord bungeeCord = BungeeCord.getInstance();
                            ProxiedPlayer proxiedPlayer = bungeeCord.getPlayer(string = this.clientUsername.toString());
                            if (proxiedPlayer != null) {
                                this.sendLoginDenied(channelHandlerContext, bungeeCord.getTranslation("already_connected_proxy", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            this.clientLoginState = 2;
                            ByteBuf byteBuf = Unpooled.buffer();
                            byteBuf.writeByte(5);
                            byteBuf.writeByte(this.clientUsername.length());
                            byteBuf.writeCharSequence(this.clientUsername, StandardCharsets.US_ASCII);
                            byteBuf.writeLong(this.clientUUID.getMostSignificantBits());
                            byteBuf.writeLong(this.clientUUID.getLeastSignificantBits());
                            channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
                        };
                        object2 = EaglerXBungee.getEagler();
                        object = ((EaglerXBungee)((Object)object2)).getConfig().getAuthConfig();
                        if (((EaglerAuthConfig)object).isEnableAuthentication() && this.clientAuth) {
                            if (this.clientAuthPassword.length == 0) {
                                this.sendLoginDenied(channelHandlerContext, "Client provided no authentication code").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            try {
                                EaglercraftHandleAuthPasswordEvent eaglercraftHandleAuthPasswordEvent = new EaglercraftHandleAuthPasswordEvent(this.conf, this.remoteAddress, this.authRequireEvent.getOriginHeader(), this.clientAuthUsername, this.authRequireEvent.getSaltingData(), this.clientUsername, this.clientUUID, this.clientAuthPassword, this.authRequireEvent.getUseAuthType(), this.authRequireEvent.getAuthMessage(), this.authRequireEvent.getAuthAttachment(), this.clientRequestedServer.toString(), arg_0 -> this.lambda$3(channelHandlerContext, (Runnable)object3, arg_0));
                                if (((EaglerAuthConfig)object).isUseBuiltInAuthentication()) {
                                    DefaultAuthSystem defaultAuthSystem = ((EaglerXBungee)((Object)object2)).getAuthService();
                                    if (defaultAuthSystem != null) {
                                        defaultAuthSystem.handleAuthPasswordEvent(eaglercraftHandleAuthPasswordEvent);
                                    }
                                } else {
                                    object2.getProxy().getPluginManager().callEvent((Event)eaglercraftHandleAuthPasswordEvent);
                                }
                                if (!eaglercraftHandleAuthPasswordEvent.isAsyncContinue()) {
                                    eaglercraftHandleAuthPasswordEvent.doDirectContinue();
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                throw new EventException(throwable);
                            }
                        }
                        object3.run();
                        break;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(channelHandlerContext, n3, "STATE_CLIENT_VERSION").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 7: {
                    if (this.clientLoginState == 2) {
                        if (this.profileData.size() > 12) {
                            this.sendErrorCode(channelHandlerContext, 4, "Too many profile data packets recieved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        n = byteBuf.readUnsignedByte();
                        object5 = byteBuf.readCharSequence(n, StandardCharsets.US_ASCII).toString();
                        n = byteBuf.readUnsignedShort();
                        object62 = new byte[n];
                        byteBuf.readBytes((byte[])object62);
                        if (byteBuf.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        if (!this.profileData.containsKey(object5)) {
                            this.profileData.put((String)object5, (byte[])object62);
                            break;
                        }
                        this.sendErrorCode(channelHandlerContext, 5, "Multiple profile data packets of the same type recieved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(channelHandlerContext, n3, "STATE_CLIENT_LOGIN").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 8: {
                    if (this.clientLoginState == 2) {
                        this.clientLoginState = 255;
                        if (byteBuf.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        this.finish(channelHandlerContext);
                        this.clientLoginState = 3;
                        break;
                    }
                    this.sendErrorWrong(channelHandlerContext, n3, "STATE_CLIENT_LOGIN").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                default: {
                    this.clientLoginState = 3;
                    this.sendErrorCode(channelHandlerContext, 1, "Unknown Packet #" + n3).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof EventException) {
                EaglerXBungee.logger().log(Level.SEVERE, "[" + this.localAddrString + "]: Hanshake packet " + n3 + " caught an exception", throwable.getCause());
            }
            this.clientLoginState = 3;
            this.sendErrorCode(channelHandlerContext, 2, n3 == -1 ? "Invalid Packet" : "Invalid Packet #" + n3).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void finish(final ChannelHandlerContext channelHandlerContext) {
        String string;
        ProxiedPlayer proxiedPlayer2;
        final BungeeCord bungeeCord = BungeeCord.getInstance();
        int n = bungeeCord.config.getPlayerLimit();
        if (n > 0 && bungeeCord.getOnlineCount() >= n) {
            this.sendErrorCode(channelHandlerContext, 8, bungeeCord.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.connectionClosed = true;
            return;
        }
        if (this.conf.getMaxPlayer() > 0) {
            int n2 = 0;
            for (ProxiedPlayer proxiedPlayer2 : bungeeCord.getPlayers()) {
                if (proxiedPlayer2.getPendingConnection().getListener() != this.conf) continue;
                ++n2;
            }
            if (n2 >= this.conf.getMaxPlayer()) {
                this.sendErrorCode(channelHandlerContext, 8, bungeeCord.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
        }
        if ((proxiedPlayer2 = bungeeCord.getPlayer(string = this.clientUsername.toString())) != null) {
            this.sendErrorCode(channelHandlerContext, 8, bungeeCord.getTranslation("already_connected_proxy", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        final Object object = new EaglerChannelWrapper(channelHandlerContext);
        InetSocketAddress inetSocketAddress = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
        InetAddress inetAddress = (InetAddress)channelHandlerContext.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
        if (inetAddress != null) {
            inetSocketAddress = new InetSocketAddress(inetAddress, inetSocketAddress.getPort());
            object.setRemoteAddress(inetSocketAddress);
        }
        final EaglerInitialHandler eaglerInitialHandler = new EaglerInitialHandler(bungeeCord, this.conf, (ChannelWrapper)object, this.gameProtocolVersion, string, this.clientUUID, inetSocketAddress, (String)channelHandlerContext.channel().attr(EaglerPipeline.HOST).get(), (String)channelHandlerContext.channel().attr(EaglerPipeline.ORIGIN).get());
        Callback<LoginEvent> callback = new Callback<LoginEvent>(){

            public void done(LoginEvent loginEvent, Throwable throwable) {
                if (loginEvent.isCancelled()) {
                    BaseComponent[] baseComponentArray = loginEvent.getCancelReasonComponents();
                    HttpWebSocketHandler.this.sendErrorCode(channelHandlerContext, 8, ComponentSerializer.toString((BaseComponent[])(baseComponentArray != null ? baseComponentArray : TextComponent.fromLegacyText((String)bungeeCord.getTranslation("kick_message", new Object[0]))))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (!channelHandlerContext.channel().isActive()) {
                    return;
                }
                ByteBuf byteBuf = Unpooled.buffer();
                byteBuf.writeByte(9);
                channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf)).addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                    public void operationComplete(Future<Void> future) throws Exception {
                        LoginResult loginResult;
                        String string4;
                        Object object2;
                        EaglerConnectionInstance eaglerConnectionInstance = (EaglerConnectionInstance)channelHandlerContext.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
                        EaglerXBungee.logger().info("[" + channelHandlerContext.channel().remoteAddress() + "]: Logged in as '" + string + "'");
                        UserConnection userConnection = eaglerConnectionInstance.userConnection = new UserConnection((ProxyServer)bungeeCord, object, string, (InitialHandler)eaglerInitialHandler);
                        userConnection.setCompressionThreshold(-1);
                        userConnection.init();
                        ChannelPipeline channelPipeline = channelHandlerContext.channel().pipeline();
                        HandlerBoss handlerBoss = new HandlerBoss(){

                            public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
                                super.channelInactive(channelHandlerContext);
                                EaglerPipeline.closeChannel(channelHandlerContext.channel());
                            }
                        };
                        handlerBoss.setHandler((PacketHandler)new UpstreamBridge((ProxyServer)bungeeCord, userConnection));
                        try {
                            handlerBoss.channelActive(channelHandlerContext);
                        }
                        catch (Exception exception) {}
                        channelPipeline.replace((ChannelHandler)HttpWebSocketHandler.this, "HandlerBoss", (ChannelHandler)handlerBoss);
                        channelPipeline.addBefore("HandlerBoss", "ReadTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)BungeeCord.getInstance().config.getTimeout(), TimeUnit.MILLISECONDS));
                        channelPipeline.addBefore("HandlerBoss", "EaglerMinecraftDecoder", (ChannelHandler)new EaglerMinecraftDecoder(EaglerBungeeProtocol.GAME, false, HttpWebSocketHandler.this.gameProtocolVersion));
                        channelPipeline.addBefore("HandlerBoss", "EaglerMinecraftByteBufEncoder", (ChannelHandler)new EaglerMinecraftByteBufEncoder());
                        channelPipeline.addBefore("HandlerBoss", "EaglerMinecraftWrappedEncoder", (ChannelHandler)new EaglerMinecraftWrappedEncoder());
                        channelPipeline.addBefore("HandlerBoss", "EaglerMinecraftEncoder", (ChannelHandler)new EaglerMinecraftEncoder(EaglerBungeeProtocol.GAME, true, HttpWebSocketHandler.this.gameProtocolVersion));
                        boolean bl = true;
                        EaglercraftRegisterSkinEvent eaglercraftRegisterSkinEvent = new EaglercraftRegisterSkinEvent(string, HttpWebSocketHandler.this.clientUUID);
                        bungeeCord.getPluginManager().callEvent((Event)eaglercraftRegisterSkinEvent);
                        Property property = eaglercraftRegisterSkinEvent.getForceUseMojangProfileProperty();
                        boolean bl2 = eaglercraftRegisterSkinEvent.getForceUseLoginResultObjectTextures();
                        if (property != null) {
                            HttpWebSocketHandler.this.texturesOverrideProperty = property;
                            HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = true;
                        } else if (bl2) {
                            HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = true;
                        } else {
                            object2 = eaglercraftRegisterSkinEvent.getForceSetUseCustomPacket();
                            if (object2 != null) {
                                HttpWebSocketHandler.this.profileData.put("skin_v1", object2);
                                HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = false;
                            } else {
                                string4 = eaglercraftRegisterSkinEvent.getForceSetUseURL();
                                if (string4 != null) {
                                    EaglerXBungee.getEagler().getSkinService().registerTextureToPlayerAssociation(string4, eaglerInitialHandler.getUniqueId());
                                    bl = false;
                                    HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = false;
                                }
                            }
                        }
                        object2 = EaglerXBungee.getEagler().getConfig();
                        if (HttpWebSocketHandler.this.texturesOverrideProperty != null) {
                            string4 = eaglerInitialHandler.getLoginProfile();
                            if (string4 == null) {
                                string4 = new LoginResult(eaglerInitialHandler.getUniqueId().toString(), eaglerInitialHandler.getName(), null);
                                eaglerInitialHandler.setLoginProfile((LoginResult)string4);
                            }
                            string4.setProperties(new Property[]{HttpWebSocketHandler.this.texturesOverrideProperty, EaglerBungeeConfig.isEaglerProperty});
                        } else if (!bl2 && (string4 = object2.getEaglerPlayersVanillaSkin()) != null) {
                            loginResult = eaglerInitialHandler.getLoginProfile();
                            if (loginResult == null) {
                                loginResult = new LoginResult(eaglerInitialHandler.getUniqueId().toString(), eaglerInitialHandler.getName(), null);
                                eaglerInitialHandler.setLoginProfile(loginResult);
                            }
                            loginResult.setProperties(object2.getEaglerPlayersVanillaSkinProperties());
                        }
                        if (HttpWebSocketHandler.this.overrideEaglerToVanillaSkins && (string4 = eaglerInitialHandler.getLoginProfile()) != null && (loginResult = string4.getProperties()) != null) {
                            int n = 0;
                            while (n < ((Property[])loginResult).length) {
                                if ("textures".equals(loginResult[n].getName())) {
                                    try {
                                        JsonElement jsonElement;
                                        String string2 = SkinPackets.bytesToAscii(Base64.decodeBase64((String)loginResult[n].getValue()));
                                        JsonObject jsonObject = new JsonParser().parse(string2).getAsJsonObject();
                                        JsonObject jsonObject2 = jsonObject.getAsJsonObject("SKIN");
                                        if (jsonObject2 != null && (jsonElement = jsonObject.get("url")) != null) {
                                            String string3 = SkinService.sanitizeTextureURL(jsonElement.getAsString());
                                            EaglerXBungee.getEagler().getSkinService().registerTextureToPlayerAssociation(string3, eaglerInitialHandler.getUniqueId());
                                        }
                                        bl = false;
                                    }
                                    catch (Throwable throwable) {}
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (bl) {
                            if (HttpWebSocketHandler.this.profileData.containsKey("skin_v1")) {
                                try {
                                    SkinPackets.registerEaglerPlayer(HttpWebSocketHandler.this.clientUUID, (byte[])HttpWebSocketHandler.this.profileData.get("skin_v1"), EaglerXBungee.getEagler().getSkinService());
                                }
                                catch (Throwable throwable) {
                                    SkinPackets.registerEaglerPlayerFallback(HttpWebSocketHandler.this.clientUUID, EaglerXBungee.getEagler().getSkinService());
                                    EaglerXBungee.logger().info("[" + channelHandlerContext.channel().remoteAddress() + "]: Invalid skin packet: " + throwable.toString());
                                }
                            } else {
                                SkinPackets.registerEaglerPlayerFallback(HttpWebSocketHandler.this.clientUUID, EaglerXBungee.getEagler().getSkinService());
                            }
                        }
                        bungeeCord.getPluginManager().callEvent((Event)new PostLoginEvent((ProxiedPlayer)userConnection));
                        string4 = bungeeCord.getReconnectHandler() != null ? bungeeCord.getReconnectHandler().getServer((ProxiedPlayer)userConnection) : AbstractReconnectHandler.getForcedHost((PendingConnection)eaglerInitialHandler);
                        if (string4 == null) {
                            string4 = bungeeCord.getServerInfo(HttpWebSocketHandler.this.conf.getDefaultServer());
                        }
                        eaglerConnectionInstance.hasBeenForwarded = true;
                        userConnection.connect((ServerInfo)string4, null, true, ServerConnectEvent.Reason.JOIN_PROXY);
                    }
                });
            }
        };
        Callback<PreLoginEvent> callback2 = new Callback<PreLoginEvent>((Callback)callback){
            private final /* synthetic */ Callback val$complete;
            {
                this.val$complete = callback;
            }

            public void done(PreLoginEvent preLoginEvent, Throwable throwable) {
                if (preLoginEvent.isCancelled()) {
                    BaseComponent[] baseComponentArray = preLoginEvent.getCancelReasonComponents();
                    HttpWebSocketHandler.this.sendErrorCode(channelHandlerContext, 8, ComponentSerializer.toString((BaseComponent[])(baseComponentArray != null ? baseComponentArray : TextComponent.fromLegacyText((String)bungeeCord.getTranslation("kick_message", new Object[0]))))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    bungeeCord.getPluginManager().callEvent((Event)new LoginEvent((PendingConnection)eaglerInitialHandler, this.val$complete));
                }
            }
        };
        bungeeCord.getPluginManager().callEvent((Event)new PreLoginEvent((PendingConnection)eaglerInitialHandler, (Callback)callback2));
    }

    private void handleText(ChannelHandlerContext channelHandlerContext, String string) {
        if (this.connectionClosed) {
            return;
        }
        if (!this.hasFirstPacket && (this.conf.isAllowMOTD() || this.conf.isAllowQuery()) && (string = string.toLowerCase()).startsWith("accept:")) {
            EaglerRateLimiter eaglerRateLimiter;
            string = string.substring(7).trim();
            this.hasFirstPacket = true;
            this.hasBinaryConnection = false;
            if (CommandConfirmCode.confirmHash != null && string.equalsIgnoreCase(CommandConfirmCode.confirmHash)) {
                channelHandlerContext.writeAndFlush((Object)new TextWebSocketFrame("OK")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                CommandConfirmCode.confirmHash = null;
                this.connectionClosed = true;
                return;
            }
            boolean bl = string.startsWith("motd");
            SocketAddress socketAddress = channelHandlerContext.channel().remoteAddress();
            InetAddress inetAddress = (InetAddress)channelHandlerContext.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
            String string2 = null;
            RateLimitStatus rateLimitStatus = RateLimitStatus.OK;
            if (inetAddress != null) {
                string2 = inetAddress.getHostAddress();
            } else if (socketAddress instanceof InetSocketAddress) {
                string2 = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
            EaglerRateLimiter eaglerRateLimiter2 = eaglerRateLimiter = bl ? this.conf.getRatelimitMOTD() : this.conf.getRatelimitQuery();
            if (string2 != null && eaglerRateLimiter != null) {
                rateLimitStatus = eaglerRateLimiter.rateLimit(string2);
            }
            if (rateLimitStatus == RateLimitStatus.LOCKED_OUT) {
                channelHandlerContext.close();
                this.connectionClosed = true;
                return;
            }
            if (rateLimitStatus != RateLimitStatus.OK) {
                RateLimitStatus rateLimitStatus2 = rateLimitStatus;
                channelHandlerContext.writeAndFlush((Object)new TextWebSocketFrame(rateLimitStatus2 == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? "{\"type\":\"locked\"}" : "{\"type\":\"blocked\"}")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            HttpServerQueryHandler httpServerQueryHandler = null;
            if (bl) {
                if (this.conf.isAllowMOTD()) {
                    httpServerQueryHandler = new MOTDQueryHandler();
                }
            } else if (this.conf.isAllowQuery()) {
                httpServerQueryHandler = QueryManager.createQueryHandler(string);
            }
            if (httpServerQueryHandler != null) {
                channelHandlerContext.pipeline().replace((ChannelHandler)this, "HttpServerQueryHandler", (ChannelHandler)httpServerQueryHandler);
                channelHandlerContext.pipeline().addBefore("HttpServerQueryHandler", "WriteTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler(5L, TimeUnit.SECONDS));
                httpServerQueryHandler.beginHandleQuery(this.conf, channelHandlerContext, string);
                if (httpServerQueryHandler instanceof MOTDQueryHandler) {
                    EaglercraftMOTDEvent eaglercraftMOTDEvent = new EaglercraftMOTDEvent((MOTDQueryHandler)httpServerQueryHandler);
                    BungeeCord.getInstance().getPluginManager().callEvent((Event)eaglercraftMOTDEvent);
                    if (!httpServerQueryHandler.isClosed()) {
                        ((MOTDQueryHandler)httpServerQueryHandler).sendToUser();
                    }
                }
                if (!httpServerQueryHandler.isClosed() && !httpServerQueryHandler.shouldKeepAlive()) {
                    this.connectionClosed = true;
                    httpServerQueryHandler.close();
                }
            } else {
                this.connectionClosed = true;
                channelHandlerContext.close();
            }
        } else {
            this.connectionClosed = true;
            channelHandlerContext.close();
            return;
        }
    }

    private int getAuthMethodId(EaglercraftIsAuthRequiredEvent.AuthMethod authMethod) {
        switch (authMethod) {
            case PLAINTEXT: {
                return 255;
            }
            case EAGLER_SHA256: {
                return 1;
            }
            case AUTHME_SHA256: {
                return 2;
            }
        }
        return -1;
    }

    private ChannelFuture sendLoginDenied(ChannelHandlerContext channelHandlerContext, String string) {
        if (!(this.isProtocolExchanged && this.clientProtocolVersion != 2 || string.length() <= 255)) {
            string = string.substring(0, 256);
        } else if (string.length() > 65535) {
            string = string.substring(0, 65536);
        }
        this.clientLoginState = 3;
        this.connectionClosed = true;
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(6);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (!this.isProtocolExchanged || this.clientProtocolVersion == 2) {
            byteBuf.writeByte(byArray.length);
        } else {
            byteBuf.writeShort(byArray.length);
        }
        byteBuf.writeBytes(byArray);
        return channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    private ChannelFuture sendErrorWrong(ChannelHandlerContext channelHandlerContext, int n, String string) {
        return this.sendErrorCode(channelHandlerContext, 3, "Wrong Packet #" + n + " in state '" + string + "'");
    }

    private ChannelFuture sendErrorCode(ChannelHandlerContext channelHandlerContext, int n, String string) {
        if (!(this.isProtocolExchanged && this.clientProtocolVersion != 2 || string.length() <= 255)) {
            string = string.substring(0, 256);
        } else if (string.length() > 65535) {
            string = string.substring(0, 65536);
        }
        this.clientLoginState = 3;
        this.connectionClosed = true;
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(255);
        byteBuf.writeByte(n);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (!this.isProtocolExchanged || this.clientProtocolVersion == 2) {
            byteBuf.writeByte(byArray.length);
        } else {
            byteBuf.writeShort(byArray.length);
        }
        byteBuf.writeBytes(byArray);
        return channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.connectionClosed = true;
        EaglerPipeline.closeChannel(channelHandlerContext.channel());
    }

    private void handleLegacyClient(final ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        this.connectionClosed = true;
        ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer();
        final String string = this.conf.redirectLegacyClientsTo();
        if (string != null) {
            HttpWebSocketHandler.writeLegacyRedirect(byteBuf2, string);
        } else {
            HttpWebSocketHandler.writeLegacyKick(byteBuf2, "This is an EaglercraftX 1.8 server, it is not compatible with 1.5.2!");
        }
        channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf2)).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                channelHandlerContext.channel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        channelHandlerContext.close();
                    }
                }, string != null ? 100L : 500L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public static void writeLegacyKick(ByteBuf byteBuf, String string) {
        byteBuf.writeByte(255);
        byteBuf.writeShort(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            byteBuf.writeByte(c >> 8 & 0xFF);
            byteBuf.writeByte(c & 0xFF);
            ++n;
        }
    }

    public static void writeLegacyRedirect(ByteBuf byteBuf, String string) {
        byteBuf.writeBytes(legacyRedirectHeader);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byteBuf.writeByte(byArray.length >> 8 & 0xFF);
        byteBuf.writeByte(byArray.length & 0xFF);
        byteBuf.writeBytes(byArray);
    }

    private /* synthetic */ void lambda$0(CharSequence charSequence, CharSequence charSequence2, boolean bl, EaglerXBungee eaglerXBungee, EaglerAuthConfig eaglerAuthConfig, ChannelHandlerContext channelHandlerContext) {
        this.clientLoginState = 1;
        this.gameProtocolVersion = 47;
        this.clientBrandString = charSequence;
        this.clientVersionString = charSequence2;
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(2);
        if (bl) {
            byteBuf.writeByte(1);
        } else {
            byteBuf.writeShort(this.clientProtocolVersion);
            byteBuf.writeShort(47);
        }
        String string = eaglerXBungee.getDescription().getName();
        byteBuf.writeByte(string.length());
        byteBuf.writeCharSequence((CharSequence)string, StandardCharsets.US_ASCII);
        String string2 = eaglerXBungee.getDescription().getVersion();
        byteBuf.writeByte(string2.length());
        byteBuf.writeCharSequence((CharSequence)string2, StandardCharsets.US_ASCII);
        if (!eaglerAuthConfig.isEnableAuthentication() || !this.clientAuth) {
            byteBuf.writeByte(0);
            byteBuf.writeShort(0);
        } else {
            int n = this.getAuthMethodId(this.authRequireEvent.getUseAuthType());
            if (n == -1) {
                this.sendErrorCode(channelHandlerContext, 8, "Unsupported authentication method resolved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, unsupported AuthMethod: " + (Object)((Object)this.authRequireEvent.getUseAuthType()));
                return;
            }
            byteBuf.writeByte(n);
            byte[] byArray = this.authRequireEvent.getSaltingData();
            if (byArray != null) {
                byteBuf.writeShort(byArray.length);
                byteBuf.writeBytes(byArray);
            } else {
                byteBuf.writeShort(0);
            }
        }
        channelHandlerContext.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
        this.isProtocolExchanged = true;
    }

    private /* synthetic */ void lambda$3(ChannelHandlerContext channelHandlerContext, Runnable runnable, EaglercraftHandleAuthPasswordEvent eaglercraftHandleAuthPasswordEvent) {
        if (eaglercraftHandleAuthPasswordEvent.getLoginAllowed() != EaglercraftHandleAuthPasswordEvent.AuthResponse.ALLOW) {
            this.sendLoginDenied(channelHandlerContext, eaglercraftHandleAuthPasswordEvent.getLoginDeniedMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        this.clientUsername = eaglercraftHandleAuthPasswordEvent.getProfileUsername();
        this.clientUUID = eaglercraftHandleAuthPasswordEvent.getProfileUUID();
        String string = eaglercraftHandleAuthPasswordEvent.getApplyTexturesPropertyValue();
        if (string != null) {
            String string2 = eaglercraftHandleAuthPasswordEvent.getApplyTexturesPropertySignature();
            this.texturesOverrideProperty = new Property("textures", string, string2);
        }
        this.overrideEaglerToVanillaSkins = eaglercraftHandleAuthPasswordEvent.isOverrideEaglerToVanillaSkins();
        runnable.run();
    }

    private static class EventException
    extends RuntimeException {
        public EventException(Throwable throwable) {
            super(throwable.toString(), throwable);
        }
    }
}

