/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.QueryManager;

public abstract class HttpServerQueryHandler
extends ChannelInboundHandlerAdapter {
    private static final InetAddress localhost;
    private EaglerListenerConfig conf;
    private ChannelHandlerContext context;
    private String accept;
    private boolean acceptTextPacket = false;
    private boolean acceptBinaryPacket = false;
    private boolean hasClosed = false;
    private boolean keepAlive = false;

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("localhost doesn't exist?!", throwable);
        }
    }

    public void beginHandleQuery(EaglerListenerConfig eaglerListenerConfig, ChannelHandlerContext channelHandlerContext, String string) {
        this.conf = eaglerListenerConfig;
        this.context = channelHandlerContext;
        this.accept = string;
        this.begin(string);
    }

    protected void acceptText() {
        this.acceptText(true);
    }

    protected void acceptText(boolean bl) {
        this.acceptTextPacket = bl;
    }

    protected void acceptBinary() {
        this.acceptBinary(true);
    }

    protected void acceptBinary(boolean bl) {
        this.acceptBinaryPacket = bl;
    }

    public void close() {
        this.context.close();
        this.hasClosed = true;
    }

    public boolean isClosed() {
        return this.hasClosed;
    }

    public InetAddress getAddress() {
        InetAddress inetAddress = (InetAddress)this.context.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
        if (inetAddress != null) {
            return inetAddress;
        }
        SocketAddress socketAddress = this.context.channel().remoteAddress();
        return socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress() : localhost;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public EaglerListenerConfig getListener() {
        return this.conf;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object instanceof WebSocketFrame) {
            if (object instanceof BinaryWebSocketFrame) {
                this.handleBinary(channelHandlerContext, ((BinaryWebSocketFrame)object).content());
            } else if (object instanceof TextWebSocketFrame) {
                this.handleText(channelHandlerContext, ((TextWebSocketFrame)object).text());
            } else if (object instanceof PingWebSocketFrame) {
                channelHandlerContext.writeAndFlush((Object)new PongWebSocketFrame());
            } else if (object instanceof CloseWebSocketFrame) {
                channelHandlerContext.close();
            }
        } else {
            EaglerXBungee.logger().severe("Unexpected Packet: " + object.getClass().getSimpleName());
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        if (channelHandlerContext.channel().isActive()) {
            EaglerXBungee.logger().warning("[" + channelHandlerContext.channel().remoteAddress() + "]: Exception Caught: " + throwable.toString());
        }
    }

    private void handleBinary(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (!this.acceptBinaryPacket) {
            channelHandlerContext.close();
            return;
        }
        byte[] byArray = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(byArray);
        this.processBytes(byArray);
    }

    private void handleText(ChannelHandlerContext channelHandlerContext, String string) {
        if (!this.acceptTextPacket) {
            channelHandlerContext.close();
            return;
        }
        JsonObject jsonObject = null;
        if (string.indexOf(123) == 0) {
            try {
                jsonObject = new JsonParser().parse(string).getAsJsonObject();
            }
            catch (JsonParseException jsonParseException) {}
        }
        if (jsonObject != null) {
            this.processJson(jsonObject);
        } else {
            this.processString(string);
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        EaglerPipeline.closeChannel(channelHandlerContext.channel());
        this.hasClosed = true;
        this.closed();
    }

    public String getAccept() {
        return this.accept;
    }

    public void sendStringResponse(String string, String string2) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createStringResponse(this.accept, string2).toString()));
    }

    public void sendStringResponseAndClose(String string, String string2) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createStringResponse(this.accept, string2).toString())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendJsonResponse(String string, JsonObject jsonObject) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createJsonObjectResponse(this.accept, jsonObject).toString()));
    }

    public void sendJsonResponseAndClose(String string, JsonObject jsonObject) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createJsonObjectResponse(this.accept, jsonObject).toString())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendBinaryResponse(byte[] byArray) {
        ByteBuf byteBuf = this.context.alloc().buffer(byArray.length, byArray.length);
        byteBuf.writeBytes(byArray);
        this.context.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    public void sendBinaryResponseAndClose(byte[] byArray) {
        ByteBuf byteBuf = this.context.alloc().buffer(byArray.length, byArray.length);
        byteBuf.writeBytes(byArray);
        this.context.writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public boolean shouldKeepAlive() {
        return this.keepAlive;
    }

    protected abstract void begin(String var1);

    protected abstract void processString(String var1);

    protected abstract void processJson(JsonObject var1);

    protected abstract void processBytes(byte[] var1);

    protected abstract void closed();

    public static class UnexpectedDataException
    extends RuntimeException {
        public UnexpectedDataException() {
        }

        public UnexpectedDataException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public UnexpectedDataException(String string) {
            super(string);
        }

        public UnexpectedDataException(Throwable throwable) {
            super(throwable);
        }
    }
}

