/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpHandshakeHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;

public class EaglerPipeline {
    public static final AttributeKey<EaglerListenerConfig> LISTENER = AttributeKey.valueOf((String)"ListenerInfo");
    public static final AttributeKey<InetSocketAddress> LOCAL_ADDRESS = AttributeKey.valueOf((String)"LocalAddress");
    public static final AttributeKey<EaglerConnectionInstance> CONNECTION_INSTANCE = AttributeKey.valueOf((String)"EaglerConnectionInstance");
    public static final AttributeKey<InetAddress> REAL_ADDRESS = AttributeKey.valueOf((String)"RealAddress");
    public static final AttributeKey<String> HOST = AttributeKey.valueOf((String)"Host");
    public static final AttributeKey<String> ORIGIN = AttributeKey.valueOf((String)"Origin");
    public static final Collection<Channel> openChannels = new LinkedList<Channel>();
    public static final TimerTask closeInactive = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger logger = EaglerXBungee.logger();
            EaglerBungeeConfig eaglerBungeeConfig = EaglerXBungee.getEagler().getConfig();
            long l = eaglerBungeeConfig.getWebsocketHandshakeTimeout();
            long l2 = eaglerBungeeConfig.getWebsocketKeepAliveTimeout();
            Collection<Channel> object2 = openChannels;
            synchronized (object2) {
                long l3 = System.currentTimeMillis();
                Iterator<Channel> iterator = openChannels.iterator();
                while (iterator.hasNext()) {
                    Channel channel = iterator.next();
                    EaglerConnectionInstance eaglerConnectionInstance = (EaglerConnectionInstance)channel.attr(CONNECTION_INSTANCE).get();
                    long l4 = 500L;
                    if (eaglerConnectionInstance.isRegularHttp) {
                        l4 = 10000L;
                    }
                    if (eaglerConnectionInstance.isWebSocket) {
                        l4 = l;
                    }
                    if (eaglerConnectionInstance == null || !eaglerConnectionInstance.hasBeenForwarded && l3 - eaglerConnectionInstance.creationTime > l4 || l3 - eaglerConnectionInstance.lastClientPongPacket > l2 || !channel.isActive()) {
                        if (channel.isActive()) {
                            channel.close();
                        }
                        iterator.remove();
                        continue;
                    }
                    long l5 = 5000L;
                    if (l5 + 700L > l2 && (l5 = l2 - 500L) < 500L) {
                        l2 = 500L;
                    }
                    if (l3 - eaglerConnectionInstance.lastServerPingPacket <= l5) continue;
                    eaglerConnectionInstance.lastServerPingPacket = l3;
                    channel.write((Object)new PingWebSocketFrame());
                }
            }
            for (EaglerListenerConfig eaglerListenerConfig : eaglerBungeeConfig.getServerListeners()) {
                HttpWebServer httpWebServer = eaglerListenerConfig.getWebServer();
                if (httpWebServer == null) continue;
                try {
                    httpWebServer.flushCache();
                }
                catch (Throwable throwable) {
                    logger.severe("Failed to flush web server cache for: " + eaglerListenerConfig.getAddress().toString());
                    throwable.printStackTrace();
                }
            }
        }
    };
    public static final ChannelInitializer<Channel> SERVER_CHILD = new ChannelInitializer<Channel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initChannel(Channel channel) throws Exception {
            Object object;
            ChannelPipeline channelPipeline = channel.pipeline();
            channelPipeline.addLast("HttpServerCodec", (ChannelHandler)new HttpServerCodec());
            channelPipeline.addLast("HttpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(65535));
            int n = EaglerXBungee.getEagler().getConfig().getHttpWebsocketCompressionLevel();
            if (n > 0) {
                if (n > 9) {
                    n = 9;
                }
                object = new DeflateFrameServerExtensionHandshaker(n);
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateServerExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(n, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
                channelPipeline.addLast("HttpCompressionHandler", (ChannelHandler)new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{object, perMessageDeflateServerExtensionHandshaker}));
            }
            channelPipeline.addLast("HttpHandshakeHandler", (ChannelHandler)new HttpHandshakeHandler((EaglerListenerConfig)((Object)channel.attr(LISTENER).get())));
            channel.attr(CONNECTION_INSTANCE).set((Object)new EaglerConnectionInstance(channel));
            object = openChannels;
            synchronized (object) {
                openChannels.add(channel);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeChannel(Channel channel) {
        Collection<Channel> collection = openChannels;
        synchronized (collection) {
            openChannels.remove(channel);
        }
    }
}

