/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import io.netty.handler.codec.http.HttpRequest;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.MOTDCacheConfiguration;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.ServerIconLoader;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.config.Configuration;

public class EaglerListenerConfig
extends ListenerInfo {
    private final InetSocketAddress address;
    private final InetSocketAddress addressV6;
    private final int maxPlayer;
    private final String tabListType;
    private final String defaultServer;
    private final boolean forceDefaultServer;
    private final boolean forwardIp;
    private final String forwardIpHeader;
    private final String redirectLegacyClientsTo;
    private final String serverIcon;
    private final List<String> serverMOTD;
    private final boolean allowMOTD;
    private final boolean allowQuery;
    private final MOTDCacheConfiguration motdCacheConfig;
    private final HttpWebServer webServer;
    private boolean serverIconSet = false;
    private int[] serverIconPixels = null;
    private final EaglerRateLimiter ratelimitIp;
    private final EaglerRateLimiter ratelimitLogin;
    private final EaglerRateLimiter ratelimitMOTD;
    private final EaglerRateLimiter ratelimitQuery;

    static EaglerListenerConfig loadConfig(Configuration configuration, Map<String, HttpContentType> map) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        String string = configuration.getString("address", "0.0.0.0:8081");
        InetSocketAddress inetSocketAddress = null;
        if (string != null && !string.equalsIgnoreCase("null") && !string.equalsIgnoreCase("none")) {
            int n2 = string.lastIndexOf(58);
            if (n2 == -1) {
                throw new IllegalArgumentException("Invalid address: " + string + "! Must be an ipv4:port combo");
            }
            inetSocketAddress = new InetSocketAddress(string.substring(0, n2), Integer.parseInt(string.substring(n2 + 1)));
        }
        String string2 = configuration.getString("address_v6", "null");
        InetSocketAddress inetSocketAddress2 = null;
        if (string2 != null && !string2.equalsIgnoreCase("null") && !string2.equalsIgnoreCase("none") && string2.length() > 0) {
            n = string2.lastIndexOf(58);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid address: " + string + "! Must be an ipv6:port combo");
            }
            inetSocketAddress2 = new InetSocketAddress(string2.substring(0, n), Integer.parseInt(string2.substring(n + 1)));
        }
        if (inetSocketAddress == null && inetSocketAddress2 == null) {
            throw new IllegalArgumentException("Invalid host specifies no addresses, both v4 and v6 address are null");
        }
        n = configuration.getInt("max_players", 60);
        String string3 = configuration.getString("tab_list", "GLOBAL_PING");
        String string4 = configuration.getString("default_server", "lobby");
        boolean bl = configuration.getBoolean("force_default_server", false);
        boolean bl2 = configuration.getBoolean("forward_ip", false);
        String string5 = configuration.getString("forward_ip_header", "X-Real-IP");
        String string6 = configuration.getString("redirect_legacy_clients_to", "null");
        if (string6 != null && (string6.equalsIgnoreCase("null") || string6.length() == 0)) {
            string6 = null;
        }
        String string7 = configuration.getString("server_icon", "server-icon.png");
        List list = configuration.getList("server_motd", Arrays.asList("&6An EaglercraftX server"));
        boolean bl3 = false;
        boolean bl4 = list.size();
        while (bl3 < bl4) {
            list.set(bl3 ? 1 : 0, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)list.get(bl3 ? 1 : 0))));
            bl3 += 1;
        }
        bl3 = configuration.getBoolean("allow_motd", false);
        boolean bl5 = configuration.getBoolean("allow_query", false);
        int n2 = 7200;
        boolean bl6 = false;
        boolean bl7 = true;
        boolean bl8 = true;
        boolean bl9 = false;
        Configuration configuration2 = configuration.getSection("request_motd_cache");
        if (configuration2 != null) {
            n2 = configuration2.getInt("cache_ttl", 7200);
            bl6 = configuration2.getBoolean("online_server_list_animation", false);
            bl7 = configuration2.getBoolean("online_server_list_results", true);
            bl8 = configuration2.getBoolean("online_server_list_trending", true);
            bl9 = configuration2.getBoolean("online_server_list_portfolios", false);
        }
        HttpWebServer httpWebServer = null;
        Configuration configuration3 = configuration.getSection("http_server");
        if (configuration3 != null && configuration3.getBoolean("enabled", false)) {
            object6 = configuration3.getString("root", "web");
            object5 = configuration3.getString("page_404_not_found", "default");
            if (object5 != null && (((String)object5).length() == 0 || ((String)object5).equalsIgnoreCase("null") || ((String)object5).equalsIgnoreCase("default"))) {
                object5 = null;
            }
            object4 = Arrays.asList("index.html", "index.htm");
            object3 = configuration3.getList("page_index_name", object4);
            object2 = new ArrayList(object3.size());
            int configuration6 = 0;
            int configuration5 = object3.size();
            while (configuration6 < configuration5) {
                object = object3.get(configuration6);
                if (object instanceof String) {
                    object2.add((String)object);
                }
                ++configuration6;
            }
            if (object2.size() == 0) {
                object2.addAll(object4);
            }
            httpWebServer = new HttpWebServer(new File(EaglerXBungee.getEagler().getDataFolder(), (String)object6), map, (List<String>)object2, (String)object5);
        }
        object6 = null;
        object5 = null;
        object4 = null;
        object3 = null;
        object2 = configuration.getSection("ratelimit");
        if (object2 != null) {
            Configuration configuration4;
            Configuration configuration5;
            Configuration mOTDCacheConfiguration = object2.getSection("ip");
            if (mOTDCacheConfiguration != null && mOTDCacheConfiguration.getBoolean("enable", false)) {
                object6 = EaglerRateLimiter.loadConfig(mOTDCacheConfiguration);
            }
            if ((configuration5 = object2.getSection("login")) != null && configuration5.getBoolean("enable", false)) {
                object5 = EaglerRateLimiter.loadConfig(configuration5);
            }
            if ((object = object2.getSection("motd")) != null && object.getBoolean("enable", false)) {
                object4 = EaglerRateLimiter.loadConfig(object);
            }
            if ((configuration4 = object2.getSection("query")) != null && configuration4.getBoolean("enable", false)) {
                object3 = EaglerRateLimiter.loadConfig(configuration4);
            }
        }
        MOTDCacheConfiguration mOTDCacheConfiguration = new MOTDCacheConfiguration(n2, bl6, bl7, bl8, bl9);
        return new EaglerListenerConfig(inetSocketAddress, inetSocketAddress2, n, string3, string4, bl, bl2, string5, string6, string7, list, bl3, bl5, mOTDCacheConfiguration, httpWebServer, (EaglerRateLimiter)object6, (EaglerRateLimiter)object5, (EaglerRateLimiter)object4, (EaglerRateLimiter)object3);
    }

    public EaglerListenerConfig(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, int n, String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, List<String> list, boolean bl3, boolean bl4, MOTDCacheConfiguration mOTDCacheConfiguration, HttpWebServer httpWebServer, EaglerRateLimiter eaglerRateLimiter, EaglerRateLimiter eaglerRateLimiter2, EaglerRateLimiter eaglerRateLimiter3, EaglerRateLimiter eaglerRateLimiter4) {
        super((SocketAddress)inetSocketAddress, String.join((CharSequence)"\n", list), n, 60, Arrays.asList(string2), bl, Collections.emptyMap(), string, false, false, 0, false, false);
        this.address = inetSocketAddress;
        this.addressV6 = inetSocketAddress2;
        this.maxPlayer = n;
        this.tabListType = string;
        this.defaultServer = string2;
        this.forceDefaultServer = bl;
        this.forwardIp = bl2;
        this.forwardIpHeader = string3;
        this.redirectLegacyClientsTo = string4;
        this.serverIcon = string5;
        this.serverMOTD = list;
        this.allowMOTD = bl3;
        this.allowQuery = bl4;
        this.motdCacheConfig = mOTDCacheConfiguration;
        this.webServer = httpWebServer;
        this.ratelimitIp = eaglerRateLimiter;
        this.ratelimitLogin = eaglerRateLimiter2;
        this.ratelimitMOTD = eaglerRateLimiter3;
        this.ratelimitQuery = eaglerRateLimiter4;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getAddressV6() {
        return this.addressV6;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public String getTabListType() {
        return this.tabListType;
    }

    public String getDefaultServer() {
        return this.defaultServer;
    }

    public boolean isForceDefaultServer() {
        return this.forceDefaultServer;
    }

    public boolean isForwardIp() {
        return this.forwardIp;
    }

    public String getForwardIpHeader() {
        return this.forwardIpHeader;
    }

    public String getServerIconName() {
        return this.serverIcon;
    }

    public int[] getServerIconPixels() {
        if (!this.serverIconSet) {
            if (this.serverIcon != null) {
                File file = new File(this.serverIcon);
                if (file.isFile()) {
                    this.serverIconPixels = ServerIconLoader.createServerIcon(file);
                    if (this.serverIconPixels == null) {
                        EaglerXBungee.logger().warning("Server icon could not be loaded: " + file.getAbsolutePath());
                    }
                } else {
                    EaglerXBungee.logger().warning("Server icon is not a file: " + file.getAbsolutePath());
                }
            }
            this.serverIconSet = true;
        }
        return this.serverIconPixels;
    }

    public List<String> getServerMOTD() {
        return this.serverMOTD;
    }

    public boolean isAllowMOTD() {
        return this.allowMOTD;
    }

    public boolean isAllowQuery() {
        return this.allowQuery;
    }

    public HttpWebServer getWebServer() {
        return this.webServer;
    }

    public MOTDCacheConfiguration getMOTDCacheConfig() {
        return this.motdCacheConfig;
    }

    public boolean blockRequest(HttpRequest httpRequest) {
        return false;
    }

    public String redirectLegacyClientsTo() {
        return this.redirectLegacyClientsTo;
    }

    public EaglerRateLimiter getRatelimitIp() {
        return this.ratelimitIp;
    }

    public EaglerRateLimiter getRatelimitLogin() {
        return this.ratelimitLogin;
    }

    public EaglerRateLimiter getRatelimitMOTD() {
        return this.ratelimitMOTD;
    }

    public EaglerRateLimiter getRatelimitQuery() {
        return this.ratelimitQuery;
    }
}

