/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.VanillaDefaultSkinProfileLoader;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.protocol.Property;

public class EaglerBungeeConfig {
    public static final Property isEaglerProperty = new Property("isEaglerPlayer", "true");
    private final String serverName;
    private final UUID serverUUID;
    private final long websocketKeepAliveTimeout;
    private final long websocketHandshakeTimeout;
    private final int httpWebsocketCompressionLevel;
    private final Map<String, EaglerListenerConfig> serverListeners;
    private final Map<String, HttpContentType> contentTypes;
    private final boolean downloadVanillaSkins;
    private final Collection<String> validSkinUrls;
    private final int uuidRateLimitPlayer;
    private final int uuidRateLimitGlobal;
    private final int skinRateLimitPlayer;
    private final int skinRateLimitGlobal;
    private final String skinCacheURI;
    private final int keepObjectsDays;
    private final int keepProfilesDays;
    private final int maxObjects;
    private final int maxProfiles;
    private final int antagonistsRateLimit;
    private final String sqliteDriverClass;
    private final String sqliteDriverPath;
    private final String eaglerPlayersVanillaSkin;
    private final EaglerAuthConfig authConfig;
    Property[] eaglerPlayersVanillaSkinCached = new Property[]{isEaglerProperty};

    public static EaglerBungeeConfig loadConfig(File file) throws IOException {
        Object object;
        String string;
        Object object2;
        Configuration configuration;
        Throwable throwable;
        HashMap<String, HttpContentType> hashMap = new HashMap<String, HttpContentType>();
        try {
            throwable = null;
            configuration = null;
            try {
                object2 = new FileInputStream(EaglerBungeeConfig.getConfigFile(file, "http_mime_types.json"));
                try {
                    EaglerBungeeConfig.loadMimeTypes((InputStream)object2, hashMap);
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = null;
                configuration = null;
                try {
                    object2 = EaglerBungeeConfig.class.getResourceAsStream("default_http_mime_types.json");
                    try {
                        EaglerBungeeConfig.loadMimeTypes((InputStream)object2, hashMap);
                    }
                    finally {
                        if (object2 != null) {
                            ((InputStream)object2).close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                EaglerXBungee.logger().severe("Could not load default_http_mime_types.json!");
                throw new RuntimeException(iOException);
            }
        }
        file.mkdirs();
        throwable = ConfigurationProvider.getProvider(YamlConfiguration.class);
        configuration = throwable.load(EaglerBungeeConfig.getConfigFile(file, "settings.yml"));
        object2 = configuration.getString("server_name", "EaglercraftXBungee Server");
        String string2 = configuration.getString("server_uuid", null);
        if (string2 == null) {
            throw new IOException("You must specify a server_uuid!");
        }
        UUID uUID = null;
        try {
            uUID = UUID.fromString(string2);
        }
        catch (Throwable throwable5) {}
        if (uUID == null) {
            throw new IOException("The server_uuid \"" + string2 + "\" is invalid!");
        }
        Configuration configuration2 = throwable.load(EaglerBungeeConfig.getConfigFile(file, "listeners.yml"));
        Iterator iterator = configuration2.getKeys().iterator();
        HashMap<String, EaglerListenerConfig> hashMap2 = new HashMap<String, EaglerListenerConfig>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object = EaglerListenerConfig.loadConfig(configuration2.getSection(string), hashMap);
            if (object != null) {
                hashMap2.put(string, (EaglerListenerConfig)((Object)object));
                continue;
            }
            EaglerXBungee.logger().severe("Invalid listener config: " + string);
        }
        if (hashMap2.size() == 0) {
            EaglerXBungee.logger().severe("No Listeners Configured!");
        }
        if (((EaglerAuthConfig)(object = EaglerAuthConfig.loadConfig((Configuration)(string = throwable.load(EaglerBungeeConfig.getConfigFile(file, "authservice.yml")))))).isEnableAuthentication()) {
            for (EaglerListenerConfig eaglerListenerConfig : hashMap2.values()) {
                if (eaglerListenerConfig.getRatelimitLogin() != null) {
                    eaglerListenerConfig.getRatelimitLogin().setDivisor(2);
                }
                if (eaglerListenerConfig.getRatelimitIp() == null) continue;
                eaglerListenerConfig.getRatelimitIp().setDivisor(2);
            }
        }
        long l = configuration.getInt("websocket_connection_timeout", 15000);
        long l2 = configuration.getInt("websocket_handshake_timeout", 5000);
        int n = configuration.getInt("http_websocket_compression_level", 6);
        boolean bl = configuration.getBoolean("download_vanilla_skins_to_clients", false);
        List list = configuration.getList("valid_skin_download_urls");
        int n2 = configuration.getInt("uuid_lookup_ratelimit_player", 50);
        int n3 = configuration.getInt("uuid_lookup_ratelimit_global", 175);
        int n4 = configuration.getInt("skin_download_ratelimit_player", 1000);
        int n5 = configuration.getInt("skin_download_ratelimit_global", 30000);
        String string3 = configuration.getString("skin_cache_db_uri", "jdbc:sqlite:eaglercraft_skins_cache.db");
        int n6 = configuration.getInt("skin_cache_keep_objects_days", 45);
        int n7 = configuration.getInt("skin_cache_keep_profiles_days", 7);
        int n8 = configuration.getInt("skin_cache_max_objects", 32768);
        int n9 = configuration.getInt("skin_cache_max_profiles", 32768);
        int n10 = configuration.getInt("skin_cache_antagonists_ratelimit", 15);
        String string4 = configuration.getString("sql_driver_class", "internal");
        String string5 = configuration.getString("sql_driver_path", null);
        String string6 = configuration.getString("eagler_players_vanilla_skin", null);
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        EaglerBungeeConfig eaglerBungeeConfig = new EaglerBungeeConfig((String)object2, uUID, l, l2, n, hashMap2, hashMap, bl, list, n2, n3, n4, n5, string3, n6, n7, n8, n9, n10, string4, string5, string6, (EaglerAuthConfig)object);
        if (string6 != null) {
            VanillaDefaultSkinProfileLoader.lookupVanillaSkinUser(eaglerBungeeConfig);
        }
        return eaglerBungeeConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getConfigFile(File file, String string) throws IOException {
        File file2 = new File(file, string);
        if (file2.isFile()) return file2;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(EaglerBungeeConfig.class.getResourceAsStream("default_" + string), StandardCharsets.UTF_8));
            try {
                try (PrintWriter printWriter = new PrintWriter(new FileWriter(file2));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.contains("${")) {
                            string2 = string2.replace("${random_uuid}", UUID.randomUUID().toString());
                        }
                        printWriter.println(string2);
                    }
                }
                if (bufferedReader == null) return file2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            return file2;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void loadMimeTypes(InputStream inputStream, Map<String, HttpContentType> map) throws IOException {
        JsonObject jsonObject = EaglerBungeeConfig.parseJsonObject(inputStream);
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = (String)entry.getKey();
            try {
                JsonObject jsonObject2 = ((JsonElement)entry.getValue()).getAsJsonObject();
                JsonArray jsonArray = jsonObject2.getAsJsonArray("files");
                if (jsonArray == null || jsonArray.size() == 0) {
                    EaglerXBungee.logger().warning("MIME type '" + string + "' defines no extensions!");
                    continue;
                }
                HashSet<String> hashSet = new HashSet<String>();
                int n = 0;
                int n2 = jsonArray.size();
                while (n < n2) {
                    hashSet.add(jsonArray.get(n).getAsString());
                    ++n;
                }
                long l = 0L;
                JsonElement jsonElement = jsonObject2.get("expires");
                if (jsonElement != null) {
                    l = (long)jsonElement.getAsInt() * 1000L;
                }
                String string2 = null;
                jsonElement = jsonObject2.get("charset");
                if (jsonElement != null) {
                    string2 = jsonElement.getAsString();
                }
                HttpContentType httpContentType = new HttpContentType(hashSet, string, string2, l);
                for (String string3 : hashSet) {
                    map.put(string3, httpContentType);
                }
            }
            catch (Throwable throwable) {
                EaglerXBungee.logger().warning("Exception parsing MIME type '" + string + "' - " + throwable.toString());
            }
        }
    }

    private static JsonObject parseJsonObject(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) > 0) {
            stringBuilder.append(new String(byArray, 0, n, "UTF-8"));
        }
        try {
            return new JsonParser().parse(stringBuilder.toString()).getAsJsonObject();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw new IOException("Invalid JSONObject", jsonSyntaxException);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public UUID getServerUUID() {
        return this.serverUUID;
    }

    public long getWebsocketKeepAliveTimeout() {
        return this.websocketKeepAliveTimeout;
    }

    public long getWebsocketHandshakeTimeout() {
        return this.websocketHandshakeTimeout;
    }

    public int getHttpWebsocketCompressionLevel() {
        return this.httpWebsocketCompressionLevel;
    }

    public Collection<EaglerListenerConfig> getServerListeners() {
        return this.serverListeners.values();
    }

    public EaglerListenerConfig getServerListenersByName(String string) {
        return this.serverListeners.get(string);
    }

    public Map<String, HttpContentType> getContentType() {
        return this.contentTypes;
    }

    public Map<String, HttpContentType> getContentTypes() {
        return this.contentTypes;
    }

    public boolean getDownloadVanillaSkins() {
        return this.downloadVanillaSkins;
    }

    public Collection<String> getValidSkinUrls() {
        return this.validSkinUrls;
    }

    public boolean isValidSkinHost(String string) {
        string = string.toLowerCase();
        for (String string2 : this.validSkinUrls) {
            if (string2.length() <= 0 || !((string2 = string2.toLowerCase()).charAt(0) == '*' ? string.endsWith(string2.substring(1)) : string.equals(string2))) continue;
            return true;
        }
        return false;
    }

    public int getUuidRateLimitPlayer() {
        return this.uuidRateLimitPlayer;
    }

    public int getUuidRateLimitGlobal() {
        return this.uuidRateLimitGlobal;
    }

    public int getSkinRateLimitPlayer() {
        return this.skinRateLimitPlayer;
    }

    public int getSkinRateLimitGlobal() {
        return this.skinRateLimitGlobal;
    }

    public String getSkinCacheURI() {
        return this.skinCacheURI;
    }

    public String getSQLiteDriverClass() {
        return this.sqliteDriverClass;
    }

    public String getSQLiteDriverPath() {
        return this.sqliteDriverPath;
    }

    public int getKeepObjectsDays() {
        return this.keepObjectsDays;
    }

    public int getKeepProfilesDays() {
        return this.keepProfilesDays;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public int getMaxProfiles() {
        return this.maxProfiles;
    }

    public int getAntagonistsRateLimit() {
        return this.antagonistsRateLimit;
    }

    public String getEaglerPlayersVanillaSkin() {
        return this.eaglerPlayersVanillaSkin;
    }

    public Property[] getEaglerPlayersVanillaSkinProperties() {
        return this.eaglerPlayersVanillaSkinCached;
    }

    public boolean isCracked() {
        return true;
    }

    public EaglerAuthConfig getAuthConfig() {
        return this.authConfig;
    }

    private EaglerBungeeConfig(String string, UUID uUID, long l, long l2, int n, Map<String, EaglerListenerConfig> map, Map<String, HttpContentType> map2, boolean bl, Collection<String> collection, int n2, int n3, int n4, int n5, String string2, int n6, int n7, int n8, int n9, int n10, String string3, String string4, String string5, EaglerAuthConfig eaglerAuthConfig) {
        this.serverName = string;
        this.serverUUID = uUID;
        this.serverListeners = map;
        this.websocketHandshakeTimeout = l2;
        this.websocketKeepAliveTimeout = l;
        this.httpWebsocketCompressionLevel = n;
        this.contentTypes = map2;
        this.downloadVanillaSkins = bl;
        this.validSkinUrls = collection;
        this.uuidRateLimitPlayer = n2;
        this.uuidRateLimitGlobal = n3;
        this.skinRateLimitPlayer = n4;
        this.skinRateLimitGlobal = n5;
        this.skinCacheURI = string2;
        this.keepObjectsDays = n6;
        this.keepProfilesDays = n7;
        this.maxObjects = n8;
        this.maxProfiles = n9;
        this.antagonistsRateLimit = n10;
        this.sqliteDriverClass = string3;
        this.sqliteDriverPath = string4;
        this.eaglerPlayersVanillaSkin = string5;
        this.authConfig = eaglerAuthConfig;
    }
}

