/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.config.Configuration;

public class EaglerAuthConfig {
    private boolean enableAuthentication;
    private boolean useBuiltInAuthentication;
    private final String databaseURI;
    private final String driverClass;
    private final String driverPath;
    private final String passwordPromptScreenText;
    private final String wrongPasswordScreenText;
    private final String notRegisteredScreenText;
    private final String eaglerCommandName;
    private final String useRegisterCommandText;
    private final String useChangeCommandText;
    private final String commandSuccessText;
    private final String lastEaglerLoginMessage;
    private final String tooManyRegistrationsMessage;
    private final String needVanillaToRegisterMessage;
    private final boolean overrideEaglerToVanillaSkins;
    private final int maxRegistrationsPerIP;

    static EaglerAuthConfig loadConfig(Configuration configuration) {
        boolean bl = configuration.getBoolean("enable_authentication_system");
        boolean bl2 = configuration.getBoolean("use_onboard_eaglerx_system");
        String string = configuration.getString("auth_db_uri");
        String string2 = configuration.getString("sql_driver_class", "internal");
        String string3 = configuration.getString("sql_driver_path", null);
        String string4 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("password_prompt_screen_text", ""));
        String string5 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("not_registered_screen_text", ""));
        String string6 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("wrong_password_screen_text", ""));
        String string7 = configuration.getString("eagler_command_name");
        String string8 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("use_register_command_text", ""));
        String string9 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("use_change_command_text", ""));
        String string10 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("command_success_text", ""));
        String string11 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("last_eagler_login_message", ""));
        String string12 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("too_many_registrations_message", ""));
        String string13 = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("need_vanilla_to_register_message", ""));
        boolean bl3 = configuration.getBoolean("override_eagler_to_vanilla_skins");
        int n = configuration.getInt("max_registration_per_ip", -1);
        return new EaglerAuthConfig(bl, bl2, string, string2, string3, string4, string6, string5, string7, string8, string9, string10, string11, string12, string13, bl3, n);
    }

    private EaglerAuthConfig(boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, boolean bl3, int n) {
        this.enableAuthentication = bl;
        this.useBuiltInAuthentication = bl2;
        this.databaseURI = string;
        this.driverClass = string2;
        this.driverPath = string3;
        this.passwordPromptScreenText = string4;
        this.wrongPasswordScreenText = string5;
        this.notRegisteredScreenText = string6;
        this.eaglerCommandName = string7;
        this.useRegisterCommandText = string8;
        this.useChangeCommandText = string9;
        this.commandSuccessText = string10;
        this.lastEaglerLoginMessage = string11;
        this.tooManyRegistrationsMessage = string12;
        this.needVanillaToRegisterMessage = string13;
        this.overrideEaglerToVanillaSkins = bl3;
        this.maxRegistrationsPerIP = n;
    }

    public boolean isEnableAuthentication() {
        return this.enableAuthentication;
    }

    public boolean isUseBuiltInAuthentication() {
        return this.useBuiltInAuthentication;
    }

    public void triggerOnlineModeDisabled() {
        this.enableAuthentication = false;
        this.useBuiltInAuthentication = false;
    }

    public String getDatabaseURI() {
        return this.databaseURI;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public String getPasswordPromptScreenText() {
        return this.passwordPromptScreenText;
    }

    public String getWrongPasswordScreenText() {
        return this.wrongPasswordScreenText;
    }

    public String getNotRegisteredScreenText() {
        return this.notRegisteredScreenText;
    }

    public String getEaglerCommandName() {
        return this.eaglerCommandName;
    }

    public String getUseRegisterCommandText() {
        return this.useRegisterCommandText;
    }

    public String getUseChangeCommandText() {
        return this.useChangeCommandText;
    }

    public String getCommandSuccessText() {
        return this.commandSuccessText;
    }

    public String getLastEaglerLoginMessage() {
        return this.lastEaglerLoginMessage;
    }

    public String getTooManyRegistrationsMessage() {
        return this.tooManyRegistrationsMessage;
    }

    public String getNeedVanillaToRegisterMessage() {
        return this.needVanillaToRegisterMessage;
    }

    public boolean getOverrideEaglerToVanillaSkins() {
        return this.overrideEaglerToVanillaSkins;
    }

    public int getMaxRegistrationsPerIP() {
        return this.maxRegistrationsPerIP;
    }
}

