/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftHandleAuthPasswordEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftIsAuthRequiredEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.AuthLoadingCache;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.GeneralDigest;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.HashUtils;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.SHA256Digest;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite.EaglerDrivers;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class DefaultAuthSystem {
    protected final String uri;
    protected final Connection databaseConnection;
    protected final String passwordPromptScreenText;
    protected final String wrongPasswordScreenText;
    protected final String notRegisteredScreenText;
    protected final String eaglerCommandName;
    protected final String useRegisterCommandText;
    protected final String useChangeCommandText;
    protected final String commandSuccessText;
    protected final String lastEaglerLoginMessage;
    protected final String tooManyRegistrationsMessage;
    protected final String needVanillaToRegisterMessage;
    protected final boolean overrideEaglerToVanillaSkins;
    protected final int maxRegistrationsPerIP;
    protected final SecureRandom secureRandom;
    protected final PreparedStatement registerUser;
    protected final PreparedStatement isRegisteredUser;
    protected final PreparedStatement pruneUsers;
    protected final PreparedStatement updatePassword;
    protected final PreparedStatement updateMojangUsername;
    protected final PreparedStatement getRegistrationsOnIP;
    protected final PreparedStatement checkRegistrationByUUID;
    protected final PreparedStatement checkRegistrationByName;
    protected final PreparedStatement setLastLogin;
    protected final PreparedStatement updateTextures;
    protected final AuthLoadingCache<String, CachedAccountInfo> authLoadingCache;
    private static final String hexString = "0123456789abcdef";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DefaultAuthSystem initializeAuthSystem(EaglerAuthConfig eaglerAuthConfig) throws AuthSystemException {
        Connection connection;
        String string = eaglerAuthConfig.getDatabaseURI();
        try {
            connection = EaglerDrivers.connectToDatabase(string, eaglerAuthConfig.getDriverClass(), eaglerAuthConfig.getDriverPath(), new Properties());
            if (connection == null) {
                throw new IllegalStateException("Connection is null");
            }
        }
        catch (Throwable throwable) {
            throw new AuthSystemException("Could not initialize '" + string + "'!", throwable);
        }
        EaglerXBungee.logger().info("Connected to database: " + string);
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (Statement statement = connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_accounts\" (\"Version\"\tTINYINT NOT NULL,\"MojangUUID\"\tTEXT(32) NOT NULL,\"MojangUsername\"\tTEXT(16) NOT NULL,\"HashBase\"\tBLOB NOT NULL,\"HashSalt\"\tBLOB NOT NULL,\"MojangTextures\"\tBLOB,\"Registered\"\tDATETIME NOT NULL,\"RegisteredIP\"\tVARCHAR(42) NOT NULL,\"LastLogin\"\tDATETIME,\"LastLoginIP\"\tVARCHAR(42),PRIMARY KEY(\"MojangUUID\"))");
                statement.execute("CREATE UNIQUE INDEX IF NOT EXISTS \"MojangUsername\" ON \"eaglercraft_accounts\" (\"MojangUsername\")");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new DefaultAuthSystem(string, connection, eaglerAuthConfig.getPasswordPromptScreenText(), eaglerAuthConfig.getWrongPasswordScreenText(), eaglerAuthConfig.getNotRegisteredScreenText(), eaglerAuthConfig.getEaglerCommandName(), eaglerAuthConfig.getUseRegisterCommandText(), eaglerAuthConfig.getUseChangeCommandText(), eaglerAuthConfig.getCommandSuccessText(), eaglerAuthConfig.getLastEaglerLoginMessage(), eaglerAuthConfig.getTooManyRegistrationsMessage(), eaglerAuthConfig.getNeedVanillaToRegisterMessage(), eaglerAuthConfig.getOverrideEaglerToVanillaSkins(), eaglerAuthConfig.getMaxRegistrationsPerIP());
        }
        catch (AuthSystemException authSystemException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            throw authSystemException;
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            throw new AuthSystemException("Could not initialize '" + string + "'!", throwable);
        }
    }

    protected DefaultAuthSystem(String string, Connection connection, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, boolean bl, int n) throws SQLException {
        this.uri = string;
        this.databaseConnection = connection;
        this.passwordPromptScreenText = string2;
        this.wrongPasswordScreenText = string3;
        this.notRegisteredScreenText = string4;
        this.eaglerCommandName = string5;
        this.useRegisterCommandText = string6;
        this.useChangeCommandText = string7;
        this.commandSuccessText = string8;
        this.lastEaglerLoginMessage = string9;
        this.tooManyRegistrationsMessage = string10;
        this.needVanillaToRegisterMessage = string11;
        this.overrideEaglerToVanillaSkins = bl;
        this.maxRegistrationsPerIP = n;
        this.registerUser = connection.prepareStatement("INSERT INTO eaglercraft_accounts (Version, MojangUUID, MojangUsername, MojangTextures, HashBase, HashSalt, Registered, RegisteredIP) VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
        this.isRegisteredUser = connection.prepareStatement("SELECT COUNT(MojangUUID) AS total_accounts FROM eaglercraft_accounts WHERE MojangUUID = ?");
        this.pruneUsers = connection.prepareStatement("DELETE FROM eaglercraft_accounts WHERE LastLogin < ?");
        this.updatePassword = connection.prepareStatement("UPDATE eaglercraft_accounts SET HashBase = ?, HashSalt = ? WHERE MojangUUID = ?");
        this.updateMojangUsername = connection.prepareStatement("UPDATE eaglercraft_accounts SET MojangUsername = ? WHERE MojangUUID = ?");
        this.getRegistrationsOnIP = connection.prepareStatement("SELECT COUNT(MojangUUID) AS total_accounts FROM eaglercraft_accounts WHERE RegisteredIP = ?");
        this.checkRegistrationByUUID = connection.prepareStatement("SELECT Version, MojangUsername, LastLogin, LastLoginIP FROM eaglercraft_accounts WHERE MojangUUID = ?");
        this.checkRegistrationByName = connection.prepareStatement("SELECT Version, MojangUUID, MojangTextures, HashBase, HashSalt, Registered, RegisteredIP, LastLogin, LastLoginIP FROM eaglercraft_accounts WHERE MojangUsername = ?");
        this.setLastLogin = connection.prepareStatement("UPDATE eaglercraft_accounts SET LastLogin = ?, LastLoginIP = ? WHERE MojangUUID = ?");
        this.updateTextures = connection.prepareStatement("UPDATE eaglercraft_accounts SET MojangTextures = ? WHERE MojangUUID = ?");
        this.authLoadingCache = new AuthLoadingCache<String, CachedAccountInfo>(new AccountLoader(), 120000L);
        this.secureRandom = new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIsAuthRequiredEvent(EaglercraftIsAuthRequiredEvent eaglercraftIsAuthRequiredEvent) {
        Random random;
        String string = new String(eaglercraftIsAuthRequiredEvent.getAuthUsername(), StandardCharsets.US_ASCII);
        String string2 = string.toString();
        if (!string2.equals(string2.replaceAll("[^A-Za-z0-9_]", "_").trim())) {
            eaglercraftIsAuthRequiredEvent.kickUser("Invalid characters in username");
            return;
        }
        if (string.length() < 3) {
            eaglercraftIsAuthRequiredEvent.kickUser("Username must be at least 3 characters");
            return;
        }
        if (string.length() > 16) {
            eaglercraftIsAuthRequiredEvent.kickUser("Username must be under 16 characters");
            return;
        }
        CachedAccountInfo cachedAccountInfo = this.authLoadingCache.get(string);
        if (cachedAccountInfo == null) {
            eaglercraftIsAuthRequiredEvent.kickUser(this.notRegisteredScreenText);
            return;
        }
        eaglercraftIsAuthRequiredEvent.setAuthAttachment(cachedAccountInfo);
        eaglercraftIsAuthRequiredEvent.setAuthRequired(EaglercraftIsAuthRequiredEvent.AuthResponse.REQUIRE);
        eaglercraftIsAuthRequiredEvent.setAuthMessage(this.passwordPromptScreenText);
        eaglercraftIsAuthRequiredEvent.setUseAuthMethod(EaglercraftIsAuthRequiredEvent.AuthMethod.EAGLER_SHA256);
        byte[] byArray = new byte[32];
        Object object = this.secureRandom;
        synchronized (object) {
            random = new Random(this.secureRandom.nextLong());
        }
        random.nextBytes(byArray);
        object = new byte[64];
        System.arraycopy(cachedAccountInfo.hashSalt, 0, object, 0, 32);
        System.arraycopy(byArray, 0, object, 32, 32);
        eaglercraftIsAuthRequiredEvent.setSaltingData((byte[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAuthPasswordEvent(EaglercraftHandleAuthPasswordEvent eaglercraftHandleAuthPasswordEvent) {
        Object object;
        CachedAccountInfo cachedAccountInfo = (CachedAccountInfo)eaglercraftHandleAuthPasswordEvent.getAuthAttachment();
        if (cachedAccountInfo == null) {
            eaglercraftHandleAuthPasswordEvent.setLoginDenied(this.notRegisteredScreenText);
            return;
        }
        byte[] byArray = eaglercraftHandleAuthPasswordEvent.getAuthPasswordDataResponse();
        if (byArray.length != 32) {
            eaglercraftHandleAuthPasswordEvent.setLoginDenied("Wrong number of bits in checksum!");
            return;
        }
        byte[] byArray2 = eaglercraftHandleAuthPasswordEvent.getAuthSaltingData();
        SHA256Digest sHA256Digest = new SHA256Digest();
        sHA256Digest.update(cachedAccountInfo.hashBase, 0, 32);
        sHA256Digest.update(byArray2, 32, 32);
        sHA256Digest.update(HashUtils.EAGLER_SHA256_SALT_BASE, 0, 32);
        byte[] byArray3 = new byte[32];
        sHA256Digest.doFinal(byArray3, 0);
        if (!Arrays.equals(byArray3, byArray)) {
            eaglercraftHandleAuthPasswordEvent.setLoginDenied(this.wrongPasswordScreenText);
            EaglerXBungee.logger().warning("User \"" + cachedAccountInfo.mojangUsername + "\" entered the wrong password while logging in from: " + eaglercraftHandleAuthPasswordEvent.getRemoteAddress().getHostAddress());
            return;
        }
        try {
            object = this.setLastLogin;
            synchronized (object) {
                this.setLastLogin.setDate(1, new Date(System.currentTimeMillis()));
                this.setLastLogin.setString(2, eaglercraftHandleAuthPasswordEvent.getRemoteAddress().getHostAddress());
                this.setLastLogin.setString(3, DefaultAuthSystem.getMojangUUID(cachedAccountInfo.mojangUUID));
                if (this.setLastLogin.executeUpdate() == 0) {
                    throw new SQLException("Query did not alter the database");
                }
            }
        }
        catch (SQLException sQLException) {
            EaglerXBungee.logger().log(Level.SEVERE, "Could not update last login for \"" + cachedAccountInfo.mojangUUID.toString() + "\"", sQLException);
        }
        eaglercraftHandleAuthPasswordEvent.setLoginAllowed();
        eaglercraftHandleAuthPasswordEvent.setProfileUsername(cachedAccountInfo.mojangUsername);
        eaglercraftHandleAuthPasswordEvent.setProfileUUID(cachedAccountInfo.mojangUUID);
        object = cachedAccountInfo.texturesProperty;
        if (object != null) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                byte[] byArray4 = new byte[n];
                dataInputStream.read(byArray4);
                String string = Base64.encodeBase64String((byte[])byArray4);
                String string2 = null;
                if (n2 > 0) {
                    byArray4 = new byte[n2];
                    dataInputStream.read(byArray4);
                    string2 = Base64.encodeBase64String((byte[])byArray4);
                }
                eaglercraftHandleAuthPasswordEvent.applyTexturesProperty(string, string2);
                eaglercraftHandleAuthPasswordEvent.setOverrideEaglerToVanillaSkins(this.overrideEaglerToVanillaSkins);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSetPassword(ProxiedPlayer proxiedPlayer, String string) throws TooManyRegisteredOnIPException, AuthException {
        PendingConnection pendingConnection = proxiedPlayer.getPendingConnection();
        if (pendingConnection instanceof EaglerInitialHandler) {
            throw new AuthException("Cannot register from an eaglercraft account!");
        }
        if (!pendingConnection.isOnlineMode()) {
            throw new AuthException("Cannot register without online mode enabled!");
        }
        try {
            String string2 = DefaultAuthSystem.getMojangUUID(proxiedPlayer.getUniqueId());
            PreparedStatement preparedStatement = this.registerUser;
            synchronized (preparedStatement) {
                int n;
                Object object = this.isRegisteredUser;
                synchronized (object) {
                    block34: {
                        this.isRegisteredUser.setString(1, string2);
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (ResultSet resultSet = this.isRegisteredUser.executeQuery();){
                            if (resultSet.next()) {
                                n = resultSet.getInt(1);
                                break block34;
                            }
                            throw new SQLException("Empty ResultSet recieved while checking if user exists");
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                object = new SHA256Digest();
                int n2 = string.length();
                ((GeneralDigest)object).update((byte)(n2 >> 8 & 0xFF));
                ((GeneralDigest)object).update((byte)(n2 & 0xFF));
                int n3 = 0;
                while (n3 < n2) {
                    char c = string.charAt(n3);
                    ((GeneralDigest)object).update((byte)(c >> 8 & 0xFF));
                    ((GeneralDigest)object).update((byte)(c & 0xFF));
                    ++n3;
                }
                ((GeneralDigest)object).update(HashUtils.EAGLER_SHA256_SALT_SAVE, 0, 32);
                byte[] byArray = new byte[32];
                ((SHA256Digest)object).doFinal(byArray, 0);
                byte[] byArray2 = new byte[32];
                Object object2 = this.secureRandom;
                synchronized (object2) {
                    this.secureRandom.nextBytes(byArray2);
                }
                ((SHA256Digest)object).reset();
                ((GeneralDigest)object).update(byArray, 0, 32);
                ((GeneralDigest)object).update(byArray2, 0, 32);
                ((GeneralDigest)object).update(HashUtils.EAGLER_SHA256_SALT_BASE, 0, 32);
                ((SHA256Digest)object).doFinal(byArray, 0);
                object2 = proxiedPlayer.getName();
                this.authLoadingCache.evict((String)object2);
                if (n > 0) {
                    PreparedStatement preparedStatement2 = this.updatePassword;
                    synchronized (preparedStatement2) {
                        this.updatePassword.setBytes(1, byArray);
                        this.updatePassword.setBytes(2, byArray2);
                        this.updatePassword.setString(3, string2);
                        if (this.updatePassword.executeUpdate() <= 0) {
                            throw new AuthException("Update password query did not alter the database!");
                        }
                    }
                } else {
                    String string3 = DefaultAuthSystem.sockAddrToString(proxiedPlayer.getSocketAddress());
                    if (this.maxRegistrationsPerIP > 0 && this.countUsersOnIP(string3) >= this.maxRegistrationsPerIP) {
                        throw new TooManyRegisteredOnIPException(string3);
                    }
                    Date date = new Date(System.currentTimeMillis());
                    this.registerUser.setInt(1, 1);
                    this.registerUser.setString(2, string2);
                    this.registerUser.setString(3, (String)object2);
                    LoginResult loginResult = ((InitialHandler)proxiedPlayer.getPendingConnection()).getLoginProfile();
                    if (loginResult != null) {
                        this.registerUser.setBytes(4, DefaultAuthSystem.getTexturesProperty(loginResult));
                    } else {
                        this.registerUser.setBytes(4, null);
                    }
                    this.registerUser.setBytes(5, byArray);
                    this.registerUser.setBytes(6, byArray2);
                    this.registerUser.setDate(7, date);
                    this.registerUser.setString(8, string3);
                    if (this.registerUser.executeUpdate() <= 0) {
                        throw new AuthException("Registration query did not alter the database!");
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AuthException("Failed to query database!", sQLException);
        }
    }

    private static byte[] getTexturesProperty(LoginResult loginResult) {
        try {
            Property[] propertyArray = loginResult.getProperties();
            int n = 0;
            while (n < propertyArray.length) {
                Property property = propertyArray[n];
                if ("textures".equals(property.getName())) {
                    byte[] byArray = Base64.decodeBase64((String)property.getValue());
                    byte[] byArray2 = property.getSignature() == null ? new byte[]{} : Base64.decodeBase64((String)property.getSignature());
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.writeInt(byArray2.length);
                    dataOutputStream.write(byArray);
                    dataOutputStream.write(byArray2);
                    return byteArrayOutputStream.toByteArray();
                }
                ++n;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pruneUsers(long l) throws AuthException {
        try {
            this.authLoadingCache.flush();
            PreparedStatement preparedStatement = this.pruneUsers;
            synchronized (preparedStatement) {
                this.pruneUsers.setDate(1, new Date(l));
                return this.pruneUsers.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            throw new AuthException("Failed to query database!", sQLException);
        }
    }

    public int countUsersOnIP(String string) throws AuthException {
        PreparedStatement preparedStatement = this.getRegistrationsOnIP;
        synchronized (preparedStatement) {
            try {
                this.getRegistrationsOnIP.setString(1, string);
                Throwable throwable = null;
                Object var4_6 = null;
                try (ResultSet resultSet = this.getRegistrationsOnIP.executeQuery();){
                    if (resultSet.next()) {
                        return resultSet.getInt(1);
                    }
                    throw new SQLException("Empty ResultSet recieved while counting accounts");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                throw new AuthException("Failed to query database!", sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVanillaLogin(PostLoginEvent postLoginEvent) {
        ProxiedPlayer proxiedPlayer = postLoginEvent.getPlayer();
        PendingConnection pendingConnection = proxiedPlayer.getPendingConnection();
        if (!(pendingConnection instanceof EaglerInitialHandler)) {
            PreparedStatement preparedStatement;
            Object object;
            Comparable<UUID> comparable;
            java.util.Date date = null;
            String string = null;
            boolean bl = false;
            Object object2 = this.checkRegistrationByUUID;
            synchronized (object2) {
                block26: {
                    comparable = proxiedPlayer.getUniqueId();
                    try {
                        Object object3;
                        block25: {
                            object = DefaultAuthSystem.getMojangUUID((UUID)comparable);
                            this.checkRegistrationByUUID.setString(1, DefaultAuthSystem.getMojangUUID(proxiedPlayer.getUniqueId()));
                            object3 = null;
                            preparedStatement = null;
                            try (ResultSet resultSet = this.checkRegistrationByUUID.executeQuery();){
                                if (!resultSet.next()) break block25;
                                bl = true;
                                resultSet.getInt(1);
                                String string2 = resultSet.getString(2);
                                date = resultSet.getDate(3);
                                string = resultSet.getString(4);
                                String string3 = proxiedPlayer.getName();
                                if (string3.equals(string2)) break block25;
                                EaglerXBungee.logger().info("Player \"" + ((UUID)comparable).toString() + "\" changed their username from \"" + string2 + " to \"" + string3 + "\", updating authentication database...");
                                PreparedStatement preparedStatement2 = this.updateMojangUsername;
                                synchronized (preparedStatement2) {
                                    this.updateMojangUsername.setString(1, string3);
                                    this.updateMojangUsername.setString(2, (String)object);
                                    if (this.updateMojangUsername.executeUpdate() == 0) {
                                        throw new SQLException("Failed to update username to \"" + string3 + "\"");
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (object3 == null) {
                                    object3 = throwable;
                                } else if (object3 != throwable) {
                                    ((Throwable)object3).addSuppressed(throwable);
                                }
                                throw object3;
                            }
                        }
                        object3 = DefaultAuthSystem.getTexturesProperty(((InitialHandler)pendingConnection).getLoginProfile());
                        if (object3 == null) break block26;
                        preparedStatement = this.updateTextures;
                        synchronized (preparedStatement) {
                            this.updateTextures.setBytes(1, (byte[])object3);
                            this.updateTextures.setString(2, (String)object);
                            this.updateTextures.executeUpdate();
                        }
                    }
                    catch (SQLException sQLException) {
                        EaglerXBungee.logger().log(Level.SEVERE, "Could not look up UUID \"" + ((UUID)comparable).toString() + "\" in auth database!", sQLException);
                    }
                }
            }
            if (bl) {
                if (date != null) {
                    comparable = new java.util.Date(date.getTime());
                    object = Calendar.getInstance();
                    int n = ((Calendar)object).get(1);
                    ((Calendar)object).setTime((java.util.Date)comparable);
                    object2 = ((Calendar)object).get(1) != n ? new SimpleDateFormat("EE, MMM d, yyyy, HH:mm z").format((java.util.Date)comparable) : new SimpleDateFormat("EE, MMM d, HH:mm z").format((java.util.Date)comparable);
                    preparedStatement = new TextComponent(this.lastEaglerLoginMessage.replace("$date", (CharSequence)object2).replace("$ip", string));
                    preparedStatement.setColor(ChatColor.GREEN);
                    proxiedPlayer.sendMessage((BaseComponent)preparedStatement);
                }
                proxiedPlayer.sendMessage((BaseComponent)new TextComponent(this.useChangeCommandText));
            } else {
                proxiedPlayer.sendMessage((BaseComponent)new TextComponent(this.useRegisterCommandText));
            }
        }
    }

    private void destroyStatement(Statement statement) {
        try {
            statement.close();
        }
        catch (SQLException sQLException) {}
    }

    public void flush() {
        this.authLoadingCache.flush();
    }

    public void destroy() {
        this.destroyStatement(this.registerUser);
        this.destroyStatement(this.isRegisteredUser);
        this.destroyStatement(this.pruneUsers);
        this.destroyStatement(this.updatePassword);
        this.destroyStatement(this.updateMojangUsername);
        this.destroyStatement(this.getRegistrationsOnIP);
        this.destroyStatement(this.checkRegistrationByUUID);
        this.destroyStatement(this.checkRegistrationByName);
        this.destroyStatement(this.setLastLogin);
        this.destroyStatement(this.updateTextures);
        try {
            this.databaseConnection.close();
            EaglerXBungee.logger().info("Successfully disconnected from database '" + this.uri + "'");
        }
        catch (SQLException sQLException) {
            EaglerXBungee.logger().log(Level.WARNING, "Exception disconnecting from database '" + this.uri + "'!", sQLException);
        }
    }

    public static String getMojangUUID(UUID uUID) {
        char[] cArray = new char[32];
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        int n = 0;
        while (n < 16) {
            int n2 = 15 - n << 2;
            cArray[n] = HEX[(int)(l >> n2 & 0xFL)];
            cArray[n + 16] = HEX[(int)(l2 >> n2 & 0xFL)];
            ++n;
        }
        return new String(cArray);
    }

    public static UUID parseMojangUUID(String string) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < 16) {
            int n2 = 15 - n << 2;
            l |= (long)hexString.indexOf(string.charAt(n)) << n2;
            l2 |= (long)hexString.indexOf(string.charAt(n + 16)) << n2;
            ++n;
        }
        return new UUID(l, l2);
    }

    private static String sockAddrToString(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
        }
        return "127.0.0.1";
    }

    protected class AccountLoader
    implements AuthLoadingCache.CacheLoader<String, CachedAccountInfo> {
        protected AccountLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CachedAccountInfo load(String string) {
            try {
                CachedAccountInfo cachedAccountInfo = null;
                PreparedStatement preparedStatement = DefaultAuthSystem.this.checkRegistrationByName;
                synchronized (preparedStatement) {
                    DefaultAuthSystem.this.checkRegistrationByName.setString(1, string);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (ResultSet resultSet = DefaultAuthSystem.this.checkRegistrationByName.executeQuery();){
                        if (resultSet.next()) {
                            cachedAccountInfo = new CachedAccountInfo(resultSet.getInt(1), DefaultAuthSystem.parseMojangUUID(resultSet.getString(2)), string, resultSet.getBytes(3), resultSet.getBytes(4), resultSet.getBytes(5), resultSet.getDate(6), resultSet.getString(7), resultSet.getDate(8), resultSet.getString(9));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                return cachedAccountInfo;
            }
            catch (SQLException sQLException) {
                throw new AuthException("Failed to query database!", sQLException);
            }
        }
    }

    public static class AuthException
    extends RuntimeException {
        public AuthException(String string) {
            super(string);
        }

        public AuthException(Throwable throwable) {
            super(throwable);
        }

        public AuthException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class AuthSystemException
    extends RuntimeException {
        public AuthSystemException() {
        }

        public AuthSystemException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public AuthSystemException(String string) {
            super(string);
        }

        public AuthSystemException(Throwable throwable) {
            super(throwable);
        }
    }

    protected class CachedAccountInfo {
        protected int version;
        protected UUID mojangUUID;
        protected String mojangUsername;
        protected byte[] texturesProperty;
        protected byte[] hashBase;
        protected byte[] hashSalt;
        protected long registered;
        protected String registeredIP;
        protected long lastLogin;
        protected String lastLoginIP;

        protected CachedAccountInfo(int n, UUID uUID, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, Date date, String string2, Date date2, String string3) {
            this(n, uUID, string, byArray, byArray2, byArray3, date == null ? 0L : date.getTime(), string2, date2 == null ? 0L : date2.getTime(), string3);
        }

        protected CachedAccountInfo(int n, UUID uUID, String string, byte[] byArray, byte[] byArray2, byte[] byArray3, long l, String string2, long l2, String string3) {
            this.version = n;
            this.mojangUUID = uUID;
            this.mojangUsername = string;
            this.texturesProperty = byArray;
            this.hashBase = byArray2;
            this.hashSalt = byArray3;
            this.registered = l;
            this.registeredIP = string2;
            this.lastLogin = l2;
            this.lastLoginIP = string3;
        }
    }

    public static class TooManyRegisteredOnIPException
    extends AuthException {
        public TooManyRegisteredOnIPException(String string) {
            super(string);
        }
    }
}

