/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class OpenGLEnumManager {
    private static boolean hasLoaded = false;
    public static final Set<String> classNames = new HashSet<String>();
    public static final Map<String, String> enumsForGLStateManager = new HashMap<String, String>();
    public static final Map<String, Map<Integer, String>> enumsForFunctionKV = new HashMap<String, Map<Integer, String>>();
    public static final Map<String, Map<String, Integer>> enumsForFunctionVK = new HashMap<String, Map<String, Integer>>();

    public static boolean loadEnumMap() {
        if (hasLoaded) {
            return true;
        }
        hasLoaded = true;
        try {
            List enumData232;
            String jsonData;
            Object is;
            String enumsPath = "/lang/enums.json";
            System.out.println("Loading OpenGL enums: " + enumsPath);
            int fcnt = 0;
            int ecnt = 0;
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                is = OpenGLEnumManager.class.getResourceAsStream(enumsPath);
                try {
                    if (is == null) {
                        throw new FileNotFoundException("classpath:/" + enumsPath);
                    }
                    jsonData = IOUtils.toString((InputStream)is, "UTF-8");
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            JSONArray enumJSON = new JSONObject(jsonData).getJSONArray("enums");
            for (Object e : enumJSON.toList()) {
                enumData232 = (List)e;
                ArrayList<String> functionsToAdd = new ArrayList<String>();
                HashMap<Integer, String> enumsToAddKV = new HashMap<Integer, String>();
                HashMap<String, Integer> enumsToAddVK = new HashMap<String, Integer>();
                Map functionSet = (Map)enumData232.get(0);
                for (Map.Entry etr : functionSet.entrySet()) {
                    classNames.add((String)etr.getKey());
                    List functionArr = (List)etr.getValue();
                    for (Object func : functionArr) {
                        functionsToAdd.add(String.valueOf((String)etr.getKey()) + "." + (String)func);
                    }
                }
                Map enumSet = (Map)enumData232.get(1);
                for (Map.Entry etr : enumSet.entrySet()) {
                    Map enumEnums = (Map)etr.getValue();
                    for (Map.Entry etr2 : enumEnums.entrySet()) {
                        Integer intg = Integer.parseInt((String)etr2.getKey());
                        enumsToAddKV.put(intg, (String)etr2.getValue());
                        enumsToAddVK.put((String)etr2.getValue(), intg);
                        ++ecnt;
                    }
                }
                for (String fn : functionsToAdd) {
                    if (enumsForFunctionKV.containsKey(fn)) continue;
                    ++fcnt;
                    enumsForFunctionKV.put(fn, enumsToAddKV);
                    enumsForFunctionVK.put(fn, enumsToAddVK);
                }
            }
            String string = "/lang/statemgr.json";
            System.out.println("Loading OpenGL enums: " + string);
            is = null;
            enumData232 = null;
            try (InputStream is2 = OpenGLEnumManager.class.getResourceAsStream(string);){
                if (is2 == null) {
                    throw new FileNotFoundException("classpath:/" + string);
                }
                jsonData = IOUtils.toString(is2, "UTF-8");
            }
            catch (Throwable enumData232) {
                if (is == null) {
                    is = enumData232;
                } else if (is != enumData232) {
                    ((Throwable)is).addSuppressed(enumData232);
                }
                throw is;
            }
            JSONObject enumStateJSON = new JSONObject(jsonData).getJSONObject("statemgr_mappings");
            for (Map.Entry<String, Object> etr : enumStateJSON.toMap().entrySet()) {
                String f = etr.getKey();
                String m = (String)etr.getValue();
                enumsForGLStateManager.put(f, m);
                if (enumsForFunctionKV.containsKey(f) || !enumsForFunctionKV.containsKey(m)) continue;
                enumsForFunctionKV.put(f, enumsForFunctionKV.get(m));
                enumsForFunctionVK.put(f, enumsForFunctionVK.get(m));
                ++fcnt;
            }
            for (String str : enumsForGLStateManager.keySet()) {
                int idx = str.indexOf(46);
                if (idx == -1) continue;
                classNames.add(str.substring(0, idx));
            }
            System.out.println("Loaded " + ecnt + " enums for " + fcnt + " functions");
            return true;
        }
        catch (Throwable ex) {
            System.err.println("ERROR: could not load opengl enum map!");
            ex.printStackTrace();
            return false;
        }
    }

    public static String insertIntoLine(String input, Consumer<Integer> progressCallback) {
        String fn;
        int idx2;
        String pfx;
        String p2;
        int idx1 = input.indexOf(46);
        if (idx1 != -1 && classNames.contains(p2 = (pfx = input.substring(0, idx1)).trim()) && (idx2 = (fn = input.substring(idx1 + 1)).indexOf(40)) != -1) {
            String argz = fn.substring(idx2 + 1);
            fn = fn.substring(0, idx2);
            int idx3 = argz.lastIndexOf(41);
            String pofx = "";
            if (idx3 == -1) {
                idx3 = argz.length();
            } else {
                pofx = argz.substring(idx3);
            }
            Map<Integer, String> repValues = enumsForFunctionKV.get(String.valueOf(p2) + "." + fn);
            if (repValues != null) {
                argz = argz.substring(0, idx3);
                CharSequence[] args = argz.split(", ");
                int cnt = 0;
                int i = 0;
                while (i < args.length) {
                    block10: {
                        Integer j;
                        try {
                            j = Integer.valueOf(args[i]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block10;
                        }
                        String estr = repValues.get(j);
                        if (estr != null) {
                            args[i] = estr;
                            ++cnt;
                        }
                    }
                    ++i;
                }
                if (cnt > 0) {
                    input = String.valueOf(pfx) + "." + fn + "(" + String.join((CharSequence)", ", args) + pofx;
                    if (progressCallback != null) {
                        progressCallback.accept(cnt);
                    }
                }
            }
        }
        return input;
    }

    public static String stripFromLine(String input) {
        String fn;
        int idx2;
        String pfx;
        String p2;
        int idx1 = input.indexOf(46);
        if (idx1 != -1 && classNames.contains(p2 = (pfx = input.substring(0, idx1)).trim()) && (idx2 = (fn = input.substring(idx1 + 1)).indexOf(40)) != -1) {
            String argz = fn.substring(idx2 + 1);
            fn = fn.substring(0, idx2);
            int idx3 = argz.lastIndexOf(41);
            String pofx = "";
            if (idx3 == -1) {
                idx3 = argz.length();
            } else {
                pofx = argz.substring(idx3);
            }
            Map<String, Integer> repValues = enumsForFunctionVK.get(String.valueOf(p2) + "." + fn);
            if (repValues != null) {
                argz = argz.substring(0, idx3);
                CharSequence[] args = argz.split(", ");
                int cnt = 0;
                int i = 0;
                while (i < args.length) {
                    Integer estr = repValues.get(args[i]);
                    if (estr != null) {
                        args[i] = estr.toString();
                        ++cnt;
                    }
                    ++i;
                }
                if (cnt > 0) {
                    return String.valueOf(pfx) + "." + fn + "(" + String.join((CharSequence)", ", args) + pofx;
                }
            }
        }
        return null;
    }
}

