/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.FFMPEG;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.ResourceRulesList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadResources {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadResources(File minecraftJarIn, File assetsIndexIn, File assetsJarOut, File tmpDir, File languagesZipOut) {
        System.out.println("Copying resources from '" + minecraftJarIn.getName() + "' into '" + assetsJarOut.getName() + "'");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(assetsJarOut));){
                ZipOutputStream os2;
                ResourceRulesList rules;
                os.setLevel(5);
                os.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                os.write("Manifest-Version: 1.0\nCreated-By: Eaglercraft BuildTools\n".getBytes(StandardCharsets.UTF_8));
                Throwable throwable2 = null;
                Throwable throwable3 = null;
                try (ZipInputStream is = new ZipInputStream(new FileInputStream(minecraftJarIn));){
                    ZipEntry e;
                    while ((e = is.getNextEntry()) != null) {
                        if (e.isDirectory()) continue;
                        String zn = e.getName();
                        if (zn.startsWith("/")) {
                            zn = zn.substring(1);
                        }
                        if (zn.startsWith("META-INF") || zn.endsWith(".class")) continue;
                        os.putNextEntry(e);
                        IOUtils.copy((InputStream)is, (OutputStream)os, 4096);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
                System.out.println();
                System.out.println("Reading 'assetsIndexTransformer.json'...");
                try {
                    rules = ResourceRulesList.loadResourceRules(new File(EaglerBuildTools.repositoryRoot, "mcp918/assetsIndexTransformer.json"));
                }
                catch (IOException ex) {
                    System.err.println();
                    System.err.println("ERROR: failed to read 'mcp918/assetsIndexTransformer.json'!");
                    ex.printStackTrace();
                    if (os == null) return false;
                    os.close();
                    return false;
                }
                System.out.println();
                System.out.println("Reading asset index '" + assetsIndexIn.getAbsolutePath() + "'...");
                throwable3 = null;
                Object var10_17 = null;
                try {
                    os2 = new ZipOutputStream(new FileOutputStream(languagesZipOut));
                    try {
                        os2.setLevel(5);
                        try {
                            JSONObject json = new JSONObject(FileUtils.readFileToString(assetsIndexIn, StandardCharsets.UTF_8)).getJSONObject("objects");
                            Iterator<String> itr = json.keys();
                            System.out.println("Downloading assets from 'https://resources.download.minecraft.net/'...");
                            while (itr.hasNext()) {
                                byte[] downloadedFile;
                                String name;
                                block54: {
                                    ResourceRulesList.ResourceRule r;
                                    block53: {
                                        URL url;
                                        name = itr.next();
                                        JSONObject obj = json.getJSONObject(name);
                                        r = rules.get(name);
                                        if (r.action == ResourceRulesList.Action.EXCLUDE) {
                                            System.out.println("Skipping file '" + name + "'");
                                            continue;
                                        }
                                        String hash = obj.getString("hash");
                                        int len = obj.getInt("size");
                                        System.out.println("Downloading '" + name + "' (" + LoadResources.formatByteLength(len) + ") ...");
                                        try {
                                            url = new URL("https://resources.download.minecraft.net/" + hash.substring(0, 2) + "/" + hash);
                                        }
                                        catch (MalformedURLException ex) {
                                            System.err.println("Resource file '" + name + "' had an invalid URL!");
                                            ex.printStackTrace();
                                            continue;
                                        }
                                        downloadedFile = new byte[len];
                                        try {
                                            Throwable throwable5 = null;
                                            Object var22_36 = null;
                                            try (InputStream is = url.openStream();){
                                                String string;
                                                StringBuilder stringBuilder;
                                                int dl = 0;
                                                int i = 0;
                                                while (true) {
                                                    if (dl == len || (i = is.read(downloadedFile, dl, len - dl)) <= 0) {
                                                        int a = is.available();
                                                        if (dl != len || a > 0) {
                                                            stringBuilder = new StringBuilder("File '").append(url.toString()).append("' was the wrong length! ");
                                                            if (a <= 0) break;
                                                            string = a + " bytes remaining";
                                                            throw new IOException(stringBuilder.append(string).toString());
                                                        }
                                                        break block53;
                                                    }
                                                    dl += i;
                                                }
                                                string = len - dl + " bytes missing";
                                                throw new IOException(stringBuilder.append(string).toString());
                                            }
                                            catch (Throwable throwable6) {
                                                if (throwable5 == null) {
                                                    throwable5 = throwable6;
                                                    throw throwable5;
                                                }
                                                if (throwable5 == throwable6) throw throwable5;
                                                throwable5.addSuppressed(throwable6);
                                                throw throwable5;
                                            }
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Resource file '" + url.toString() + "' could not be downloaded!");
                                            ex.printStackTrace();
                                            continue;
                                        }
                                    }
                                    if (r.action == ResourceRulesList.Action.ENCODE) {
                                        try {
                                            System.out.println(" - encoding ogg: " + r.ffmpegSamples / 1000 + "kHz, " + r.ffmpegBitrate + "kbps, " + (r.ffmpegStereo ? "stereo" : "mono"));
                                            downloadedFile = FFMPEG.encodeOgg(tmpDir, downloadedFile, r.ffmpegSamples, r.ffmpegBitrate, r.ffmpegStereo);
                                            break block54;
                                        }
                                        catch (IOException ex) {
                                            System.err.println("Resource file '" + name + "' could not be encoded!");
                                            ex.printStackTrace();
                                            continue;
                                        }
                                    }
                                    if (r.action == ResourceRulesList.Action.LANGUAGES_ZIP) {
                                        int j = name.lastIndexOf(47);
                                        if (j != -1) {
                                            name = name.substring(j + 1);
                                        }
                                        System.out.println(" - writing language '" + name + "' to '" + languagesZipOut.getName() + "'");
                                        os2.putNextEntry(new ZipEntry(name));
                                        os2.write(downloadedFile);
                                        continue;
                                    }
                                }
                                os.putNextEntry(new ZipEntry("assets/" + name));
                                os.write(downloadedFile);
                            }
                        }
                        catch (IOException | JSONException ex) {
                            System.err.println("ERROR: failed to download additional assets from '" + assetsIndexIn.getName() + "'!");
                            ex.printStackTrace();
                            if (os2 != null) {
                                os2.close();
                            }
                            if (os == null) return false;
                            os.close();
                            return false;
                        }
                    }
                    catch (Throwable throwable7) {
                        if (os2 == null) throw throwable7;
                        os2.close();
                        throw throwable7;
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable3 == null) {
                        throwable3 = throwable8;
                        throw throwable3;
                    }
                    if (throwable3 == throwable8) throw throwable3;
                    throwable3.addSuppressed(throwable8);
                    throw throwable3;
                }
                if (os2 == null) return true;
                os2.close();
                return true;
            }
            catch (Throwable throwable9) {
                if (throwable == null) {
                    throwable = throwable9;
                    throw throwable;
                }
                if (throwable == throwable9) throw throwable;
                throwable.addSuppressed(throwable9);
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.err.println("ERROR: failed to copy from '" + minecraftJarIn.getName() + "' -> '" + assetsJarOut.getName() + "'!");
            ex.printStackTrace();
            return false;
        }
    }

    private static String formatByteLength(int len) {
        if (len < 4096) {
            return "" + len;
        }
        if (len < 0x400000) {
            return len / 1024 + "k";
        }
        return len / 1024 / 1024 + "M";
    }
}

