/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.CSVMappings;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.GenerateEXCs;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.GenerateSRGs;
import org.apache.commons.io.IOUtils;

public class InitMCP {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean initTask(File f, File mcpDataTMP) throws Throwable {
        boolean[] configFound;
        String[] configToCopy;
        boolean[] jarsFound;
        String[] jarsToUnify;
        block38: {
            File mcpUnifiedJar = new File(mcpDataTMP, "runtime.jar");
            jarsToUnify = new String[]{"mcinjector.jar", "specialsource.jar"};
            jarsFound = new boolean[jarsToUnify.length];
            configToCopy = new String[]{"exceptor.json", "fields.csv", "joined.exc", "joined.srg", "methods.csv", "params.csv", "fernflower.jar"};
            configFound = new boolean[configToCopy.length];
            HashSet<String> copiedFiles = new HashSet<String>();
            System.out.println();
            System.out.println("Extracting \"" + f.getAbsolutePath() + "\" to \"" + mcpDataTMP.getAbsolutePath() + "\"...");
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try {
                    ZipInputStream is = new ZipInputStream(new FileInputStream(f));
                    try {
                        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(mcpUnifiedJar));){
                            ZipEntry e;
                            os.setLevel(0);
                            os.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                            os.write("Manifest-Version: 1.0\nCreated-By: Eaglercraft BuildTools\n".getBytes(StandardCharsets.UTF_8));
                            block14: while ((e = is.getNextEntry()) != null) {
                                String zn = e.getName();
                                if (zn.startsWith("/")) {
                                    zn = zn.substring(1);
                                }
                                int ii = 0;
                                while (true) {
                                    if (ii >= jarsToUnify.length) {
                                        ii = 0;
                                        break;
                                    }
                                    if (zn.endsWith(jarsToUnify[ii])) {
                                        System.out.println("   " + jarsToUnify[ii] + " -> " + mcpUnifiedJar.getName());
                                        ZipInputStream iis = new ZipInputStream(is);
                                        while (true) {
                                            String n;
                                            int i;
                                            ZipEntry e2;
                                            if ((e2 = iis.getNextEntry()) == null) {
                                                jarsFound[ii] = true;
                                                continue block14;
                                            }
                                            if (e2.isDirectory() || (i = (n = e2.getName()).indexOf("META-INF")) == 0 || i == 1 || !copiedFiles.add(n)) continue;
                                            ZipEntry e3 = new ZipEntry(e2.getName());
                                            os.putNextEntry(e3);
                                            IOUtils.copy((InputStream)iis, (OutputStream)os, 4096);
                                        }
                                    }
                                    ++ii;
                                }
                                while (ii < configToCopy.length) {
                                    if (zn.endsWith(configToCopy[ii])) {
                                        System.out.println("   " + configToCopy[ii] + " -> " + configToCopy[ii]);
                                        Throwable throwable2 = null;
                                        Object var16_24 = null;
                                        try (FileOutputStream oss = new FileOutputStream(new File(mcpDataTMP, configToCopy[ii]));){
                                            IOUtils.copy((InputStream)is, (OutputStream)oss, 32768);
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                                throw throwable2;
                                            }
                                            if (throwable2 == throwable3) throw throwable2;
                                            throwable2.addSuppressed(throwable3);
                                            throw throwable2;
                                        }
                                        configFound[ii] = true;
                                        continue block14;
                                    }
                                    ++ii;
                                }
                            }
                        }
                        if (is == null) break block38;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
            catch (IOException ex) {
                System.err.println("ERROR: failed to extract \"" + f.getAbsolutePath() + "\" to \"" + mcpDataTMP.getAbsolutePath() + "\"!");
                ex.printStackTrace();
                return false;
            }
        }
        boolean err = false;
        int ii = 0;
        while (true) {
            if (ii >= jarsToUnify.length) break;
            if (!jarsFound[ii]) {
                err = true;
                System.err.println("JAR not found: \"" + jarsToUnify[ii] + "\"!");
            }
            ++ii;
        }
        ii = 0;
        while (true) {
            if (ii >= configToCopy.length) {
                if (!err) break;
                System.err.println("ERROR: Could not extract all required MCP files from \"" + f.getName() + "\"!");
                return false;
            }
            if (!configFound[ii]) {
                err = true;
                System.err.println("Config not found: \"" + configToCopy[ii] + "\"!");
            }
            ++ii;
        }
        File srgsOut = new File(mcpDataTMP, "minecraft.srg");
        CSVMappings mappings = new CSVMappings();
        if (!GenerateSRGs.generate(mcpDataTMP, srgsOut, mappings)) {
            System.err.println("ERROR: could not generate joined \"minecraft.srg\" file from conf in \"" + mcpDataTMP.getAbsolutePath() + "\"!");
            return false;
        }
        File excsOut = new File(mcpDataTMP, "minecraft.exc");
        if (GenerateEXCs.generateEXCs(mcpDataTMP, excsOut, mappings)) return true;
        System.err.println("ERROR: could not generate joined \"minecraft.exc\" file from conf in \"" + mcpDataTMP.getAbsolutePath() + "\"!");
        return false;
    }
}

