/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.CSVMappings;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InsertJavaDoc;
import org.apache.commons.io.IOUtils;

public class CreateUnpatched {
    public static boolean createUnpatched() {
        try {
            return CreateUnpatched.createUnpatched0();
        }
        catch (Throwable t) {
            System.err.println();
            System.err.println("Exception encountered while running task 'unpatched'!");
            t.printStackTrace();
            return false;
        }
    }

    private static boolean createUnpatched0() throws Throwable {
        File tmpDirectory = EaglerBuildToolsConfig.getTemporaryDirectory();
        File mcpDir = new File(tmpDirectory, "ModCoderPack");
        File minecraftSrc = new File(tmpDirectory, "MinecraftSrc/minecraft_src.jar");
        File minecraftRes = new File(tmpDirectory, "MinecraftSrc/minecraft_res.jar");
        File outputFile = new File("./MinecraftSrc.zip");
        if (outputFile.exists()) {
            System.err.println("ERROR: The file 'MinecraftSrc.zip' already exists in this directory!");
            System.err.println("Delete it and re-run 'unpatched' to try again");
            return false;
        }
        if (!mcpDir.isDirectory()) {
            System.err.println("The '" + mcpDir.getName() + "' directory was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        if (!minecraftSrc.isFile()) {
            System.err.println("The '" + minecraftSrc.getName() + "' file was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        if (!minecraftRes.isFile()) {
            System.err.println("The '" + minecraftRes.getName() + "' file was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        File tmpJavadocOut = new File(tmpDirectory, "MinecraftSrc/minecraft_unpatched_javadoc.jar");
        System.out.println();
        System.out.println("Preparing source in '" + minecraftSrc.getName() + "'...");
        System.out.println();
        CSVMappings mp = new CSVMappings();
        InsertJavaDoc.processSource(minecraftSrc, tmpJavadocOut, mcpDir, mp, false);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ZipOutputStream zot = new ZipOutputStream(new FileOutputStream(outputFile));){
            int tl;
            FileInputStream fin;
            zot.setLevel(0);
            System.out.println("Extracting '" + tmpJavadocOut.getName() + "' into '" + outputFile.getName() + "'...");
            Throwable throwable2 = null;
            Object var12_15 = null;
            try {
                fin = new FileInputStream(tmpJavadocOut);
                try {
                    tl = CreateUnpatched.extractZipTo(new ZipInputStream(fin), zot, "src");
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            System.out.println("Extracted " + tl + " files.");
            System.out.println();
            System.out.println("Extracting '" + minecraftRes.getName() + "' into '" + outputFile.getName() + "'...");
            throwable2 = null;
            var12_15 = null;
            try {
                fin = new FileInputStream(minecraftRes);
                try {
                    tl = CreateUnpatched.extractZipTo(new ZipInputStream(fin), zot, "res");
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            System.out.println("Extracted " + tl + " files.");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        if (!tmpJavadocOut.delete()) {
            System.err.println();
            System.err.println("ERROR: failed to delete '" + tmpJavadocOut.getName() + "' from temporary directory!");
        }
        return true;
    }

    private static int extractZipTo(ZipInputStream zin, ZipOutputStream zout, String pfx) throws IOException {
        ZipEntry in;
        int cnt = 0;
        while ((in = zin.getNextEntry()) != null) {
            if (in.isDirectory()) continue;
            String n = in.getName();
            if (n.startsWith("/")) {
                n = n.substring(1);
            }
            if (n.startsWith("META-INF")) continue;
            ZipEntry out = new ZipEntry(String.valueOf(pfx) + "/" + n);
            zout.putNextEntry(out);
            IOUtils.copy((InputStream)zin, (OutputStream)zout, 8192);
            ++cnt;
        }
        return cnt;
    }
}

