/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVMappings {
    public final Map<String, Symbol> csvFieldsMappings = new HashMap<String, Symbol>();
    public final Map<String, Symbol> csvMethodsMappings = new HashMap<String, Symbol>();
    public final Map<String, Param> csvParamsMappings = new HashMap<String, Param>();
    public final Map<String, Param[]> csvParamsForFunction = new HashMap<String, Param[]>();

    public void loadMethodsFile(Reader reader) throws IOException {
        this.loadSymbols(reader, this.csvMethodsMappings, "methods.csv");
    }

    public void loadFieldsFile(Reader reader) throws IOException {
        this.loadSymbols(reader, this.csvFieldsMappings, "fields.csv");
    }

    private void loadSymbols(Reader reader, Map<String, Symbol> map, String debugFileName) throws IOException {
        try {
            CSVParser ps = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(reader);
            for (CSVRecord rec : ps) {
                String srgName = rec.get("searge");
                String deobfName = rec.get("name");
                int mod = Integer.parseInt(rec.get("side"));
                String comment = rec.get("desc");
                map.put(srgName, new Symbol(deobfName, mod, comment));
            }
            System.out.println("   Loaded " + map.size() + " symbols from " + debugFileName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Invalid " + debugFileName + " file!");
        }
    }

    public void loadParamsFile(Reader reader) throws IOException {
        try {
            CSVParser ps = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(reader);
            for (CSVRecord rec : ps) {
                int i2;
                String srgName = rec.get("param");
                String deobfName = rec.get("name");
                int mod = Integer.parseInt(rec.get("side"));
                this.csvParamsMappings.put(srgName, new Param(deobfName, mod));
                String fName = srgName.substring(srgName.indexOf(95) + 1);
                if (fName.startsWith("i") || (i2 = fName.indexOf(95)) == -1) continue;
                int ordinal = -1;
                String ordStr = fName.substring(i2 + 1);
                if (ordStr.length() >= 2) {
                    try {
                        ordinal = Integer.parseInt(ordStr.substring(0, ordStr.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (ordinal < 0) continue;
                Param[] prm = this.csvParamsForFunction.get(fName = "func_" + fName.substring(0, i2));
                if (prm == null || prm.length <= ordinal) {
                    Param[] prm2 = new Param[ordinal + 1];
                    if (prm != null) {
                        System.arraycopy(prm, 0, prm2, 0, prm.length);
                    }
                    prm = prm2;
                }
                prm[ordinal] = new Param(deobfName, mod);
                this.csvParamsForFunction.put(fName, prm);
            }
            System.out.println("   Loaded " + this.csvParamsMappings.size() + " symbols from params.csv");
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid params.csv file!");
        }
    }

    public static class Param {
        public final String name;
        public final int mod;

        public Param(String name, int mod) {
            this.name = name;
            this.mod = mod;
        }
    }

    public static class Symbol {
        public final String name;
        public final int mod;
        public final String comment;

        public Symbol(String name, int mod, String comment) {
            this.name = name;
            this.mod = mod;
            this.comment = comment;
        }
    }
}

