/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TeaVMBinaries {
    public static final String teavmCoreJar = "teavm-core-0.6.1.jar";
    public static final String teavmCoreMaven = "org/teavm/teavm-core/0.6.1/teavm-core-0.6.1.jar";
    public static File teavmCore = null;
    public static final String teavmCliJar = "teavm-cli-0.6.1.jar";
    public static final String teavmCliMaven = "org/teavm/teavm-cli/0.6.1/teavm-cli-0.6.1.jar";
    public static File teavmCli = null;
    public static final String teavmToolingJar = "teavm-tooling-0.6.1.jar";
    public static final String teavmToolingMaven = "org/teavm/teavm-tooling/0.6.1/teavm-tooling-0.6.1.jar";
    public static File teavmTooling = null;
    public static final String teavmPlatformJar = "teavm-platform-0.6.1.jar";
    public static final String teavmPlatformMaven = "org/teavm/teavm-platform/0.6.1/teavm-platform-0.6.1.jar";
    public static File teavmPlatform = null;
    public static final String teavmClasslibJar = "teavm-classlib-0.6.1.jar";
    public static final String teavmClasslibMaven = "org/teavm/teavm-classlib/0.6.1/teavm-classlib-0.6.1.jar";
    public static File teavmClasslib = null;
    public static final String teavmInteropJar = "teavm-interop-0.6.1.jar";
    public static final String teavmInteropMaven = "org/teavm/teavm-interop/0.6.1/teavm-interop-0.6.1.jar";
    public static File teavmInterop = null;
    public static final String teavmJSOJar = "teavm-jso-0.6.1.jar";
    public static final String teavmJSOMaven = "org/teavm/teavm-jso/0.6.1/teavm-jso-0.6.1.jar";
    public static File teavmJSO = null;
    public static final String teavmJSOApisJar = "teavm-jso-apis-0.6.1.jar";
    public static final String teavmJSOApisMaven = "org/teavm/teavm-jso-apis/0.6.1/teavm-jso-apis-0.6.1.jar";
    public static File teavmJSOApis = null;
    public static final String teavmJSOImplJar = "teavm-jso-impl-0.6.1.jar";
    public static final String teavmJSOImplMaven = "org/teavm/teavm-jso-impl/0.6.1/teavm-jso-impl-0.6.1.jar";
    public static File teavmJSOImpl = null;
    public static final String teavmMetaprogrammingAPIJar = "teavm-metaprogramming-api-0.6.1.jar";
    public static final String teavmMetaprogrammingAPIMaven = "org/teavm/teavm-metaprogramming-api/0.6.1/teavm-metaprogramming-api-0.6.1.jar";
    public static File teavmMetaprogrammingAPI = null;
    public static final String teavmMetaprogrammingImplJar = "teavm-metaprogramming-impl-0.6.1.jar";
    public static final String teavmMetaprogrammingImplMaven = "org/teavm/teavm-metaprogramming-impl/0.6.1/teavm-metaprogramming-impl-0.6.1.jar";
    public static File teavmMetaprogrammingImpl = null;
    public static final String teavmJodaTimeJar = "joda-time-2.7.jar";
    public static final String teavmJodaTimeMaven = "joda-time/joda-time/2.7/joda-time-2.7.jar";
    public static File teavmJodaTime = null;
    public static final String teavmJZLIBJar = "jzlib-1.1.3.jar";
    public static final String teavmJZLIBMaven = "com/jcraft/jzlib/1.1.3/jzlib-1.1.3.jar";
    public static File teavmJZLIB = null;
    public static File teavmBridge = null;

    public static void downloadFromMaven(String url, File outputDir) throws MissingJARsException {
        File f;
        teavmCli = null;
        teavmTooling = null;
        teavmJZLIB = null;
        teavmJodaTime = null;
        teavmMetaprogrammingImpl = null;
        teavmMetaprogrammingAPI = null;
        teavmJSOImpl = null;
        teavmJSOApis = null;
        teavmJSO = null;
        teavmInterop = null;
        teavmClasslib = null;
        teavmPlatform = null;
        teavmCore = null;
        if (url.lastIndexOf(47) != url.length() - 1) {
            url = String.valueOf(url) + "/";
        }
        String urlConc = String.valueOf(url) + teavmCoreMaven;
        try {
            f = new File(outputDir, teavmCoreJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmCore = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmCliMaven;
        try {
            f = new File(outputDir, teavmCliJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmCli = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmToolingMaven;
        try {
            f = new File(outputDir, teavmToolingJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmTooling = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmPlatformMaven;
        try {
            f = new File(outputDir, teavmPlatformJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmPlatform = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmClasslibMaven;
        try {
            f = new File(outputDir, teavmClasslibJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmClasslib = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmInteropMaven;
        try {
            f = new File(outputDir, teavmInteropJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmInterop = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmJSOMaven;
        try {
            f = new File(outputDir, teavmJSOJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmJSO = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmJSOApisMaven;
        try {
            f = new File(outputDir, teavmJSOApisJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmJSOApis = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmJSOImplMaven;
        try {
            f = new File(outputDir, teavmJSOImplJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmJSOImpl = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmMetaprogrammingAPIMaven;
        try {
            f = new File(outputDir, teavmMetaprogrammingAPIJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmMetaprogrammingAPI = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmMetaprogrammingImplMaven;
        try {
            f = new File(outputDir, teavmMetaprogrammingImplJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmMetaprogrammingImpl = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmJodaTimeMaven;
        try {
            f = new File(outputDir, teavmJodaTimeJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmJodaTime = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
        urlConc = String.valueOf(url) + teavmJZLIBMaven;
        try {
            f = new File(outputDir, teavmJZLIBJar);
            TeaVMBinaries.copyURLToFileCheck404(urlConc, f);
            teavmJZLIB = f;
        }
        catch (IOException ex) {
            System.err.println("Could not download JAR: " + urlConc);
            ex.printStackTrace();
            throw new MissingJARsException("The following JAR file could not be downloaded: " + urlConc, Arrays.asList(urlConc));
        }
    }

    public static void loadFromDirectory(File directory) throws MissingJARsException {
        teavmCli = null;
        teavmTooling = null;
        teavmJZLIB = null;
        teavmJodaTime = null;
        teavmMetaprogrammingImpl = null;
        teavmMetaprogrammingAPI = null;
        teavmJSOImpl = null;
        teavmJSOApis = null;
        teavmJSO = null;
        teavmInterop = null;
        teavmClasslib = null;
        teavmPlatform = null;
        teavmCore = null;
        TeaVMBinaries.discoverJars(directory);
        ArrayList<String> missingJars = new ArrayList<String>();
        if (teavmCore == null) {
            missingJars.add(teavmCoreJar);
        }
        if (teavmCli == null) {
            missingJars.add(teavmCliJar);
        }
        if (teavmTooling == null) {
            missingJars.add(teavmToolingJar);
        }
        if (teavmPlatform == null) {
            missingJars.add(teavmPlatformJar);
        }
        if (teavmClasslib == null) {
            missingJars.add(teavmClasslibJar);
        }
        if (teavmInterop == null) {
            missingJars.add(teavmInteropJar);
        }
        if (teavmJSO == null) {
            missingJars.add(teavmJSOJar);
        }
        if (teavmJSOApis == null) {
            missingJars.add(teavmJSOApisJar);
        }
        if (teavmJSOImpl == null) {
            missingJars.add(teavmJSOImplJar);
        }
        if (teavmMetaprogrammingAPI == null) {
            missingJars.add(teavmMetaprogrammingAPIJar);
        }
        if (teavmMetaprogrammingImpl == null) {
            missingJars.add(teavmMetaprogrammingImplJar);
        }
        if (teavmJodaTime == null) {
            missingJars.add(teavmJodaTimeJar);
        }
        if (teavmJZLIB == null) {
            missingJars.add(teavmJZLIBJar);
        }
        if (missingJars.size() > 0) {
            throw new MissingJARsException(missingJars);
        }
    }

    private static void discoverJars(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            block45: {
                String n;
                File f;
                block44: {
                    f = files[i];
                    if (!f.isDirectory()) break block44;
                    TeaVMBinaries.discoverJars(f);
                    break block45;
                }
                switch (n = f.getName()) {
                    case "teavm-core-0.6.1.jar": {
                        teavmCore = f;
                        break;
                    }
                    case "teavm-cli-0.6.1.jar": {
                        teavmCli = f;
                        break;
                    }
                    case "teavm-tooling-0.6.1.jar": {
                        teavmTooling = f;
                        break;
                    }
                    case "teavm-platform-0.6.1.jar": {
                        teavmPlatform = f;
                        break;
                    }
                    case "teavm-classlib-0.6.1.jar": {
                        teavmClasslib = f;
                        break;
                    }
                    case "teavm-interop-0.6.1.jar": {
                        teavmInterop = f;
                        break;
                    }
                    case "teavm-jso-0.6.1.jar": {
                        teavmJSO = f;
                        break;
                    }
                    case "teavm-jso-apis-0.6.1.jar": {
                        teavmJSOApis = f;
                        break;
                    }
                    case "teavm-jso-impl-0.6.1.jar": {
                        teavmJSOImpl = f;
                        break;
                    }
                    case "teavm-metaprogramming-api-0.6.1.jar": {
                        teavmMetaprogrammingAPI = f;
                        break;
                    }
                    case "teavm-metaprogramming-impl-0.6.1.jar": {
                        teavmMetaprogrammingImpl = f;
                        break;
                    }
                    case "joda-time-2.7.jar": {
                        teavmJodaTime = f;
                        break;
                    }
                    case "jzlib-1.1.3.jar": {
                        teavmJZLIB = f;
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private static void copyURLToFileCheck404(String urlIn, File fileOut) throws IOException {
        URL url;
        System.out.println("downloading: " + urlIn);
        try {
            url = new URL(urlIn);
        }
        catch (MalformedURLException ex) {
            throw new IOException("Invalid URL: " + urlIn, ex);
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        int respCode = connection.getResponseCode();
        if (respCode != 200) {
            connection.disconnect();
            throw new IOException("Recieved response code: " + respCode);
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = connection.getInputStream();){
                FileUtils.copyInputStreamToFile(stream, fileOut);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static boolean tryLoadTeaVMBridge() {
        File teavmBridgeCheck;
        String override = System.getProperty("eaglercraft.TeaVMBridge");
        if (override != null) {
            teavmBridgeCheck = new File(override);
        } else {
            try {
                teavmBridgeCheck = new File(new File(URLDecoder.decode(TeaVMBinaries.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), "UTF-8")).getParent(), "TeaVMBridge.jar");
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                System.err.println("Failed to locate TeaVMBridge.jar relative to BuildTools jar!");
                e.printStackTrace();
                return false;
            }
        }
        if (teavmBridgeCheck.exists()) {
            teavmBridge = teavmBridgeCheck;
            return true;
        }
        System.err.println("File does not exist: " + teavmBridgeCheck.getAbsolutePath());
        return false;
    }

    public static File[] getTeaVMCompilerClasspath() {
        return new File[]{teavmCore, teavmCli, teavmTooling, teavmInterop, teavmMetaprogrammingAPI, teavmBridge};
    }

    public static String[] getTeaVMRuntimeClasspath() {
        return new String[]{teavmJodaTime.getAbsolutePath(), teavmJZLIB.getAbsolutePath(), teavmClasslib.getAbsolutePath(), teavmInterop.getAbsolutePath(), teavmJSO.getAbsolutePath(), teavmJSOApis.getAbsolutePath(), teavmJSOImpl.getAbsolutePath(), teavmMetaprogrammingAPI.getAbsolutePath(), teavmMetaprogrammingImpl.getAbsolutePath(), teavmPlatform.getAbsolutePath()};
    }

    public static class MissingJARsException
    extends RuntimeException {
        public final List<String> jars;

        public MissingJARsException(String msg, List<String> jars) {
            super(msg);
            this.jars = jars;
        }

        public MissingJARsException(List<String> jars) {
            this("The following JAR files were not found: " + String.join((CharSequence)", ", jars), jars);
        }
    }
}

