/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.lax1dude.eaglercraft.v1_8.buildtools.gui.CompileLatestClientGUI;

public class ConsoleRedirector
extends OutputStream {
    private final OutputStream stdout;
    private final boolean err;

    public ConsoleRedirector(boolean err) {
        this.stdout = err ? System.err : System.out;
        this.err = err;
    }

    @Override
    public void write(byte[] b, int o, int l) throws IOException {
        this.stdout.write(b, o, l);
        String append = new String(b, o, l, StandardCharsets.US_ASCII);
        if (this.err) {
            CompileLatestClientGUI.frame.logError(append);
        } else {
            CompileLatestClientGUI.frame.logInfo(append);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.stdout.write(b);
        this.write0(b);
    }

    private void write0(int b) throws IOException {
        char c = (char)b;
        if (c != '\r') {
            if (this.err && c != '\n') {
                CompileLatestClientGUI.frame.logError(new String(new char[]{c}));
            } else {
                CompileLatestClientGUI.frame.logInfo(new String(new char[]{c}));
            }
        }
    }
}

