/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.placeholder_server;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.placeholder_server.ServerIconLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlaceholderServerConfig {
    public static final File configFile = new File("config.json");
    public static String host = "0.0.0.0";
    public static int port = 8081;
    public static String icon = null;
    public static String serverName = "EaglercraftX 1.8 Server";
    public static String serverUUID = "";
    public static int clientTimeout = 3000;
    public static String motd1 = "Coming Soon";
    public static String motd2 = "";
    public static String kick = "This server is still under construction";
    public static String redirect = "";
    public static byte[] cachedIconPacket = null;
    public static byte[] cachedLegacyKickRedirectPacket = null;
    public static byte[] cachedKickPacket = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load() throws IOException {
        Closeable is;
        Object var2_5;
        Throwable throwable;
        block43: {
            if (!configFile.exists()) {
                int i;
                FileOutputStream os;
                block41: {
                    System.out.println("Writing new config file to: " + configFile.getName());
                    throwable = null;
                    var2_5 = null;
                    try {
                        is = new InputStreamReader(PlaceholderServerConfig.class.getResourceAsStream("/config_default.json"));
                        try {
                            os = new FileOutputStream(configFile);
                            try {
                                char[] cArray = new char[1024];
                                StringBuilder sb = new StringBuilder();
                                while (true) {
                                    if ((i = ((Reader)is).read(cArray)) == -1) {
                                        String str = sb.toString();
                                        str = str.replace("${random_uuid}", UUID.randomUUID().toString());
                                        ((OutputStream)os).write(str.getBytes(StandardCharsets.UTF_8));
                                        break;
                                    }
                                    sb.append(cArray, 0, i);
                                }
                            }
                            finally {
                                if (os != null) {
                                    ((OutputStream)os).close();
                                }
                            }
                            if (is == null) break block41;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            ((Reader)is).close();
                            throw throwable;
                        }
                        ((Reader)is).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                throwable = null;
                var2_5 = null;
                try {
                    is = PlaceholderServerConfig.class.getResourceAsStream("/server-icon_default.png");
                    try {
                        os = new FileOutputStream(new File("server-icon.png"));
                        try {
                            byte[] byArray = new byte[1024];
                            while ((i = ((InputStream)is).read(byArray)) != -1) {
                                ((OutputStream)os).write(byArray, 0, i);
                            }
                        }
                        finally {
                            if (os != null) {
                                ((OutputStream)os).close();
                            }
                        }
                        if (is == null) break block43;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (is == null) throw throwable;
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    ((InputStream)is).close();
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    }
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                    throw throwable;
                }
            }
        }
        System.out.println("Reading config file: " + configFile.getName());
        byte[] fileBytes = new byte[(int)configFile.length()];
        throwable = null;
        var2_5 = null;
        try {
            is = new FileInputStream(configFile);
            try {
                int n;
                int i = 0;
                while (i < fileBytes.length && (n = ((InputStream)is).read(fileBytes, i, fileBytes.length - i)) != -1) {
                    i += n;
                }
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
        try {
            JSONObject loaded = new JSONObject(new String(fileBytes, StandardCharsets.UTF_8));
            host = loaded.getString("server_host");
            port = loaded.getInt("server_port");
            icon = loaded.getString("server_icon");
            serverName = loaded.getString("server_name");
            serverUUID = loaded.getString("server_uuid");
            clientTimeout = loaded.getInt("client_timeout");
            JSONArray motd = loaded.getJSONArray("server_motd");
            motd1 = motd.getString(0);
            if (motd.length() > 1) {
                motd2 = motd.getString(1);
            }
            if ((kick = loaded.getString("kick_message")).length() > 255) {
                kick = kick.substring(0, 255);
                System.err.println("Warning: kick message was truncated to 255 characters");
            }
            redirect = loaded.optString("redirect_legacy", null);
        }
        catch (Throwable t) {
            throw new IOException("Could not load config file \"" + configFile.getAbsolutePath() + "\"!", t);
        }
        PlaceholderServerConfig.cacheKickPacket();
        PlaceholderServerConfig.cacheRedirectPacket();
        if (icon == null) return;
        if (icon.length() <= 0) return;
        PlaceholderServerConfig.cacheIconPacket();
    }

    private static void cacheKickPacket() throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bao);
        dos.writeByte(255);
        dos.writeByte(8);
        dos.writeByte(kick.length());
        int i = 0;
        int l = kick.length();
        while (i < l) {
            dos.writeByte(kick.charAt(i) & 0xFF);
            ++i;
        }
        cachedKickPacket = bao.toByteArray();
    }

    private static void cacheRedirectPacket() throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bao);
        if (redirect == null || redirect.length() == 0) {
            String message = "This is an EaglercraftX 1.8 server, it is not compatible with 1.5.2!";
            dos.writeByte(255);
            dos.writeShort(message.length());
            int i = 0;
            int l = message.length();
            while (i < l) {
                char j = message.charAt(i);
                dos.writeByte(j >> 8 & 0xFF);
                dos.writeByte(j & 0xFF);
                ++i;
            }
        } else {
            dos.writeByte(1);
            dos.writeInt(0);
            dos.writeShort(0);
            dos.writeByte(0);
            dos.writeByte(0);
            dos.writeByte(255);
            dos.writeByte(0);
            dos.writeByte(0);
            dos.writeByte(250);
            String channel = "EAG|Reconnect";
            int cl = channel.length();
            dos.writeShort(cl);
            int i = 0;
            while (i < cl) {
                dos.writeChar(channel.charAt(i));
                ++i;
            }
            byte[] redirect_ = redirect.getBytes(StandardCharsets.UTF_8);
            dos.writeShort(redirect_.length);
            dos.write(redirect_);
        }
        cachedLegacyKickRedirectPacket = bao.toByteArray();
    }

    private static void cacheIconPacket() throws IOException {
        File f = new File(icon);
        int[] iconPixels = ServerIconLoader.createServerIcon(f);
        if (iconPixels != null) {
            cachedIconPacket = new byte[16384];
            int i = 0;
            while (i < 4096) {
                int j = i << 2;
                PlaceholderServerConfig.cachedIconPacket[j] = (byte)(iconPixels[i] >> 16 & 0xFF);
                PlaceholderServerConfig.cachedIconPacket[j + 1] = (byte)(iconPixels[i] >> 8 & 0xFF);
                PlaceholderServerConfig.cachedIconPacket[j + 2] = (byte)(iconPixels[i] & 0xFF);
                PlaceholderServerConfig.cachedIconPacket[j + 3] = (byte)(iconPixels[i] >> 24 & 0xFF);
                ++i;
            }
        } else {
            System.err.println("Could not load server icon \"" + f.getAbsolutePath() + "\"!");
        }
    }
}

