/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.placeholder_server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import net.lax1dude.eaglercraft.v1_8.placeholder_server.DummyConnection;
import net.lax1dude.eaglercraft.v1_8.placeholder_server.PlaceholderServerConfig;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class PlaceholderServer
extends WebSocketServer {
    public static PlaceholderServer websocketServer = null;
    private boolean isOpen = false;

    public static void main(String[] args) throws IOException {
        System.out.println();
        System.out.println("Copyright (c) 2022 lax1dude");
        System.out.println("All rights reserved.");
        System.out.println();
        System.out.println("Starting placeholder 1.8 server...");
        System.out.println();
        PlaceholderServerConfig.load();
        System.out.println("Starting WebSocket server...");
        System.out.println();
        websocketServer = new PlaceholderServer(new InetSocketAddress(PlaceholderServerConfig.host, PlaceholderServerConfig.port));
        websocketServer.start();
        long redirTimeout = PlaceholderServerConfig.redirect != null && PlaceholderServerConfig.redirect.length() > 0 ? 500L : 100L;
        while (true) {
            try {
                block3: while (true) {
                    Thread.sleep(200L);
                    long millis = System.currentTimeMillis();
                    Iterator<WebSocket> iterator = websocketServer.getConnections().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        WebSocket ws = iterator.next();
                        DummyConnection conn = (DummyConnection)ws.getAttachment();
                        if (conn == null || (conn.sendRedirectAt <= 0L || millis - conn.sendRedirectAt <= redirTimeout) && millis - conn.age <= (long)PlaceholderServerConfig.clientTimeout) continue;
                        ws.close();
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private PlaceholderServer(InetSocketAddress addr) {
        super(addr);
        this.setReuseAddr(true);
        this.setTcpNoDelay(true);
    }

    @Override
    public void onClose(WebSocket arg0, int arg1, String arg2, boolean arg3) {
    }

    @Override
    public void onError(WebSocket arg0, Exception arg1) {
        System.err.println();
        if (arg0 != null) {
            System.err.println("Caught WebSocket exception on " + arg0.getRemoteSocketAddress() + "!");
            arg0.close();
        } else {
            System.err.println("Caught WebSocket exception!");
        }
        arg1.printStackTrace();
        if (!this.isOpen) {
            System.exit(-1);
        }
    }

    @Override
    public void onMessage(WebSocket arg0, String arg1) {
        ((DummyConnection)arg0.getAttachment()).processString(arg1);
    }

    @Override
    public void onMessage(WebSocket arg0, ByteBuffer arg1) {
        ((DummyConnection)arg0.getAttachment()).processBinary(arg1);
    }

    @Override
    public void onOpen(WebSocket arg0, ClientHandshake arg1) {
        arg0.setAttachment(new DummyConnection(arg0));
    }

    @Override
    public void onStart() {
        System.out.println();
        System.out.println("Listening on: " + this.getAddress());
        this.isOpen = true;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PlaceholderServer.this.stop();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }, "Shutdown Thread"));
        System.out.println("Use CTRL+C to exit");
    }
}

