package net.minecraft.init;

import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemEmptyMap;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.util.ResourceLocation;

/**+
 * This portion of EaglercraftX contains deobfuscated Minecraft 1.8 source code.
 * 
 * Minecraft 1.8.8 bytecode is (c) 2015 Mojang AB. "Do not distribute!"
 * Mod Coder Pack v9.18 deobfuscation configs are (c) Copyright by the MCP Team
 * 
 * EaglercraftX 1.8 patch files are (c) 2022-2023 LAX1DUDE. All Rights Reserved.
 * 
 * WITH THE EXCEPTION OF PATCH FILES, MINIFIED JAVASCRIPT, AND ALL FILES
 * NORMALLY FOUND IN AN UNMODIFIED MINECRAFT RESOURCE PACK, YOU ARE NOT ALLOWED
 * TO SHARE, DISTRIBUTE, OR REPURPOSE ANY FILE USED BY OR PRODUCED BY THE
 * SOFTWARE IN THIS REPOSITORY WITHOUT PRIOR PERMISSION FROM THE PROJECT AUTHOR.
 * 
 * NOT FOR COMMERCIAL OR MALICIOUS USE
 * 
 * (please read the 'LICENSE' file this repo's root directory for more info) 
 * 
 */
public class Items {
	public static Item iron_shovel;
	public static Item iron_pickaxe;
	public static Item iron_axe;
	public static Item flint_and_steel;
	public static Item apple;
	public static ItemBow bow;
	public static Item arrow;
	public static Item coal;
	public static Item diamond;
	public static Item iron_ingot;
	public static Item gold_ingot;
	public static Item iron_sword;
	public static Item wooden_sword;
	public static Item wooden_shovel;
	public static Item wooden_pickaxe;
	public static Item wooden_axe;
	public static Item stone_sword;
	public static Item stone_shovel;
	public static Item stone_pickaxe;
	public static Item stone_axe;
	public static Item diamond_sword;
	public static Item diamond_shovel;
	public static Item diamond_pickaxe;
	public static Item diamond_axe;
	public static Item stick;
	public static Item bowl;
	public static Item mushroom_stew;
	public static Item golden_sword;
	public static Item golden_shovel;
	public static Item golden_pickaxe;
	public static Item golden_axe;
	public static Item string;
	public static Item feather;
	public static Item gunpowder;
	public static Item wooden_hoe;
	public static Item stone_hoe;
	public static Item iron_hoe;
	public static Item diamond_hoe;
	public static Item golden_hoe;
	public static Item wheat_seeds;
	public static Item wheat;
	public static Item bread;
	public static ItemArmor leather_helmet;
	public static ItemArmor leather_chestplate;
	public static ItemArmor leather_leggings;
	public static ItemArmor leather_boots;
	public static ItemArmor chainmail_helmet;
	public static ItemArmor chainmail_chestplate;
	public static ItemArmor chainmail_leggings;
	public static ItemArmor chainmail_boots;
	public static ItemArmor iron_helmet;
	public static ItemArmor iron_chestplate;
	public static ItemArmor iron_leggings;
	public static ItemArmor iron_boots;
	public static ItemArmor diamond_helmet;
	public static ItemArmor diamond_chestplate;
	public static ItemArmor diamond_leggings;
	public static ItemArmor diamond_boots;
	public static ItemArmor golden_helmet;
	public static ItemArmor golden_chestplate;
	public static ItemArmor golden_leggings;
	public static ItemArmor golden_boots;
	public static Item flint;
	public static Item porkchop;
	public static Item cooked_porkchop;
	public static Item painting;
	public static Item golden_apple;
	public static Item sign;
	public static Item oak_door;
	public static Item spruce_door;
	public static Item birch_door;
	public static Item jungle_door;
	public static Item acacia_door;
	public static Item dark_oak_door;
	public static Item bucket;
	public static Item water_bucket;
	public static Item lava_bucket;
	public static Item minecart;
	public static Item saddle;
	public static Item iron_door;
	public static Item redstone;
	public static Item snowball;
	public static Item boat;
	public static Item leather;
	public static Item milk_bucket;
	public static Item brick;
	public static Item clay_ball;
	public static Item reeds;
	public static Item paper;
	public static Item book;
	public static Item slime_ball;
	public static Item chest_minecart;
	public static Item furnace_minecart;
	public static Item egg;
	public static Item compass;
	public static ItemFishingRod fishing_rod;
	public static Item clock;
	public static Item glowstone_dust;
	public static Item fish;
	public static Item cooked_fish;
	public static Item dye;
	public static Item bone;
	public static Item sugar;
	public static Item cake;
	public static Item bed;
	public static Item repeater;
	public static Item cookie;
	public static ItemMap filled_map;
	public static ItemShears shears;
	public static Item melon;
	public static Item pumpkin_seeds;
	public static Item melon_seeds;
	public static Item beef;
	public static Item cooked_beef;
	public static Item chicken;
	public static Item cooked_chicken;
	public static Item mutton;
	public static Item cooked_mutton;
	public static Item rabbit;
	public static Item cooked_rabbit;
	public static Item rabbit_stew;
	public static Item rabbit_foot;
	public static Item rabbit_hide;
	public static Item rotten_flesh;
	public static Item ender_pearl;
	public static Item blaze_rod;
	public static Item ghast_tear;
	public static Item gold_nugget;
	public static Item nether_wart;
	public static ItemPotion potionitem;
	public static Item glass_bottle;
	public static Item spider_eye;
	public static Item fermented_spider_eye;
	public static Item blaze_powder;
	public static Item magma_cream;
	public static Item brewing_stand;
	public static Item cauldron;
	public static Item ender_eye;
	public static Item speckled_melon;
	public static Item spawn_egg;
	public static Item experience_bottle;
	public static Item fire_charge;
	public static Item writable_book;
	public static Item written_book;
	public static Item emerald;
	public static Item item_frame;
	public static Item flower_pot;
	public static Item carrot;
	public static Item potato;
	public static Item baked_potato;
	public static Item poisonous_potato;
	public static ItemEmptyMap map;
	public static Item golden_carrot;
	public static Item skull;
	public static Item carrot_on_a_stick;
	public static Item nether_star;
	public static Item pumpkin_pie;
	public static Item fireworks;
	public static Item firework_charge;
	public static ItemEnchantedBook enchanted_book;
	public static Item comparator;
	public static Item netherbrick;
	public static Item quartz;
	public static Item tnt_minecart;
	public static Item hopper_minecart;
	public static ItemArmorStand armor_stand;
	public static Item iron_horse_armor;
	public static Item golden_horse_armor;
	public static Item diamond_horse_armor;
	public static Item lead;
	public static Item name_tag;
	public static Item command_block_minecart;
	public static Item record_13;
	public static Item record_cat;
	public static Item record_blocks;
	public static Item record_chirp;
	public static Item record_far;
	public static Item record_mall;
	public static Item record_mellohi;
	public static Item record_stal;
	public static Item record_strad;
	public static Item record_ward;
	public static Item record_11;
	public static Item record_wait;
	public static Item prismarine_shard;
	public static Item prismarine_crystals;
	public static Item banner;

	private static Item getRegisteredItem(String name) {
		return (Item) Item.itemRegistry.getObject(new ResourceLocation(name));
	}

	static void doBootstrap() {
		if (!Bootstrap.isRegistered()) {
			throw new RuntimeException("Accessed Items before Bootstrap!");
		} else {
			iron_shovel = getRegisteredItem("iron_shovel");
			iron_pickaxe = getRegisteredItem("iron_pickaxe");
			iron_axe = getRegisteredItem("iron_axe");
			flint_and_steel = getRegisteredItem("flint_and_steel");
			apple = getRegisteredItem("apple");
			bow = (ItemBow) getRegisteredItem("bow");
			arrow = getRegisteredItem("arrow");
			coal = getRegisteredItem("coal");
			diamond = getRegisteredItem("diamond");
			iron_ingot = getRegisteredItem("iron_ingot");
			gold_ingot = getRegisteredItem("gold_ingot");
			iron_sword = getRegisteredItem("iron_sword");
			wooden_sword = getRegisteredItem("wooden_sword");
			wooden_shovel = getRegisteredItem("wooden_shovel");
			wooden_pickaxe = getRegisteredItem("wooden_pickaxe");
			wooden_axe = getRegisteredItem("wooden_axe");
			stone_sword = getRegisteredItem("stone_sword");
			stone_shovel = getRegisteredItem("stone_shovel");
			stone_pickaxe = getRegisteredItem("stone_pickaxe");
			stone_axe = getRegisteredItem("stone_axe");
			diamond_sword = getRegisteredItem("diamond_sword");
			diamond_shovel = getRegisteredItem("diamond_shovel");
			diamond_pickaxe = getRegisteredItem("diamond_pickaxe");
			diamond_axe = getRegisteredItem("diamond_axe");
			stick = getRegisteredItem("stick");
			bowl = getRegisteredItem("bowl");
			mushroom_stew = getRegisteredItem("mushroom_stew");
			golden_sword = getRegisteredItem("golden_sword");
			golden_shovel = getRegisteredItem("golden_shovel");
			golden_pickaxe = getRegisteredItem("golden_pickaxe");
			golden_axe = getRegisteredItem("golden_axe");
			string = getRegisteredItem("string");
			feather = getRegisteredItem("feather");
			gunpowder = getRegisteredItem("gunpowder");
			wooden_hoe = getRegisteredItem("wooden_hoe");
			stone_hoe = getRegisteredItem("stone_hoe");
			iron_hoe = getRegisteredItem("iron_hoe");
			diamond_hoe = getRegisteredItem("diamond_hoe");
			golden_hoe = getRegisteredItem("golden_hoe");
			wheat_seeds = getRegisteredItem("wheat_seeds");
			wheat = getRegisteredItem("wheat");
			bread = getRegisteredItem("bread");
			leather_helmet = (ItemArmor) getRegisteredItem("leather_helmet");
			leather_chestplate = (ItemArmor) getRegisteredItem("leather_chestplate");
			leather_leggings = (ItemArmor) getRegisteredItem("leather_leggings");
			leather_boots = (ItemArmor) getRegisteredItem("leather_boots");
			chainmail_helmet = (ItemArmor) getRegisteredItem("chainmail_helmet");
			chainmail_chestplate = (ItemArmor) getRegisteredItem("chainmail_chestplate");
			chainmail_leggings = (ItemArmor) getRegisteredItem("chainmail_leggings");
			chainmail_boots = (ItemArmor) getRegisteredItem("chainmail_boots");
			iron_helmet = (ItemArmor) getRegisteredItem("iron_helmet");
			iron_chestplate = (ItemArmor) getRegisteredItem("iron_chestplate");
			iron_leggings = (ItemArmor) getRegisteredItem("iron_leggings");
			iron_boots = (ItemArmor) getRegisteredItem("iron_boots");
			diamond_helmet = (ItemArmor) getRegisteredItem("diamond_helmet");
			diamond_chestplate = (ItemArmor) getRegisteredItem("diamond_chestplate");
			diamond_leggings = (ItemArmor) getRegisteredItem("diamond_leggings");
			diamond_boots = (ItemArmor) getRegisteredItem("diamond_boots");
			golden_helmet = (ItemArmor) getRegisteredItem("golden_helmet");
			golden_chestplate = (ItemArmor) getRegisteredItem("golden_chestplate");
			golden_leggings = (ItemArmor) getRegisteredItem("golden_leggings");
			golden_boots = (ItemArmor) getRegisteredItem("golden_boots");
			flint = getRegisteredItem("flint");
			porkchop = getRegisteredItem("porkchop");
			cooked_porkchop = getRegisteredItem("cooked_porkchop");
			painting = getRegisteredItem("painting");
			golden_apple = getRegisteredItem("golden_apple");
			sign = getRegisteredItem("sign");
			oak_door = getRegisteredItem("wooden_door");
			spruce_door = getRegisteredItem("spruce_door");
			birch_door = getRegisteredItem("birch_door");
			jungle_door = getRegisteredItem("jungle_door");
			acacia_door = getRegisteredItem("acacia_door");
			dark_oak_door = getRegisteredItem("dark_oak_door");
			bucket = getRegisteredItem("bucket");
			water_bucket = getRegisteredItem("water_bucket");
			lava_bucket = getRegisteredItem("lava_bucket");
			minecart = getRegisteredItem("minecart");
			saddle = getRegisteredItem("saddle");
			iron_door = getRegisteredItem("iron_door");
			redstone = getRegisteredItem("redstone");
			snowball = getRegisteredItem("snowball");
			boat = getRegisteredItem("boat");
			leather = getRegisteredItem("leather");
			milk_bucket = getRegisteredItem("milk_bucket");
			brick = getRegisteredItem("brick");
			clay_ball = getRegisteredItem("clay_ball");
			reeds = getRegisteredItem("reeds");
			paper = getRegisteredItem("paper");
			book = getRegisteredItem("book");
			slime_ball = getRegisteredItem("slime_ball");
			chest_minecart = getRegisteredItem("chest_minecart");
			furnace_minecart = getRegisteredItem("furnace_minecart");
			egg = getRegisteredItem("egg");
			compass = getRegisteredItem("compass");
			fishing_rod = (ItemFishingRod) getRegisteredItem("fishing_rod");
			clock = getRegisteredItem("clock");
			glowstone_dust = getRegisteredItem("glowstone_dust");
			fish = getRegisteredItem("fish");
			cooked_fish = getRegisteredItem("cooked_fish");
			dye = getRegisteredItem("dye");
			bone = getRegisteredItem("bone");
			sugar = getRegisteredItem("sugar");
			cake = getRegisteredItem("cake");
			bed = getRegisteredItem("bed");
			repeater = getRegisteredItem("repeater");
			cookie = getRegisteredItem("cookie");
			filled_map = (ItemMap) getRegisteredItem("filled_map");
			shears = (ItemShears) getRegisteredItem("shears");
			melon = getRegisteredItem("melon");
			pumpkin_seeds = getRegisteredItem("pumpkin_seeds");
			melon_seeds = getRegisteredItem("melon_seeds");
			beef = getRegisteredItem("beef");
			cooked_beef = getRegisteredItem("cooked_beef");
			chicken = getRegisteredItem("chicken");
			cooked_chicken = getRegisteredItem("cooked_chicken");
			mutton = getRegisteredItem("mutton");
			cooked_mutton = getRegisteredItem("cooked_mutton");
			rabbit = getRegisteredItem("rabbit");
			cooked_rabbit = getRegisteredItem("cooked_rabbit");
			rabbit_stew = getRegisteredItem("rabbit_stew");
			rabbit_foot = getRegisteredItem("rabbit_foot");
			rabbit_hide = getRegisteredItem("rabbit_hide");
			rotten_flesh = getRegisteredItem("rotten_flesh");
			ender_pearl = getRegisteredItem("ender_pearl");
			blaze_rod = getRegisteredItem("blaze_rod");
			ghast_tear = getRegisteredItem("ghast_tear");
			gold_nugget = getRegisteredItem("gold_nugget");
			nether_wart = getRegisteredItem("nether_wart");
			potionitem = (ItemPotion) getRegisteredItem("potion");
			glass_bottle = getRegisteredItem("glass_bottle");
			spider_eye = getRegisteredItem("spider_eye");
			fermented_spider_eye = getRegisteredItem("fermented_spider_eye");
			blaze_powder = getRegisteredItem("blaze_powder");
			magma_cream = getRegisteredItem("magma_cream");
			brewing_stand = getRegisteredItem("brewing_stand");
			cauldron = getRegisteredItem("cauldron");
			ender_eye = getRegisteredItem("ender_eye");
			speckled_melon = getRegisteredItem("speckled_melon");
			spawn_egg = getRegisteredItem("spawn_egg");
			experience_bottle = getRegisteredItem("experience_bottle");
			fire_charge = getRegisteredItem("fire_charge");
			writable_book = getRegisteredItem("writable_book");
			written_book = getRegisteredItem("written_book");
			emerald = getRegisteredItem("emerald");
			item_frame = getRegisteredItem("item_frame");
			flower_pot = getRegisteredItem("flower_pot");
			carrot = getRegisteredItem("carrot");
			potato = getRegisteredItem("potato");
			baked_potato = getRegisteredItem("baked_potato");
			poisonous_potato = getRegisteredItem("poisonous_potato");
			map = (ItemEmptyMap) getRegisteredItem("map");
			golden_carrot = getRegisteredItem("golden_carrot");
			skull = getRegisteredItem("skull");
			carrot_on_a_stick = getRegisteredItem("carrot_on_a_stick");
			nether_star = getRegisteredItem("nether_star");
			pumpkin_pie = getRegisteredItem("pumpkin_pie");
			fireworks = getRegisteredItem("fireworks");
			firework_charge = getRegisteredItem("firework_charge");
			enchanted_book = (ItemEnchantedBook) getRegisteredItem("enchanted_book");
			comparator = getRegisteredItem("comparator");
			netherbrick = getRegisteredItem("netherbrick");
			quartz = getRegisteredItem("quartz");
			tnt_minecart = getRegisteredItem("tnt_minecart");
			hopper_minecart = getRegisteredItem("hopper_minecart");
			armor_stand = (ItemArmorStand) getRegisteredItem("armor_stand");
			iron_horse_armor = getRegisteredItem("iron_horse_armor");
			golden_horse_armor = getRegisteredItem("golden_horse_armor");
			diamond_horse_armor = getRegisteredItem("diamond_horse_armor");
			lead = getRegisteredItem("lead");
			name_tag = getRegisteredItem("name_tag");
			command_block_minecart = getRegisteredItem("command_block_minecart");
			record_13 = getRegisteredItem("record_13");
			record_cat = getRegisteredItem("record_cat");
			record_blocks = getRegisteredItem("record_blocks");
			record_chirp = getRegisteredItem("record_chirp");
			record_far = getRegisteredItem("record_far");
			record_mall = getRegisteredItem("record_mall");
			record_mellohi = getRegisteredItem("record_mellohi");
			record_stal = getRegisteredItem("record_stal");
			record_strad = getRegisteredItem("record_strad");
			record_ward = getRegisteredItem("record_ward");
			record_11 = getRegisteredItem("record_11");
			record_wait = getRegisteredItem("record_wait");
			prismarine_shard = getRegisteredItem("prismarine_shard");
			prismarine_crystals = getRegisteredItem("prismarine_crystals");
			banner = getRegisteredItem("banner");
		}
	}
}