/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.internal.DisposableNativeObject;
import java.util.Objects;

public class AudioResampler
extends DisposableNativeObject {
    private int targetFrames;
    private boolean initialized;

    public AudioResampler() {
        this.initialize();
    }

    public AudioResampler(int sourceSampleRate, int targetSampleRate, int channels) {
        this.initialize();
        this.reset(sourceSampleRate, targetSampleRate, channels);
    }

    public void reset(int sourceSampleRate, int targetSampleRate, int channels) {
        this.initialized = false;
        this.resetInternal(sourceSampleRate, targetSampleRate, channels);
        this.targetFrames = targetSampleRate / 100 * channels;
        this.initialized = true;
    }

    public int resample(byte[] samplesIn, int nSamplesIn, byte[] samplesOut) {
        Objects.requireNonNull(samplesIn);
        Objects.requireNonNull(samplesOut);
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized: Use reset() to set parameters");
        }
        int arraySamplesIn = samplesIn.length / 2;
        int maxSamplesOut = samplesOut.length / 2;
        nSamplesIn = Math.min(arraySamplesIn, Math.max(0, nSamplesIn));
        if (this.targetFrames > maxSamplesOut) {
            throw new IllegalArgumentException("Insufficient samples output length");
        }
        return this.resampleInternal(samplesIn, nSamplesIn, samplesOut, maxSamplesOut);
    }

    @Override
    public native void dispose();

    private native void initialize();

    private native void resetInternal(int var1, int var2, int var3);

    private native int resampleInternal(byte[] var1, int var2, byte[] var3, int var4);
}

