/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.media.audio.AudioDevice;
import dev.onvoid.webrtc.media.audio.AudioDeviceModule;
import dev.onvoid.webrtc.media.audio.AudioSource;
import java.util.concurrent.atomic.AtomicBoolean;

public class AudioPlayer {
    private final AtomicBoolean playing = new AtomicBoolean();
    private AudioDeviceModule module;
    private AudioDevice device;
    private AudioSource source;

    public void setAudioDevice(AudioDevice device) {
        this.device = device;
    }

    public void setAudioSource(AudioSource source) {
        this.source = source;
    }

    public void start() {
        if (this.playing.compareAndSet(false, true)) {
            this.module = new AudioDeviceModule();
            this.module.setPlayoutDevice(this.device);
            this.module.setAudioSource(this.source);
            this.module.initPlayout();
            this.module.startPlayout();
        }
    }

    public void stop() {
        if (this.playing.compareAndSet(true, false)) {
            this.module.stopPlayout();
            this.module.dispose();
        }
    }
}

