/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftHandleAuthPasswordEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftIsAuthRequiredEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftMOTDEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftRegisterSkinEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandConfirmCode;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerUpdateConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerChannelWrapper;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftByteBufEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftDecoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerMinecraftWrappedEncoder;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerUpdateSvc;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpServerQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerBungeeProtocol;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.MOTDQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.QueryManager;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.PreLoginEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class HttpWebSocketHandler
extends ChannelInboundHandlerAdapter {
    private final EaglerListenerConfig conf;
    private int clientLoginState = 0;
    private int clientProtocolVersion = -1;
    private boolean isProtocolExchanged = false;
    private int gameProtocolVersion = -1;
    private CharSequence clientBrandString;
    private CharSequence clientVersionString;
    private CharSequence clientUsername;
    private UUID clientUUID;
    private CharSequence clientRequestedServer;
    private boolean clientAuth;
    private byte[] clientAuthUsername;
    private byte[] clientAuthPassword;
    private EaglercraftIsAuthRequiredEvent authRequireEvent;
    private final Map<String, byte[]> profileData = new HashMap<String, byte[]>();
    private boolean hasFirstPacket = false;
    private boolean hasBinaryConnection = false;
    private boolean connectionClosed = false;
    private InetAddress remoteAddress;
    private String localAddrString;
    private Property texturesOverrideProperty;
    private boolean overrideEaglerToVanillaSkins;
    private static final byte[] legacyRedirectHeader;

    static {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bao);
        try {
            dos.writeByte(1);
            dos.writeInt(0);
            dos.writeShort(0);
            dos.writeByte(0);
            dos.writeByte(0);
            dos.writeByte(255);
            dos.writeByte(0);
            dos.writeByte(0);
            dos.writeByte(250);
            String channel = "EAG|Reconnect";
            int cl = channel.length();
            dos.writeShort(cl);
            int i = 0;
            while (i < cl) {
                dos.writeChar(channel.charAt(i));
                ++i;
            }
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        legacyRedirectHeader = bao.toByteArray();
    }

    public HttpWebSocketHandler(EaglerListenerConfig conf) {
        this.conf = conf;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            if (msg instanceof BinaryWebSocketFrame) {
                this.handleBinary(ctx, ((BinaryWebSocketFrame)msg).content());
            } else if (msg instanceof TextWebSocketFrame) {
                this.handleText(ctx, ((TextWebSocketFrame)msg).text());
            } else if (msg instanceof PingWebSocketFrame) {
                ctx.writeAndFlush((Object)new PongWebSocketFrame());
            } else if (msg instanceof CloseWebSocketFrame) {
                ctx.close();
            }
        } else {
            EaglerXBungee.logger().severe("Unexpected Packet: " + msg.getClass().getSimpleName());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            EaglerXBungee.logger().warning("[Yee][" + ctx.channel().remoteAddress() + "]: Exception Caught: " + cause.toString());
        }
    }

    private void handleBinary(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (this.connectionClosed) {
            return;
        }
        if (!this.hasFirstPacket) {
            String origin;
            if (buffer.readableBytes() >= 2 && buffer.getByte(0) == 2 && buffer.getByte(1) == 69) {
                this.handleLegacyClient(ctx, buffer);
                return;
            }
            this.hasFirstPacket = true;
            this.hasBinaryConnection = true;
            BungeeCord bungus = BungeeCord.getInstance();
            int limit = bungus.config.getPlayerLimit();
            if (limit > 0 && bungus.getOnlineCount() >= limit) {
                this.sendErrorCode(ctx, 8, bungus.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            if (this.conf.getMaxPlayer() > 0) {
                int i = 0;
                for (ProxiedPlayer p : bungus.getPlayers()) {
                    if (p.getPendingConnection().getListener() != this.conf) continue;
                    ++i;
                }
                if (i >= this.conf.getMaxPlayer()) {
                    this.sendErrorCode(ctx, 8, bungus.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.connectionClosed = true;
                    return;
                }
            }
            SocketAddress localSocketAddr = ctx.channel().remoteAddress();
            InetAddress addr = (InetAddress)ctx.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
            String limiterAddress = null;
            RateLimitStatus loginRateLimit = RateLimitStatus.OK;
            if (addr != null) {
                this.remoteAddress = addr;
                limiterAddress = addr.getHostAddress();
            } else if (localSocketAddr instanceof InetSocketAddress) {
                this.remoteAddress = ((InetSocketAddress)localSocketAddr).getAddress();
                limiterAddress = this.remoteAddress.getHostAddress();
            } else {
                this.remoteAddress = InetAddress.getLoopbackAddress();
            }
            EaglerRateLimiter limiter = this.conf.getRatelimitLogin();
            if (limiterAddress != null && limiter != null) {
                loginRateLimit = limiter.rateLimit(limiterAddress);
            }
            if (loginRateLimit == RateLimitStatus.LOCKED_OUT) {
                ctx.close();
                this.connectionClosed = true;
                return;
            }
            if (loginRateLimit != RateLimitStatus.OK) {
                this.sendErrorCode(ctx, loginRateLimit == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? 7 : 6, "Too many logins!").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            this.localAddrString = localSocketAddr.toString();
            EaglerXBungee.logger().info("[" + this.localAddrString + "]: Connected via websocket");
            if (addr != null) {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: Real address is " + addr.getHostAddress());
            }
            if ((origin = (String)ctx.channel().attr(EaglerPipeline.ORIGIN).get()) != null) {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: Origin header is " + origin);
            } else {
                EaglerXBungee.logger().info("[" + this.localAddrString + "]: No origin header is present!");
            }
        } else if (!this.hasBinaryConnection) {
            this.connectionClosed = true;
            ctx.close();
            return;
        }
        int op = -1;
        try {
            op = buffer.readUnsignedByte();
            switch (op) {
                case 1: {
                    if (this.clientLoginState == 0) {
                        InetAddress addr;
                        this.clientLoginState = 255;
                        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
                        EaglerAuthConfig authConfig = eaglerXBungee.getConfig().getAuthConfig();
                        int minecraftProtocolVersion = 47;
                        short eaglerLegacyProtocolVersion = buffer.readUnsignedByte();
                        if (eaglerLegacyProtocolVersion == 1) {
                            if (authConfig.isEnableAuthentication()) {
                                this.sendErrorCode(ctx, 8, "Please update your client to register on this server!").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            if (buffer.readUnsignedByte() != 47) {
                                this.clientLoginState = 3;
                                ByteBuf buf = Unpooled.buffer();
                                buf.writeByte(3);
                                buf.writeByte(1);
                                buf.writeByte(1);
                                buf.writeByte((int)eaglerLegacyProtocolVersion);
                                String str = "Outdated Client";
                                buf.writeByte(str.length());
                                buf.writeCharSequence((CharSequence)str, StandardCharsets.US_ASCII);
                                ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                        } else if (eaglerLegacyProtocolVersion == 2) {
                            int j;
                            int minProtVers = Integer.MAX_VALUE;
                            int maxProtVers = -1;
                            boolean hasV2InList = false;
                            boolean hasV3InList = false;
                            int minGameVers = Integer.MAX_VALUE;
                            int maxGameVers = -1;
                            boolean has47InList = false;
                            int cnt = buffer.readUnsignedShort();
                            int i = 0;
                            while (i < cnt) {
                                j = buffer.readUnsignedShort();
                                if (j == 2) {
                                    hasV2InList = true;
                                }
                                if (j == 3) {
                                    hasV3InList = true;
                                }
                                if (j > maxProtVers) {
                                    maxProtVers = j;
                                }
                                if (j < minProtVers) {
                                    minProtVers = j;
                                }
                                ++i;
                            }
                            cnt = buffer.readUnsignedShort();
                            i = 0;
                            while (i < cnt) {
                                j = buffer.readUnsignedShort();
                                if (j == 47) {
                                    has47InList = true;
                                }
                                if (j > maxGameVers) {
                                    maxGameVers = j;
                                }
                                if (j < minGameVers) {
                                    minGameVers = j;
                                }
                                ++i;
                            }
                            if (minProtVers == Integer.MAX_VALUE || minGameVers == Integer.MAX_VALUE) {
                                throw new IOException();
                            }
                            boolean versMisMatch = false;
                            boolean isServerProbablyOutdated = false;
                            boolean isClientProbablyOutdated = false;
                            if (!hasV2InList && !hasV3InList) {
                                versMisMatch = true;
                                isServerProbablyOutdated = minProtVers > 3 && maxProtVers > 3;
                                isClientProbablyOutdated = minProtVers < 2 && maxProtVers < 2;
                            } else if (!has47InList) {
                                versMisMatch = true;
                                isServerProbablyOutdated = minGameVers > 47 && maxGameVers > 47;
                                isClientProbablyOutdated = minGameVers < 47 && maxGameVers < 47;
                            }
                            int n = this.clientProtocolVersion = hasV3InList ? 3 : 2;
                            if (versMisMatch) {
                                this.clientLoginState = 3;
                                ByteBuf buf = Unpooled.buffer();
                                buf.writeByte(3);
                                buf.writeShort(2);
                                buf.writeShort(2);
                                buf.writeShort(3);
                                buf.writeShort(1);
                                buf.writeShort(47);
                                String str = isClientProbablyOutdated ? "Outdated Client" : (isServerProbablyOutdated ? "Outdated Server" : "Unsupported Client Version");
                                buf.writeByte(str.length());
                                buf.writeCharSequence((CharSequence)str, StandardCharsets.US_ASCII);
                                ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                        } else {
                            this.sendErrorCode(ctx, 8, "Legacy protocol version should always be '2' on post-snapshot clients").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        short strlen = buffer.readUnsignedByte();
                        CharSequence eaglerBrand = buffer.readCharSequence((int)strlen, StandardCharsets.US_ASCII);
                        strlen = buffer.readUnsignedByte();
                        CharSequence eaglerVersionString = buffer.readCharSequence((int)strlen, StandardCharsets.US_ASCII);
                        if (eaglerLegacyProtocolVersion >= 2) {
                            this.clientAuth = buffer.readBoolean();
                            strlen = buffer.readUnsignedByte();
                            this.clientAuthUsername = new byte[strlen];
                            buffer.readBytes(this.clientAuthUsername);
                        }
                        if (buffer.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        boolean useSnapshotFallbackProtocol = false;
                        if (eaglerLegacyProtocolVersion == 1 && !authConfig.isEnableAuthentication()) {
                            this.clientProtocolVersion = 2;
                            useSnapshotFallbackProtocol = true;
                            this.clientAuth = false;
                            this.clientAuthUsername = null;
                        }
                        if ((addr = (InetAddress)ctx.channel().attr(EaglerPipeline.REAL_ADDRESS).get()) == null) {
                            SocketAddress remoteSocketAddr = ctx.channel().remoteAddress();
                            addr = remoteSocketAddr instanceof InetSocketAddress ? ((InetSocketAddress)remoteSocketAddr).getAddress() : InetAddress.getLoopbackAddress();
                        }
                        boolean final_useSnapshotFallbackProtocol = useSnapshotFallbackProtocol;
                        Runnable continueThread = () -> {
                            this.clientLoginState = 1;
                            this.gameProtocolVersion = 47;
                            this.clientBrandString = eaglerBrand;
                            this.clientVersionString = eaglerVersionString;
                            ByteBuf buf = Unpooled.buffer();
                            buf.writeByte(2);
                            if (final_useSnapshotFallbackProtocol) {
                                buf.writeByte(1);
                            } else {
                                buf.writeShort(this.clientProtocolVersion);
                                buf.writeShort(47);
                            }
                            String brandStr = eaglerXBungee.getDescription().getName();
                            buf.writeByte(brandStr.length());
                            buf.writeCharSequence((CharSequence)brandStr, StandardCharsets.US_ASCII);
                            String versStr = eaglerXBungee.getDescription().getVersion();
                            buf.writeByte(versStr.length());
                            buf.writeCharSequence((CharSequence)versStr, StandardCharsets.US_ASCII);
                            if (!authConfig.isEnableAuthentication() || !this.clientAuth) {
                                buf.writeByte(0);
                                buf.writeShort(0);
                            } else {
                                int meth = this.getAuthMethodId(this.authRequireEvent.getUseAuthType());
                                if (meth == -1) {
                                    this.sendErrorCode(ctx, 8, "Unsupported authentication method resolved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                    EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, unsupported AuthMethod: " + (Object)((Object)this.authRequireEvent.getUseAuthType()));
                                    return;
                                }
                                buf.writeByte(meth);
                                byte[] saltingData = this.authRequireEvent.getSaltingData();
                                if (saltingData != null) {
                                    buf.writeShort(saltingData.length);
                                    buf.writeBytes(saltingData);
                                } else {
                                    buf.writeShort(0);
                                }
                            }
                            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf));
                            this.isProtocolExchanged = true;
                        };
                        this.authRequireEvent = null;
                        if (authConfig.isEnableAuthentication()) {
                            String origin = (String)ctx.channel().attr(EaglerPipeline.ORIGIN).get();
                            try {
                                this.authRequireEvent = new EaglercraftIsAuthRequiredEvent(this.conf, this.remoteAddress, origin, this.clientAuth, this.clientAuthUsername, reqAuthEvent -> {
                                    if (this.authRequireEvent.shouldKickUser()) {
                                        this.sendErrorCode(ctx, 8, this.authRequireEvent.getKickMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        return;
                                    }
                                    EaglercraftIsAuthRequiredEvent.AuthResponse resp = this.authRequireEvent.getAuthRequired();
                                    if (resp == null) {
                                        this.sendErrorCode(ctx, 8, "IsAuthRequiredEvent was not handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no installed authentication system handled: " + ((Object)((Object)this.authRequireEvent)).toString());
                                        return;
                                    }
                                    if (resp == EaglercraftIsAuthRequiredEvent.AuthResponse.DENY) {
                                        this.sendErrorCode(ctx, 8, this.authRequireEvent.getKickMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        return;
                                    }
                                    EaglercraftIsAuthRequiredEvent.AuthMethod type = this.authRequireEvent.getUseAuthType();
                                    if (type == null) {
                                        this.sendErrorCode(ctx, 8, "IsAuthRequiredEvent was not fully handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no authentication method provided by handler");
                                        return;
                                    }
                                    int typeId = this.getAuthMethodId(type);
                                    if (typeId == -1) {
                                        this.sendErrorCode(ctx, 8, "Unsupported authentication method resolved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, unsupported AuthMethod: " + (Object)((Object)type));
                                        return;
                                    }
                                    if (!this.clientAuth && resp == EaglercraftIsAuthRequiredEvent.AuthResponse.REQUIRE) {
                                        this.sendErrorCode(ctx, 9, "Authentication Required: [" + typeId + "] " + this.authRequireEvent.getAuthMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().info("[" + this.localAddrString + "]: Displaying authentication screen");
                                        return;
                                    }
                                    if (this.authRequireEvent.getUseAuthType() == null) {
                                        this.sendErrorCode(ctx, 8, "IsAuthRequiredEvent was not fully handled").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        EaglerXBungee.logger().severe("[" + this.localAddrString + "]: Disconnecting, no authentication method provided by handler");
                                        return;
                                    }
                                    continueThread.run();
                                });
                                if (authConfig.isUseBuiltInAuthentication()) {
                                    DefaultAuthSystem authSystem = eaglerXBungee.getAuthService();
                                    if (authSystem != null) {
                                        authSystem.handleIsAuthRequiredEvent(this.authRequireEvent);
                                    }
                                } else {
                                    eaglerXBungee.getProxy().getPluginManager().callEvent((Event)this.authRequireEvent);
                                }
                                if (!this.authRequireEvent.isAsyncContinue()) {
                                    this.authRequireEvent.doDirectContinue();
                                }
                                break;
                            }
                            catch (Throwable t) {
                                throw new EventException(t);
                            }
                        }
                        continueThread.run();
                        break;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(ctx, op, "STATE_OPENED").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 4: {
                    int strlen;
                    if (this.clientLoginState == 1) {
                        this.clientLoginState = 255;
                        strlen = buffer.readUnsignedByte();
                        this.clientUsername = buffer.readCharSequence(strlen, StandardCharsets.US_ASCII);
                        String usrs = this.clientUsername.toString();
                        if (!usrs.equals(usrs.replaceAll("[^A-Za-z0-9_]", "_").trim())) {
                            this.sendLoginDenied(ctx, "Invalid characters in username").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientUsername.length() < 3) {
                            this.sendLoginDenied(ctx, "Username must be at least 3 characters").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientUsername.length() > 16) {
                            this.sendLoginDenied(ctx, "Username must be under 16 characters").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        if (this.clientAuthUsername == null) {
                            this.clientAuthUsername = new byte[strlen];
                            int i = 0;
                            while (i < strlen) {
                                this.clientAuthUsername[i] = (byte)this.clientUsername.charAt(i);
                                ++i;
                            }
                        }
                        String offlinePlayerStr = "OfflinePlayer:";
                        byte[] uuidHashGenerator = new byte[offlinePlayerStr.length() + this.clientAuthUsername.length];
                        System.arraycopy(offlinePlayerStr.getBytes(StandardCharsets.US_ASCII), 0, uuidHashGenerator, 0, offlinePlayerStr.length());
                        System.arraycopy(this.clientAuthUsername, 0, uuidHashGenerator, offlinePlayerStr.length(), this.clientAuthUsername.length);
                        this.clientUUID = UUID.nameUUIDFromBytes(uuidHashGenerator);
                        strlen = buffer.readUnsignedByte();
                        this.clientRequestedServer = buffer.readCharSequence(strlen, StandardCharsets.US_ASCII);
                        strlen = buffer.readUnsignedByte();
                        this.clientAuthPassword = new byte[strlen];
                        buffer.readBytes(this.clientAuthPassword);
                        if (buffer.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        Runnable continueThread = () -> {
                            String usernameStr;
                            BungeeCord bungee = BungeeCord.getInstance();
                            ProxiedPlayer oldName = bungee.getPlayer(usernameStr = this.clientUsername.toString());
                            if (oldName != null) {
                                this.sendLoginDenied(ctx, bungee.getTranslation("already_connected_proxy", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            this.clientLoginState = 2;
                            ByteBuf buf = Unpooled.buffer();
                            buf.writeByte(5);
                            buf.writeByte(this.clientUsername.length());
                            buf.writeCharSequence(this.clientUsername, StandardCharsets.US_ASCII);
                            buf.writeLong(this.clientUUID.getMostSignificantBits());
                            buf.writeLong(this.clientUUID.getLeastSignificantBits());
                            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf));
                        };
                        EaglerXBungee eaglerXBungee = EaglerXBungee.getEagler();
                        EaglerAuthConfig authConfig = eaglerXBungee.getConfig().getAuthConfig();
                        if (authConfig.isEnableAuthentication() && this.clientAuth) {
                            if (this.clientAuthPassword.length == 0) {
                                this.sendLoginDenied(ctx, "Client provided no authentication code").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                return;
                            }
                            try {
                                EaglercraftHandleAuthPasswordEvent handleEvent = new EaglercraftHandleAuthPasswordEvent(this.conf, this.remoteAddress, this.authRequireEvent.getOriginHeader(), this.clientAuthUsername, this.authRequireEvent.getSaltingData(), this.clientUsername, this.clientUUID, this.clientAuthPassword, this.authRequireEvent.getUseAuthType(), this.authRequireEvent.getAuthMessage(), this.authRequireEvent.getAuthAttachment(), this.clientRequestedServer.toString(), handleAuthEvent -> {
                                    if (handleAuthEvent.getLoginAllowed() != EaglercraftHandleAuthPasswordEvent.AuthResponse.ALLOW) {
                                        this.sendLoginDenied(ctx, handleAuthEvent.getLoginDeniedMessage()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                                        return;
                                    }
                                    this.clientUsername = handleAuthEvent.getProfileUsername();
                                    this.clientUUID = handleAuthEvent.getProfileUUID();
                                    String texPropOverrideValue = handleAuthEvent.getApplyTexturesPropertyValue();
                                    if (texPropOverrideValue != null) {
                                        String texPropOverrideSig = handleAuthEvent.getApplyTexturesPropertySignature();
                                        this.texturesOverrideProperty = new Property("textures", texPropOverrideValue, texPropOverrideSig);
                                    }
                                    this.overrideEaglerToVanillaSkins = handleAuthEvent.isOverrideEaglerToVanillaSkins();
                                    continueThread.run();
                                });
                                if (authConfig.isUseBuiltInAuthentication()) {
                                    DefaultAuthSystem authSystem = eaglerXBungee.getAuthService();
                                    if (authSystem != null) {
                                        authSystem.handleAuthPasswordEvent(handleEvent);
                                    }
                                } else {
                                    eaglerXBungee.getProxy().getPluginManager().callEvent((Event)handleEvent);
                                }
                                if (!handleEvent.isAsyncContinue()) {
                                    handleEvent.doDirectContinue();
                                }
                                break;
                            }
                            catch (Throwable t) {
                                throw new EventException(t);
                            }
                        }
                        continueThread.run();
                        break;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(ctx, op, "STATE_CLIENT_VERSION").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 7: {
                    int strlen;
                    if (this.clientLoginState == 2) {
                        if (this.profileData.size() > 12) {
                            this.sendErrorCode(ctx, 4, "Too many profile data packets recieved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            return;
                        }
                        strlen = buffer.readUnsignedByte();
                        String dataType = buffer.readCharSequence(strlen, StandardCharsets.US_ASCII).toString();
                        strlen = buffer.readUnsignedShort();
                        byte[] readData = new byte[strlen];
                        buffer.readBytes(readData);
                        if (buffer.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        if (!this.profileData.containsKey(dataType)) {
                            this.profileData.put(dataType, readData);
                            break;
                        }
                        this.sendErrorCode(ctx, 5, "Multiple profile data packets of the same type recieved").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                        return;
                    }
                    this.clientLoginState = 3;
                    this.sendErrorWrong(ctx, op, "STATE_CLIENT_LOGIN").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                case 8: {
                    if (this.clientLoginState == 2) {
                        this.clientLoginState = 255;
                        if (buffer.isReadable()) {
                            throw new IllegalArgumentException("Packet too long");
                        }
                        this.finish(ctx);
                        this.clientLoginState = 3;
                        break;
                    }
                    this.sendErrorWrong(ctx, op, "STATE_CLIENT_LOGIN").addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                default: {
                    this.clientLoginState = 3;
                    this.sendErrorCode(ctx, 1, "Unknown Packet #" + op).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
            }
        }
        catch (Throwable ex) {
            if (ex instanceof EventException) {
                EaglerXBungee.logger().log(Level.SEVERE, "[" + this.localAddrString + "]: Hanshake packet " + op + " caught an exception", ex.getCause());
            }
            this.clientLoginState = 3;
            this.sendErrorCode(ctx, 2, op == -1 ? "Invalid Packet" : "Invalid Packet #" + op).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(final ChannelHandlerContext ctx) {
        byte[] b;
        String usernameStr;
        ProxiedPlayer oldName;
        final BungeeCord bungee = BungeeCord.getInstance();
        int limit = bungee.config.getPlayerLimit();
        if (limit > 0 && bungee.getOnlineCount() >= limit) {
            this.sendErrorCode(ctx, 8, bungee.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.connectionClosed = true;
            return;
        }
        if (this.conf.getMaxPlayer() > 0) {
            int i = 0;
            for (ProxiedPlayer p : bungee.getPlayers()) {
                if (p.getPendingConnection().getListener() != this.conf) continue;
                ++i;
            }
            if (i >= this.conf.getMaxPlayer()) {
                this.sendErrorCode(ctx, 8, bungee.getTranslation("proxy_full", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
        }
        if ((oldName = bungee.getPlayer(usernameStr = this.clientUsername.toString())) != null) {
            this.sendErrorCode(ctx, 8, bungee.getTranslation("already_connected_proxy", new Object[0])).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        final EaglerChannelWrapper ch = new EaglerChannelWrapper(ctx);
        InetSocketAddress baseAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        InetAddress addr = (InetAddress)ctx.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
        if (addr != null) {
            baseAddress = new InetSocketAddress(addr, baseAddress.getPort());
            ch.setRemoteAddress(baseAddress);
        }
        EaglerUpdateConfig updateconf = EaglerXBungee.getEagler().getConfig().getUpdateConfig();
        boolean blockUpdate = updateconf.isBlockAllClientUpdates();
        EaglerInitialHandler.ClientCertificateHolder cert = null;
        if (!blockUpdate && !updateconf.isDiscardLoginPacketCerts() && (b = this.profileData.get("update_cert_v1")) != null && b.length < 32759) {
            EaglerUpdateSvc.sendCertificateToPlayers(EaglerUpdateSvc.tryMakeHolder(b));
        }
        final EaglerInitialHandler initialHandler = new EaglerInitialHandler(bungee, this.conf, ch, this.gameProtocolVersion, usernameStr, this.clientUUID, baseAddress, (String)ctx.channel().attr(EaglerPipeline.HOST).get(), (String)ctx.channel().attr(EaglerPipeline.ORIGIN).get(), cert);
        if (!blockUpdate) {
            List<EaglerInitialHandler.ClientCertificateHolder> set;
            List<EaglerInitialHandler.ClientCertificateHolder> list = set = EaglerUpdateSvc.getCertList();
            synchronized (list) {
                initialHandler.certificatesToSend.addAll(set);
            }
            for (ProxiedPlayer p : bungee.getPlayers()) {
                if (!(p.getPendingConnection() instanceof EaglerInitialHandler)) continue;
                EaglerInitialHandler pp = (EaglerInitialHandler)p.getPendingConnection();
                if (pp.clientCertificate == null || pp.clientCertificate == cert) continue;
                initialHandler.certificatesToSend.add(pp.clientCertificate);
            }
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    BaseComponent[] reason = result.getCancelReasonComponents();
                    HttpWebSocketHandler.this.sendErrorCode(ctx, 8, ComponentSerializer.toString((BaseComponent[])(reason != null ? reason : TextComponent.fromLegacyText((String)bungee.getTranslation("kick_message", new Object[0]))))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    return;
                }
                if (!ctx.channel().isActive()) {
                    return;
                }
                ByteBuf buf = Unpooled.buffer();
                buf.writeByte(9);
                ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

                    public void operationComplete(Future<Void> var1) throws Exception {
                        Property[] props;
                        LoginResult res;
                        String vanillaSkin;
                        EaglerConnectionInstance eaglerCon = (EaglerConnectionInstance)ctx.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
                        EaglerXBungee.logger().info("[" + ctx.channel().remoteAddress() + "]: Logged in as '" + usernameStr + "'");
                        UserConnection userCon = eaglerCon.userConnection = new UserConnection((ProxyServer)bungee, ch, usernameStr, (InitialHandler)initialHandler);
                        userCon.setCompressionThreshold(-1);
                        try {
                            if (!userCon.init()) {
                                userCon.disconnect(bungee.getTranslation("already_connected_proxy", new Object[0]));
                                EaglerPipeline.closeChannel(ctx.channel());
                                return;
                            }
                        }
                        catch (NoSuchMethodError e) {
                            UserConnection.class.getDeclaredMethod("init", new Class[0]).invoke((Object)userCon, new Object[0]);
                        }
                        ChannelPipeline pp = ctx.channel().pipeline();
                        HandlerBoss handler = new HandlerBoss(){

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                super.channelInactive(ctx);
                                EaglerPipeline.closeChannel(ctx.channel());
                            }
                        };
                        handler.setHandler((PacketHandler)new UpstreamBridge((ProxyServer)bungee, userCon));
                        try {
                            handler.channelActive(ctx);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        pp.replace((ChannelHandler)HttpWebSocketHandler.this, "HandlerBoss", (ChannelHandler)handler);
                        pp.addBefore("HandlerBoss", "ReadTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler((long)BungeeCord.getInstance().config.getTimeout(), TimeUnit.MILLISECONDS));
                        pp.addBefore("HandlerBoss", "EaglerMinecraftDecoder", (ChannelHandler)new EaglerMinecraftDecoder(EaglerBungeeProtocol.GAME, false, HttpWebSocketHandler.this.gameProtocolVersion));
                        pp.addBefore("HandlerBoss", "EaglerMinecraftByteBufEncoder", (ChannelHandler)new EaglerMinecraftByteBufEncoder());
                        pp.addBefore("HandlerBoss", "EaglerMinecraftWrappedEncoder", (ChannelHandler)new EaglerMinecraftWrappedEncoder());
                        pp.addBefore("HandlerBoss", "EaglerMinecraftEncoder", (ChannelHandler)new EaglerMinecraftEncoder(EaglerBungeeProtocol.GAME, true, HttpWebSocketHandler.this.gameProtocolVersion));
                        boolean doRegisterSkins = true;
                        EaglercraftRegisterSkinEvent registerSkinEvent = new EaglercraftRegisterSkinEvent(usernameStr, HttpWebSocketHandler.this.clientUUID);
                        bungee.getPluginManager().callEvent((Event)registerSkinEvent);
                        Property prop = registerSkinEvent.getForceUseMojangProfileProperty();
                        boolean useExistingProp = registerSkinEvent.getForceUseLoginResultObjectTextures();
                        if (prop != null) {
                            HttpWebSocketHandler.this.texturesOverrideProperty = prop;
                            HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = true;
                        } else if (useExistingProp) {
                            HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = true;
                        } else {
                            byte[] custom = registerSkinEvent.getForceSetUseCustomPacket();
                            if (custom != null) {
                                HttpWebSocketHandler.this.profileData.put("skin_v1", custom);
                                HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = false;
                            } else {
                                String customUrl = registerSkinEvent.getForceSetUseURL();
                                if (customUrl != null) {
                                    EaglerXBungee.getEagler().getSkinService().registerTextureToPlayerAssociation(customUrl, initialHandler.getUniqueId());
                                    doRegisterSkins = false;
                                    HttpWebSocketHandler.this.overrideEaglerToVanillaSkins = false;
                                }
                            }
                        }
                        EaglerBungeeConfig eaglerConf = EaglerXBungee.getEagler().getConfig();
                        if (HttpWebSocketHandler.this.texturesOverrideProperty != null) {
                            LoginResult oldProfile = initialHandler.getLoginProfile();
                            if (oldProfile == null) {
                                oldProfile = new LoginResult(initialHandler.getUniqueId().toString(), initialHandler.getName(), null);
                                initialHandler.setLoginProfile(oldProfile);
                            }
                            oldProfile.setProperties(new Property[]{HttpWebSocketHandler.this.texturesOverrideProperty, EaglerBungeeConfig.isEaglerProperty});
                        } else if (!useExistingProp && (vanillaSkin = eaglerConf.getEaglerPlayersVanillaSkin()) != null) {
                            LoginResult oldProfile = initialHandler.getLoginProfile();
                            if (oldProfile == null) {
                                oldProfile = new LoginResult(initialHandler.getUniqueId().toString(), initialHandler.getName(), null);
                                initialHandler.setLoginProfile(oldProfile);
                            }
                            oldProfile.setProperties(eaglerConf.getEaglerPlayersVanillaSkinProperties());
                        }
                        if (HttpWebSocketHandler.this.overrideEaglerToVanillaSkins && (res = initialHandler.getLoginProfile()) != null && (props = res.getProperties()) != null) {
                            int i = 0;
                            while (i < props.length) {
                                if ("textures".equals(props[i].getName())) {
                                    try {
                                        JsonElement url;
                                        String jsonStr = SkinPackets.bytesToAscii(Base64.decodeBase64((String)props[i].getValue()));
                                        JsonObject json = new JsonParser().parse(jsonStr).getAsJsonObject();
                                        JsonObject skinObj = json.getAsJsonObject("SKIN");
                                        if (skinObj != null && (url = json.get("url")) != null) {
                                            String urlStr = SkinService.sanitizeTextureURL(url.getAsString());
                                            EaglerXBungee.getEagler().getSkinService().registerTextureToPlayerAssociation(urlStr, initialHandler.getUniqueId());
                                        }
                                        doRegisterSkins = false;
                                    }
                                    catch (Throwable throwable) {}
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (doRegisterSkins) {
                            if (HttpWebSocketHandler.this.profileData.containsKey("skin_v1")) {
                                try {
                                    SkinPackets.registerEaglerPlayer(HttpWebSocketHandler.this.clientUUID, (byte[])HttpWebSocketHandler.this.profileData.get("skin_v1"), EaglerXBungee.getEagler().getSkinService());
                                }
                                catch (Throwable ex) {
                                    SkinPackets.registerEaglerPlayerFallback(HttpWebSocketHandler.this.clientUUID, EaglerXBungee.getEagler().getSkinService());
                                    EaglerXBungee.logger().info("[" + ctx.channel().remoteAddress() + "]: Invalid skin packet: " + ex.toString());
                                }
                            } else {
                                SkinPackets.registerEaglerPlayerFallback(HttpWebSocketHandler.this.clientUUID, EaglerXBungee.getEagler().getSkinService());
                            }
                        }
                        bungee.getPluginManager().callEvent((Event)new PostLoginEvent((ProxiedPlayer)userCon));
                        ServerInfo server = bungee.getReconnectHandler() != null ? bungee.getReconnectHandler().getServer((ProxiedPlayer)userCon) : AbstractReconnectHandler.getForcedHost((PendingConnection)initialHandler);
                        if (server == null) {
                            server = bungee.getServerInfo(HttpWebSocketHandler.this.conf.getDefaultServer());
                        }
                        eaglerCon.hasBeenForwarded = true;
                        userCon.connect(server, null, true, ServerConnectEvent.Reason.JOIN_PROXY);
                    }
                });
            }
        };
        Callback<PreLoginEvent> completePre = new Callback<PreLoginEvent>((Callback)complete){
            private final /* synthetic */ Callback val$complete;
            {
                this.val$complete = callback;
            }

            public void done(PreLoginEvent var1, Throwable var2) {
                if (var1.isCancelled()) {
                    BaseComponent[] reason = var1.getCancelReasonComponents();
                    HttpWebSocketHandler.this.sendErrorCode(ctx, 8, ComponentSerializer.toString((BaseComponent[])(reason != null ? reason : TextComponent.fromLegacyText((String)bungee.getTranslation("kick_message", new Object[0]))))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    bungee.getPluginManager().callEvent((Event)new LoginEvent((PendingConnection)initialHandler, this.val$complete));
                }
            }
        };
        bungee.getPluginManager().callEvent((Event)new PreLoginEvent((PendingConnection)initialHandler, (Callback)completePre));
    }

    private void handleText(ChannelHandlerContext ctx, String str) {
        if (this.connectionClosed) {
            return;
        }
        if (!this.hasFirstPacket && (this.conf.isAllowMOTD() || this.conf.isAllowQuery()) && (str = str.toLowerCase()).startsWith("accept:")) {
            EaglerRateLimiter limiter;
            str = str.substring(7).trim();
            this.hasFirstPacket = true;
            this.hasBinaryConnection = false;
            if (CommandConfirmCode.confirmHash != null && str.equalsIgnoreCase(CommandConfirmCode.confirmHash)) {
                ctx.writeAndFlush((Object)new TextWebSocketFrame("OK")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                CommandConfirmCode.confirmHash = null;
                this.connectionClosed = true;
                return;
            }
            boolean isMOTD = str.startsWith("motd");
            SocketAddress localSocketAddr = ctx.channel().remoteAddress();
            InetAddress addr = (InetAddress)ctx.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
            String limiterAddress = null;
            RateLimitStatus queryRateLimit = RateLimitStatus.OK;
            if (addr != null) {
                limiterAddress = addr.getHostAddress();
            } else if (localSocketAddr instanceof InetSocketAddress) {
                limiterAddress = ((InetSocketAddress)localSocketAddr).getAddress().getHostAddress();
            }
            EaglerRateLimiter eaglerRateLimiter = limiter = isMOTD ? this.conf.getRatelimitMOTD() : this.conf.getRatelimitQuery();
            if (limiterAddress != null && limiter != null) {
                queryRateLimit = limiter.rateLimit(limiterAddress);
            }
            if (queryRateLimit == RateLimitStatus.LOCKED_OUT) {
                ctx.close();
                this.connectionClosed = true;
                return;
            }
            if (queryRateLimit != RateLimitStatus.OK) {
                RateLimitStatus rateLimitTypeFinal = queryRateLimit;
                ctx.writeAndFlush((Object)new TextWebSocketFrame(rateLimitTypeFinal == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? "{\"type\":\"locked\"}" : "{\"type\":\"blocked\"}")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.connectionClosed = true;
                return;
            }
            HttpServerQueryHandler handler = null;
            if (isMOTD) {
                if (this.conf.isAllowMOTD()) {
                    handler = new MOTDQueryHandler();
                }
            } else if (this.conf.isAllowQuery()) {
                handler = QueryManager.createQueryHandler(str);
            }
            if (handler != null) {
                ctx.pipeline().replace((ChannelHandler)this, "HttpServerQueryHandler", (ChannelHandler)handler);
                ctx.pipeline().addBefore("HttpServerQueryHandler", "WriteTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler(5L, TimeUnit.SECONDS));
                handler.beginHandleQuery(this.conf, ctx, str);
                if (handler instanceof MOTDQueryHandler) {
                    EaglercraftMOTDEvent evt = new EaglercraftMOTDEvent((MOTDQueryHandler)handler);
                    BungeeCord.getInstance().getPluginManager().callEvent((Event)evt);
                    if (!handler.isClosed()) {
                        ((MOTDQueryHandler)handler).sendToUser();
                    }
                }
                if (!handler.isClosed() && !handler.shouldKeepAlive()) {
                    this.connectionClosed = true;
                    handler.close();
                }
            } else {
                this.connectionClosed = true;
                ctx.close();
            }
        } else {
            this.connectionClosed = true;
            ctx.close();
            return;
        }
    }

    private int getAuthMethodId(EaglercraftIsAuthRequiredEvent.AuthMethod meth) {
        switch (meth) {
            case PLAINTEXT: {
                return 255;
            }
            case EAGLER_SHA256: {
                return 1;
            }
            case AUTHME_SHA256: {
                return 2;
            }
        }
        return -1;
    }

    private ChannelFuture sendLoginDenied(ChannelHandlerContext ctx, String reason) {
        if (!(this.isProtocolExchanged && this.clientProtocolVersion != 2 || reason.length() <= 255)) {
            reason = reason.substring(0, 256);
        } else if (reason.length() > 65535) {
            reason = reason.substring(0, 65536);
        }
        this.clientLoginState = 3;
        this.connectionClosed = true;
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(6);
        byte[] msg = reason.getBytes(StandardCharsets.UTF_8);
        if (!this.isProtocolExchanged || this.clientProtocolVersion == 2) {
            buf.writeByte(msg.length);
        } else {
            buf.writeShort(msg.length);
        }
        buf.writeBytes(msg);
        return ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf));
    }

    private ChannelFuture sendErrorWrong(ChannelHandlerContext ctx, int op, String state) {
        return this.sendErrorCode(ctx, 3, "Wrong Packet #" + op + " in state '" + state + "'");
    }

    private ChannelFuture sendErrorCode(ChannelHandlerContext ctx, int code, String str) {
        if (!(this.isProtocolExchanged && this.clientProtocolVersion != 2 || str.length() <= 255)) {
            str = str.substring(0, 256);
        } else if (str.length() > 65535) {
            str = str.substring(0, 65536);
        }
        this.clientLoginState = 3;
        this.connectionClosed = true;
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(255);
        buf.writeByte(code);
        byte[] msg = str.getBytes(StandardCharsets.UTF_8);
        if (!this.isProtocolExchanged || this.clientProtocolVersion == 2) {
            buf.writeByte(msg.length);
        } else {
            buf.writeShort(msg.length);
        }
        buf.writeBytes(msg);
        return ctx.writeAndFlush((Object)new BinaryWebSocketFrame(buf));
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.connectionClosed = true;
        EaglerPipeline.closeChannel(ctx.channel());
    }

    private void handleLegacyClient(final ChannelHandlerContext ctx, ByteBuf buffer) {
        this.connectionClosed = true;
        ByteBuf kickMsg = ctx.alloc().buffer();
        final String redir = this.conf.redirectLegacyClientsTo();
        if (redir != null) {
            HttpWebSocketHandler.writeLegacyRedirect(kickMsg, redir);
        } else {
            HttpWebSocketHandler.writeLegacyKick(kickMsg, "This is an EaglercraftX 1.8 server, it is not compatible with 1.5.2!");
        }
        ctx.writeAndFlush((Object)new BinaryWebSocketFrame(kickMsg)).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture var1) throws Exception {
                ctx.channel().eventLoop().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ctx.close();
                    }
                }, redir != null ? 100L : 500L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public static void writeLegacyKick(ByteBuf buffer, String message) {
        buffer.writeByte(255);
        buffer.writeShort(message.length());
        int i = 0;
        int l = message.length();
        while (i < l) {
            char j = message.charAt(i);
            buffer.writeByte(j >> 8 & 0xFF);
            buffer.writeByte(j & 0xFF);
            ++i;
        }
    }

    public static void writeLegacyRedirect(ByteBuf buffer, String redirect) {
        buffer.writeBytes(legacyRedirectHeader);
        byte[] redirect_ = redirect.getBytes(StandardCharsets.UTF_8);
        buffer.writeByte(redirect_.length >> 8 & 0xFF);
        buffer.writeByte(redirect_.length & 0xFF);
        buffer.writeBytes(redirect_);
    }

    private static class EventException
    extends RuntimeException {
        public EventException(Throwable t) {
            super(t.toString(), t);
        }
    }
}

