/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command;

import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.command.ConsoleCommandSender;

public class CommandEaglerPurge
extends Command {
    public CommandEaglerPurge(String name) {
        super(String.valueOf(name) + "-purge", "eaglercraft.command.purge", new String[0]);
    }

    public void execute(CommandSender var1, String[] var2) {
        if (var1 instanceof ConsoleCommandSender) {
            DefaultAuthSystem srv;
            int mx;
            if (var2.length != 1) {
                TextComponent comp = new TextComponent("Use /" + this.getName() + " <maxAge>");
                comp.setColor(ChatColor.RED);
                var1.sendMessage((BaseComponent)comp);
                return;
            }
            try {
                mx = Integer.parseInt(var2[0]);
            }
            catch (NumberFormatException ex) {
                TextComponent comp = new TextComponent("'" + var2[0] + "' is not an integer!");
                comp.setColor(ChatColor.RED);
                var1.sendMessage((BaseComponent)comp);
                return;
            }
            EaglerAuthConfig authConf = EaglerXBungee.getEagler().getConfig().getAuthConfig();
            if (authConf.isEnableAuthentication() && authConf.isUseBuiltInAuthentication() && (srv = EaglerXBungee.getEagler().getAuthService()) != null) {
                int cnt;
                try {
                    EaglerXBungee.logger().warning("Console is attempting to purge all accounts with " + mx + " days of inactivity");
                    cnt = srv.pruneUsers(System.currentTimeMillis() - (long)mx * 86400000L);
                }
                catch (DefaultAuthSystem.AuthException ex) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Failed to purge accounts", ex);
                    TextComponent comp = new TextComponent("Failed to purge, check log! Reason: " + ex.getMessage());
                    comp.setColor(ChatColor.AQUA);
                    var1.sendMessage((BaseComponent)comp);
                    return;
                }
                EaglerXBungee.logger().warning("Console purged " + cnt + " accounts from auth database");
                TextComponent comp = new TextComponent("Purged " + cnt + " old accounts from the database");
                comp.setColor(ChatColor.AQUA);
                var1.sendMessage((BaseComponent)comp);
            }
        } else {
            TextComponent comp = new TextComponent("This command can only be run from the console!");
            comp.setColor(ChatColor.RED);
            var1.sendMessage((BaseComponent)comp);
        }
    }
}

