/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVMappings {
    public final Map<String, Symbol> csvFieldsMappings = new HashMap<String, Symbol>();
    public final Map<String, Symbol> csvMethodsMappings = new HashMap<String, Symbol>();
    public final Map<String, Param> csvParamsMappings = new HashMap<String, Param>();
    public final Map<String, Param[]> csvParamsForFunction = new HashMap<String, Param[]>();

    public void loadMethodsFile(Reader reader) throws IOException {
        this.loadSymbols(reader, this.csvMethodsMappings, "methods.csv");
    }

    public void loadFieldsFile(Reader reader) throws IOException {
        this.loadSymbols(reader, this.csvFieldsMappings, "fields.csv");
    }

    private void loadSymbols(Reader reader, Map<String, Symbol> map, String string) throws IOException {
        try {
            CSVParser cSVParser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(reader);
            for (CSVRecord cSVRecord : cSVParser) {
                String string2 = cSVRecord.get("searge");
                String string3 = cSVRecord.get("name");
                int n = Integer.parseInt(cSVRecord.get("side"));
                String string4 = cSVRecord.get("desc");
                map.put(string2, new Symbol(string3, n, string4));
            }
            System.out.println("   Loaded " + map.size() + " symbols from " + string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Invalid " + string + " file!");
        }
    }

    public void loadParamsFile(Reader reader) throws IOException {
        try {
            CSVParser cSVParser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(reader);
            for (CSVRecord cSVRecord : cSVParser) {
                int n;
                String string = cSVRecord.get("param");
                String string2 = cSVRecord.get("name");
                int n2 = Integer.parseInt(cSVRecord.get("side"));
                this.csvParamsMappings.put(string, new Param(string2, n2));
                String string3 = string.substring(string.indexOf(95) + 1);
                if (string3.startsWith("i") || (n = string3.indexOf(95)) == -1) continue;
                int n3 = -1;
                String string4 = string3.substring(n + 1);
                if (string4.length() >= 2) {
                    try {
                        n3 = Integer.parseInt(string4.substring(0, string4.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (n3 < 0) continue;
                Param[] paramArray = this.csvParamsForFunction.get(string3 = "func_" + string3.substring(0, n));
                if (paramArray == null || paramArray.length <= n3) {
                    Param[] paramArray2 = new Param[n3 + 1];
                    if (paramArray != null) {
                        System.arraycopy(paramArray, 0, paramArray2, 0, paramArray.length);
                    }
                    paramArray = paramArray2;
                }
                paramArray[n3] = new Param(string2, n2);
                this.csvParamsForFunction.put(string3, paramArray);
            }
            System.out.println("   Loaded " + this.csvParamsMappings.size() + " symbols from params.csv");
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid params.csv file!");
        }
    }

    public static class Param {
        public final String name;
        public final int mod;

        public Param(String string, int n) {
            this.name = string;
            this.mod = n;
        }
    }

    public static class Symbol {
        public final String name;
        public final int mod;
        public final String comment;

        public Symbol(String string, int n, String string2) {
            this.name = string;
            this.mod = n;
            this.comment = string2;
        }
    }
}

