/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.CRC32;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.JARMemoryCache;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.Lines;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.formatter.EclipseFormatter;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InsertJavaDoc;
import net.lax1dude.eaglercraft.v1_8.buildtools.util.FileWriterUTF;
import org.apache.commons.io.FileUtils;

public class PullRequestTask {
    private static final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();
    private static final String hex = "0123456789ABCDEF";

    public static boolean pullRequest() {
        try {
            return PullRequestTask.pullRequest0();
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'pullrequest'!");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean pullRequest0() throws Throwable {
        Object object;
        File file = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src.jar");
        File file2 = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src_patch.jar");
        File file3 = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src_javadoc.jar");
        File file4 = new File(EaglerBuildTools.repositoryRoot, "sources/main/java");
        File file5 = new File(EaglerBuildTools.repositoryRoot, "sources/teavm/java");
        File file6 = new File(EaglerBuildTools.repositoryRoot, "sources/lwjgl/java");
        File file7 = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_res.jar");
        File file8 = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_res_patch.jar");
        File file9 = new File(EaglerBuildTools.repositoryRoot, "sources/resources");
        File file10 = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/main/java");
        File file11 = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/teavm/java");
        File file12 = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/lwjgl/java");
        File file13 = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "desktopRuntime/resources");
        File file14 = new File(EaglerBuildTools.repositoryRoot, "pullrequest");
        boolean bl = file14.exists();
        if (bl && (!file14.isDirectory() || file14.list().length != 0)) {
            System.out.println();
            System.out.print("Warning: The 'pullrequest' folder already exists in your repository. Overwrite? [Y/n]: ");
            object = "n";
            try {
                object = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            object = ((String)object).toLowerCase();
            if (!((String)object).startsWith("y")) {
                System.out.println();
                System.out.println("The pull request was cancelled.");
                return true;
            }
            try {
                FileUtils.deleteDirectory(file14);
                bl = false;
            }
            catch (IOException iOException) {
                System.err.println("ERROR: Could not delete \"" + file14.getAbsolutePath() + "\"!");
                iOException.printStackTrace();
                return false;
            }
        }
        if (!bl && !file14.mkdirs()) {
            System.err.println("ERROR: Could not create folder \"" + file14.getAbsolutePath() + "\"!");
        }
        object = new File(file14, "source");
        File file15 = new File(file14, "resources");
        boolean bl2 = false;
        int n = PullRequestTask.copyAllModified(file11, file5);
        if (n > 0) {
            bl2 = true;
        }
        System.out.println("Found " + n + " changed files in /src/teavm/java/");
        n = PullRequestTask.copyAllModified(file12, file6);
        if (n > 0) {
            bl2 = true;
        }
        System.out.println("Found " + n + " changed files in /src/lwjgl/java/");
        n = PullRequestTask.createDiffFiles(file4, file3, file, file2, file10, (File)object, true);
        if (n > 0) {
            bl2 = true;
        }
        System.out.println("Found " + n + " changed files in /src/main/java/");
        n = PullRequestTask.createDiffFiles(file9, file8, file7, null, file13, file15, false);
        if (n > 0) {
            bl2 = true;
        }
        System.out.println("Found " + n + " changed files in /desktopRuntime/resources/");
        if (!bl2) {
            System.out.println("ERROR: No modified files were found!");
            if (file14.exists()) {
                file14.delete();
            }
        }
        return true;
    }

    private static int createDiffFiles(File file, File file2, File file3, File file4, File file5, File file6, boolean bl) throws Throwable {
        HashSet<String> hashSet;
        Object object;
        Map<String, byte[]> map;
        Serializable serializable;
        Map<String, byte[]> map2;
        Collection<File> collection;
        int n;
        boolean bl2;
        block53: {
            Map<Object, Object> map3;
            block52: {
                block51: {
                    if (!file5.isDirectory()) {
                        return 0;
                    }
                    bl2 = file6.isDirectory();
                    n = 0;
                    collection = FileUtils.listFiles(file5, null, true);
                    if (file3 != null) {
                        System.out.println("Loading files from '" + file3.getName() + "'...");
                        map2 = null;
                        serializable = null;
                        try {
                            map = new FileInputStream(file3);
                            try {
                                map3 = JARMemoryCache.loadJAR((InputStream)((Object)map));
                                break block51;
                            }
                            finally {
                                if (map != null) {
                                    ((FileInputStream)((Object)map)).close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (map2 == null) {
                                map2 = throwable;
                            } else if (map2 != throwable) {
                                ((Throwable)((Object)map2)).addSuppressed(throwable);
                            }
                            throw map2;
                        }
                    }
                    map3 = new WeakHashMap();
                }
                if (file2 != null) {
                    System.out.println("Loading files from '" + file2.getName() + "'...");
                    serializable = null;
                    map = null;
                    try {
                        object = new FileInputStream(file2);
                        try {
                            map2 = JARMemoryCache.loadJAR((InputStream)object);
                            break block52;
                        }
                        finally {
                            if (object != null) {
                                ((FileInputStream)object).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (serializable == null) {
                            serializable = throwable;
                        } else if (serializable != throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                        throw serializable;
                    }
                }
                map2 = new WeakHashMap();
            }
            serializable = new HashMap();
            serializable.putAll(map3);
            serializable.putAll(map2);
            if (file4 != null) {
                System.out.println("Loading files from '" + file4.getName() + "'...");
                object = null;
                hashSet = null;
                try (FileInputStream object2 = new FileInputStream(file4);){
                    map = JARMemoryCache.loadJAR(object2);
                    break block53;
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            map = new WeakHashMap();
        }
        System.out.println("Comparing...");
        System.out.println("(this may take a while)");
        object = file5.getAbsolutePath();
        hashSet = new HashSet<String>();
        for (File file7 : collection) {
            String string = file7.getAbsolutePath().replace((CharSequence)object, "");
            if (string.indexOf(92) != -1) {
                string = string.replace('\\', '/');
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            File file8 = new File(file, string);
            byte[] byArray = null;
            boolean bl3 = file8.exists();
            if (bl3) {
                hashSet.add(string);
                if (!PullRequestTask.copyFileIfChanged(file7, file8)) continue;
                ++n;
                continue;
            }
            byArray = (byte[])serializable.get(string);
            if (byArray != null) {
                Object object2;
                hashSet.add(string);
                byte[] byArray2 = byArray;
                byte[] byArray3 = FileUtils.readFileToByteArray(file7);
                boolean bl4 = false;
                if (byArray2.length != byArray3.length) {
                    if (!bl2) {
                        if (!file6.mkdirs()) {
                            throw new IOException("Could not create folder: \"" + file6.getAbsolutePath() + "\"!");
                        }
                        bl2 = true;
                    }
                    String string2 = null;
                    object2 = map.get(string);
                    if (object2 != null) {
                        string2 = new String((byte[])object2, StandardCharsets.UTF_8);
                    }
                    if (PullRequestTask.writeDiff(byArray2, byArray3, file6, string, bl, string2)) {
                        bl4 = true;
                        ++n;
                    }
                } else {
                    int n2 = 0;
                    while (n2 < byArray2.length) {
                        if (byArray2[n2] != byArray3[n2]) {
                            if (!bl2) {
                                if (!file6.mkdirs()) {
                                    throw new IOException("Could not create folder: \"" + file6.getAbsolutePath() + "\"!");
                                }
                                bl2 = true;
                            }
                            object2 = null;
                            byte[] byArray4 = map.get(string);
                            if (byArray4 != null) {
                                object2 = new String(byArray4, StandardCharsets.UTF_8);
                            }
                            if (!PullRequestTask.writeDiff(byArray2, byArray3, file6, string, bl, (String)object2)) break;
                            bl4 = true;
                            ++n;
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl4 || map2.containsKey(string)) continue;
                FileUtils.writeByteArrayToFile(new File(file6, PullRequestTask.makeName(string, "recreate")), byArray);
                ++n;
                continue;
            }
            hashSet.add(string);
            FileUtils.copyFile(file7, file8);
            ++n;
        }
        if (map2.size() > 0) {
            for (Map.Entry entry : map2.entrySet()) {
                if (hashSet.contains(entry.getKey()) || new File(file5, (String)entry.getKey()).exists()) continue;
                if (!bl2) {
                    if (!file6.mkdirs()) {
                        throw new IOException("Could not create folder: \"" + file6.getAbsolutePath() + "\"!");
                    }
                    bl2 = true;
                }
                FileUtils.writeStringToFile(new File(file6, PullRequestTask.makeName((String)entry.getKey(), "delete")), "#hash: " + PullRequestTask.getCRC32((byte[])entry.getValue()), "UTF-8");
                ++n;
            }
        }
        return n;
    }

    private static boolean writeDiff(byte[] byArray, byte[] byArray2, File file, String string, boolean bl, String string2) throws IOException {
        String string3;
        String string4 = PullRequestTask.toStringIfValid(byArray);
        String string5 = string3 = string4 == null ? null : PullRequestTask.toStringIfValid(byArray2);
        if (string4 == null || string3 == null) {
            FileUtils.writeByteArrayToFile(new File(file, PullRequestTask.makeName(string, "replace")), byArray2);
        } else {
            List<String> list;
            Patch<String> patch;
            if (string2 != null) {
                string4 = string2;
            }
            string3 = PullRequestTask.stripJavadocAndFormat(string3);
            List<String> list2 = Lines.linesList(string4);
            List<String> list3 = UnifiedDiffUtils.generateUnifiedDiff(string, string, list2, patch = DiffUtils.diff(list2, list = Lines.linesList(string3)), 3);
            if (list3.size() == 0) {
                return false;
            }
            File file2 = new File(file, PullRequestTask.makeName(string, "edit"));
            File file3 = file2.getParentFile();
            if (!file3.isDirectory() && !file3.mkdirs()) {
                throw new IOException("Failed to create directory \"" + file3.getAbsolutePath() + "\"!");
            }
            Throwable throwable = null;
            Object var15_16 = null;
            try (PrintWriter printWriter = new PrintWriter(new FileWriterUTF(file2));){
                int n = 0;
                int n2 = list3.size();
                while (n < n2) {
                    printWriter.println(list3.get(n));
                    ++n;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return true;
    }

    private static String stripJavadocAndFormat(String string) {
        string = InsertJavaDoc.stripDocForDiff(string);
        string = EclipseFormatter.processSource(string, System.lineSeparator());
        return string;
    }

    private static int copyAllModified(File file, File file2) throws IOException {
        if (!file.isDirectory()) {
            return 0;
        }
        int n = 0;
        Collection<File> collection = FileUtils.listFiles(file, null, true);
        String string = file.getAbsolutePath();
        for (File file3 : collection) {
            File file4;
            String string2 = file3.getAbsolutePath().replace(string, "");
            if (string2.indexOf(92) != -1) {
                string2 = string2.replace('\\', '/');
            }
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if (!PullRequestTask.copyFileIfChanged(file3, file4 = new File(file2, string2))) continue;
            ++n;
        }
        return n;
    }

    private static String makeName(String string, String string2) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n2 > n + 1) {
            return String.valueOf(string.substring(0, n2)) + "." + string2 + string.substring(n2);
        }
        return String.valueOf(string) + "." + string2;
    }

    private static String toStringIfValid(byte[] byArray) {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            charBuffer = utf8Decoder.decode(byteBuffer);
        }
        catch (Throwable throwable) {
            return null;
        }
        return charBuffer.toString();
    }

    private static String hex32(long l) {
        char[] cArray = new char[8];
        int n = 7;
        while (n >= 0) {
            cArray[n] = hex.charAt((int)(l >> (n << 2) & 0xFL));
            --n;
        }
        return new String(cArray);
    }

    private static String getCRC32(File file) throws IOException {
        CRC32 cRC32 = new CRC32();
        cRC32.update(FileUtils.readFileToByteArray(file));
        return PullRequestTask.hex32(cRC32.getValue());
    }

    private static String getCRC32(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return PullRequestTask.hex32(cRC32.getValue());
    }

    private static boolean checkCRC32(File file, File file2) throws IOException {
        CRC32 cRC32 = new CRC32();
        cRC32.update(FileUtils.readFileToByteArray(file));
        long l = cRC32.getValue();
        cRC32.reset();
        cRC32.update(FileUtils.readFileToByteArray(file2));
        return l != cRC32.getValue();
    }

    private static boolean copyFileIfChanged(File file, File file2) throws IOException {
        if (!file2.exists()) {
            FileUtils.copyFile(file, file2);
            return true;
        }
        if (file.lastModified() == file2.lastModified()) {
            return false;
        }
        CRC32 cRC32 = new CRC32();
        byte[] byArray = FileUtils.readFileToByteArray(file);
        cRC32.update(byArray);
        long l = cRC32.getValue();
        cRC32.reset();
        byte[] byArray2 = FileUtils.readFileToByteArray(file2);
        cRC32.update(byArray2);
        if (l != cRC32.getValue()) {
            FileUtils.writeByteArrayToFile(file2, byArray);
            return true;
        }
        return false;
    }
}

