/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.teavm;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.buildtools.gui.TeaVMBinaries;

public class TeaVMBridge {
    private static URLClassLoader classLoader = null;

    public static boolean compileTeaVM(Map<String, Object> options) throws TeaVMClassLoadException, TeaVMRuntimeException {
        File[] cp = TeaVMBinaries.getTeaVMCompilerClasspath();
        URL[] urls = new URL[cp.length];
        int i = 0;
        while (i < cp.length) {
            try {
                urls[i] = cp[i].toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new TeaVMClassLoadException("Could not resolve URL for: " + cp[i].getAbsolutePath(), e);
            }
            ++i;
        }
        Method found = null;
        try {
            if (classLoader == null) {
                classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
            }
            Class<?> c = classLoader.loadClass("net.lax1dude.eaglercraft.v1_8.buildtools.task.teavm.TeaVMBridgeImpl");
            Method[] methods = c.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                Method m = methods[i2];
                if (m.getName().equals("compileTeaVM")) {
                    found = m;
                }
                ++i2;
            }
            if (found == null) {
                throw new NoSuchMethodException("compileTeaVM");
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | TeaVMClassLoadException t) {
            throw new TeaVMClassLoadException("Could not link TeaVM compiler!", t);
        }
        catch (RuntimeException t) {
            String msg = t.getMessage();
            if (msg.startsWith("[TeaVMBridge]")) {
                throw new TeaVMRuntimeException(msg.substring(13).trim(), t.getCause());
            }
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", t);
        }
        catch (Throwable t) {
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", t);
        }
        try {
            Object ret = found.invoke(null, options);
            return ret != null && ret instanceof Boolean && (Boolean)ret != false;
        }
        catch (InvocationTargetException ex) {
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", ex.getCause());
        }
        catch (Throwable t) {
            throw new TeaVMRuntimeException("Failed to invoke 'compileTeaVM'!", t);
        }
    }

    public static void free() {
        if (classLoader != null) {
            try {
                classLoader.close();
                classLoader = null;
            }
            catch (IOException e) {
                System.err.println("Memory leak, failed to release TeaVM JAR ClassLoader!");
                e.printStackTrace();
            }
        }
    }

    public static class TeaVMClassLoadException
    extends RuntimeException {
        public TeaVMClassLoadException(String message, Throwable cause) {
            super(message, cause);
        }

        public TeaVMClassLoadException(String message) {
            super(message);
        }
    }

    public static class TeaVMRuntimeException
    extends RuntimeException {
        public TeaVMRuntimeException(String message, Throwable cause) {
            super(message, cause);
        }

        public TeaVMRuntimeException(String message) {
            super(message);
        }
    }
}

