/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.CRC32;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.JARMemoryCache;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.Lines;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.formatter.EclipseFormatter;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InsertJavaDoc;
import net.lax1dude.eaglercraft.v1_8.buildtools.util.FileWriterUTF;
import org.apache.commons.io.FileUtils;

public class PullRequestTask {
    private static final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();
    private static final String hex = "0123456789ABCDEF";

    public static boolean pullRequest() {
        try {
            return PullRequestTask.pullRequest0();
        }
        catch (Throwable t) {
            System.err.println();
            System.err.println("Exception encountered while running task 'pullrequest'!");
            t.printStackTrace();
            return false;
        }
    }

    private static boolean pullRequest0() throws Throwable {
        File originalUnpatchedSourceMainJar = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src.jar");
        File originalSourceMainJar = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src_patch.jar");
        File minecraftJavadocTmp = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_src_javadoc.jar");
        File originalSourceMain = new File(EaglerBuildTools.repositoryRoot, "sources/main/java");
        File originalSourceTeaVM = new File(EaglerBuildTools.repositoryRoot, "sources/teavm/java");
        File originalSourceLWJGL = new File(EaglerBuildTools.repositoryRoot, "sources/lwjgl/java");
        File originalUnpatchedSourceResourcesJar = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_res.jar");
        File originalSourceResourcesJar = new File(EaglerBuildToolsConfig.getTemporaryDirectory(), "MinecraftSrc/minecraft_res_patch.jar");
        File originalSourceResources = new File(EaglerBuildTools.repositoryRoot, "sources/resources");
        File diffFromMain = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/main/java");
        File diffFromTeaVM = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/teavm/java");
        File diffFromLWJGL = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "src/lwjgl/java");
        File diffFromResources = new File(EaglerBuildToolsConfig.getWorkspaceDirectory(), "desktopRuntime/resources");
        File pullRequestTo = new File(EaglerBuildTools.repositoryRoot, "pullrequest");
        boolean prExist = pullRequestTo.exists();
        if (prExist && (!pullRequestTo.isDirectory() || pullRequestTo.list().length != 0)) {
            System.out.println();
            System.out.print("Warning: The 'pullrequest' folder already exists in your repository. Overwrite? [Y/n]: ");
            String ret = "n";
            try {
                ret = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            ret = ret.toLowerCase();
            if (!ret.startsWith("y")) {
                System.out.println();
                System.out.println("The pull request was cancelled.");
                return true;
            }
            try {
                FileUtils.deleteDirectory(pullRequestTo);
                prExist = false;
            }
            catch (IOException ex) {
                System.err.println("ERROR: Could not delete \"" + pullRequestTo.getAbsolutePath() + "\"!");
                ex.printStackTrace();
                return false;
            }
        }
        if (!prExist && !pullRequestTo.mkdirs()) {
            System.err.println("ERROR: Could not create folder \"" + pullRequestTo.getAbsolutePath() + "\"!");
        }
        File pullRequestToMain = new File(pullRequestTo, "source");
        File pullRequestToResources = new File(pullRequestTo, "resources");
        boolean flag = false;
        int i = PullRequestTask.copyAllModified(diffFromTeaVM, originalSourceTeaVM);
        if (i > 0) {
            flag = true;
        }
        System.out.println("Found " + i + " changed files in /src/teavm/java/");
        i = PullRequestTask.copyAllModified(diffFromLWJGL, originalSourceLWJGL);
        if (i > 0) {
            flag = true;
        }
        System.out.println("Found " + i + " changed files in /src/lwjgl/java/");
        i = PullRequestTask.createDiffFiles(originalSourceMain, minecraftJavadocTmp, originalUnpatchedSourceMainJar, originalSourceMainJar, diffFromMain, pullRequestToMain, true);
        if (i > 0) {
            flag = true;
        }
        System.out.println("Found " + i + " changed files in /src/main/java/");
        i = PullRequestTask.createDiffFiles(originalSourceResources, originalSourceResourcesJar, originalUnpatchedSourceResourcesJar, null, diffFromResources, pullRequestToResources, false);
        if (i > 0) {
            flag = true;
        }
        System.out.println("Found " + i + " changed files in /desktopRuntime/resources/");
        if (!flag) {
            System.out.println("ERROR: No modified files were found!");
            if (pullRequestTo.exists()) {
                pullRequestTo.delete();
            }
        }
        return true;
    }

    private static int createDiffFiles(File folderOriginal, File jarOriginal, File jarOriginalUnpatched, File originalJarNoJavadoc, File folderEdited, File folderOut, boolean isJava) throws Throwable {
        Map<Object, Object> jarEntriesNoJavadoc;
        HashMap jarEntries;
        Map<Object, Object> jarEntriesPatched;
        Collection<File> workspaceFiles;
        int cnt;
        boolean createdFolderOut;
        block53: {
            Object is;
            Map<Object, Object> jarEntriesUnpatched;
            block52: {
                FileInputStream is232;
                Throwable throwable;
                block51: {
                    if (!folderEdited.isDirectory()) {
                        return 0;
                    }
                    createdFolderOut = folderOut.isDirectory();
                    cnt = 0;
                    workspaceFiles = FileUtils.listFiles(folderEdited, null, true);
                    if (jarOriginalUnpatched != null) {
                        System.out.println("Loading files from '" + jarOriginalUnpatched.getName() + "'...");
                        Throwable throwable2 = null;
                        throwable = null;
                        try {
                            is232 = new FileInputStream(jarOriginalUnpatched);
                            try {
                                jarEntriesUnpatched = JARMemoryCache.loadJAR(is232);
                                break block51;
                            }
                            finally {
                                if (is232 != null) {
                                    is232.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    jarEntriesUnpatched = new WeakHashMap();
                }
                if (jarOriginal != null) {
                    System.out.println("Loading files from '" + jarOriginal.getName() + "'...");
                    throwable = null;
                    is232 = null;
                    try {
                        is = new FileInputStream(jarOriginal);
                        try {
                            jarEntriesPatched = JARMemoryCache.loadJAR((InputStream)is);
                            break block52;
                        }
                        finally {
                            if (is != null) {
                                ((FileInputStream)is).close();
                            }
                        }
                    }
                    catch (Throwable is232) {
                        if (throwable == null) {
                            throwable = is232;
                        } else if (throwable != is232) {
                            throwable.addSuppressed(is232);
                        }
                        throw throwable;
                    }
                }
                jarEntriesPatched = new WeakHashMap();
            }
            jarEntries = new HashMap();
            jarEntries.putAll(jarEntriesUnpatched);
            jarEntries.putAll(jarEntriesPatched);
            if (originalJarNoJavadoc != null) {
                System.out.println("Loading files from '" + originalJarNoJavadoc.getName() + "'...");
                is = null;
                Object var15_20 = null;
                try (FileInputStream fileInputStream = new FileInputStream(originalJarNoJavadoc);){
                    jarEntriesNoJavadoc = JARMemoryCache.loadJAR(fileInputStream);
                    break block53;
                }
                catch (Throwable throwable) {
                    if (is == null) {
                        is = throwable;
                    } else if (is != throwable) {
                        ((Throwable)is).addSuppressed(throwable);
                    }
                    throw is;
                }
            }
            jarEntriesNoJavadoc = new WeakHashMap();
        }
        System.out.println("Comparing...");
        System.out.println("(this may take a while)");
        String editedPrefix = folderEdited.getAbsolutePath();
        HashSet<String> filesReplaced = new HashSet<String>();
        for (File file : workspaceFiles) {
            String newPath = file.getAbsolutePath().replace(editedPrefix, "");
            if (newPath.indexOf(92) != -1) {
                newPath = newPath.replace('\\', '/');
            }
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            File orig = new File(folderOriginal, newPath);
            byte[] jarData = null;
            boolean replacedFileExists = orig.exists();
            if (replacedFileExists) {
                filesReplaced.add(newPath);
                if (!PullRequestTask.copyFileIfChanged(file, orig)) continue;
                ++cnt;
                continue;
            }
            jarData = (byte[])jarEntries.get(newPath);
            if (jarData != null) {
                filesReplaced.add(newPath);
                byte[] o = jarData;
                byte[] n = FileUtils.readFileToByteArray(file);
                boolean changed = false;
                if (o.length != n.length) {
                    if (!createdFolderOut) {
                        if (!folderOut.mkdirs()) {
                            throw new IOException("Could not create folder: \"" + folderOut.getAbsolutePath() + "\"!");
                        }
                        createdFolderOut = true;
                    }
                    String noJavaDocString = null;
                    byte[] noJavaDoc = (byte[])jarEntriesNoJavadoc.get(newPath);
                    if (noJavaDoc != null) {
                        noJavaDocString = new String(noJavaDoc, StandardCharsets.UTF_8);
                    }
                    if (PullRequestTask.writeDiff(o, n, folderOut, newPath, isJava, noJavaDocString)) {
                        changed = true;
                        ++cnt;
                    }
                } else {
                    int i = 0;
                    while (i < o.length) {
                        if (o[i] != n[i]) {
                            if (!createdFolderOut) {
                                if (!folderOut.mkdirs()) {
                                    throw new IOException("Could not create folder: \"" + folderOut.getAbsolutePath() + "\"!");
                                }
                                createdFolderOut = true;
                            }
                            String noJavaDocString = null;
                            byte[] noJavaDoc = (byte[])jarEntriesNoJavadoc.get(newPath);
                            if (noJavaDoc != null) {
                                noJavaDocString = new String(noJavaDoc, StandardCharsets.UTF_8);
                            }
                            if (!PullRequestTask.writeDiff(o, n, folderOut, newPath, isJava, noJavaDocString)) break;
                            changed = true;
                            ++cnt;
                            break;
                        }
                        ++i;
                    }
                }
                if (changed || jarEntriesPatched.containsKey(newPath)) continue;
                FileUtils.writeByteArrayToFile(new File(folderOut, PullRequestTask.makeName(newPath, "recreate")), jarData);
                ++cnt;
                continue;
            }
            filesReplaced.add(newPath);
            FileUtils.copyFile(file, orig);
            ++cnt;
        }
        if (jarEntriesPatched.size() > 0) {
            for (Map.Entry entry : jarEntriesPatched.entrySet()) {
                if (filesReplaced.contains(entry.getKey()) || new File(folderEdited, (String)entry.getKey()).exists()) continue;
                if (!createdFolderOut) {
                    if (!folderOut.mkdirs()) {
                        throw new IOException("Could not create folder: \"" + folderOut.getAbsolutePath() + "\"!");
                    }
                    createdFolderOut = true;
                }
                FileUtils.writeStringToFile(new File(folderOut, PullRequestTask.makeName((String)entry.getKey(), "delete")), "#hash: " + PullRequestTask.getCRC32((byte[])entry.getValue()), "UTF-8");
                ++cnt;
            }
        }
        return cnt;
    }

    private static boolean writeDiff(byte[] old, byte[] _new, File outDir, String outName, boolean isJava, String javaNotJavadoc) throws IOException {
        String newStr;
        String oldStr = PullRequestTask.toStringIfValid(old);
        String string = newStr = oldStr == null ? null : PullRequestTask.toStringIfValid(_new);
        if (oldStr == null || newStr == null) {
            FileUtils.writeByteArrayToFile(new File(outDir, PullRequestTask.makeName(outName, "replace")), _new);
        } else {
            List<String> newLines;
            Patch<String> deltas;
            if (javaNotJavadoc != null) {
                oldStr = javaNotJavadoc;
            }
            newStr = PullRequestTask.stripJavadocAndFormat(newStr);
            List<String> oldLines = Lines.linesList(oldStr);
            List<String> diffFile = UnifiedDiffUtils.generateUnifiedDiff(outName, outName, oldLines, deltas = DiffUtils.diff(oldLines, newLines = Lines.linesList(newStr)), 3);
            if (diffFile.size() == 0) {
                return false;
            }
            File fout = new File(outDir, PullRequestTask.makeName(outName, "edit"));
            File p = fout.getParentFile();
            if (!p.isDirectory() && !p.mkdirs()) {
                throw new IOException("Failed to create directory \"" + p.getAbsolutePath() + "\"!");
            }
            Throwable throwable = null;
            Object var15_16 = null;
            try (PrintWriter foutStream = new PrintWriter(new FileWriterUTF(fout));){
                int i = 0;
                int l = diffFile.size();
                while (i < l) {
                    foutStream.println(diffFile.get(i));
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return true;
    }

    private static String stripJavadocAndFormat(String input) {
        input = InsertJavaDoc.stripDocForDiff(input);
        input = EclipseFormatter.processSource(input, System.lineSeparator());
        return input;
    }

    private static int copyAllModified(File inDir, File outDir) throws IOException {
        if (!inDir.isDirectory()) {
            return 0;
        }
        int cnt = 0;
        Collection<File> workspaceFiles = FileUtils.listFiles(inDir, null, true);
        String editedPrefix = inDir.getAbsolutePath();
        for (File wf : workspaceFiles) {
            File orig;
            String newPath = wf.getAbsolutePath().replace(editedPrefix, "");
            if (newPath.indexOf(92) != -1) {
                newPath = newPath.replace('\\', '/');
            }
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            if (!PullRequestTask.copyFileIfChanged(wf, orig = new File(outDir, newPath))) continue;
            ++cnt;
        }
        return cnt;
    }

    private static String makeName(String input, String type) {
        int lastSlash = input.lastIndexOf(47);
        int lastDot = input.lastIndexOf(46);
        if (lastDot > lastSlash + 1) {
            return String.valueOf(input.substring(0, lastDot)) + "." + type + input.substring(lastDot);
        }
        return String.valueOf(input) + "." + type;
    }

    private static String toStringIfValid(byte[] in) {
        CharBuffer cb;
        ByteBuffer inn = ByteBuffer.wrap(in);
        try {
            cb = utf8Decoder.decode(inn);
        }
        catch (Throwable throwable) {
            return null;
        }
        return cb.toString();
    }

    private static String hex32(long in) {
        char[] ret = new char[8];
        int i = 7;
        while (i >= 0) {
            ret[i] = hex.charAt((int)(in >> (i << 2) & 0xFL));
            --i;
        }
        return new String(ret);
    }

    private static String getCRC32(File in) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(FileUtils.readFileToByteArray(in));
        return PullRequestTask.hex32(crc.getValue());
    }

    private static String getCRC32(byte[] in) {
        CRC32 crc = new CRC32();
        crc.update(in);
        return PullRequestTask.hex32(crc.getValue());
    }

    private static boolean checkCRC32(File in1, File in2) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(FileUtils.readFileToByteArray(in1));
        long v1 = crc.getValue();
        crc.reset();
        crc.update(FileUtils.readFileToByteArray(in2));
        return v1 != crc.getValue();
    }

    private static boolean copyFileIfChanged(File in1, File in2) throws IOException {
        if (!in2.exists()) {
            FileUtils.copyFile(in1, in2);
            return true;
        }
        if (in1.lastModified() == in2.lastModified()) {
            return false;
        }
        CRC32 crc = new CRC32();
        byte[] f1 = FileUtils.readFileToByteArray(in1);
        crc.update(f1);
        long v1 = crc.getValue();
        crc.reset();
        byte[] f2 = FileUtils.readFileToByteArray(in2);
        crc.update(f2);
        if (v1 != crc.getValue()) {
            FileUtils.writeByteArrayToFile(in2, f1);
            return true;
        }
        return false;
    }
}

