/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.EaglerContextRedacted;
import org.apache.commons.io.FileUtils;

public class DiffSet {
    public static final DeleteFunction deleteFunction = new DeleteFunction();
    public final Map<String, Object> diffs = new HashMap<String, Object>();
    public final Map<String, byte[]> recreate = new HashMap<String, byte[]>();
    private static final Pattern editPattern = Pattern.compile(".*\\.edit(\\.[^\\.\\/\\\\]+)?$");
    private static final Pattern replacePattern = Pattern.compile(".*\\.replace(\\.[^\\.\\/\\\\]+)?$");
    private static final Pattern deletePattern = Pattern.compile(".*\\.delete(\\.[^\\.\\/\\\\]+)?$");
    private static final Pattern recreatePattern = Pattern.compile(".*\\.recreate(\\.[^\\.\\/\\\\]+)?$");

    public int loadFolder(File pathIn, boolean useECR, SourceProvider ecrContextProvider) throws IOException {
        String baseAbsolutePath = pathIn.getAbsolutePath();
        int total = 0;
        File del = new File(pathIn, "delete.txt");
        if (del.isFile()) {
            List<String> cl = FileUtils.readLines(del, "UTF-8");
            for (String s : cl) {
                s = s.trim();
                if ((s = s.replace('\\', '/')).startsWith("#")) continue;
                if (s.startsWith("/")) {
                    s = s.substring(1);
                }
                this.diffs.put(s, deleteFunction);
            }
        }
        Collection<File> fl = FileUtils.listFiles(pathIn, null, true);
        for (File f : fl) {
            String fName = f.getAbsolutePath().replace(baseAbsolutePath, "").replace('\\', '/');
            if (fName.startsWith("/")) {
                fName = fName.substring(1);
            }
            if (editPattern.matcher(fName).matches()) {
                try {
                    Patch<String> pth;
                    String nm;
                    block25: {
                        nm = DiffSet.removeExt(fName, "edit");
                        if (useECR) {
                            Throwable throwable = null;
                            Object var14_15 = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));){
                                pth = EaglerContextRedacted.readContextRestricted(ecrContextProvider.getSource(nm), reader);
                                break block25;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        List<String> phile = FileUtils.readLines(f, "UTF-8");
                        pth = UnifiedDiffUtils.parseUnifiedDiff(phile);
                    }
                    if (pth == null) {
                        throw new IOException("Invalid DIFF file!");
                    }
                    this.diffs.put(nm, pth);
                    ++total;
                }
                catch (Throwable throwable) {
                    System.err.println("ERROR: could not read '" + fName + "'!");
                }
                continue;
            }
            if (replacePattern.matcher(fName).matches()) {
                try {
                    this.diffs.put(DiffSet.removeExt(fName, "replace"), new ReplaceFunction(FileUtils.readFileToByteArray(f)));
                    ++total;
                }
                catch (Throwable throwable) {
                    System.err.println("ERROR: could not read '" + fName + "'!");
                }
                continue;
            }
            if (deletePattern.matcher(fName).matches()) {
                this.diffs.put(DiffSet.removeExt(fName, "delete"), deleteFunction);
                ++total;
                continue;
            }
            if (!recreatePattern.matcher(fName).matches()) continue;
            try {
                String str = DiffSet.removeExt(fName, "recreate");
                this.recreate.put(str, FileUtils.readFileToByteArray(f));
                this.diffs.remove(str);
                ++total;
            }
            catch (Throwable throwable) {
                System.err.println("ERROR: could not read '" + fName + "'!");
            }
        }
        return total;
    }

    private static String removeExt(String fn, String ext) {
        int end = fn.lastIndexOf("." + ext);
        if (end != -1) {
            return String.valueOf(fn.substring(0, end)) + fn.substring(end + ext.length() + 1, fn.length());
        }
        return fn;
    }

    public static class DeleteFunction {
        private DeleteFunction() {
        }
    }

    public static class ReplaceFunction {
        public final byte[] file;

        private ReplaceFunction(byte[] file) {
            this.file = file;
        }
    }

    public static interface SourceProvider {
        public List<String> getSource(String var1) throws IOException;
    }
}

