/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.DiffSet;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.JARMemoryCache;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.Lines;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ApplyPatchesToZip {
    public static final int patchContextLength = 3;

    public static void applyPatches(File zipIn, File unpatchedZipIn, File patchesIn, File zipOut, boolean compress, boolean useECR) throws Throwable {
        Map<Object, Object> jarEntriesPatched;
        Map<Object, Object> jarEntriesUnpatched;
        block40: {
            FileInputStream is232;
            Throwable throwable;
            block39: {
                if (!patchesIn.isDirectory()) {
                    FileUtils.copyFile(zipIn, zipOut);
                    return;
                }
                if (unpatchedZipIn != null) {
                    System.out.println("Loading files from '" + unpatchedZipIn.getName() + "'...");
                    Throwable throwable2 = null;
                    throwable = null;
                    try {
                        is232 = new FileInputStream(unpatchedZipIn);
                        try {
                            jarEntriesUnpatched = JARMemoryCache.loadJAR(is232);
                            break block39;
                        }
                        finally {
                            if (is232 != null) {
                                is232.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                jarEntriesUnpatched = new WeakHashMap();
            }
            if (zipIn != null) {
                System.out.println("Loading files from '" + zipIn.getName() + "'...");
                throwable = null;
                is232 = null;
                try (FileInputStream is = new FileInputStream(zipIn);){
                    jarEntriesPatched = JARMemoryCache.loadJAR(is);
                    break block40;
                }
                catch (Throwable is232) {
                    if (throwable == null) {
                        throwable = is232;
                    } else if (throwable != is232) {
                        throwable.addSuppressed(is232);
                    }
                    throw throwable;
                }
            }
            jarEntriesPatched = new WeakHashMap();
        }
        System.out.println("Patching files in '" + zipIn.getName() + "'...");
        final HashMap jarEntries = new HashMap();
        jarEntries.putAll(jarEntriesUnpatched);
        jarEntries.putAll(jarEntriesPatched);
        DiffSet diffs = new DiffSet();
        int totalLoad = diffs.loadFolder(patchesIn, useECR, useECR ? new DiffSet.SourceProvider(){

            @Override
            public List<String> getSource(String filename) throws IOException {
                byte[] etr = (byte[])jarEntries.get(filename);
                if (etr == null) {
                    throw new FileNotFoundException("Could not find source for: " + filename);
                }
                return Lines.linesList(new String(etr, StandardCharsets.UTF_8));
            }
        } : null);
        System.out.println("   loaded " + totalLoad + " patch files from the repo");
        System.out.println("   patching files...");
        System.out.print("   ");
        int cnt = 0;
        int crtCnt = 0;
        int delCnt = 0;
        int repCnt = 0;
        int pthCnt = 0;
        Throwable throwable = null;
        Object var17_23 = null;
        try (ZipOutputStream jarOut = new ZipOutputStream(new FileOutputStream(zipOut));){
            jarOut.setLevel(compress ? 5 : 0);
            jarOut.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            jarOut.write("Manifest-Version: 1.0\nCreated-By: Eaglercraft BuildTools\n".getBytes(StandardCharsets.UTF_8));
            for (Map.Entry entry : jarEntries.entrySet()) {
                String nm = (String)entry.getKey();
                if (nm.startsWith("META-INF")) continue;
                Object op = diffs.diffs.get(nm);
                if (op != null) {
                    if (op instanceof DiffSet.DeleteFunction) {
                        ++delCnt;
                        continue;
                    }
                    if (op instanceof DiffSet.ReplaceFunction) {
                        jarOut.putNextEntry(new ZipEntry(nm));
                        IOUtils.write(((DiffSet.ReplaceFunction)op).file, (OutputStream)jarOut);
                        ++repCnt;
                    } else if (op instanceof Patch) {
                        jarOut.putNextEntry(new ZipEntry(nm));
                        List<String> lines = Lines.linesList(new String((byte[])entry.getValue(), "UTF-8"));
                        try {
                            lines = ((Patch)op).applyTo(lines);
                        }
                        catch (PatchFailedException ptch) {
                            throw new IOException("Could not patch file \"" + nm + "\"!", ptch);
                        }
                        IOUtils.writeLines(lines, null, (OutputStream)jarOut, "UTF-8");
                        ++pthCnt;
                    }
                    if (++cnt % 75 != 74) continue;
                    System.out.print(".");
                    continue;
                }
                if (!jarEntriesPatched.containsKey(nm)) continue;
                jarOut.putNextEntry(new ZipEntry(nm));
                IOUtils.write((byte[])entry.getValue(), (OutputStream)jarOut);
                if (++cnt % 75 != 74) continue;
                System.out.print(".");
            }
            for (Map.Entry<Object, Object> entry : diffs.recreate.entrySet()) {
                jarOut.putNextEntry(new ZipEntry((String)entry.getKey()));
                IOUtils.write((byte[])entry.getValue(), (OutputStream)jarOut);
                ++crtCnt;
                if (++cnt % 75 != 74) continue;
                System.out.print(".");
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        System.out.println();
        System.out.println("Patched " + pthCnt + " files");
        System.out.println("Restored " + crtCnt + " files");
        System.out.println("Replaced " + repCnt + " files");
        System.out.println("Deleted " + delCnt + " files");
        System.out.println();
    }
}

