/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class EPKCompiler {
    private static File currentJarFile = null;
    private static URLClassLoader classLoader = null;
    private static Method mainMethod = null;

    public static void compilerMain(File jarFile, String[] args) throws InvocationTargetException {
        if (currentJarFile != null && !currentJarFile.equals(jarFile)) {
            throw new IllegalArgumentException("Cannot load two different EPKCompiler versions into the same runtime");
        }
        if (mainMethod == null) {
            currentJarFile = jarFile;
            try {
                if (classLoader == null) {
                    classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, ClassLoader.getSystemClassLoader());
                }
                Class<?> epkCompilerMain = classLoader.loadClass("CompilePackage");
                mainMethod = epkCompilerMain.getDeclaredMethod("main", String[].class);
            }
            catch (SecurityException | MalformedURLException e) {
                throw new IllegalArgumentException("Illegal EPKCompiler JAR path!", e);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new IllegalArgumentException("EPKCompiler JAR does not contain main class: 'CompilePackage'", e);
            }
        }
        try {
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalArgumentException("EPKCompiler JAR does not contain valid 'main' method", e);
        }
    }

    public static void free() {
        if (classLoader != null) {
            try {
                classLoader.close();
                classLoader = null;
            }
            catch (IOException e) {
                System.err.println("Memory leak, failed to release EPKCompiler ClassLoader!");
                e.printStackTrace();
            }
        }
    }
}

