/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.decompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class LocalVariableGenerator
extends SignatureVisitor {
    public static final Map<Character, String> primitiveNames = new HashMap<Character, String>();
    public static final Set<String> illegalVariableNames = new HashSet<String>();
    private String baseClass = null;
    private boolean isArray = false;
    private String typeParam1 = null;
    private boolean typeParam1IsArray = false;
    private String typeParam2 = null;
    private boolean typeParam2IsArray = false;
    public static final SignatureVisitor nopVisitor;

    static {
        primitiveNames.put(Character.valueOf('Z'), "Flag");
        primitiveNames.put(Character.valueOf('C'), "Char");
        primitiveNames.put(Character.valueOf('B'), "Byte");
        primitiveNames.put(Character.valueOf('S'), "Short");
        primitiveNames.put(Character.valueOf('I'), "Int");
        primitiveNames.put(Character.valueOf('F'), "Float");
        primitiveNames.put(Character.valueOf('J'), "Long");
        primitiveNames.put(Character.valueOf('D'), "Double");
        primitiveNames.put(Character.valueOf('V'), "Void");
        illegalVariableNames.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "const", "default", "do", "double", "else", "enum", "exports", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "var", "void", "volatile", "while", "string"));
        nopVisitor = new SignatureVisitor(327680){};
    }

    LocalVariableGenerator() {
        super(327680);
    }

    public static String createName(String sig) {
        SignatureReader rd = new SignatureReader(sig);
        LocalVariableGenerator gen = new LocalVariableGenerator();
        rd.acceptType(gen);
        return gen.getResult();
    }

    private String removePath(String in) {
        int idx = in.lastIndexOf(47);
        int idx2 = in.lastIndexOf(36);
        if (idx2 > idx && idx2 != in.length() - 1) {
            idx = idx2;
        }
        if (idx != -1) {
            in = in.substring(idx + 1);
        }
        if (in.length() == 0 || Character.isDigit(in.charAt(0))) {
            in = "obj" + in;
        }
        return in;
    }

    String getResult() {
        String rt = this.baseClass == null ? "Object" : this.removePath(this.baseClass);
        if (this.typeParam1 == null && this.typeParam2 == null) {
            if (this.isArray) {
                rt = "ArrayOf" + rt;
            }
        } else if (this.isArray) {
            rt = String.valueOf(rt) + "Array";
        }
        if (this.typeParam1 != null && this.typeParam2 == null) {
            if (this.typeParam1IsArray) {
                this.typeParam1 = String.valueOf(this.typeParam1) + "Array";
            }
            rt = String.valueOf(rt) + "Of" + this.removePath(this.typeParam1);
        } else if (this.typeParam1 != null && this.typeParam2 != null) {
            if (this.typeParam1IsArray) {
                this.typeParam1 = String.valueOf(this.typeParam1) + "Array";
            }
            if (this.typeParam2IsArray) {
                this.typeParam2 = String.valueOf(this.typeParam2) + "Array";
            }
            rt = String.valueOf(rt) + "Of" + this.removePath(this.typeParam1) + "And" + this.removePath(this.typeParam2);
        }
        return rt;
    }

    @Override
    public SignatureVisitor visitArrayType() {
        if (this.baseClass == null) {
            this.isArray = true;
            return new ArrayTypeVisitor();
        }
        return nopVisitor;
    }

    @Override
    public void visitBaseType(char descriptor) {
        if (this.baseClass == null) {
            this.baseClass = primitiveNames.get(Character.valueOf(descriptor));
        }
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return nopVisitor;
    }

    @Override
    public void visitClassType(String name) {
        if (this.baseClass == null) {
            this.baseClass = name;
        }
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return nopVisitor;
    }

    @Override
    public void visitFormalTypeParameter(String name) {
    }

    @Override
    public void visitInnerClassType(String name) {
    }

    @Override
    public SignatureVisitor visitInterface() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        return nopVisitor;
    }

    @Override
    public void visitTypeArgument() {
    }

    @Override
    public SignatureVisitor visitTypeArgument(char wildcard) {
        if (this.typeParam1 == null) {
            return new TypeParamVisitor(1);
        }
        if (this.typeParam2 == null) {
            return new TypeParamVisitor(2);
        }
        return nopVisitor;
    }

    @Override
    public void visitTypeVariable(String name) {
    }

    public static String nextLocalVariableNameFromString(Map<String, Integer> tmpLocalsMap, String signature, String pfx) {
        String ls;
        Integer i;
        String str;
        String string = str = signature.length() == 1 ? primitiveNames.get(Character.valueOf(signature.charAt(0))) : null;
        if (str == null) {
            str = LocalVariableGenerator.createName(signature);
        }
        if ((i = tmpLocalsMap.get(ls = str.toLowerCase())) == null) {
            tmpLocalsMap.put(ls, 1);
            str = Character.isDigit(str.charAt(str.length() - 1)) ? String.valueOf(str) + "_1" : (illegalVariableNames.contains(str.toLowerCase()) ? String.valueOf(str) + "1" : str);
        } else {
            int ii = i + 1;
            tmpLocalsMap.put(ls, ii);
            str = Character.isDigit(str.charAt(str.length() - 1)) || str.contains("And") || str.length() > 16 ? String.valueOf(str) + "_" + ii : String.valueOf(str) + ii;
        }
        return pfx == null ? LocalVariableGenerator.camelCase(str) : String.valueOf(pfx) + str;
    }

    public static String nextLocalVariableName(Map<String, Integer> tmpLocalsMap, LocalVariableGenerator signature, String pfx) {
        String str = signature.getResult();
        String ls = str.toLowerCase();
        Integer i = tmpLocalsMap.get(ls);
        if (i == null) {
            tmpLocalsMap.put(ls, 1);
            str = Character.isDigit(str.charAt(str.length() - 1)) ? String.valueOf(str) + "_1" : (illegalVariableNames.contains(str.toLowerCase()) ? String.valueOf(str) + "1" : str);
        } else {
            int ii = i + 1;
            tmpLocalsMap.put(ls, ii);
            str = Character.isDigit(str.charAt(str.length() - 1)) || str.contains("And") || str.length() > 16 ? String.valueOf(str) + "_" + ii : String.valueOf(str) + ii;
        }
        return pfx == null ? LocalVariableGenerator.camelCase(str) : String.valueOf(pfx) + str;
    }

    public static String camelCase(String in) {
        if (in == null || in.length() <= 0) {
            return "name";
        }
        if (in.length() > 1 && Character.isUpperCase(in.charAt(0)) && Character.isUpperCase(in.charAt(1))) {
            return "var" + in;
        }
        return String.valueOf(in.substring(0, 1).toLowerCase()) + in.substring(1);
    }

    private class ArrayTypeVisitor
    extends SignatureVisitor {
        protected ArrayTypeVisitor() {
            super(327680);
        }

        @Override
        public void visitBaseType(char descriptor) {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = primitiveNames.get(Character.valueOf(descriptor));
            }
        }

        @Override
        public void visitClassType(String name) {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = name;
            }
        }

        @Override
        public SignatureVisitor visitArrayType() {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = "array";
            }
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitInterface() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitTypeArgument(char wildcard) {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return nopVisitor;
        }
    }

    private class TypeParamVisitor
    extends SignatureVisitor {
        private boolean hasVisited;
        private final int firstOrSecond;

        protected TypeParamVisitor(int firstOrSecond) {
            super(327680);
            this.hasVisited = false;
            this.firstOrSecond = firstOrSecond;
        }

        @Override
        public void visitBaseType(char descriptor) {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1 = primitiveNames.get(Character.valueOf(descriptor));
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2 = primitiveNames.get(Character.valueOf(descriptor));
                }
                this.hasVisited = true;
            }
        }

        @Override
        public void visitClassType(String name) {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1 = name;
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2 = name;
                }
                this.hasVisited = true;
            }
        }

        @Override
        public SignatureVisitor visitArrayType() {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1IsArray = true;
                        return new TypeParamArrayVisitor();
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2IsArray = true;
                    return new TypeParamArrayVisitor();
                }
            }
            return nopVisitor;
        }

        private class TypeParamArrayVisitor
        extends SignatureVisitor {
            protected TypeParamArrayVisitor() {
                super(327680);
            }

            @Override
            public void visitBaseType(char descriptor) {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = primitiveNames.get(Character.valueOf(descriptor));
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = primitiveNames.get(Character.valueOf(descriptor));
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
            }

            @Override
            public void visitClassType(String name) {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = name;
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = name;
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
            }

            @Override
            public SignatureVisitor visitArrayType() {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = "array";
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = "array";
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitClassBound() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitExceptionType() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitInterface() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitParameterType() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char wildcard) {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitReturnType() {
                return nopVisitor;
            }
        }
    }
}

