/*
 * Decompiled with CFR 0.152.
 */
import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.DeflaterOutputStream;
import com.jcraft.jzlib.GZIPOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CompilePackage {
    private static List<FileEntry> files = new ArrayList<FileEntry>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException {
        int compressionType;
        files.clear();
        if (args.length < 2 || args.length > 4) {
            System.out.println("Usage: java -jar CompilePackage.jar <input directories/zips> <output file> [gzip|zlib|none] [file-type]");
            return;
        }
        String[] dirs = args[0].split("\\" + System.getProperty("path.separator"));
        File output = new File(args[1]);
        if (args.length > 2) {
            if (args[2].equalsIgnoreCase("gzip")) {
                compressionType = 71;
            } else if (args[2].equalsIgnoreCase("zlib")) {
                compressionType = 90;
            } else {
                if (!args[2].equalsIgnoreCase("none")) throw new IllegalArgumentException("Unknown compression method: " + args[2]);
                compressionType = 48;
            }
        } else {
            compressionType = 71;
        }
        int i = 0;
        while (i < dirs.length) {
            CompilePackage.listDirectory(new File(dirs[i]));
            ++i;
        }
        ByteArrayOutputStream osb = new ByteArrayOutputStream();
        osb.write("EAGPKG$$".getBytes(Charset.forName("UTF-8")));
        String chars = "ver2.0";
        osb.write(chars.length());
        osb.write(chars.getBytes(StandardCharsets.US_ASCII));
        Date d = new Date();
        String comment = "\n\n #  Eagler EPK v2.0 (c) " + new SimpleDateFormat("yyyy").format(d) + " lax1dude\n" + " #  update: on " + new SimpleDateFormat("MM/dd/yyyy").format(d) + " at " + new SimpleDateFormat("hh:mm:ss aa").format(d) + "\n\n";
        String nm = output.getName();
        osb.write(nm.length());
        osb.write(nm.getBytes(StandardCharsets.US_ASCII));
        CompilePackage.writeShort(comment.length(), osb);
        osb.write(comment.getBytes(StandardCharsets.US_ASCII));
        CompilePackage.writeLong(d.getTime(), osb);
        CompilePackage.writeInt(files.size() + 1, osb);
        osb.write(compressionType);
        OutputStream os = compressionType == 71 ? new GZIPOutputStream(osb, new Deflater(9, 31), 16384, true) : (compressionType == 90 ? new DeflaterOutputStream(osb, new Deflater(9), 16384, true) : osb);
        os.write("HEAD".getBytes(StandardCharsets.US_ASCII));
        String key = "file-type";
        os.write(key.length());
        os.write(key.getBytes(StandardCharsets.US_ASCII));
        String value = args.length > 3 ? args[3] : "epk/resources";
        CompilePackage.writeInt(value.length(), os);
        os.write(value.getBytes(StandardCharsets.US_ASCII));
        os.write(62);
        CRC32 checkSum = new CRC32();
        for (FileEntry f : files) {
            String p = f.name;
            byte[] targetArray = f.value;
            checkSum.reset();
            checkSum.update(targetArray, 0, targetArray.length);
            int ch = (int)checkSum.getValue();
            os.write("FILE".getBytes(StandardCharsets.US_ASCII));
            if (p.startsWith("/")) {
                p = p.substring(1);
            }
            os.write(p.length());
            os.write(p.getBytes(StandardCharsets.US_ASCII));
            CompilePackage.writeInt(targetArray.length + 5, os);
            CompilePackage.writeInt(ch, os);
            os.write(targetArray);
            os.write(58);
            os.write(62);
        }
        os.write("END$".getBytes(StandardCharsets.US_ASCII));
        os.close();
        osb.write(":::YEE:>".getBytes(StandardCharsets.US_ASCII));
        FileOutputStream out = new FileOutputStream(output);
        out.write(osb.toByteArray());
        out.close();
    }

    public static void writeShort(int i, OutputStream os) throws IOException {
        os.write(i >> 8 & 0xFF);
        os.write(i & 0xFF);
    }

    public static void writeInt(int i, OutputStream os) throws IOException {
        os.write(i >> 24 & 0xFF);
        os.write(i >> 16 & 0xFF);
        os.write(i >> 8 & 0xFF);
        os.write(i & 0xFF);
    }

    public static void writeLong(long i, OutputStream os) throws IOException {
        os.write((int)(i >> 56 & 0xFFL));
        os.write((int)(i >> 48 & 0xFFL));
        os.write((int)(i >> 40 & 0xFFL));
        os.write((int)(i >> 32 & 0xFFL));
        os.write((int)(i >> 24 & 0xFFL));
        os.write((int)(i >> 16 & 0xFFL));
        os.write((int)(i >> 8 & 0xFFL));
        os.write((int)(i & 0xFFL));
    }

    public static void listDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            CompilePackage.listDirectoryFile(dir, dir.getAbsolutePath().length());
        } else {
            CompilePackage.listDirectoryZIP(dir);
        }
    }

    public static void listDirectoryFile(File dir, int pfxLen) throws IOException {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                CompilePackage.listDirectoryFile(f, pfxLen);
            } else {
                String name = f.getAbsolutePath().substring(pfxLen).replace('\\', '/');
                files.add(new FileEntry(name, CompilePackage.fileToBytes(f)));
            }
            ++n2;
        }
    }

    public static void listDirectoryZIP(File zip) throws IOException {
        byte[] copyBuffer = new byte[16384];
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry etr;
            while ((etr = zis.getNextEntry()) != null) {
                int i;
                if (etr.isDirectory() || etr.getName().startsWith("META-INF")) continue;
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                while ((i = zis.read(copyBuffer)) != -1) {
                    bao.write(copyBuffer, 0, i);
                }
                files.add(new FileEntry(etr.getName(), bao.toByteArray()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] fileToBytes(File fileIn) throws IOException {
        byte[] data = new byte[(int)fileIn.length()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream fin = new FileInputStream(fileIn);){
            int j;
            int i = 0;
            while ((j = fin.read(data, i, data.length - i)) != -1 && i < data.length) {
                i += j;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return data;
    }

    private static class FileEntry {
        private final String name;
        private final byte[] value;

        public FileEntry(String name, byte[] value) {
            this.name = name;
            this.value = value;
        }
    }
}

