/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import org.codehaus.plexus.util.FileUtils;

public class EaglerDrivers {
    private static final Map<String, URLClassLoader> driversJARs = new HashMap<String, URLClassLoader>();
    private static final Map<String, Driver> driversDrivers = new HashMap<String, Driver>();

    private static Driver initializeDriver(String string, String string2) {
        Object object;
        Serializable serializable;
        URLClassLoader uRLClassLoader = driversJARs.get(string);
        if (uRLClassLoader == null) {
            if (string.equalsIgnoreCase("internal")) {
                serializable = new File(EaglerXBungee.getEagler().getDataFolder(), "drivers/sqlite-jdbc.jar");
                ((File)serializable).getParentFile().mkdirs();
                if (!((File)serializable).exists()) {
                    try {
                        FileUtils.copyURLToFile((URL)EaglerDrivers.class.getResource("sqlite-jdbc.jar"), (File)serializable);
                    }
                    catch (IOException iOException) {
                        EaglerXBungee.logger().severe("Could not extract sqlite-jdbc.jar!");
                        throw new ExceptionInInitializerError(iOException);
                    }
                }
            } else {
                serializable = new File(string);
            }
            try {
                object = ((File)serializable).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                EaglerXBungee.logger().severe("Invalid JDBC driver path: " + string);
                throw new ExceptionInInitializerError(malformedURLException);
            }
            uRLClassLoader = new URLClassLoader(new URL[]{object}, ClassLoader.getSystemClassLoader());
            driversJARs.put(string, uRLClassLoader);
        }
        try {
            serializable = uRLClassLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                uRLClassLoader.close();
            }
            catch (IOException iOException) {}
            EaglerXBungee.logger().severe("Could not find JDBC driver class: " + string2);
            throw new ExceptionInInitializerError(classNotFoundException);
        }
        object = null;
        try {
            object = (Driver)((Class)serializable).newInstance();
        }
        catch (Throwable throwable) {
            try {
                uRLClassLoader.close();
            }
            catch (IOException iOException) {}
            EaglerXBungee.logger().severe("Could not initialize JDBC driver class: " + string2);
            throw new ExceptionInInitializerError(throwable);
        }
        return object;
    }

    public static Connection connectToDatabase(String string, String string2, String string3, Properties properties) throws SQLException {
        if (string2.equalsIgnoreCase("internal")) {
            string2 = "org.sqlite.JDBC";
        }
        if (string3 == null) {
            try {
                Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException("Driver class not found in JRE: " + string2, classNotFoundException);
            }
            return DriverManager.getConnection(string, properties);
        }
        String string4 = string3 + "?" + string2;
        Driver driver = driversDrivers.get(string4);
        if (driver == null) {
            driver = EaglerDrivers.initializeDriver(string3, string2);
            driversDrivers.put(string4, driver);
        }
        return driver.connect(string, properties);
    }
}

