/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.AsyncSkinProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.JDBCCacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class SkinService
implements ISkinService {
    public static final int masterRateLimitPerPlayer = 250;
    public static final int PACKET_MY_SKIN_PRESET = 1;
    public static final int PACKET_MY_SKIN_CUSTOM = 2;
    public static final int PACKET_GET_OTHER_SKIN = 3;
    public static final int PACKET_OTHER_SKIN_PRESET = 4;
    public static final int PACKET_OTHER_SKIN_CUSTOM = 5;
    public static final String CHANNEL = "EAG|Skins-1.8";
    private final Map<UUID, CachedPlayerSkin> onlinePlayersCache = new HashMap<UUID, CachedPlayerSkin>();
    private final Multimap<UUID, UUID> onlinePlayersFromTexturesMap = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<UUID, UUID> onlinePlayersToTexturesMap = new HashMap<UUID, UUID>();
    private final Map<UUID, CachedForeignSkin> foreignSkinCache = new HashMap<UUID, CachedForeignSkin>();
    private final Map<UUID, PendingTextureDownload> pendingTextures = new HashMap<UUID, PendingTextureDownload>();
    private final Map<UUID, PendingProfileUUIDLookup> pendingUUIDs = new HashMap<UUID, PendingProfileUUIDLookup>();
    private final Map<String, PendingProfileNameLookup> pendingNameLookups = new HashMap<String, PendingProfileNameLookup>();
    private final TObjectIntMap<UUID> antagonists = new TObjectIntHashMap();
    private long antagonistCooldown = System.currentTimeMillis();
    private final Consumer<Set<UUID>> antagonistLogger = new Consumer<Set<UUID>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Set<UUID> set) {
            if (set.size() == 1) {
                int n = EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit() << 1;
                UUID uUID = set.iterator().next();
                TObjectIntMap tObjectIntMap = SkinService.this.antagonists;
                synchronized (tObjectIntMap) {
                    int n2 = SkinService.this.antagonists.get((Object)uUID);
                    if (n2 == SkinService.this.antagonists.getNoEntryValue()) {
                        SkinService.this.antagonists.put((Object)uUID, 1);
                    } else if (n2 <= n) {
                        SkinService.this.antagonists.put((Object)uUID, n2 + 1);
                    }
                }
            }
        }
    };
    private ICacheProvider cacheProvider = null;
    private int ee = 0;
    private static final String hexString = "0123456789abcdef";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public void init(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        this.antagonistCooldown = System.currentTimeMillis();
        if (this.cacheProvider == null) {
            this.cacheProvider = JDBCCacheProvider.initialize(string, string2, string3, n, n2, n3, n4);
        }
        this.resetMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID uUID, UserConnection userConnection) {
        CachedPlayerSkin cachedPlayerSkin;
        EaglerInitialHandler eaglerInitialHandler = (EaglerInitialHandler)userConnection.getPendingConnection();
        if (!eaglerInitialHandler.skinLookupRateLimiter.rateLimit(250)) {
            return;
        }
        ProxiedPlayer proxiedPlayer = this.onlinePlayersCache;
        synchronized (proxiedPlayer) {
            cachedPlayerSkin = this.onlinePlayersCache.get(uUID);
        }
        if (cachedPlayerSkin != null) {
            userConnection.sendData(CHANNEL, cachedPlayerSkin.data);
        } else {
            Object object;
            Property property;
            UUID uUID2;
            proxiedPlayer = BungeeCord.getInstance().getPlayer(uUID);
            Object object2 = this.onlinePlayersToTexturesMap;
            synchronized (object2) {
                uUID2 = this.onlinePlayersToTexturesMap.get(uUID);
            }
            if (uUID2 != null) {
                Object object3;
                boolean bl;
                Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
                synchronized (multimap) {
                    object2 = this.onlinePlayersFromTexturesMap.get((Object)uUID2);
                }
                boolean bl2 = bl = object2.size() > 0;
                if (bl) {
                    property = object2.iterator();
                    while (property.hasNext()) {
                        object3 = (UUID)property.next();
                        object = this.onlinePlayersCache;
                        synchronized (object) {
                            cachedPlayerSkin = this.onlinePlayersCache.get(object3);
                        }
                        if (cachedPlayerSkin == null) continue;
                        object = SkinPackets.rewriteUUID(uUID, cachedPlayerSkin.data);
                        if (proxiedPlayer != null) {
                            Map<UUID, CachedPlayerSkin> map = this.onlinePlayersCache;
                            synchronized (map) {
                                this.onlinePlayersCache.put(uUID, new CachedPlayerSkin((byte[])object, cachedPlayerSkin.textureUUID, cachedPlayerSkin.modelId));
                            }
                        }
                        userConnection.sendData(CHANNEL, (byte[])object);
                        return;
                    }
                }
                property = this.foreignSkinCache;
                synchronized (property) {
                    object3 = this.foreignSkinCache.get(uUID2);
                }
                if (object3 != null && ((CachedForeignSkin)object3).modelKnown != -1) {
                    if (proxiedPlayer != null) {
                        property = this.onlinePlayersCache;
                        synchronized (property) {
                            this.onlinePlayersCache.put(uUID, new CachedPlayerSkin(SkinPackets.rewriteUUID(uUID, ((CachedForeignSkin)object3).data), uUID2, ((CachedForeignSkin)object3).modelKnown));
                        }
                        property = this.foreignSkinCache;
                        synchronized (property) {
                            this.foreignSkinCache.remove(uUID2);
                        }
                    }
                    ((CachedForeignSkin)object3).lastHit = System.currentTimeMillis();
                    userConnection.sendData(CHANNEL, ((CachedForeignSkin)object3).data);
                    return;
                }
            }
            if (proxiedPlayer != null && proxiedPlayer instanceof UserConnection) {
                Property[] propertyArray;
                if (proxiedPlayer instanceof UserConnection && (object2 = ((UserConnection)proxiedPlayer).getPendingConnection().getLoginProfile()) != null && (propertyArray = object2.getProperties()).length > 0) {
                    int n = 0;
                    while (n < propertyArray.length) {
                        block58: {
                            property = propertyArray[n];
                            if (property.getName().equals("textures")) {
                                try {
                                    CachedForeignSkin cachedForeignSkin;
                                    JsonElement jsonElement;
                                    object = SkinPackets.bytesToAscii(Base64.decodeBase64((String)property.getValue()));
                                    JsonObject jsonObject = new JsonParser().parse((String)object).getAsJsonObject();
                                    JsonObject jsonObject2 = jsonObject.getAsJsonObject("SKIN");
                                    if (jsonObject2 == null || (jsonElement = jsonObject.get("url")) == null) break block58;
                                    String string = jsonElement.getAsString();
                                    if ((string = SkinService.sanitizeTextureURL(string)) == null) break;
                                    int n2 = 0;
                                    JsonElement jsonElement2 = jsonObject2.get("metadata");
                                    if (jsonElement2 != null && jsonElement2.isJsonObject() && (jsonElement2 = jsonElement2.getAsJsonObject().get("model")) != null) {
                                        n2 = SkinPackets.getModelId(jsonElement2.getAsString());
                                    }
                                    UUID uUID3 = SkinPackets.createEaglerURLSkinUUID(string);
                                    Object object4 = this.foreignSkinCache;
                                    synchronized (object4) {
                                        cachedForeignSkin = this.foreignSkinCache.remove(uUID3);
                                    }
                                    if (cachedForeignSkin != null) {
                                        this.registerTextureToPlayerAssociation(uUID3, uUID);
                                        object4 = SkinPackets.rewriteUUIDModel(uUID, cachedForeignSkin.data, n2);
                                        Map<UUID, CachedPlayerSkin> map = this.onlinePlayersCache;
                                        synchronized (map) {
                                            this.onlinePlayersCache.put(uUID, new CachedPlayerSkin((byte[])object4, uUID3, n2));
                                        }
                                        userConnection.sendData(CHANNEL, (byte[])object4);
                                        return;
                                    }
                                    if (!this.isLimitedAsAntagonist(proxiedPlayer.getUniqueId())) {
                                        this.processResolveURLTextureForOnline(userConnection, uUID, uUID3, string, n2);
                                    }
                                    return;
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        ++n;
                    }
                }
                if (!this.isLimitedAsAntagonist(proxiedPlayer.getUniqueId())) {
                    if (proxiedPlayer.getPendingConnection().isOnlineMode()) {
                        this.processResolveProfileTextureByUUIDForOnline(userConnection, uUID);
                    } else {
                        this.processResolveProfileTextureByNameForOnline(userConnection, proxiedPlayer.getPendingConnection().getName(), uUID);
                    }
                }
            } else {
                Map<UUID, CachedForeignSkin> map = this.foreignSkinCache;
                synchronized (map) {
                    object2 = this.foreignSkinCache.get(uUID);
                }
                if (object2 != null) {
                    ((CachedForeignSkin)object2).lastHit = System.currentTimeMillis();
                    userConnection.sendData(CHANNEL, ((CachedForeignSkin)object2).data);
                } else if (eaglerInitialHandler.skinUUIDLookupRateLimiter.rateLimit(EaglerXBungee.getEagler().getConfig().getUuidRateLimitPlayer()) && !this.isLimitedAsAntagonist(userConnection.getUniqueId())) {
                    this.processResolveProfileTextureByUUIDForeign(userConnection, uUID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID uUID, String string, UserConnection userConnection) {
        CachedForeignSkin cachedForeignSkin;
        EaglerBungeeConfig eaglerBungeeConfig = EaglerXBungee.getEagler().getConfig();
        EaglerInitialHandler eaglerInitialHandler = (EaglerInitialHandler)userConnection.getPendingConnection();
        if (!eaglerInitialHandler.skinLookupRateLimiter.rateLimit(250)) {
            return;
        }
        Object object = this.foreignSkinCache;
        synchronized (object) {
            cachedForeignSkin = this.foreignSkinCache.get(uUID);
        }
        if (cachedForeignSkin != null) {
            cachedForeignSkin.lastHit = System.currentTimeMillis();
            userConnection.sendData(CHANNEL, cachedForeignSkin.data);
        } else {
            boolean bl;
            Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
            synchronized (multimap) {
                object = this.onlinePlayersFromTexturesMap.get((Object)uUID);
            }
            boolean bl2 = bl = object.size() > 0;
            if (bl) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CachedPlayerSkin cachedPlayerSkin;
                    UUID uUID2 = (UUID)iterator.next();
                    Object object2 = this.onlinePlayersCache;
                    synchronized (object2) {
                        cachedPlayerSkin = this.onlinePlayersCache.get(uUID2);
                    }
                    if (cachedPlayerSkin == null) continue;
                    object2 = SkinPackets.rewriteUUID(uUID, cachedPlayerSkin.data);
                    Map<UUID, CachedPlayerSkin> map = this.onlinePlayersCache;
                    synchronized (map) {
                        this.onlinePlayersCache.put(uUID, cachedPlayerSkin);
                    }
                    userConnection.sendData(CHANNEL, (byte[])object2);
                    return;
                }
            }
            if (eaglerInitialHandler.skinTextureDownloadRateLimiter.rateLimit(eaglerBungeeConfig.getSkinRateLimitPlayer()) && !this.isLimitedAsAntagonist(userConnection.getUniqueId())) {
                this.processResolveURLTextureForForeign(userConnection, uUID, uUID, string, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveURLTextureForOnline(final UserConnection userConnection, final UUID uUID, final UUID uUID2, String string, final int n) {
        Map<UUID, PendingTextureDownload> map = this.pendingTextures;
        synchronized (map) {
            PendingTextureDownload pendingTextureDownload = this.pendingTextures.get(uUID2);
            if (pendingTextureDownload != null) {
                if (pendingTextureDownload.antagonists.add(userConnection.getUniqueId())) {
                    pendingTextureDownload.callbacks.add(new Consumer<byte[]>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(byte[] byArray) {
                            CachedPlayerSkin cachedPlayerSkin;
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                cachedPlayerSkin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(uUID);
                            }
                            if (cachedPlayerSkin != null) {
                                userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                            }
                        }
                    });
                }
            } else {
                PendingTextureDownload pendingTextureDownload2 = new PendingTextureDownload(uUID2, string, userConnection.getUniqueId(), new Consumer<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(byte[] byArray) {
                        CachedPlayerSkin cachedPlayerSkin;
                        if (byArray != null) {
                            SkinService.this.registerTextureToPlayerAssociation(uUID2, uUID);
                            cachedPlayerSkin = new CachedPlayerSkin(SkinPackets.makeCustomResponse(uUID, n, byArray), uUID2, n);
                        } else {
                            cachedPlayerSkin = new CachedPlayerSkin(SkinPackets.makePresetResponse(uUID), null, -1);
                        }
                        Map map = SkinService.this.onlinePlayersCache;
                        synchronized (map) {
                            SkinService.this.onlinePlayersCache.put(uUID, cachedPlayerSkin);
                        }
                        userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.downloadSkin(uUID2, string, this.cacheProvider, pendingTextureDownload2);
                }
                catch (AsyncSkinProvider.CancelException cancelException) {
                    return;
                }
                this.pendingTextures.put(uUID2, pendingTextureDownload2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveURLTextureForForeign(final UserConnection userConnection, final UUID uUID, UUID uUID2, String string, final int n) {
        Map<UUID, PendingTextureDownload> map = this.pendingTextures;
        synchronized (map) {
            PendingTextureDownload pendingTextureDownload = this.pendingTextures.get(uUID2);
            if (pendingTextureDownload != null) {
                if (pendingTextureDownload.antagonists.add(userConnection.getUniqueId())) {
                    pendingTextureDownload.callbacks.add(new Consumer<byte[]>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(byte[] byArray) {
                            CachedForeignSkin cachedForeignSkin;
                            Map map = SkinService.this.foreignSkinCache;
                            synchronized (map) {
                                cachedForeignSkin = (CachedForeignSkin)SkinService.this.foreignSkinCache.get(uUID);
                            }
                            if (cachedForeignSkin != null) {
                                userConnection.sendData(SkinService.CHANNEL, cachedForeignSkin.data);
                            }
                        }
                    });
                }
            } else {
                PendingTextureDownload pendingTextureDownload2 = new PendingTextureDownload(uUID2, string, userConnection.getUniqueId(), new Consumer<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(byte[] byArray) {
                        CachedForeignSkin cachedForeignSkin = byArray != null ? new CachedForeignSkin(uUID, SkinPackets.makeCustomResponse(uUID, n, byArray), n) : new CachedForeignSkin(uUID, SkinPackets.makePresetResponse(uUID), -1);
                        Map map = SkinService.this.foreignSkinCache;
                        synchronized (map) {
                            SkinService.this.foreignSkinCache.put(uUID, cachedForeignSkin);
                        }
                        userConnection.sendData(SkinService.CHANNEL, cachedForeignSkin.data);
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.downloadSkin(uUID2, string, this.cacheProvider, pendingTextureDownload2);
                }
                catch (AsyncSkinProvider.CancelException cancelException) {
                    return;
                }
                this.pendingTextures.put(uUID2, pendingTextureDownload2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByUUIDForOnline(final UserConnection userConnection, final UUID uUID) {
        Map<UUID, PendingProfileUUIDLookup> map = this.pendingUUIDs;
        synchronized (map) {
            PendingProfileUUIDLookup pendingProfileUUIDLookup = this.pendingUUIDs.get(uUID);
            if (pendingProfileUUIDLookup != null) {
                if (pendingProfileUUIDLookup.antagonists.add(userConnection.getUniqueId())) {
                    pendingProfileUUIDLookup.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                            if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                                CachedPlayerSkin cachedPlayerSkin;
                                Map map = SkinService.this.onlinePlayersCache;
                                synchronized (map) {
                                    cachedPlayerSkin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(uUID);
                                }
                                if (cachedPlayerSkin != null) {
                                    userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForOnline(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileUUIDLookup pendingProfileUUIDLookup2 = new PendingProfileUUIDLookup(uUID, userConnection.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                        if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                            CachedPlayerSkin cachedPlayerSkin = cacheFetchedProfile == null ? new CachedPlayerSkin(SkinPackets.makePresetResponse(uUID), null, -1) : new CachedPlayerSkin(SkinPackets.makePresetResponse(uUID, SkinPackets.getModelId(cacheFetchedProfile.model) == 1 ? 1 : 0), null, -1);
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                SkinService.this.onlinePlayersCache.put(uUID, cachedPlayerSkin);
                            }
                            userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForOnline(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUUID(uUID, this.cacheProvider, pendingProfileUUIDLookup2);
                }
                catch (AsyncSkinProvider.CancelException cancelException) {
                    return;
                }
                this.pendingUUIDs.put(uUID, pendingProfileUUIDLookup2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByNameForOnline(final UserConnection userConnection, String string, final UUID uUID) {
        Map<String, PendingProfileNameLookup> map = this.pendingNameLookups;
        synchronized (map) {
            PendingProfileNameLookup pendingProfileNameLookup = this.pendingNameLookups.get(string);
            if (pendingProfileNameLookup != null) {
                if (pendingProfileNameLookup.antagonists.add(userConnection.getUniqueId())) {
                    pendingProfileNameLookup.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                            if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                                CachedPlayerSkin cachedPlayerSkin;
                                Map map = SkinService.this.onlinePlayersCache;
                                synchronized (map) {
                                    cachedPlayerSkin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(cacheFetchedProfile.uuid);
                                }
                                if (cachedPlayerSkin != null) {
                                    userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForOnline(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileNameLookup pendingProfileNameLookup2 = new PendingProfileNameLookup(string, userConnection.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                        if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                            CachedPlayerSkin cachedPlayerSkin = cacheFetchedProfile == null ? new CachedPlayerSkin(SkinPackets.makePresetResponse(uUID), null, -1) : new CachedPlayerSkin(SkinPackets.makePresetResponse(uUID, SkinPackets.getModelId(cacheFetchedProfile.model) == 1 ? 1 : 0), null, -1);
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                SkinService.this.onlinePlayersCache.put(uUID, cachedPlayerSkin);
                            }
                            userConnection.sendData(SkinService.CHANNEL, cachedPlayerSkin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForOnline(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUsername(string, this.cacheProvider, pendingProfileNameLookup2);
                }
                catch (AsyncSkinProvider.CancelException cancelException) {
                    return;
                }
                this.pendingNameLookups.put(string, pendingProfileNameLookup2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByUUIDForeign(final UserConnection userConnection, final UUID uUID) {
        Map<UUID, PendingProfileUUIDLookup> map = this.pendingUUIDs;
        synchronized (map) {
            PendingProfileUUIDLookup pendingProfileUUIDLookup = this.pendingUUIDs.get(uUID);
            if (pendingProfileUUIDLookup != null) {
                if (pendingProfileUUIDLookup.antagonists.add(userConnection.getUniqueId())) {
                    pendingProfileUUIDLookup.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                            if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                                CachedForeignSkin cachedForeignSkin;
                                Map map = SkinService.this.foreignSkinCache;
                                synchronized (map) {
                                    cachedForeignSkin = (CachedForeignSkin)SkinService.this.foreignSkinCache.get(uUID);
                                }
                                if (cachedForeignSkin != null) {
                                    userConnection.sendData(SkinService.CHANNEL, cachedForeignSkin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForForeign(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileUUIDLookup pendingProfileUUIDLookup2 = new PendingProfileUUIDLookup(uUID, userConnection.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
                        if (cacheFetchedProfile == null || cacheFetchedProfile.texture == null) {
                            CachedForeignSkin cachedForeignSkin = cacheFetchedProfile == null ? new CachedForeignSkin(uUID, SkinPackets.makePresetResponse(uUID), -1) : new CachedForeignSkin(uUID, SkinPackets.makePresetResponse(uUID, SkinPackets.getModelId(cacheFetchedProfile.model) == 1 ? 1 : 0), -1);
                            Map map = SkinService.this.foreignSkinCache;
                            synchronized (map) {
                                SkinService.this.foreignSkinCache.put(uUID, cachedForeignSkin);
                            }
                            userConnection.sendData(SkinService.CHANNEL, cachedForeignSkin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForForeign(userConnection, uUID, cacheFetchedProfile.textureUUID, cacheFetchedProfile.texture, SkinPackets.getModelId(cacheFetchedProfile.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUUID(uUID, this.cacheProvider, pendingProfileUUIDLookup2);
                }
                catch (AsyncSkinProvider.CancelException cancelException) {
                    return;
                }
                this.pendingUUIDs.put(uUID, pendingProfileUUIDLookup2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEaglercraftPlayer(UUID uUID, byte[] byArray, int n) throws IOException {
        Map<UUID, Object> map = this.foreignSkinCache;
        synchronized (map) {
            this.foreignSkinCache.remove(uUID);
        }
        map = this.onlinePlayersCache;
        synchronized (map) {
            this.onlinePlayersCache.put(uUID, new CachedPlayerSkin(byArray, null, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPlayer(UUID uUID) {
        CachedPlayerSkin cachedPlayerSkin;
        Map<UUID, Object> map = this.onlinePlayersCache;
        synchronized (map) {
            cachedPlayerSkin = this.onlinePlayersCache.remove(uUID);
        }
        if (cachedPlayerSkin != null) {
            map = this.foreignSkinCache;
            synchronized (map) {
                this.foreignSkinCache.put(uUID, new CachedForeignSkin(uUID, cachedPlayerSkin.data, cachedPlayerSkin.modelId));
            }
            if (cachedPlayerSkin.textureUUID != null) {
                map = this.foreignSkinCache;
                synchronized (map) {
                    this.foreignSkinCache.put(cachedPlayerSkin.textureUUID, new CachedForeignSkin(cachedPlayerSkin.textureUUID, cachedPlayerSkin.data, cachedPlayerSkin.modelId));
                }
            }
            this.deletePlayerTextureAssociation(uUID, cachedPlayerSkin.textureUUID);
        } else {
            this.deletePlayerTextureAssociation(uUID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePlayerTextureAssociation(UUID uUID, UUID uUID2) {
        UUID uUID3;
        if (uUID2 != null) {
            Map<UUID, UUID> map = this.onlinePlayersToTexturesMap;
            synchronized (map) {
                this.onlinePlayersToTexturesMap.remove(uUID);
            }
            map = this.onlinePlayersFromTexturesMap;
            synchronized (map) {
                this.onlinePlayersFromTexturesMap.remove((Object)uUID2, (Object)uUID);
            }
        }
        Map<UUID, UUID> map = this.onlinePlayersToTexturesMap;
        synchronized (map) {
            uUID3 = this.onlinePlayersToTexturesMap.remove(uUID);
        }
        if (uUID3 != null) {
            map = this.onlinePlayersFromTexturesMap;
            synchronized (map) {
                this.onlinePlayersFromTexturesMap.remove((Object)uUID3, (Object)uUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTextureToPlayerAssociation(UUID uUID, UUID uUID2) {
        Object object = this.onlinePlayersFromTexturesMap;
        synchronized (object) {
            this.onlinePlayersFromTexturesMap.put((Object)uUID, (Object)uUID2);
        }
        object = this.onlinePlayersToTexturesMap;
        synchronized (object) {
            this.onlinePlayersToTexturesMap.put(uUID2, uUID);
        }
        Map<UUID, Object> map = this.foreignSkinCache;
        synchronized (map) {
            object = this.foreignSkinCache.remove(uUID);
        }
        if (object != null) {
            map = this.onlinePlayersCache;
            synchronized (map) {
                this.onlinePlayersCache.put(uUID2, new CachedPlayerSkin(object.data, uUID, object.modelKnown));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        TObjectIntMap<UUID> tObjectIntMap;
        Iterator<Object> iterator;
        long l = System.currentTimeMillis();
        Map<Object, Object> map = this.foreignSkinCache;
        synchronized (map) {
            iterator = this.foreignSkinCache.values().iterator();
            while (iterator.hasNext()) {
                if (l - iterator.next().lastHit <= 900000L) continue;
                iterator.remove();
            }
        }
        map = this.pendingTextures;
        synchronized (map) {
            iterator = this.pendingTextures.values().iterator();
            while (iterator.hasNext()) {
                tObjectIntMap = (PendingTextureDownload)iterator.next();
                if (l - tObjectIntMap.initializedTime <= (tObjectIntMap.finalized ? 5000L : 10000L)) continue;
                iterator.remove();
                try {
                    tObjectIntMap.antagonistsCallback.accept(tObjectIntMap.antagonists);
                }
                catch (Throwable throwable) {}
            }
        }
        map = this.pendingUUIDs;
        synchronized (map) {
            iterator = this.pendingUUIDs.values().iterator();
            while (iterator.hasNext()) {
                tObjectIntMap = (PendingProfileUUIDLookup)iterator.next();
                if (l - tObjectIntMap.initializedTime <= (tObjectIntMap.finalized ? 5000L : 10000L)) continue;
                iterator.remove();
                try {
                    tObjectIntMap.antagonistsCallback.accept(tObjectIntMap.antagonists);
                }
                catch (Throwable throwable) {}
            }
        }
        map = this.pendingNameLookups;
        synchronized (map) {
            iterator = this.pendingNameLookups.values().iterator();
            while (iterator.hasNext()) {
                tObjectIntMap = (PendingProfileNameLookup)iterator.next();
                if (l - tObjectIntMap.initializedTime <= (tObjectIntMap.finalized ? 5000L : 10000L)) continue;
                iterator.remove();
                try {
                    tObjectIntMap.antagonistsCallback.accept(tObjectIntMap.antagonists);
                }
                catch (Throwable throwable) {}
            }
        }
        int n = 60000 / EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit();
        int n2 = (int)(l - this.antagonistCooldown);
        if ((n2 /= n) > 0) {
            this.antagonistCooldown += (long)(n2 * n);
            tObjectIntMap = this.antagonists;
            synchronized (tObjectIntMap) {
                Iterator iterator2 = this.antagonists.keySet().iterator();
                while (iterator2.hasNext()) {
                    UUID uUID = (UUID)iterator2.next();
                    int n3 = this.antagonists.get((Object)uUID) - n2;
                    if (n3 <= 0) {
                        iterator2.remove();
                        continue;
                    }
                    this.antagonists.put((Object)uUID, n3);
                }
            }
        }
        this.cacheProvider.flush();
    }

    @Override
    public void shutdown() {
        this.resetMaps();
        if (this.cacheProvider != null) {
            this.cacheProvider.destroy();
        }
        this.cacheProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLimitedAsAntagonist(UUID uUID) {
        int n = EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit();
        n += n >> 1;
        TObjectIntMap<UUID> tObjectIntMap = this.antagonists;
        synchronized (tObjectIntMap) {
            int n2 = this.antagonists.get((Object)uUID);
            return n2 != this.antagonists.getNoEntryValue() && n2 > n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMaps() {
        Map<Object, Object> map = this.onlinePlayersCache;
        synchronized (map) {
            this.onlinePlayersCache.clear();
        }
        map = this.onlinePlayersFromTexturesMap;
        synchronized (map) {
            this.onlinePlayersFromTexturesMap.clear();
        }
        map = this.onlinePlayersToTexturesMap;
        synchronized (map) {
            this.onlinePlayersToTexturesMap.clear();
        }
        map = this.foreignSkinCache;
        synchronized (map) {
            this.foreignSkinCache.clear();
        }
        map = this.pendingTextures;
        synchronized (map) {
            this.pendingTextures.clear();
        }
        map = this.pendingUUIDs;
        synchronized (map) {
            this.pendingUUIDs.clear();
        }
        map = this.pendingNameLookups;
        synchronized (map) {
            this.pendingNameLookups.clear();
        }
        map = this.antagonists;
        synchronized (map) {
            this.antagonists.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sanitizeTextureURL(String string) {
        try {
            String string2;
            URI uRI = URI.create(string);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = uRI.getScheme();
            if (string3 == null) {
                return null;
            }
            String string4 = uRI.getHost();
            if (string4 == null) {
                return null;
            }
            string3 = string3.toLowerCase();
            stringBuilder.append(string3).append("://");
            stringBuilder.append(string4);
            int n = uRI.getPort();
            if (n != -1) {
                switch (string3) {
                    case "http": {
                        if (n != 80) break;
                        n = -1;
                        break;
                    }
                    case "https": {
                        if (n != 443) break;
                        n = -1;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (n != -1) {
                    stringBuilder.append(":").append(n);
                }
            }
            if ((string2 = uRI.getRawPath()) != null) {
                int n2;
                if (string2.contains("//")) {
                    string2 = String.join((CharSequence)"/", string2.split("[\\/]+"));
                }
                if ((n2 = string2.length()) > 1 && string2.charAt(n2 - 1) == '/') {
                    string2 = string2.substring(0, n2 - 1);
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getMojangUUID(UUID uUID) {
        char[] cArray = new char[32];
        long l = uUID.getMostSignificantBits();
        long l2 = uUID.getLeastSignificantBits();
        int n = 0;
        while (n < 16) {
            int n2 = 15 - n << 2;
            cArray[n] = HEX[(int)(l >> n2 & 0xFL)];
            cArray[n + 16] = HEX[(int)(l2 >> n2 & 0xFL)];
            ++n;
        }
        return new String(cArray);
    }

    public static UUID parseMojangUUID(String string) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < 16) {
            int n2 = 15 - n << 2;
            l |= (long)hexString.indexOf(string.charAt(n)) << n2;
            l2 |= (long)hexString.indexOf(string.charAt(n + 16)) << n2;
            ++n;
        }
        return new UUID(l, l2);
    }

    public static boolean isAlex(UUID uUID) {
        return (uUID.hashCode() & 1) != 0;
    }

    protected static class CachedForeignSkin {
        protected final UUID uuid;
        protected final byte[] data;
        protected final int modelKnown;
        protected long lastHit;

        protected CachedForeignSkin(UUID uUID, byte[] byArray, int n) {
            this.uuid = uUID;
            this.data = byArray;
            this.modelKnown = n;
            this.lastHit = System.currentTimeMillis();
        }
    }

    protected static class CachedPlayerSkin {
        protected final byte[] data;
        protected final UUID textureUUID;
        protected final int modelId;

        protected CachedPlayerSkin(byte[] byArray, UUID uUID, int n) {
            this.data = byArray;
            this.textureUUID = uUID;
            this.modelId = n;
        }
    }

    protected class PendingProfileNameLookup
    implements Consumer<AsyncSkinProvider.CacheFetchedProfile> {
        protected final String profileName;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<AsyncSkinProvider.CacheFetchedProfile>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingProfileNameLookup(String string, UUID uUID, Consumer<AsyncSkinProvider.CacheFetchedProfile> consumer, Consumer<Set<UUID>> consumer2) {
            this.profileName = string;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(uUID);
            this.callbacks = new LinkedList<Consumer<AsyncSkinProvider.CacheFetchedProfile>>();
            this.callbacks.add(consumer);
            this.antagonistsCallback = consumer2;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
            int n = 0;
            int n2 = this.callbacks.size();
            while (n < n2) {
                try {
                    this.callbacks.get(n).accept(cacheFetchedProfile);
                }
                catch (Throwable throwable) {}
                ++n;
            }
            if (cacheFetchedProfile != null) {
                Map map = SkinService.this.pendingNameLookups;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingNameLookups.remove(this.profileName);
                }
            }
        }
    }

    protected class PendingProfileUUIDLookup
    implements Consumer<AsyncSkinProvider.CacheFetchedProfile> {
        protected final UUID profileUUID;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<AsyncSkinProvider.CacheFetchedProfile>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingProfileUUIDLookup(UUID uUID, UUID uUID2, Consumer<AsyncSkinProvider.CacheFetchedProfile> consumer, Consumer<Set<UUID>> consumer2) {
            this.profileUUID = uUID;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(uUID2);
            this.callbacks = new LinkedList<Consumer<AsyncSkinProvider.CacheFetchedProfile>>();
            this.callbacks.add(consumer);
            this.antagonistsCallback = consumer2;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(AsyncSkinProvider.CacheFetchedProfile cacheFetchedProfile) {
            int n = 0;
            int n2 = this.callbacks.size();
            while (n < n2) {
                try {
                    this.callbacks.get(n).accept(cacheFetchedProfile);
                }
                catch (Throwable throwable) {}
                ++n;
            }
            if (cacheFetchedProfile != null) {
                Map map = SkinService.this.pendingUUIDs;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingUUIDs.remove(this.profileUUID);
                }
            }
        }
    }

    protected class PendingTextureDownload
    implements Consumer<byte[]> {
        protected final UUID textureUUID;
        protected final String textureURL;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<byte[]>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingTextureDownload(UUID uUID, String string, UUID uUID2, Consumer<byte[]> consumer, Consumer<Set<UUID>> consumer2) {
            this.textureUUID = uUID;
            this.textureURL = string;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(uUID2);
            this.callbacks = new LinkedList<Consumer<byte[]>>();
            this.callbacks.add(consumer);
            this.antagonistsCallback = consumer2;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(byte[] byArray) {
            int n = 0;
            int n2 = this.callbacks.size();
            while (n < n2) {
                try {
                    this.callbacks.get(n).accept(byArray);
                }
                catch (Throwable throwable) {}
                ++n;
            }
            if (byArray != null) {
                Map map = SkinService.this.pendingTextures;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingTextures.remove(this.textureUUID);
                }
            }
        }
    }
}

